/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.resources.ResourceVisibility;
import com.android.tools.dom.attrs.AttributeDefinition;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.ResourceNamespaceContext;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.android.tools.idea.res.psi.ResourceReferencePsiElement;
import com.android.tools.res.CacheableResourceRepository;
import com.android.tools.res.LocalResourceRepository;
import com.android.utils.DataBindingUtils;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ConverterManager;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.android.dom.AdditionalConverter;
import org.jetbrains.android.dom.AndroidResourceType;
import org.jetbrains.android.dom.converters.AndroidResourceReference;
import org.jetbrains.android.dom.converters.AttributeValueDocumentationProvider;
import org.jetbrains.android.dom.converters.ResourceNamespaceReference;
import org.jetbrains.android.dom.drawable.DrawableStateListItem;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.CreateFileResourceQuickFix;
import org.jetbrains.android.inspections.CreateValueResourceQuickFix;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceReferenceConverter
extends ResolvingConverter<ResourceValue>
implements CustomReferenceConverter<ResourceValue>,
AttributeValueDocumentationProvider {
    private static final Pattern NAMESPACE_COLON = Pattern.compile("^((?:\\w|\\.)+):.*");
    private static final Pattern PREFIX_NAMESPACE_COLON = Pattern.compile("^@((?:\\w|\\.)+):.*");
    private static final ImmutableSet<String> TOP_PRIORITY_VALUES = ImmutableSet.of((Object)"match_parent", (Object)"wrap_content");
    private final Set<ResourceType> myResourceTypes;
    private ResolvingConverter<String> myAdditionalConverter;
    private boolean myAdditionalConverterSoft = false;
    private boolean myWithPrefix = true;
    private boolean myWithExplicitResourceType = true;
    private boolean myQuiet = false;
    private boolean myIncludeDynamicFeatures = false;
    private boolean myAllowAttributeReferences = true;
    private boolean myExpandedCompletionSuggestion = true;
    private boolean myAllowLiterals = true;
    @Nullable
    private AttributeDefinition myAttributeDefinition = null;

    public ResourceReferenceConverter() {
        this(EnumSet.noneOf(ResourceType.class));
    }

    public ResourceReferenceConverter(@NotNull Collection<ResourceType> resourceTypes) {
        this.myResourceTypes = EnumSet.copyOf(resourceTypes);
    }

    public ResourceReferenceConverter(@NotNull Collection<ResourceType> resourceTypes, @Nullable AttributeDefinition attributeDefinition) {
        this.myResourceTypes = EnumSet.copyOf(resourceTypes);
        this.myAttributeDefinition = attributeDefinition;
    }

    public void setAllowLiterals(boolean allowLiterals) {
        this.myAllowLiterals = allowLiterals;
    }

    public ResourceReferenceConverter(@NotNull ResourceType resourceType, boolean withPrefix, boolean withExplicitResourceType) {
        this.myResourceTypes = EnumSet.of(resourceType);
        this.myWithPrefix = withPrefix;
        this.myWithExplicitResourceType = withExplicitResourceType;
    }

    public void setAdditionalConverter(@Nullable ResolvingConverter<String> additionalConverter, boolean soft) {
        this.myAdditionalConverter = additionalConverter;
        this.myAdditionalConverterSoft = soft;
    }

    public void setQuiet(boolean quiet) {
        this.myQuiet = quiet;
    }

    public void setIncludeDynamicFeatures(boolean includeDynamicFeatures) {
        this.myIncludeDynamicFeatures = includeDynamicFeatures;
    }

    public boolean getIncludeDynamicFeatures() {
        return this.myIncludeDynamicFeatures;
    }

    public void setExpandedCompletionSuggestion(boolean expandedCompletionSuggestion) {
        this.myExpandedCompletionSuggestion = expandedCompletionSuggestion;
    }

    public void setAllowAttributeReferences(boolean allowAttributeReferences) {
        this.myAllowAttributeReferences = allowAttributeReferences;
    }

    @Nullable
    static String getValue(XmlElement element) {
        if (element instanceof XmlAttribute) {
            return ((XmlAttribute)element).getValue();
        }
        if (element instanceof XmlTag) {
            return ((XmlTag)element).getValue().getText();
        }
        return null;
    }

    @NotNull
    public Collection<? extends ResourceValue> getVariants(@NotNull ConvertContext context) {
        ResolvingConverter<String> additionalConverter;
        XmlElement element;
        Module module = context.getModule();
        if (module == null || module.isDisposed()) {
            return Collections.emptySet();
        }
        AndroidFacet facet = AndroidFacet.getInstance((Module)module);
        if (facet == null) {
            return Collections.emptySet();
        }
        HashSet<ResourceValue> result2 = new HashSet<ResourceValue>();
        Set<ResourceType> recommendedTypes = this.getResourceTypes(context);
        if (recommendedTypes.contains(ResourceType.BOOL) && recommendedTypes.size() < IdeResourcesUtil.VALUE_RESOURCE_TYPES.size()) {
            result2.add(ResourceValue.literal("true"));
            result2.add(ResourceValue.literal("false"));
        }
        if (recommendedTypes.contains(ResourceType.ID) && recommendedTypes.size() == 1) {
            result2.add(ResourceValue.reference("@+id/"));
        }
        if ((element = context.getXmlElement()) == null) {
            return result2;
        }
        String value2 = ResourceReferenceConverter.getValue(element);
        assert (value2 != null);
        boolean startsWithRefChar = StringUtil.startsWithChar((CharSequence)value2, (char)'@');
        if (!this.myQuiet || startsWithRefChar) {
            char prefix;
            ResourceNamespace namespace = null;
            String namespacePrefix = null;
            Matcher matcher = (this.myWithPrefix ? PREFIX_NAMESPACE_COLON : NAMESPACE_COLON).matcher(value2);
            if (matcher.matches()) {
                ResourceNamespaceContext namespacesContext = IdeResourcesUtil.getNamespacesContext(element);
                namespacePrefix = matcher.group(1);
                namespace = namespacesContext != null ? ResourceNamespace.fromNamespacePrefix((String)namespacePrefix, (ResourceNamespace)namespacesContext.getCurrentNs(), (ResourceNamespace.Resolver)namespacesContext.getResolver()) : ResourceNamespace.fromPackageName((String)namespacePrefix);
            } else {
                ResourceNamespace.Resolver resolver = IdeResourcesUtil.getNamespaceResolver(element);
                String frameworkPrefix = (String)MoreObjects.firstNonNull((Object)resolver.uriToPrefix(ResourceNamespace.ANDROID.getXmlNamespaceUri()), (Object)ResourceNamespace.ANDROID.getPackageName());
                result2.add(ResourceValue.literal(this.myWithPrefix || startsWithRefChar ? "@" + frameworkPrefix + ":" : frameworkPrefix + ":"));
            }
            char c = prefix = this.myWithPrefix || startsWithRefChar ? (char)'@' : '\u0000';
            if (value2.startsWith("@+id/")) {
                this.addVariantsForIdDeclaration(context, facet, prefix, value2, result2);
            }
            if (this.myExpandedCompletionSuggestion) {
                boolean explicitResourceType = startsWithRefChar || this.myWithExplicitResourceType;
                for (ResourceType type : recommendedTypes) {
                    if (!type.getCanBeReferenced() && type != ResourceType.SAMPLE_DATA) continue;
                    ResourceReferenceConverter.addResourceReferenceValues(facet, element, prefix, type, namespace, result2, explicitResourceType, this.myIncludeDynamicFeatures);
                }
            } else {
                Set<ResourceType> filteringSet = namespace == ResourceNamespace.ANDROID ? EnumSet.allOf(ResourceType.class) : ResourceReferenceConverter.getResourceTypesInCurrentModule(facet);
                for (ResourceType resourceType : ResourceType.values()) {
                    if (!resourceType.getCanBeReferenced()) continue;
                    String typePrefix = this.getTypePrefix(namespacePrefix, resourceType);
                    if (value2.startsWith(typePrefix)) {
                        ResourceReferenceConverter.addResourceReferenceValues(facet, element, prefix, resourceType, namespace, result2, true, this.myIncludeDynamicFeatures);
                        continue;
                    }
                    if (!recommendedTypes.contains(resourceType) || !filteringSet.contains(resourceType)) continue;
                    result2.add(ResourceValue.literal(typePrefix));
                }
            }
        }
        if (this.myAllowAttributeReferences) {
            ResourceReferenceConverter.completeAttributeReferences(value2, facet, result2);
        }
        if ((additionalConverter = this.getAdditionalConverter(context)) != null) {
            for (String variant : additionalConverter.getVariants(context)) {
                result2.add(ResourceValue.literal(variant));
            }
        }
        return result2;
    }

    private void addVariantsForIdDeclaration(@NotNull ConvertContext context, @NotNull AndroidFacet facet, final char prefix, final @NotNull String value2, final @NotNull Set<ResourceValue> result2) {
        final ResourceNamespace namespace = ResourceNamespace.TODO();
        XmlFile file = context.getFile();
        file.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitXmlAttributeValue(@NotNull XmlAttributeValue attributeValue) {
                String valueText = attributeValue.getValue();
                if (valueText != null && valueText.startsWith("@id/") && valueText.length() > "@id/".length()) {
                    String name2 = valueText.substring("@id/".length());
                    ResourceValue ref = ResourceReferenceConverter.referenceTo(prefix, "+id", namespace.getPackageName(), name2, true);
                    if (!value2.startsWith(ResourceReferenceConverter.this.convertToString(ref))) {
                        result2.add(ref);
                    }
                }
            }
        });
        Set ids = StudioResourceRepositoryManager.getAppResources(facet).getResources(namespace, ResourceType.ID).keySet();
        for (String name2 : ids) {
            ResourceValue ref = ResourceReferenceConverter.referenceTo(prefix, "+id", namespace.getPackageName(), name2, true);
            if (value2.startsWith(this.convertToString(ref))) continue;
            result2.add(ref);
        }
    }

    private static void completeAttributeReferences(String value2, AndroidFacet facet, Set<ResourceValue> result2) {
        if (StringUtil.startsWith((CharSequence)value2, (CharSequence)"?attr/")) {
            ResourceReferenceConverter.addResourceReferenceValues(facet, null, '?', ResourceType.ATTR, null, result2, true, false);
        } else if (StringUtil.startsWith((CharSequence)value2, (CharSequence)"?android:attr/")) {
            ResourceReferenceConverter.addResourceReferenceValues(facet, null, '?', ResourceType.ATTR, ResourceNamespace.ANDROID, result2, true, false);
        } else if (StringUtil.startsWithChar((CharSequence)value2, (char)'?')) {
            ResourceReferenceConverter.addResourceReferenceValues(facet, null, '?', ResourceType.ATTR, null, result2, false, false);
            ResourceReferenceConverter.addResourceReferenceValues(facet, null, '?', ResourceType.ATTR, ResourceNamespace.ANDROID, result2, false, false);
            result2.add(ResourceValue.literal("?attr/"));
            result2.add(ResourceValue.literal("?android:attr/"));
        }
    }

    public boolean isReferenceTo(@NotNull PsiElement element, String stringValue2, @Nullable ResourceValue resolveResult, @NotNull ConvertContext context) {
        if (element instanceof ResourceReferencePsiElement) {
            ResourceReference reference = ((ResourceReferencePsiElement)element).getResourceReference();
            XmlElement xmlElement = context.getXmlElement();
            if (xmlElement != null && resolveResult != null) {
                ResourceNamespace resolvedNamespace = IdeResourcesUtil.resolveResourceNamespace(xmlElement, resolveResult.getPackage());
                return reference.getNamespace().equals((Object)resolvedNamespace) && reference.getResourceType().equals((Object)resolveResult.getType()) && reference.getName().equals(resolveResult.getResourceName());
            }
        }
        return super.isReferenceTo(element, stringValue2, (Object)resolveResult, context);
    }

    @NotNull
    public static Set<ResourceType> getResourceTypesInCurrentModule(@NotNull AndroidFacet facet) {
        StudioResourceRepositoryManager repositoryManager = StudioResourceRepositoryManager.getInstance(facet);
        CacheableResourceRepository repository2 = repositoryManager.getAppResources();
        return repository2.getResourceTypes(repositoryManager.getNamespace());
    }

    @NotNull
    private String getTypePrefix(@Nullable String namespacePrefix, @NotNull ResourceType type) {
        StringBuilder sb = new StringBuilder();
        if (this.myWithPrefix) {
            sb.append('@');
        }
        if (namespacePrefix != null) {
            sb.append(namespacePrefix).append(':');
        }
        sb.append(type.getName()).append('/');
        return sb.toString();
    }

    @NotNull
    private Set<ResourceType> getResourceTypes(ConvertContext context) {
        return this.getResourceTypes(context.getInvocationElement());
    }

    @NotNull
    public Set<ResourceType> getResourceTypes(@NotNull DomElement element) {
        String s;
        ResourceType t;
        AndroidResourceType resourceType = (AndroidResourceType)element.getAnnotation(AndroidResourceType.class);
        EnumSet<ResourceType> types = EnumSet.copyOf(this.myResourceTypes);
        if (resourceType != null && (t = ResourceType.fromClassName((String)(s = resourceType.value()))) != null) {
            types.add(t);
        }
        if (types.isEmpty()) {
            return IdeResourcesUtil.VALUE_RESOURCE_TYPES;
        }
        if (types.contains(ResourceType.DRAWABLE)) {
            types.add(ResourceType.COLOR);
            if (element.getParent() instanceof DrawableStateListItem) {
                types.add(ResourceType.MIPMAP);
            }
        }
        if ("http://schemas.android.com/tools".equals(element.getXmlElementNamespace())) {
            types.add(ResourceType.SAMPLE_DATA);
        }
        return types;
    }

    private static void addResourceReferenceValues(AndroidFacet facet, @Nullable XmlElement element, char prefix, ResourceType type, @Nullable ResourceNamespace onlyNamespace, Collection<ResourceValue> result2, boolean explicitResourceType, boolean includeDynamicFeatures) {
        PsiFile file;
        PsiFile psiFile = file = element != null ? element.getContainingFile() : null;
        if (type == ResourceType.ID && onlyNamespace != ResourceNamespace.ANDROID && file != null && ResourceReferenceConverter.isNonValuesResourceFile(file)) {
            for (ResourceUrl url : IdeResourcesUtil.findIdUrlsInFile(file)) {
                result2.add(ResourceReferenceConverter.referenceTo(prefix, type.getName(), url.namespace, url.name, explicitResourceType));
            }
        } else {
            ResourceRepository frameworkResources;
            StudioResourceRepositoryManager repoManager = StudioResourceRepositoryManager.getInstance(facet);
            CacheableResourceRepository appResources = repoManager.getAppResources();
            if (onlyNamespace == ResourceNamespace.ANDROID && (frameworkResources = repoManager.getFrameworkResources((Set)ImmutableSet.of())) != null) {
                ResourceReferenceConverter.addResourceReferenceValuesFromRepo(frameworkResources, repoManager, element, prefix, type, ResourceNamespace.ANDROID, result2, explicitResourceType);
            }
            if (onlyNamespace == null) {
                for (ResourceNamespace namespace : appResources.getNamespaces()) {
                    ResourceReferenceConverter.addResourceReferenceValuesFromRepo(appResources, repoManager, element, prefix, type, namespace, result2, explicitResourceType);
                }
            } else {
                ResourceReferenceConverter.addResourceReferenceValuesFromRepo(appResources, repoManager, element, prefix, type, onlyNamespace, result2, explicitResourceType);
            }
            if (includeDynamicFeatures) {
                ResourceReferenceConverter.addResourceReferenceValuesFromDynamicFeatures(element, prefix, type, onlyNamespace, result2);
            }
        }
    }

    private static void addResourceReferenceValuesFromDynamicFeatures(@Nullable XmlElement element, char prefix, @Nullable ResourceType type, @Nullable ResourceNamespace onlyNamespace, @NotNull Collection<ResourceValue> result2) {
        ResourceNamespace namespace;
        ResourceNamespace resourceNamespace = namespace = onlyNamespace != null ? onlyNamespace : ResourceNamespace.RES_AUTO;
        if (element == null || type == null) {
            return;
        }
        AndroidModuleSystem androidModuleSystem = ProjectSystemUtil.getModuleSystem((PsiElement)element);
        if (androidModuleSystem == null) {
            return;
        }
        ResourceNamespace.Resolver resolver = (ResourceNamespace.Resolver)MoreObjects.firstNonNull((Object)IdeResourcesUtil.getNamespaceResolver(element), (Object)ResourceNamespace.Resolver.EMPTY_RESOLVER);
        String namespacePrefix = resolver.uriToPrefix(namespace.getXmlNamespaceUri());
        List<Module> modules = androidModuleSystem.getDynamicFeatureModules();
        for (Module module : modules) {
            LocalResourceRepository<VirtualFile> moduleResources2 = StudioResourceRepositoryManager.getModuleResources(module);
            if (moduleResources2 == null) continue;
            Set resourceNames = moduleResources2.getResourceNames(namespace, type);
            for (String name2 : resourceNames) {
                result2.add(ResourceReferenceConverter.referenceTo(prefix, type.getName(), namespacePrefix, name2, true));
            }
        }
    }

    private static void addResourceReferenceValuesFromRepo(ResourceRepository repo, StudioResourceRepositoryManager repoManager, @Nullable XmlElement element, char prefix, ResourceType type, @NotNull ResourceNamespace onlyNamespace, Collection<ResourceValue> result2, boolean explicitResourceType) {
        Collection<String> names = IdeResourcesUtil.getResourceItems(repo, onlyNamespace, type, ResourceVisibility.PUBLIC);
        ResourceNamespace.Resolver resolver = ResourceNamespace.Resolver.EMPTY_RESOLVER;
        if (element != null) {
            resolver = (ResourceNamespace.Resolver)MoreObjects.firstNonNull((Object)IdeResourcesUtil.getNamespaceResolver(element), (Object)resolver);
        }
        String namespacePrefix = new ResourceReference((ResourceNamespace)onlyNamespace, (ResourceType)ResourceType.STRING, (String)"dummy").getRelativeResourceUrl((ResourceNamespace)repoManager.getNamespace(), (ResourceNamespace.Resolver)resolver).namespace;
        for (String name2 : names) {
            result2.add(ResourceReferenceConverter.referenceTo(prefix, type.getName(), namespacePrefix, name2, explicitResourceType));
        }
    }

    private static boolean isNonValuesResourceFile(@NotNull PsiFile file) {
        ResourceFolderType resourceType = IdeResourcesUtil.getFolderType(file.getOriginalFile());
        return resourceType != null && resourceType != ResourceFolderType.VALUES;
    }

    private static ResourceValue referenceTo(char prefix, String type, String resPackage, String name2, boolean explicitResourceType) {
        return ResourceValue.referenceTo(prefix, resPackage, explicitResourceType ? type : null, name2);
    }

    public String getErrorMessage(@Nullable String s, @NotNull ConvertContext context) {
        if (s == null || s.isEmpty()) {
            return "Missing value";
        }
        ResourceValue parsed = ResourceValue.parse(s, true, this.myWithPrefix, false);
        if (parsed != null && parsed.isReference()) {
            String errorMessage = parsed.getErrorMessage();
            if (errorMessage != null) {
                return "Invalid resource reference - " + StringUtil.decapitalize((String)errorMessage);
            }
        } else {
            if (this.myResourceTypes.contains(ResourceType.STRING)) {
                return null;
            }
            ResolvingConverter<String> additionalConverter = this.getAdditionalConverter(context);
            if (additionalConverter != null) {
                return additionalConverter.getErrorMessage(s, context);
            }
        }
        return super.getErrorMessage(s, context);
    }

    @Nullable
    public LookupElement createLookupElement(ResourceValue resourceValue) {
        String value2 = resourceValue.toString();
        boolean deprecated = false;
        if (this.myAttributeDefinition != null) {
            deprecated = this.myAttributeDefinition.isValueDeprecated(value2);
        }
        LookupElementBuilder builder = LookupElementBuilder.create((String)value2);
        builder = builder.withCaseSensitivity(true).withStrikeoutness(deprecated);
        String resourceName = resourceValue.getResourceName();
        if (resourceName != null) {
            builder = builder.withLookupString(resourceName);
        } else if (this.isNamespaceLiteral(resourceValue.getValue())) {
            builder = builder.withInsertHandler((context, item) -> context.setLaterRunnable(() -> new CodeCompletionHandlerBase(CompletionType.BASIC).invokeCompletion(context.getProject(), context.getEditor())));
        }
        int priority = deprecated ? 0 : (TOP_PRIORITY_VALUES.contains((Object)value2) ? 2 : 1);
        return PrioritizedLookupElement.withPriority((LookupElement)builder, (double)priority);
    }

    public boolean isNamespaceLiteral(@Nullable String value2) {
        return value2 != null && value2.charAt(value2.length() - 1) == ':' && value2.indexOf(47) == -1;
    }

    public ResourceValue fromString(@Nullable @NonNls String s, @NotNull ConvertContext context) {
        if (s == null) {
            return null;
        }
        if (DataBindingUtils.isBindingExpression((String)s)) {
            return ResourceValue.INVALID;
        }
        ResourceValue parsed = ResourceValue.parse(s, true, this.myWithPrefix, true);
        ResolvingConverter<String> additionalConverter = this.getAdditionalConverter(context);
        if (parsed == null || !parsed.isReference()) {
            if (additionalConverter != null) {
                String value2 = (String)additionalConverter.fromString(s, context);
                if (value2 != null) {
                    return ResourceValue.literal(value2);
                }
                if (!this.myAdditionalConverterSoft) {
                    return null;
                }
            } else if (!this.myAllowLiterals) {
                return null;
            }
        }
        if (parsed != null) {
            String resType = parsed.getResourceType();
            if (parsed.getPrefix() == '?') {
                if (!this.myAllowAttributeReferences) {
                    return null;
                }
                if (resType == null) {
                    parsed.setResourceType(ResourceType.ATTR.getName());
                } else if (!ResourceType.ATTR.getName().equals(resType)) {
                    return null;
                }
            } else if (resType == null) {
                if (parsed.isReference()) {
                    if (this.myWithExplicitResourceType && !"@null".equals(s)) {
                        return null;
                    }
                    if (this.myResourceTypes.size() == 1) {
                        parsed.setResourceType(this.myResourceTypes.iterator().next().getName());
                    }
                } else {
                    Set<ResourceType> types = this.getResourceTypes(context);
                    if (types.size() == 1 && types.contains(ResourceType.BOOL) && !"true".equals(s) && !"false".equals(s)) {
                        return null;
                    }
                }
            }
        }
        return parsed;
    }

    @Nullable
    private ResolvingConverter<String> getAdditionalConverter(ConvertContext context) {
        if (this.myAdditionalConverter != null) {
            return this.myAdditionalConverter;
        }
        AdditionalConverter additionalConverterAnnotation = (AdditionalConverter)context.getInvocationElement().getAnnotation(AdditionalConverter.class);
        if (additionalConverterAnnotation != null) {
            Class<? extends ResolvingConverter> converterClass = additionalConverterAnnotation.value();
            ConverterManager converterManager = (ConverterManager)ApplicationManager.getApplication().getService(ConverterManager.class);
            return (ResolvingConverter)converterManager.getConverterInstance(converterClass);
        }
        return null;
    }

    public final String toString(@Nullable ResourceValue element, @NotNull ConvertContext context) {
        return this.convertToString(element);
    }

    @Nullable
    public String convertToString(@Nullable ResourceValue element) {
        if (element == null) {
            return null;
        }
        if (this.myWithExplicitResourceType || !element.isReference()) {
            return element.toString();
        }
        return ResourceValue.referenceTo(element.getPrefix(), element.getPackage(), null, element.getResourceName()).toString();
    }

    public LocalQuickFix[] getQuickFixes(@NotNull ConvertContext context) {
        ResourceValue resourceValue;
        String value2;
        DomElement domElement;
        AndroidFacet facet = AndroidFacet.getInstance((ConvertContext)context);
        if (facet != null && (domElement = context.getInvocationElement()) instanceof GenericDomValue && (value2 = ((GenericDomValue)domElement).getStringValue()) != null && (resourceValue = ResourceValue.parse(value2, false, this.myWithPrefix, true)) != null) {
            String aPackage = resourceValue.getPackage();
            ResourceType resType = resourceValue.getType();
            if (resType == null && this.myResourceTypes.size() == 1) {
                resType = this.myResourceTypes.iterator().next();
            }
            String resourceName = resourceValue.getResourceName();
            if (aPackage == null && resType != null && resourceName != null && IdeResourcesUtil.isCorrectAndroidResourceName(resourceName)) {
                ArrayList<Object> fixes = new ArrayList<Object>();
                ResourceFolderType folderType = FolderTypeRelationship.getNonValuesRelatedFolder((ResourceType)resType);
                if (folderType != null) {
                    fixes.add(new CreateFileResourceQuickFix(facet, folderType, resourceName, (PsiFile)context.getFile(), false));
                }
                if (IdeResourcesUtil.VALUE_RESOURCE_TYPES.contains(resType) && resType != ResourceType.LAYOUT) {
                    fixes.add(new CreateValueResourceQuickFix(facet, resType, resourceName, (PsiFile)context.getFile()));
                }
                return fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
            }
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<ResourceValue> value2, PsiElement element, ConvertContext context) {
        if ("@null".equals(value2.getStringValue())) {
            return PsiReference.EMPTY_ARRAY;
        }
        Module module = context.getModule();
        if (module == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        AndroidFacet facet = AndroidFacet.getInstance((Module)module);
        if (facet == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        ResourceValue resValue = (ResourceValue)value2.getValue();
        if (resValue == null || !resValue.isReference()) {
            return PsiReference.EMPTY_ARRAY;
        }
        String resType = resValue.getResourceType();
        if (resType == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        AndroidResourceReference resourceReference = new AndroidResourceReference(value2, facet, resValue, this.myIncludeDynamicFeatures);
        if (!StringUtil.isEmpty((String)resValue.getPackage())) {
            ResourceNamespaceReference namespaceReference = new ResourceNamespaceReference(value2, resValue);
            return new PsiReference[]{namespaceReference, resourceReference};
        }
        return new PsiReference[]{resourceReference};
    }

    @Override
    public String getDocumentation(@NotNull String value2) {
        String description2;
        if (this.myAttributeDefinition != null && (description2 = this.myAttributeDefinition.getValueDescription(value2)) != null) {
            return description2;
        }
        return this.myAdditionalConverter instanceof AttributeValueDocumentationProvider ? ((AttributeValueDocumentationProvider)this.myAdditionalConverter).getDocumentation(value2) : null;
    }
}

