/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.google.common.collect.Multimap;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.XmlName;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.function.Predicate;
import org.jetbrains.android.dom.AndroidDomElement;
import org.jetbrains.android.dom.navigation.NavElement;
import org.jetbrains.android.dom.navigation.NavigationSchema;
import org.jetbrains.android.dom.resources.PublicResource;
import org.jetbrains.android.dom.resources.Resources;
import org.jetbrains.android.dom.xml.PreferenceElementBase;
import org.jetbrains.android.dom.xml.XmlResourceElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;

public class SubtagsProcessingUtil {
    private SubtagsProcessingUtil() {
    }

    public static void registerXmlResourcesSubtags(@NotNull AndroidFacet facet, @NotNull XmlTag tag, @NotNull SubtagProcessor subtagProcessor, boolean processExistingSubTags) {
        String tagName;
        switch (tagName = tag.getName()) {
            case "searchable": {
                subtagProcessor.processSubtag("actionkey", (Type)((Object)XmlResourceElement.class));
                break;
            }
            case "Keyboard": {
                subtagProcessor.processSubtag("Row", (Type)((Object)XmlResourceElement.class));
                break;
            }
            case "Row": {
                subtagProcessor.processSubtag("Key", (Type)((Object)XmlResourceElement.class));
                break;
            }
            case "device-admin": {
                subtagProcessor.processSubtag("uses-policies", (Type)((Object)XmlResourceElement.class));
                break;
            }
            case "uses-policies": {
                subtagProcessor.processSubtag("limit-password", (Type)((Object)XmlResourceElement.class));
                subtagProcessor.processSubtag("watch-login", (Type)((Object)XmlResourceElement.class));
                subtagProcessor.processSubtag("reset-password", (Type)((Object)XmlResourceElement.class));
                subtagProcessor.processSubtag("force-lock", (Type)((Object)XmlResourceElement.class));
                subtagProcessor.processSubtag("wipe-data", (Type)((Object)XmlResourceElement.class));
                subtagProcessor.processSubtag("set-global-proxy", (Type)((Object)XmlResourceElement.class));
                subtagProcessor.processSubtag("expire-password", (Type)((Object)XmlResourceElement.class));
                subtagProcessor.processSubtag("encrypted-storage", (Type)((Object)XmlResourceElement.class));
                subtagProcessor.processSubtag("disable-camera", (Type)((Object)XmlResourceElement.class));
                subtagProcessor.processSubtag("disable-keyguard-features", (Type)((Object)XmlResourceElement.class));
                break;
            }
            case "preference-headers": {
                subtagProcessor.processSubtag("header", (Type)((Object)PreferenceElementBase.class));
            }
        }
    }

    private static void registerSubtags(@NotNull XmlTag tag, @NotNull Collection<String> allowedTags, @NotNull Collection<String> tagsToComplete, @NotNull Type type, @NotNull SubtagProcessor subtagProcessor, boolean processExistingSubTags) {
        for (String tagName : tagsToComplete) {
            subtagProcessor.processSubtag(tagName, type);
        }
        if (processExistingSubTags) {
            SubtagsProcessingUtil.processExistingSubTags(tag, allowedTags::contains, type, subtagProcessor);
        }
    }

    public static void processSubTags(@NotNull AndroidFacet facet, @NotNull AndroidDomElement element, boolean processExistingSubTags, @NotNull SubtagProcessor subtagProcessor) {
        if (element instanceof XmlResourceElement) {
            XmlTag tag = element.getXmlTag();
            if (tag != null) {
                SubtagsProcessingUtil.registerXmlResourcesSubtags(facet, tag, subtagProcessor, true);
            }
        } else if (element instanceof NavElement) {
            try {
                NavigationSchema.createIfNecessary(facet.getModule());
            }
            catch (ClassNotFoundException e) {
                return;
            }
            NavigationSchema schema = NavigationSchema.get(facet.getModule());
            Multimap<Class<? extends AndroidDomElement>, String> subtags = schema.getDestinationSubtags(element.getXmlTag().getName());
            for (Class c : subtags.keys()) {
                SubtagsProcessingUtil.registerSubtags(element.getXmlTag(), subtags.get((Object)c), subtags.get((Object)c), c, subtagProcessor, processExistingSubTags);
            }
        } else if (element instanceof Resources && ((AndroidFacetConfiguration)facet.getConfiguration()).isLibraryProject()) {
            subtagProcessor.processSubtag("public", (Type)((Object)PublicResource.class));
        }
    }

    private static void processExistingSubTags(@NotNull XmlTag tag, @NotNull Predicate<String> filter2, @NotNull Type type, @NotNull SubtagProcessor subtagProcessor) {
        XmlTag[] subtags;
        for (XmlTag subtag : subtags = tag.getSubTags()) {
            String localName = subtag.getLocalName();
            if (!filter2.test(localName) || localName.endsWith(CompletionUtil.DUMMY_IDENTIFIER_TRIMMED)) continue;
            subtagProcessor.processSubtag(new XmlName(localName), type);
        }
    }

    public static interface SubtagProcessor {
        public void processSubtag(@NotNull XmlName var1, @NotNull Type var2);

        default public void processSubtag(@NotNull String xmlName, @NotNull Type type) {
            this.processSubtag(new XmlName(xmlName), type);
        }
    }
}

