/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.impl.source.xml.TagNameReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.DefaultXmlExtension;
import com.intellij.xml.XmlNSDescriptor;
import org.jetbrains.android.dom.AndroidResourceDomFileDescription;
import org.jetbrains.android.dom.drawable.DrawableResourceNSDescriptor;
import org.jetbrains.android.dom.layout.AndroidLayoutNSDescriptor;
import org.jetbrains.android.dom.manifest.ManifestDomFileDescription;
import org.jetbrains.android.dom.xml.XmlResourceNSDescriptor;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.TagFromClassDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidXmlExtension
extends DefaultXmlExtension {
    private static final SchemaPrefix EMPTY_SCHEMA = new SchemaPrefix(null, new TextRange(0, 0), "android");

    @Nullable
    public XmlNSDescriptor getNSDescriptor(XmlTag element, String namespace, boolean strict) {
        boolean isRoot2;
        XmlFile file = (XmlFile)element.getContainingFile();
        boolean bl = isRoot2 = file.getRootTag() == element;
        if (isRoot2 && AndroidResourceDomFileDescription.isFileInResourceFolderType(file, ResourceFolderType.LAYOUT)) {
            return AndroidLayoutNSDescriptor.INSTANCE;
        }
        if (isRoot2 && AndroidResourceDomFileDescription.isFileInResourceFolderType(file, ResourceFolderType.XML)) {
            return XmlResourceNSDescriptor.INSTANCE;
        }
        if (isRoot2 && AndroidResourceDomFileDescription.isFileInResourceFolderType(file, ResourceFolderType.DRAWABLE)) {
            return DrawableResourceNSDescriptor.INSTANCE;
        }
        return super.getNSDescriptor(element, namespace, strict);
    }

    @Nullable
    public TagNameReference createTagNameReference(ASTNode nameElement, boolean startTagFlag) {
        return new TagNameReference(this, nameElement, startTagFlag){

            public boolean isSoft() {
                return true;
            }

            public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
                if (element instanceof PsiQualifiedNamedElement) {
                    return null;
                }
                return super.bindToElement(element);
            }

            @Nullable
            public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
                XmlTag element = this.getTagElement();
                if (element != null && element.getDescriptor() instanceof TagFromClassDescriptor) {
                    return null;
                }
                return super.handleElementRename(newElementName);
            }
        };
    }

    public boolean isAvailable(final PsiFile file) {
        if (file instanceof XmlFile) {
            return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    String tagName;
                    if (AndroidFacet.getInstance((PsiElement)file) != null) {
                        if (IdeResourcesUtil.isInResourceSubdirectoryInAnyVariant(file, null)) {
                            return true;
                        }
                        if (file.getName().equals("AndroidManifest.xml") && ManifestDomFileDescription.isManifestFile((XmlFile)file)) {
                            return true;
                        }
                    }
                    if ("lint.xml".equals(file.getName())) {
                        return true;
                    }
                    XmlFile xmlFile = (XmlFile)file;
                    XmlTag tag = xmlFile.getRootTag();
                    if (tag != null && ("lint".equals(tagName = tag.getName()) || "issues".equals(tagName))) {
                        return true;
                    }
                    return false;
                }
            });
        }
        return false;
    }

    public SchemaPrefix getPrefixDeclaration(XmlTag context, String namespacePrefix) {
        SchemaPrefix prefix = super.getPrefixDeclaration(context, namespacePrefix);
        if (prefix != null) {
            return prefix;
        }
        if (namespacePrefix.isEmpty()) {
            return EMPTY_SCHEMA;
        }
        return null;
    }

    public boolean isRequiredAttributeImplicitlyPresent(@NotNull XmlTag tag, @NotNull String attrName) {
        return AndroidXmlExtension.isAaptAttributeDefined(tag, attrName);
    }

    public static boolean isAaptAttributeDefined(@NotNull XmlTag tag, @NotNull String attrName) {
        XmlTag[] subTags;
        for (XmlTag child : subTags = tag.getSubTags()) {
            XmlAttribute attr;
            if (!"attr".equals(child.getLocalName()) || !"http://schemas.android.com/aapt".equals(child.getNamespace()) || (attr = child.getAttribute("name")) == null || !attrName.equals(attr.getValue())) continue;
            return true;
        }
        return false;
    }
}

