/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.diagnostics.error;

import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import org.jetbrains.android.diagnostics.error.ErrorBean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeaITNProxy {
    @NotNull
    private static final List<String> TEXT_BASED_ATTACHMENTS = new ImmutableList.Builder().add((Object)"Kotlin version").build();

    public static List<Pair<String, String>> getKeyValuePairs(@Nullable String login2, @Nullable String password, ErrorBean error, Application application, ApplicationInfoEx appInfo, ApplicationNamesInfo namesInfo, UpdateSettings updateSettings2) {
        ArrayList<Pair<String, String>> params2 = new ArrayList<Pair<String, String>>();
        params2.add(Pair.create((Object)"protocol.version", (Object)"1"));
        if (login2 != null) {
            params2.add(Pair.create((Object)"user.login", (Object)login2));
            params2.add(Pair.create((Object)"user.password", (Object)password));
        }
        params2.add(Pair.create((Object)"os.name", (Object)SystemInfo.OS_NAME));
        params2.add(Pair.create((Object)"java.version", (Object)SystemInfo.JAVA_VERSION));
        params2.add(Pair.create((Object)"java.vm.vendor", (Object)SystemInfo.JAVA_VENDOR));
        params2.add(Pair.create((Object)"app.name", (Object)namesInfo.getProductName()));
        params2.add(Pair.create((Object)"app.name.full", (Object)namesInfo.getFullProductName()));
        params2.add(Pair.create((Object)"app.name.version", (Object)appInfo.getVersionName()));
        params2.add(Pair.create((Object)"app.eap", (Object)Boolean.toString(appInfo.isEAP())));
        params2.add(Pair.create((Object)"app.internal", (Object)Boolean.toString(application.isInternal())));
        params2.add(Pair.create((Object)"app.build", (Object)appInfo.getBuild().asString()));
        params2.add(Pair.create((Object)"app.version.major", (Object)appInfo.getMajorVersion()));
        params2.add(Pair.create((Object)"app.version.minor", (Object)appInfo.getMinorVersion()));
        params2.add(Pair.create((Object)"app.build.date", (Object)IdeaITNProxy.format(appInfo.getBuildDate())));
        params2.add(Pair.create((Object)"app.build.date.release", (Object)IdeaITNProxy.format(appInfo.getMajorReleaseBuildDate())));
        params2.add(Pair.create((Object)"update.channel.status", (Object)updateSettings2.getSelectedChannelStatus().getCode()));
        params2.add(Pair.create((Object)"update.ignored.builds", (Object)StringUtil.join((Collection)updateSettings2.getIgnoredBuildNumbers(), (String)",")));
        params2.add(Pair.create((Object)"plugin.name", (Object)error.getPluginName()));
        params2.add(Pair.create((Object)"plugin.version", (Object)error.getPluginVersion()));
        params2.add(Pair.create((Object)"last.action", (Object)error.getLastAction()));
        params2.add(Pair.create((Object)"previous.exception", null));
        params2.add(Pair.create((Object)"error.message", (Object)error.getMessage()));
        params2.add(Pair.create((Object)"error.stacktrace", (Object)error.getStackTrace()));
        params2.add(Pair.create((Object)"error.description", (Object)error.getDescription()));
        params2.add(Pair.create((Object)"assignee.id", null));
        List<Attachment> attachments = error.getAttachments();
        for (int i = 0; i < attachments.size(); ++i) {
            Attachment attachment = attachments.get(i);
            params2.add((Pair<String, String>)Pair.create((Object)("attachment" + (i + 1) + ".name"), (Object)attachment.getName()));
            params2.add((Pair<String, String>)Pair.create((Object)("attachment" + (i + 1) + ".value"), (Object)IdeaITNProxy.getAttachmentValue(attachment)));
        }
        Project[] projects = ProjectManager.getInstance().getOpenProjects();
        for (int i = 0; i < projects.length; ++i) {
            params2.add((Pair<String, String>)Pair.create((Object)("is.gradle.project." + i), (Object)Boolean.toString(ProjectSystemUtil.requiresAndroidModel(projects[i]))));
        }
        return params2;
    }

    private static String format(Calendar calendar) {
        return calendar == null ? "" : Long.toString(calendar.getTime().getTime());
    }

    @NotNull
    private static String getAttachmentValue(@NotNull Attachment attachment) {
        if (TEXT_BASED_ATTACHMENTS.contains(attachment.getName())) {
            return attachment.getDisplayText();
        }
        return attachment.getEncodedBytes();
    }
}

