/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.res.AndroidDependenciesCache;
import com.android.tools.idea.res.IdeResourceNameValidator;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.CommonBundle;
import com.intellij.application.options.ModulesComboBox;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.ide.actions.TemplateKindCombo;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.PlatformIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.android.actions.CreateResourceDialogUtils;
import org.jetbrains.android.actions.CreateResourceFileDialogBase;
import org.jetbrains.android.actions.CreateTypedResourceFileAction;
import org.jetbrains.android.actions.ElementCreatingValidator;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.DeviceConfiguratorPanel;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateResourceFileDialog
extends CreateResourceFileDialogBase {
    private JTextField myFileNameField;
    private TemplateKindCombo myResourceTypeCombo;
    private JPanel myPanel;
    private JLabel myUpDownHint;
    private JLabel myResTypeLabel;
    private JPanel myDeviceConfiguratorWrapper;
    private JBLabel myErrorLabel;
    private JTextField myDirectoryNameTextField;
    private JPanel myRootElementFieldWrapper;
    private JBLabel myRootElementLabel;
    private JLabel myFileNameLabel;
    private ModulesComboBox myModuleCombo;
    private JBLabel myModuleLabel;
    private JComboBox mySourceSetCombo;
    private JBLabel mySourceSetLabel;
    private TextFieldWithAutoCompletion<String> myRootElementField;
    private ElementCreatingValidator myValidator;
    private CreateResourceFileDialogBase.ValidatorFactory myValidatorFactory;
    private final DeviceConfiguratorPanel myDeviceConfiguratorPanel;
    private final AndroidFacet myFacet;
    private PsiDirectory myResDirectory;

    public CreateResourceFileDialog(@NotNull AndroidFacet facet, @NotNull Collection<CreateTypedResourceFileAction> actions2, @Nullable ResourceFolderType folderType, @Nullable String filename, @Nullable String rootElement, @Nullable FolderConfiguration folderConfiguration, boolean chooseFileName, boolean chooseModule, @Nullable PsiDirectory resDirectory, @NotNull CreateResourceFileDialogBase.ValidatorFactory validatorFactory) {
        super(facet.getModule().getProject());
        this.setupUI();
        Module module = facet.getModule();
        this.myFacet = facet;
        this.myResDirectory = resDirectory;
        this.myValidatorFactory = validatorFactory;
        this.myResTypeLabel.setLabelFor((Component)this.myResourceTypeCombo);
        this.myUpDownHint.setIcon(PlatformIcons.UP_DOWN_ARROWS);
        String selectedTemplate = this.setupSubActions(actions2, this.myResourceTypeCombo, folderType);
        this.myDeviceConfiguratorPanel = this.setupDeviceConfigurationPanel(this.myDirectoryNameTextField, this.myResourceTypeCombo, this.myErrorLabel);
        if (folderConfiguration != null) {
            this.myDeviceConfiguratorPanel.init(folderConfiguration);
        }
        this.myResourceTypeCombo.getComboBox().addActionListener(e -> {
            this.myDeviceConfiguratorPanel.applyEditors();
            this.updateRootElementTextField();
        });
        if (folderType != null && selectedTemplate != null) {
            this.myResTypeLabel.setVisible(false);
            this.myResourceTypeCombo.setVisible(false);
            this.myUpDownHint.setVisible(false);
            this.myResourceTypeCombo.setSelectedName(selectedTemplate);
        } else {
            this.myResourceTypeCombo.setSelectedName("values");
            this.myResourceTypeCombo.registerUpDownHint((JComponent)this.myFileNameField);
        }
        if (chooseFileName) {
            filename = IdeResourcesUtil.prependResourcePrefix(module, filename, folderType);
        }
        boolean validateImmediately = false;
        if (filename != null && this.getNameError(filename) != null) {
            chooseFileName = true;
            validateImmediately = true;
        }
        if (filename != null) {
            if (!chooseFileName) {
                this.myFileNameField.setVisible(false);
                this.myFileNameLabel.setVisible(false);
            }
            this.myFileNameField.setText(filename);
        }
        HashSet<Module> modulesSet = new HashSet<Module>();
        modulesSet.add(module);
        for (AndroidFacet depFacet : AndroidDependenciesCache.getAllAndroidDependencies(module, true)) {
            modulesSet.add(depFacet.getModule());
        }
        this.myModuleCombo.setModules(modulesSet);
        if (!chooseModule || modulesSet.size() == 1) {
            this.myModuleLabel.setVisible(false);
            this.myModuleCombo.setVisible(false);
        }
        this.myModuleCombo.setSelectedModule(module);
        this.myModuleCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CreateResourceDialogUtils.updateSourceSetCombo((JComponent)CreateResourceFileDialog.this.mySourceSetLabel, CreateResourceFileDialog.this.mySourceSetCombo, AndroidFacet.getInstance((Module)CreateResourceFileDialog.this.getSelectedModule()), CreateResourceFileDialog.this.myResDirectory);
            }
        });
        CreateResourceDialogUtils.updateSourceSetCombo((JComponent)this.mySourceSetLabel, this.mySourceSetCombo, AndroidFacet.getInstance((Module)this.getSelectedModule()), this.myResDirectory);
        this.myDeviceConfiguratorPanel.updateAll();
        this.myDeviceConfiguratorWrapper.add((Component)this.myDeviceConfiguratorPanel, "Center");
        this.updateOkAction();
        this.updateRootElementTextField();
        if (folderType == ResourceFolderType.RAW) {
            this.myRootElementLabel.setVisible(false);
            this.myRootElementFieldWrapper.setVisible(false);
            this.myRootElementField.setVisible(false);
        } else if (rootElement != null) {
            this.myRootElementLabel.setVisible(false);
            this.myRootElementFieldWrapper.setVisible(false);
            this.myRootElementField.setText(rootElement);
        }
        this.init();
        this.setTitle(AndroidBundle.message("new.resource.dialog.title", new Object[0]));
        this.myFileNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(@NotNull DocumentEvent event) {
                CreateResourceFileDialog.this.validateName();
            }
        });
        this.myResourceTypeCombo.getComboBox().addActionListener(actionEvent -> this.validateName());
        if (validateImmediately) {
            this.validateName();
        }
    }

    @Override
    protected void updateOkAction() {
        boolean enabled = !this.myDirectoryNameTextField.getText().isEmpty();
        enabled = enabled && this.getNameError(this.myFileNameField.getText()) == null;
        this.setOKActionEnabled(enabled);
    }

    @Nullable
    private ResourceFolderType getSelectedFolderType() {
        return ResourceFolderType.getFolderType((String)this.myResourceTypeCombo.getSelectedName());
    }

    @Nullable
    private String getNameError(@NotNull String fileName) {
        ResourceFolderType type = this.getSelectedFolderType();
        if (type != null) {
            IdeResourceNameValidator validator = IdeResourceNameValidator.forFilename(type, ".xml");
            return validator.getErrorText(fileName);
        }
        return null;
    }

    private void validateName() {
        this.setErrorText(this.getNameError(this.myFileNameField.getText()));
        this.updateOkAction();
    }

    private void updateRootElementTextField() {
        CreateTypedResourceFileAction action2 = this.getSelectedAction(this.myResourceTypeCombo);
        if (action2 != null) {
            try {
                Module module = this.myFacet.getModule();
                List<String> allowedTagNames = action2.getSortedAllowedTagNames(this.myFacet);
                this.myRootElementField = new TextFieldWithAutoCompletion<String>(module.getProject(), (TextFieldWithAutoCompletionListProvider)new TextFieldWithAutoCompletion.StringsCompletionProvider(allowedTagNames, null), true, null){

                    @NotNull
                    protected EditorEx createEditor() {
                        EditorEx editor = super.createEditor();
                        editor.putUserData(AutoPopupController.SHOW_BOTTOM_PANEL_IN_LOOKUP_UI, (Object)false);
                        return editor;
                    }
                };
                this.myRootElementField.addSettingsProvider(editor -> {
                    Color bgColor = this.myRootElementField.isEnabled() ? null : UIManager.getColor("Panel.background");
                    editor.setBackgroundColor(bgColor);
                });
                this.myRootElementField.setEnabled(allowedTagNames.size() > 1);
                this.myRootElementField.setText(action2.isChooseTagName() ? "" : action2.getDefaultRootTag(module));
                this.myRootElementFieldWrapper.removeAll();
                this.myRootElementFieldWrapper.add((Component)this.myRootElementField, "Center");
                this.myRootElementLabel.setLabelFor(this.myRootElementField);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    @VisibleForTesting
    @NotNull
    public String getFileName() {
        return this.myFileNameField.getText().trim();
    }

    protected void doOKAction() {
        String fileName = this.myFileNameField.getText().trim();
        CreateTypedResourceFileAction action2 = this.getSelectedAction(this.myResourceTypeCombo);
        assert (action2 != null);
        if (fileName.isEmpty()) {
            Messages.showErrorDialog((Component)this.myPanel, (String)AndroidBundle.message("file.name.not.specified.error", new Object[0]), (String)CommonBundle.getErrorTitle());
            return;
        }
        String rootElement = this.getRootElement();
        if (!action2.isChooseTagName() && action2.getResourceFolderType() != ResourceFolderType.RAW && (rootElement == null || rootElement.isEmpty())) {
            Messages.showErrorDialog((Component)this.myPanel, (String)AndroidBundle.message("root.element.not.specified.error", new Object[0]), (String)CommonBundle.getErrorTitle());
            return;
        }
        String subdirName = this.getSubdirName();
        if (subdirName.isEmpty()) {
            Messages.showErrorDialog((Component)this.myPanel, (String)AndroidBundle.message("directory.not.specified.error", new Object[0]), (String)CommonBundle.getErrorTitle());
            return;
        }
        String errorMessage = this.getNameError(fileName);
        if (errorMessage != null) {
            Messages.showErrorDialog((Component)this.myPanel, (String)errorMessage, (String)CommonBundle.getErrorTitle());
            return;
        }
        PsiDirectory resDir = this.getResourceDirectory();
        if (resDir == null) {
            Messages.showErrorDialog((Component)this.myPanel, (String)AndroidBundle.message("check.resource.dir.error", this.getSelectedModule()), (String)CommonBundle.getErrorTitle());
            super.doOKAction();
            return;
        }
        this.myValidator = this.myValidatorFactory.create(resDir, subdirName, rootElement);
        if (this.myValidator.checkInput(fileName) && this.myValidator.canClose(fileName)) {
            super.doOKAction();
        }
    }

    @Override
    @NotNull
    public PsiElement[] getCreatedElements() {
        return this.myValidator != null ? this.myValidator.getCreatedElements() : PsiElement.EMPTY_ARRAY;
    }

    protected String getDimensionServiceKey() {
        return "AndroidCreateResourceFileDialog";
    }

    @Nullable
    private PsiDirectory getResourceDirectory() {
        if (this.myResDirectory != null) {
            return this.myResDirectory;
        }
        Module module = this.getSelectedModule();
        return CreateResourceDialogUtils.getOrCreateResourceDirectory(this.mySourceSetCombo, module);
    }

    @NotNull
    private Module getSelectedModule() {
        Module module = this.myModuleCombo.getSelectedModule();
        assert (module != null);
        return module;
    }

    @NotNull
    private String getSubdirName() {
        return this.myDirectoryNameTextField.getText().trim();
    }

    @Nullable
    protected String getRootElement() {
        return this.myRootElementField == null ? null : this.myRootElementField.getText().trim();
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        String name2 = this.myFileNameField.getText();
        if (name2.isEmpty() || name2.equals(IdeResourcesUtil.prependResourcePrefix(this.getSelectedModule(), null, this.getSelectedFolderType())) || this.getNameError(name2) != null) {
            return this.myFileNameField;
        }
        if (this.myResourceTypeCombo.isVisible()) {
            return this.myResourceTypeCombo;
        }
        if (this.myModuleCombo.isVisible()) {
            return this.myModuleCombo;
        }
        if (this.myRootElementFieldWrapper.isVisible()) {
            return this.myRootElementField;
        }
        return this.myDirectoryNameTextField;
    }

    private void setupUI() {
        this.myPanel = new JPanel();
        this.myPanel.setLayout((LayoutManager)new GridLayoutManager(8, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.myPanel.setPreferredSize(new Dimension(800, 400));
        this.myFileNameLabel = new JLabel();
        this.myFileNameLabel.setText("File name:");
        this.myFileNameLabel.setDisplayedMnemonic('F');
        this.myFileNameLabel.setDisplayedMnemonicIndex(0);
        this.myPanel.add((Component)this.myFileNameLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myFileNameField = new JTextField();
        this.myPanel.add((Component)this.myFileNameField, new GridConstraints(0, 1, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.myResTypeLabel = new JLabel();
        this.myResTypeLabel.setText("Resource type:");
        this.myResTypeLabel.setDisplayedMnemonic('R');
        this.myResTypeLabel.setDisplayedMnemonicIndex(0);
        this.myPanel.add((Component)this.myResTypeLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myUpDownHint = new JLabel();
        this.myUpDownHint.setToolTipText("Pressing Up or Down arrows while in editor changes the kind");
        this.myPanel.add((Component)this.myUpDownHint, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myResourceTypeCombo = new TemplateKindCombo();
        this.myPanel.add((Component)this.myResourceTypeCombo, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.myDeviceConfiguratorWrapper = new JPanel();
        this.myDeviceConfiguratorWrapper.setLayout(new BorderLayout(0, 0));
        this.myPanel.add((Component)this.myDeviceConfiguratorWrapper, new GridConstraints(6, 0, 1, 3, 0, 3, 3, 3, null, null, null, 0, false));
        this.myErrorLabel = new JBLabel();
        this.myPanel.add((Component)this.myErrorLabel, new GridConstraints(7, 0, 1, 3, 0, 3, 0, 0, null, null, null, 0, false));
        JBLabel jBLabel1 = new JBLabel();
        jBLabel1.setText("Directory name:");
        jBLabel1.setDisplayedMnemonic('Y');
        jBLabel1.setDisplayedMnemonicIndex(8);
        this.myPanel.add((Component)jBLabel1, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myDirectoryNameTextField = new JTextField();
        this.myDirectoryNameTextField.setEditable(true);
        this.myDirectoryNameTextField.setEnabled(true);
        this.myPanel.add((Component)this.myDirectoryNameTextField, new GridConstraints(5, 1, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.myRootElementLabel = new JBLabel();
        this.myRootElementLabel.setText("Root element:");
        this.myRootElementLabel.setDisplayedMnemonic('E');
        this.myRootElementLabel.setDisplayedMnemonicIndex(5);
        this.myPanel.add((Component)this.myRootElementLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myRootElementFieldWrapper = new JPanel();
        this.myRootElementFieldWrapper.setLayout(new BorderLayout(0, 0));
        this.myPanel.add((Component)this.myRootElementFieldWrapper, new GridConstraints(3, 1, 1, 1, 0, 3, 3, 0, null, null, null, 0, false));
        this.myModuleLabel = new JBLabel();
        this.myModuleLabel.setText("Module:");
        this.myModuleLabel.setDisplayedMnemonic('M');
        this.myModuleLabel.setDisplayedMnemonicIndex(0);
        this.myPanel.add((Component)this.myModuleLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myModuleCombo = new ModulesComboBox();
        this.myPanel.add((Component)this.myModuleCombo, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
        this.mySourceSetLabel = new JBLabel();
        this.mySourceSetLabel.setText("Source set:");
        this.mySourceSetLabel.setDisplayedMnemonic('S');
        this.mySourceSetLabel.setDisplayedMnemonicIndex(0);
        this.myPanel.add((Component)this.mySourceSetLabel, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.mySourceSetCombo = new JComboBox();
        this.myPanel.add((Component)this.mySourceSetCombo, new GridConstraints(4, 1, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
        this.myFileNameLabel.setLabelFor(this.myFileNameField);
        jBLabel1.setLabelFor((Component)this.myDirectoryNameTextField);
        this.myModuleLabel.setLabelFor((Component)this.myModuleCombo);
        this.mySourceSetLabel.setLabelFor((Component)this.myModuleCombo);
    }
}

