/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.ddms.DeviceNameProperties;
import com.android.tools.idea.ddms.DeviceNamePropertiesFetcher;
import com.android.tools.idea.ddms.DeviceRenderer;
import com.android.tools.idea.execution.common.debug.AndroidDebugger;
import com.android.tools.idea.execution.common.debug.RunConfigurationWithDebugger;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.run.NativeDebugOnRemoteDeviceChecker;
import com.android.tools.idea.run.editor.AndroidDebuggerInfoProvider;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidProcessChooserDialog
extends DialogWrapper {
    @NonNls
    private static final String DEBUGGABLE_PROCESS_PROPERTY = "DEBUGGABLE_PROCESS";
    @NonNls
    private static final String SHOW_ALL_PROCESSES_PROPERTY = "SHOW_ALL_PROCESSES";
    @NonNls
    private static final String DEBUGGABLE_DEVICE_PROPERTY = "DEBUGGABLE_DEVICE";
    @NonNls
    private static final String DEBUGGER_ID_PROPERTY = "DEBUGGER_ID";
    private final Project myProject;
    private final boolean myShowDebuggerSelection;
    private final MyProcessTreeCellRenderer myCellRenderer;
    private JPanel myContentPanel;
    private Tree myProcessTree;
    private JBCheckBox myShowAllProcessesCheckBox;
    private JLabel myDebuggerRunConfigLabel;
    private JComboBox<RunConfigurationWithDebugger> myDebuggerRunConfigCombo;
    private JLabel myDebuggerLabel;
    private JComboBox<AndroidDebugger> myDebuggerTypeCombo;
    private String myLastSelectedDevice;
    private String myLastSelectedProcess;
    private final MergingUpdateQueue myUpdatesQueue;
    private final AndroidDebugBridge.IClientChangeListener myClientChangeListener;
    private final AndroidDebugBridge.IDeviceChangeListener myDeviceChangeListener;
    private Client mySelectedClient;
    private RunConfigurationWithDebugger mySelectedRunConfiguration;
    private AndroidDebugger mySelectedAndroidDebugger;

    public AndroidProcessChooserDialog(@NotNull Project project, boolean showDebuggerSelection) {
        super(project);
        this.setupUI();
        this.setTitle("Choose Process");
        this.myShowDebuggerSelection = showDebuggerSelection;
        this.myProject = project;
        this.myUpdatesQueue = new MergingUpdateQueue("AndroidProcessChooserDialogUpdatingQueue", 500, true, MergingUpdateQueue.ANY_COMPONENT, this.getDisposable());
        PropertiesComponent properties = PropertiesComponent.getInstance((Project)this.myProject);
        this.myLastSelectedProcess = properties.getValue(DEBUGGABLE_PROCESS_PROPERTY);
        this.myLastSelectedDevice = properties.getValue(DEBUGGABLE_DEVICE_PROPERTY);
        String lastSelectedDebuggerId = properties.getValue(DEBUGGER_ID_PROPERTY);
        boolean showAllProcesses = Boolean.parseBoolean(properties.getValue(SHOW_ALL_PROCESSES_PROPERTY));
        this.myShowAllProcessesCheckBox.setSelected(showAllProcesses);
        this.myClientChangeListener = (client, changeMask) -> this.updateTree();
        AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)this.myClientChangeListener);
        this.myDeviceChangeListener = new AndroidDebugBridge.IDeviceChangeListener(){

            public void deviceConnected(@NotNull IDevice device2) {
                AndroidProcessChooserDialog.this.updateTree();
            }

            public void deviceDisconnected(@NotNull IDevice device2) {
                AndroidProcessChooserDialog.this.updateTree();
            }

            public void deviceChanged(@NotNull IDevice device2, int changeMask) {
                AndroidProcessChooserDialog.this.updateTree();
            }
        };
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this.myDeviceChangeListener);
        this.myShowAllProcessesCheckBox.addActionListener(e -> this.updateTree());
        this.setupDebuggerSelection(showDebuggerSelection, lastSelectedDebuggerId);
        this.myProcessTree.addTreeSelectionListener(e -> {
            IDevice selectedDevice = this.getSelectedDevice();
            Client selectedClient = this.getSelectedClient();
            this.myLastSelectedDevice = AndroidProcessChooserDialog.getPersistableName(selectedDevice);
            this.myLastSelectedProcess = AndroidProcessChooserDialog.getPersistableName(selectedClient);
            this.getOKAction().setEnabled(selectedDevice != null && selectedClient != null);
        });
        TreeSpeedSearch treeSpeedSearch = new TreeSpeedSearch(this, (JTree)this.myProcessTree, null){

            protected boolean isMatchingElement(Object element, String pattern) {
                Object userObject;
                Object lastComponent;
                if (element instanceof TreePath && (lastComponent = ((TreePath)element).getLastPathComponent()) instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)lastComponent).getUserObject()) instanceof Client) {
                    String pkg = ((Client)userObject).getClientData().getProcessName();
                    return pkg != null && pkg.contains(pattern);
                }
                return false;
            }
        };
        treeSpeedSearch.setupListeners();
        FutureCallback<DeviceNameProperties> callback2 = new FutureCallback<DeviceNameProperties>(){

            public void onSuccess(@Nullable DeviceNameProperties properties) {
                AndroidProcessChooserDialog.this.updateTree();
            }

            public void onFailure(@NotNull Throwable throwable) {
                if (!(throwable instanceof CancellationException)) {
                    Logger.getInstance(AndroidProcessChooserDialog.class).warn("Error retrieving device name properties", throwable);
                }
            }
        };
        DeviceNamePropertiesFetcher fetcher = new DeviceNamePropertiesFetcher(this.getDisposable(), callback2);
        boolean showSerialNumbers = DeviceRenderer.shouldShowSerialNumbers(this.getDeviceList(), fetcher);
        this.myCellRenderer = new MyProcessTreeCellRenderer(treeSpeedSearch, showSerialNumbers, fetcher);
        this.myProcessTree.setCellRenderer((TreeCellRenderer)((Object)this.myCellRenderer));
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                if (AndroidProcessChooserDialog.this.isOKActionEnabled()) {
                    AndroidProcessChooserDialog.this.doOKAction();
                    return true;
                }
                return false;
            }
        }.installOn((Component)this.myProcessTree);
        this.myProcessTree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && AndroidProcessChooserDialog.this.isOKActionEnabled()) {
                    AndroidProcessChooserDialog.this.doOKAction();
                }
            }
        });
        this.doUpdateTree(showAllProcesses);
        this.init();
    }

    private void setupDebuggerSelection(boolean showDebuggerSelection, @Nullable String lastSelectedDebuggerId) {
        if (!showDebuggerSelection) {
            this.myDebuggerLabel.setVisible(false);
            this.myDebuggerTypeCombo.setVisible(false);
            this.myDebuggerRunConfigLabel.setVisible(false);
            this.myDebuggerRunConfigCombo.setVisible(false);
            return;
        }
        this.myDebuggerRunConfigCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AndroidProcessChooserDialog.this.myDebuggerTypeCombo.setEnabled(AndroidProcessChooserDialog.this.myDebuggerRunConfigCombo.getSelectedItem() == null);
                AndroidProcessChooserDialog.this.myDebuggerLabel.setEnabled(AndroidProcessChooserDialog.this.myDebuggerRunConfigCombo.getSelectedItem() == null);
                PropertiesComponent properties = PropertiesComponent.getInstance((Project)AndroidProcessChooserDialog.this.myProject);
                String lastSelectedDebuggerId = properties.getValue(AndroidProcessChooserDialog.DEBUGGER_ID_PROPERTY);
                AndroidProcessChooserDialog.this.populateDebuggerTypeCombo((RunConfigurationWithDebugger)AndroidProcessChooserDialog.this.myDebuggerRunConfigCombo.getSelectedItem(), lastSelectedDebuggerId);
            }
        });
        List existingValidRunConfigurations = ContainerUtil.filterIsInstance((Collection)RunManager.getInstance((Project)this.myProject).getAllConfigurationsList(), RunConfigurationWithDebugger.class);
        ArrayList runConfigurations = new ArrayList();
        runConfigurations.add(null);
        runConfigurations.addAll(existingValidRunConfigurations);
        this.myDebuggerRunConfigCombo.setModel((ComboBoxModel<RunConfigurationWithDebugger>)new CollectionComboBoxModel(runConfigurations));
        this.myDebuggerRunConfigCombo.setRenderer((ListCellRenderer<RunConfigurationWithDebugger>)SimpleListCellRenderer.create((String)"[Use default settings]", RunProfile::getName));
        RunConfiguration configuration2 = this.getCurrentRunConfiguration();
        if (!existingValidRunConfigurations.contains(configuration2)) {
            configuration2 = null;
        }
        this.myDebuggerRunConfigCombo.setSelectedItem(configuration2);
        this.populateDebuggerTypeCombo((RunConfigurationWithDebugger)configuration2, lastSelectedDebuggerId);
    }

    private void populateDebuggerTypeCombo(@Nullable RunConfigurationWithDebugger configuration2, @Nullable String lastSelectedDebuggerId) {
        if (configuration2 != null) {
            this.myDebuggerRunConfigCombo.setSelectedItem(configuration2);
            this.myDebuggerLabel.setEnabled(false);
            this.myDebuggerTypeCombo.setEnabled(false);
        }
        ArrayList<AndroidDebugger> androidDebuggers = this.getAndroidDebuggers(configuration2);
        androidDebuggers.sort((left2, right) -> left2.getId().compareTo(right.getId()));
        this.myDebuggerTypeCombo.setModel((ComboBoxModel<AndroidDebugger>)new CollectionComboBoxModel(androidDebuggers));
        this.myDebuggerTypeCombo.setRenderer((ListCellRenderer<AndroidDebugger>)SimpleListCellRenderer.create((String)"", AndroidDebugger::getDisplayName));
        AndroidDebugger selectedDebugger = null;
        if (configuration2 != null) {
            for (AndroidDebuggerInfoProvider provider : (AndroidDebuggerInfoProvider[])AndroidDebuggerInfoProvider.EP_NAME.getExtensions()) {
                if (!provider.supportsProject(this.myProject)) continue;
                selectedDebugger = provider.getSelectedAndroidDebugger((RunConfiguration)configuration2);
                break;
            }
        }
        if (selectedDebugger == null) {
            AndroidDebugger defaultDebugger = null;
            for (AndroidDebugger androidDebugger : androidDebuggers) {
                if (selectedDebugger == null && lastSelectedDebuggerId != null && androidDebugger.getId().equals(lastSelectedDebuggerId)) {
                    selectedDebugger = androidDebugger;
                    continue;
                }
                if (!androidDebugger.shouldBeDefault()) continue;
                defaultDebugger = androidDebugger;
            }
            if (selectedDebugger == null) {
                if (defaultDebugger != null) {
                    selectedDebugger = defaultDebugger;
                } else if (!androidDebuggers.isEmpty()) {
                    selectedDebugger = (AndroidDebugger)androidDebuggers.get(0);
                }
            }
        }
        if (selectedDebugger != null) {
            for (AndroidDebugger debugger : androidDebuggers) {
                if (!debugger.getId().equals(selectedDebugger.getId())) continue;
                this.myDebuggerTypeCombo.setSelectedItem(debugger);
            }
        }
    }

    private ArrayList<AndroidDebugger> getAndroidDebuggers(@Nullable RunConfigurationWithDebugger configuration2) {
        if (configuration2 != null) {
            for (AndroidDebuggerInfoProvider provider : (AndroidDebuggerInfoProvider[])AndroidDebuggerInfoProvider.EP_NAME.getExtensions()) {
                if (!provider.supportsProject(this.myProject)) continue;
                return Lists.newArrayList(provider.getAndroidDebuggers((RunConfiguration)configuration2));
            }
        }
        ArrayList<AndroidDebugger> androidDebuggers = new ArrayList<AndroidDebugger>();
        for (AndroidDebugger androidDebugger : (AndroidDebugger[])AndroidDebugger.EP_NAME.getExtensions()) {
            if (!androidDebugger.supportsProject(this.myProject)) continue;
            androidDebuggers.add(androidDebugger);
        }
        return androidDebuggers;
    }

    @Nullable
    private RunConfiguration getCurrentRunConfiguration() {
        RunnerAndConfigurationSettings currentRunnerAndConfigurationSettings = RunManager.getInstance((Project)this.myProject).getSelectedConfiguration();
        if (currentRunnerAndConfigurationSettings == null) {
            return null;
        }
        return currentRunnerAndConfigurationSettings.getConfiguration();
    }

    private void setupUI() {
        this.myContentPanel = new JPanel();
        this.myContentPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1));
        JBLabel jBLabel1 = new JBLabel();
        jBLabel1.setText("Select a process to attach to:");
        jBLabel1.setDisplayedMnemonic('S');
        jBLabel1.setDisplayedMnemonicIndex(0);
        this.myContentPanel.add((Component)jBLabel1, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null, 0, false));
        JBScrollPane jBScrollPane1 = new JBScrollPane();
        this.myContentPanel.add((Component)jBScrollPane1, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, new Dimension(250, 300), null, 0, false));
        this.myProcessTree = new Tree();
        this.myProcessTree.setRootVisible(false);
        this.myProcessTree.setShowsRootHandles(true);
        jBScrollPane1.setViewportView((Component)this.myProcessTree);
        this.myShowAllProcessesCheckBox = new JBCheckBox();
        this.myShowAllProcessesCheckBox.setText("Show all processes");
        this.myShowAllProcessesCheckBox.setMnemonic('A');
        this.myShowAllProcessesCheckBox.setDisplayedMnemonicIndex(5);
        this.myContentPanel.add((Component)this.myShowAllProcessesCheckBox, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, null, null, 0, false));
        this.myDebuggerRunConfigLabel = new JLabel();
        this.myDebuggerRunConfigLabel.setText("Use Android Debugger Settings from:");
        this.myContentPanel.add((Component)this.myDebuggerRunConfigLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myDebuggerRunConfigCombo = new JComboBox();
        this.myContentPanel.add(this.myDebuggerRunConfigCombo, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
        this.myDebuggerLabel = new JLabel();
        this.myDebuggerLabel.setText("Debug Type:");
        this.myContentPanel.add((Component)this.myDebuggerLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myDebuggerTypeCombo = new JComboBox();
        this.myDebuggerTypeCombo.setEnabled(true);
        this.myContentPanel.add(this.myDebuggerTypeCombo, new GridConstraints(3, 1, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
        jBLabel1.setLabelFor((Component)jBScrollPane1);
        this.myDebuggerLabel.setLabelFor(this.myDebuggerTypeCombo);
    }

    @NotNull
    private static String getPersistableName(@Nullable Client client) {
        return client == null ? "" : client.getClientData().getProcessName();
    }

    @NotNull
    private static String getPersistableName(@Nullable IDevice device2) {
        return device2 == null ? "" : device2.getName();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myProcessTree;
    }

    @Nullable
    protected String getHelpId() {
        return "org.jetbrains.android.studio/debug/index.html";
    }

    protected void dispose() {
        super.dispose();
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this.myDeviceChangeListener);
        AndroidDebugBridge.removeClientChangeListener((AndroidDebugBridge.IClientChangeListener)this.myClientChangeListener);
    }

    private void updateTree() {
        final boolean showAllProcesses = this.myShowAllProcessesCheckBox.isSelected();
        this.myUpdatesQueue.queue(new Update((Object)this){

            public void run() {
                AndroidDebugBridge debugBridge = AndroidSdkUtils.getDebugBridge(AndroidProcessChooserDialog.this.myProject);
                if (debugBridge != null && AndroidProcessChooserDialog.isDdmsCorrupted(debugBridge)) {
                    ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Component)AndroidProcessChooserDialog.this.myContentPanel, (String)AndroidBundle.message("ddms.corrupted.error", new Object[0])));
                    return;
                }
                AndroidProcessChooserDialog.this.doUpdateTree(showAllProcesses);
            }

            public boolean canEat(@NotNull Update update2) {
                return true;
            }
        });
    }

    private List<IDevice> getDeviceList() {
        AndroidDebugBridge debugBridge = AndroidSdkUtils.getDebugBridge(this.myProject);
        if (debugBridge == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(debugBridge.getDevices());
    }

    private void doUpdateTree(boolean showAllProcesses) {
        IDevice[] devices2;
        AndroidDebugBridge debugBridge = AndroidSdkUtils.getDebugBridge(this.myProject);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        DefaultTreeModel model = new DefaultTreeModel(root);
        if (debugBridge == null) {
            this.myProcessTree.setModel((TreeModel)model);
            return;
        }
        Set<String> processNames = AndroidProcessChooserDialog.collectAllProcessNames(this.myProject);
        DefaultMutableTreeNode selectedDeviceNode = null;
        DefaultMutableTreeNode selectedClientNode = null;
        Object[] firstTreePath = null;
        for (IDevice device2 : devices2 = debugBridge.getDevices()) {
            DefaultMutableTreeNode deviceNode = new DefaultMutableTreeNode(device2);
            root.add(deviceNode);
            String deviceName = device2.getName();
            if (deviceName.equals(this.myLastSelectedDevice)) {
                selectedDeviceNode = deviceNode;
            }
            ArrayList clients = Lists.newArrayList((Object[])device2.getClients());
            Collections.sort(clients, (c1, c2) -> {
                String n1 = StringUtil.notNullize((String)c1.getClientData().getProcessName());
                String n2 = StringUtil.notNullize((String)c2.getClientData().getProcessName());
                return n1.compareTo(n2);
            });
            for (Client client : clients) {
                String clientDescription = client.getClientData().getProcessName();
                if (clientDescription == null || !showAllProcesses && !AndroidProcessChooserDialog.isRelatedProcess(processNames, clientDescription)) continue;
                DefaultMutableTreeNode clientNode = new DefaultMutableTreeNode(client);
                deviceNode.add(clientNode);
                if (clientDescription.equals(this.myLastSelectedProcess) && (selectedDeviceNode == null || deviceName.equals(this.myLastSelectedDevice))) {
                    selectedClientNode = clientNode;
                    selectedDeviceNode = deviceNode;
                }
                if (firstTreePath != null) continue;
                firstTreePath = new Object[]{root, deviceNode, clientNode};
            }
        }
        Object[] pathToSelect = selectedDeviceNode != null && selectedClientNode != null ? new Object[]{root, selectedDeviceNode, selectedClientNode} : (selectedDeviceNode != null ? new Object[]{root, selectedDeviceNode} : firstTreePath);
        if (this.myCellRenderer != null) {
            this.myCellRenderer.setShowSerial(Arrays.asList(devices2));
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            this.myProcessTree.setModel((TreeModel)model);
            if (pathToSelect != null) {
                this.myProcessTree.getSelectionModel().setSelectionPath(new TreePath(pathToSelect));
            } else {
                this.getOKAction().setEnabled(false);
            }
            TreeUtil.expandAll((JTree)this.myProcessTree);
        });
    }

    private static boolean isRelatedProcess(Set<String> processNames, String clientDescription) {
        String lc = StringUtil.toLowerCase((String)clientDescription);
        for (String processName : processNames) {
            if (!lc.startsWith(processName)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static Set<String> collectAllProcessNames(Project project) {
        List facets = ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID);
        HashSet<String> result2 = new HashSet<String>();
        for (AndroidFacet facet : facets) {
            AndroidModel androidModel;
            XmlElement xmlElement;
            Manifest manifest;
            String packageName = AndroidCompileUtil.getAaptManifestPackage(facet);
            if (packageName != null) {
                result2.add(StringUtil.toLowerCase((String)packageName));
            }
            if ((manifest = Manifest.getMainManifest(facet)) != null && (xmlElement = manifest.getXmlElement()) != null) {
                AndroidProcessChooserDialog.collectProcessNames(xmlElement, result2);
            }
            if ((androidModel = AndroidModel.get(facet)) == null) continue;
            result2.addAll(androidModel.getAllApplicationIds());
        }
        return result2;
    }

    private static void collectProcessNames(XmlElement xmlElement, final Set<String> result2) {
        xmlElement.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitXmlAttribute(@NotNull XmlAttribute attribute2) {
                String value2;
                if ("process".equals(attribute2.getLocalName()) && (value2 = attribute2.getValue()) != null) {
                    result2.add(StringUtil.toLowerCase((String)value2));
                }
            }
        });
    }

    protected JComponent createCenterPanel() {
        return this.myContentPanel;
    }

    protected void doOKAction() {
        PropertiesComponent properties = PropertiesComponent.getInstance((Project)this.myProject);
        IDevice selectedDevice = this.getSelectedDevice();
        if (selectedDevice == null) {
            return;
        }
        this.mySelectedClient = this.getSelectedClient();
        if (this.mySelectedClient == null) {
            return;
        }
        this.mySelectedAndroidDebugger = (AndroidDebugger)this.myDebuggerTypeCombo.getSelectedItem();
        properties.setValue(DEBUGGABLE_DEVICE_PROPERTY, AndroidProcessChooserDialog.getPersistableName(selectedDevice));
        properties.setValue(DEBUGGABLE_PROCESS_PROPERTY, AndroidProcessChooserDialog.getPersistableName(this.mySelectedClient));
        properties.setValue(SHOW_ALL_PROCESSES_PROPERTY, Boolean.toString(this.myShowAllProcessesCheckBox.isSelected()));
        if (this.mySelectedAndroidDebugger != null) {
            properties.setValue(DEBUGGER_ID_PROPERTY, this.mySelectedAndroidDebugger.getId());
            NativeDebugOnRemoteDeviceChecker deviceChecker = new NativeDebugOnRemoteDeviceChecker(this.myProject);
            boolean ok2 = deviceChecker.showWarningIfNeeded(this.mySelectedAndroidDebugger, selectedDevice.getSerialNumber());
            if (!ok2) {
                return;
            }
        }
        this.mySelectedRunConfiguration = (RunConfigurationWithDebugger)this.myDebuggerRunConfigCombo.getSelectedItem();
        super.doOKAction();
    }

    @Nullable
    public Client getClient() {
        return this.mySelectedClient;
    }

    @Nullable
    public RunConfigurationWithDebugger getRunConfiguration() {
        return this.mySelectedRunConfiguration;
    }

    @NotNull
    public AndroidDebugger getSelectedAndroidDebugger() {
        assert (this.myShowDebuggerSelection) : "Cannot obtain debugger after constructing dialog w/o debugger selection combo";
        return this.mySelectedAndroidDebugger;
    }

    protected String getDimensionServiceKey() {
        return "AndroidProcessChooserDialog";
    }

    @Nullable
    private IDevice getSelectedDevice() {
        TreePath selectionPath = this.myProcessTree.getSelectionPath();
        if (selectionPath == null || selectionPath.getPathCount() < 2) {
            return null;
        }
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)selectionPath.getPathComponent(1);
        Object obj = selectedNode.getUserObject();
        return obj instanceof IDevice ? (IDevice)obj : null;
    }

    @Nullable
    private Client getSelectedClient() {
        TreePath selectionPath = this.myProcessTree.getSelectionPath();
        if (selectionPath == null || selectionPath.getPathCount() < 3) {
            return null;
        }
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)selectionPath.getPathComponent(2);
        Object obj = selectedNode.getUserObject();
        return obj instanceof Client ? (Client)obj : null;
    }

    public static boolean isDdmsCorrupted(@NotNull AndroidDebugBridge bridge) {
        IDevice[] devices2 = bridge.getDevices();
        if (devices2.length > 0) {
            for (IDevice device2 : devices2) {
                Client[] clients = device2.getClients();
                if (clients.length <= 0) continue;
                ClientData clientData = clients[0].getClientData();
                return clientData.getVmIdentifier() == null;
            }
        }
        return false;
    }

    private static class MyProcessTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private final TreeSpeedSearch mySpeedSearch;
        private boolean myShowSerial;
        private final DeviceNamePropertiesFetcher myDeviceNamePropertiesFetcher;

        private MyProcessTreeCellRenderer(@NotNull TreeSpeedSearch treeSpeedSearch, boolean showSerial, @NotNull DeviceNamePropertiesFetcher deviceNamePropertiesFetcher) {
            this.mySpeedSearch = treeSpeedSearch;
            this.myShowSerial = showSerial;
            this.myDeviceNamePropertiesFetcher = deviceNamePropertiesFetcher;
        }

        private void setShowSerial(@NotNull List<IDevice> devices2) {
            this.myShowSerial = DeviceRenderer.shouldShowSerialNumbers(devices2, this.myDeviceNamePropertiesFetcher);
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (!(value2 instanceof DefaultMutableTreeNode)) {
                return;
            }
            Object userObject = ((DefaultMutableTreeNode)value2).getUserObject();
            if (userObject instanceof IDevice && !Disposer.isDisposed((Disposable)this.myDeviceNamePropertiesFetcher)) {
                IDevice device2 = (IDevice)userObject;
                DeviceRenderer.renderDeviceName(device2, this.myDeviceNamePropertiesFetcher.get(device2), (ColoredTextContainer)this, this.myShowSerial);
            } else if (userObject instanceof Client) {
                ClientData clientData = ((Client)userObject).getClientData();
                SimpleTextAttributes attr = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                SearchUtil.appendFragments((String)this.mySpeedSearch.getEnteredPrefix(), (String)clientData.getProcessName(), (int)attr.getStyle(), (Color)attr.getFgColor(), (Color)attr.getBgColor(), (SimpleColoredComponent)this);
                if (clientData.isValidUserId() && clientData.getUserId() != 0) {
                    this.append(" (user " + Integer.toString(clientData.getUserId()) + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
            }
        }
    }
}

