/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rendering.security;

import com.android.tools.rendering.RenderService;
import com.android.tools.rendering.security.RenderPropertiesAccessUtil;
import com.android.tools.rendering.security.RenderSecurityException;
import com.android.tools.rendering.security.RenderSecurityManagerDefaults;
import com.android.utils.ILogger;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FilePermission;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.Permission;
import java.util.Arrays;
import java.util.PropertyPermission;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class RenderSecurityManager
extends SecurityManager {
    public static final String ENABLED_PROPERTY = "android.render.sandbox";
    public static boolean sEnabled = !"false".equals(System.getProperty("android.render.sandbox"));
    private static Object sCredential;
    private static String sLastFailedPath;
    private final String[] mAllowedPaths;
    private boolean mAllowSetSecurityManager;
    private boolean mDisabled;
    private final String mSdkPath;
    private final String mProjectPath;
    private final String mTempDir;
    private final String mNormalizedTempDir;
    private String mCanonicalTempDir;
    private String mAppTempDir;
    private SecurityManager myPreviousSecurityManager;
    private ILogger mLogger;
    private boolean isRestrictReads;
    private final Supplier<Boolean> isRenderThread;

    public static RenderSecurityManager getCurrent() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager instanceof RenderSecurityManager) {
            RenderSecurityManager manager = (RenderSecurityManager)securityManager;
            return manager.isRelevant() ? manager : null;
        }
        return null;
    }

    protected RenderSecurityManager(String sdkPath, String projectPath, boolean restrictReads, @NotNull String[] allowedPaths, @NotNull Supplier<Boolean> isRenderThread) {
        this.mSdkPath = sdkPath;
        this.mProjectPath = projectPath;
        this.mTempDir = System.getProperty("java.io.tmpdir");
        this.mNormalizedTempDir = new File(this.mTempDir).getPath();
        this.mAllowedPaths = allowedPaths;
        sLastFailedPath = null;
        this.isRestrictReads = restrictReads;
        this.isRenderThread = isRenderThread;
    }

    @NotNull
    static RenderSecurityManager createForTests(String sdkPath, String projectPath, boolean restrictReads, @NotNull Supplier<Boolean> isRenderThread) {
        return new RenderSecurityManager(sdkPath, projectPath, restrictReads, RenderSecurityManagerDefaults.getDefaultAllowedPaths(), isRenderThread);
    }

    @NotNull
    public static RenderSecurityManager create(String sdkPath, String projectPath, boolean restrictReads, @NotNull String[] allowedPaths) {
        return new RenderSecurityManager(sdkPath, projectPath, restrictReads, allowedPaths, RenderService::isRenderThread);
    }

    public RenderSecurityManager setLogger(ILogger logger) {
        this.mLogger = logger;
        return this;
    }

    public RenderSecurityManager setAppTempDir(String appTempDir) {
        this.mAppTempDir = appTempDir;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActive(boolean active, Object credential) {
        boolean isActive;
        SecurityManager current = System.getSecurityManager();
        boolean bl = isActive = current == this;
        if (active == isActive) {
            return;
        }
        if (active) {
            assert (!(current instanceof RenderSecurityManager));
            this.myPreviousSecurityManager = current;
            this.mDisabled = false;
            System.setSecurityManager(this);
            sCredential = credential;
        } else {
            if (credential != sCredential) {
                throw RenderSecurityException.create("Invalid credential");
            }
            this.mAllowSetSecurityManager = true;
            try {
                if (current instanceof RenderSecurityManager) {
                    System.setSecurityManager(this.myPreviousSecurityManager);
                } else if (this.mLogger != null) {
                    this.mLogger.warning("Security manager was changed behind the scenes: ", new Object[]{current});
                }
            }
            finally {
                this.mDisabled = true;
                this.mAllowSetSecurityManager = false;
            }
        }
    }

    protected boolean isRelevant() {
        return sEnabled && !this.mDisabled && this.isRenderThread.get() != false;
    }

    public void dispose(Object credential) {
        this.setActive(false, credential);
    }

    public static boolean enterSafeRegion(Object credential) {
        boolean token = sEnabled;
        if (credential == sCredential) {
            sEnabled = false;
        }
        return token;
    }

    public static void exitSafeRegion(boolean token) {
        sEnabled = token;
    }

    public static void runInSafeRegion(Object credential, @NotNull Runnable runnable2) {
        boolean token = RenderSecurityManager.enterSafeRegion(credential);
        try {
            runnable2.run();
        }
        finally {
            RenderSecurityManager.exitSafeRegion(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T runInSafeRegion(Object credential, @NotNull Callable<T> callable) throws Exception {
        boolean token = RenderSecurityManager.enterSafeRegion(credential);
        try {
            T t = callable.call();
            return t;
        }
        finally {
            RenderSecurityManager.exitSafeRegion(token);
        }
    }

    public static String getLastFailedPath() {
        return sLastFailedPath;
    }

    @Override
    public void checkPackageAccess(String pkg) {
    }

    @Override
    public void checkPropertyAccess(String property2) {
    }

    @Override
    public void checkPropertiesAccess() {
        boolean isWithinLogger;
        if (this.isRelevant() && !RenderPropertiesAccessUtil.isPropertyAccessAllowed() && !(isWithinLogger = Arrays.stream(this.getClassContext()).anyMatch(clazz2 -> "Logger".equals(clazz2.getSimpleName()) && "com.intellij.openapi.diagnostic.Logger".equals(clazz2.getCanonicalName())))) {
            throw RenderSecurityException.create("Property", null);
        }
    }

    @Override
    public void checkCreateClassLoader() {
    }

    @Override
    public void checkRead(String file) {
        if (this.isRestrictReads && this.isRelevant() && !this.isReadingAllowed(file)) {
            throw RenderSecurityException.create("Read", file);
        }
    }

    @Override
    public void checkRead(String file, Object context) {
        if (this.isRestrictReads && this.isRelevant() && !this.isReadingAllowed(file)) {
            throw RenderSecurityException.create("Read", file);
        }
    }

    private boolean isReadingAllowed(String path) {
        if (this.isRestrictReads) {
            try {
                path = RenderSecurityManager.canonicalize(path);
            }
            catch (IOException e) {
                return false;
            }
            if (this.mSdkPath != null && path.startsWith(this.mSdkPath)) {
                return true;
            }
            if (this.mProjectPath != null && path.startsWith(this.mProjectPath)) {
                return true;
            }
            if (path.startsWith("#") && path.indexOf(File.separatorChar) == -1) {
                return true;
            }
            if (path.endsWith(".class") || path.endsWith(".jar")) {
                return true;
            }
            if (this.isTempDirPath(path)) {
                return true;
            }
            String javaHome = System.getProperty("java.home");
            if (path.startsWith(javaHome)) {
                return true;
            }
            return javaHome.endsWith("/Contents/Home") && path.regionMatches(0, javaHome, 0, javaHome.length() - "Contents/Home".length());
        }
        return true;
    }

    private static String canonicalize(@NotNull String path) throws IOException {
        return Paths.get(path, new String[0]).normalize().toFile().getCanonicalPath();
    }

    private boolean isInAllowedPath(@NotNull String path) {
        for (int i = 0; i < this.mAllowedPaths.length; ++i) {
            if (!path.startsWith(this.mAllowedPaths[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isWritingAllowed(String path) {
        try {
            path = RenderSecurityManager.canonicalize(path);
            if (Files.isSymbolicLink(Paths.get(path, new String[0]))) {
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        return this.isTempDirPath(path) || this.isInAllowedPath(path);
    }

    private boolean isTempDirPath(String path) {
        if (path.startsWith(this.mTempDir) || path.startsWith(this.mNormalizedTempDir)) {
            return true;
        }
        if (this.mAppTempDir != null && path.startsWith(this.mAppTempDir)) {
            return true;
        }
        try {
            if (this.mCanonicalTempDir == null) {
                this.mCanonicalTempDir = RenderSecurityManager.canonicalize(this.mNormalizedTempDir);
            }
            if (path.startsWith(this.mCanonicalTempDir) || RenderSecurityManager.canonicalize(path).startsWith(this.mCanonicalTempDir)) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        sLastFailedPath = path;
        return false;
    }

    private static boolean isPropertyWriteAllowed(String name2) {
        if (name2.equals("sun.font.fontmanager")) {
            return true;
        }
        if (name2.startsWith("sun.awt.") || name2.startsWith("apple.awt.")) {
            return true;
        }
        return name2.equals("user.timezone");
    }

    @Override
    public void checkExit(int status2) {
        if (this.isRelevant()) {
            throw RenderSecurityException.create("Exit", String.valueOf(status2));
        }
        super.checkExit(status2);
    }

    @Override
    public void checkPackageDefinition(String pkg) {
        if (this.isRelevant()) {
            throw RenderSecurityException.create("Package", pkg);
        }
    }

    @Override
    public void checkExec(String cmd) {
        if (this.isRelevant()) {
            throw RenderSecurityException.create("Exec", cmd);
        }
    }

    @Override
    public void checkConnect(String host, int port) {
        if (this.isRelevant()) {
            throw RenderSecurityException.create("Socket", host + ":" + port);
        }
    }

    @Override
    public void checkConnect(String host, int port, Object context) {
        if (this.isRelevant()) {
            throw RenderSecurityException.create("Socket", host + ":" + port);
        }
    }

    @Override
    public void checkListen(int port) {
        if (this.isRelevant()) {
            throw RenderSecurityException.create("Socket", "port " + port);
        }
    }

    @Override
    public void checkAccept(String host, int port) {
        if (this.isRelevant()) {
            throw RenderSecurityException.create("Socket", host + ":" + port);
        }
    }

    @Override
    public void checkSetFactory() {
        if (this.isRelevant()) {
            throw RenderSecurityException.create("Socket", null);
        }
    }

    @Override
    public void checkMulticast(InetAddress inetAddress) {
        if (this.isRelevant()) {
            throw RenderSecurityException.create("Socket", inetAddress.getCanonicalHostName());
        }
    }

    @Override
    public void checkMulticast(InetAddress inetAddress, byte ttl) {
        if (this.isRelevant()) {
            throw RenderSecurityException.create("Socket", inetAddress.getCanonicalHostName());
        }
    }

    @Override
    public void checkDelete(String file) {
        if (this.isRelevant()) {
            if (this.isWritingAllowed(file)) {
                return;
            }
            throw RenderSecurityException.create("Delete", file);
        }
    }

    @Override
    public void checkWrite(FileDescriptor fileDescriptor) {
        if (this.isRelevant()) {
            throw RenderSecurityException.create("Write", fileDescriptor.toString());
        }
    }

    @Override
    public void checkWrite(String file) {
        if (this.isRelevant()) {
            if (this.isWritingAllowed(file)) {
                return;
            }
            throw RenderSecurityException.create("Write", file);
        }
    }

    @Override
    public void checkPrintJobAccess() {
        if (this.isRelevant()) {
            throw RenderSecurityException.create("Print", null);
        }
    }

    @Override
    public void checkAccess(Thread thread) {
    }

    @Override
    public void checkAccess(ThreadGroup threadGroup) {
    }

    @Override
    public void checkPermission(Permission permission) {
        String name2 = permission.getName();
        if ("setSecurityManager".equals(name2)) {
            if (this.isRelevant()) {
                if (!this.mAllowSetSecurityManager) {
                    throw RenderSecurityException.create("Security", null);
                }
            } else if (this.mLogger != null) {
                this.mLogger.warning("RenderSecurityManager being replaced by another thread", new Object[0]);
            }
        } else if ("accessEventQueue".equals(name2)) {
            if (this.isRelevant()) {
                throw RenderSecurityException.create("Event", null);
            }
        } else if ("accessClipboard".equals(name2)) {
            if (this.isRelevant()) {
                throw RenderSecurityException.create("Clipboard", null);
            }
        } else if ("showWindowWithoutWarningBanner".equals(name2)) {
            if (this.isRelevant()) {
                throw RenderSecurityException.create("Window", null);
            }
        } else if ("symbolic".equals(name2)) {
            if (this.isRelevant()) {
                throw RenderSecurityException.create("SymbolicLinks", null);
            }
        } else if (this.isRelevant()) {
            String actions2 = permission.getActions();
            if (this.isRestrictReads && "read".equals(actions2)) {
                if (!this.isReadingAllowed(name2)) {
                    throw RenderSecurityException.create("Read", name2);
                }
            } else if (!(actions2.isEmpty() || actions2.equals("read") || permission instanceof FilePermission && this.isWritingAllowed(name2))) {
                if (permission instanceof PropertyPermission && RenderSecurityManager.isPropertyWriteAllowed(name2)) {
                    return;
                }
                throw RenderSecurityException.create("Write", name2);
            }
        }
    }
}

