/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rendering;

import com.android.tools.rendering.HtmlLinkManager;
import com.android.tools.rendering.IRenderLogger;
import com.android.tools.rendering.ProblemSeverity;
import com.android.tools.rendering.RenderProblem;
import com.android.tools.rendering.security.RenderSecurityManager;
import com.android.utils.HtmlBuilder;
import com.android.utils.XmlUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.v1.XmlPullParserException;

public class RenderLogger
implements IRenderLogger {
    public static final RenderLogger NOP_RENDER_LOGGER = new RenderLogger(){

        @Override
        public void addMessage(@NotNull RenderProblem message) {
        }

        @Override
        public void error(@Nullable String tag, @Nullable String message, @Nullable Object viewCookie, @Nullable Object data2) {
        }

        @Override
        public void error(@Nullable String tag, @Nullable String message, @Nullable Throwable throwable, @Nullable Object viewCookie, @Nullable Object data2) {
        }

        @Override
        public void warning(@Nullable String tag, @NotNull String message, @Nullable Object viewCookie, @Nullable Object data2) {
        }

        @Override
        public void fidelityWarning(@Nullable String tag, @Nullable String message, @Nullable Throwable throwable, @Nullable Object viewCookie, @Nullable Object data2) {
        }

        @Override
        public void setHasLoadedClasses() {
        }

        @Override
        public void setMissingResourceClass() {
        }

        @Override
        public void setResourceClass(@NotNull String resourceClass) {
        }

        @Override
        public void addMissingClass(@NotNull String className) {
        }

        @Override
        public void addBrokenClass(@NotNull String className, @NotNull Throwable exception) {
        }

        @Override
        public void logAndroidFramework(int priority, String tag, @NotNull String message) {
        }
    };
    public static final String TAG_MISSING_DIMENSION = "missing.dimension";
    public static final String TAG_MISSING_FRAGMENT = "missing.fragment";
    public static final String TAG_STILL_BUILDING = "project.building";
    private static final Logger LOG = Logger.getInstance((String)"#com.android.tools.idea.rendering.RenderLogger");
    @VisibleForTesting
    static final int RENDER_PROBLEMS_LIMIT = Integer.getInteger("com.android.tools.idea.rendering.RENDER_PROBLEMS_LIMIT", 100);
    @VisibleForTesting
    static final int STACK_OVERFLOW_TRACE_LIMIT = Integer.getInteger("com.android.tools.idea.rendering.STACK_OVERFLOW_TRACE_LIMIT", 100);
    private static Set<String> ourIgnoredFidelityWarnings;
    private static boolean ourIgnoreAllFidelityWarnings;
    private static boolean ourIgnoreFragments;
    private final String myProjectBasePath;
    private Set<String> myFidelityWarningStrings;
    private boolean myHaveExceptions;
    private Multiset<String> myTags;
    private final List<RenderProblem> myMessages = new ArrayList<RenderProblem>();
    private int myMessagesOverflowCounter;
    private List<RenderProblem> myFidelityWarnings;
    private Set<String> myMissingClasses;
    private Map<String, Throwable> myBrokenClasses;
    private String myResourceClass;
    private boolean myMissingResourceClass;
    private boolean myHasLoadedClasses;
    private HtmlLinkManager myLinkManager;
    private boolean myMissingSize;
    private List<String> myMissingFragments;
    private Object myCredential;
    private final boolean myLogFramework;
    private final RenderProblemBuilder myRenderProblemBuilder;
    private final Supplier<HtmlLinkManager> myHtmlLinkManagerFactory;
    private static final int ANDROID_LOG_VERBOSE = 0;
    private static final int ANDROID_LOG_DEBUG = 1;
    private static final int ANDROID_LOG_INFO = 2;
    private static final int ANDROID_LOG_WARN = 3;
    private static final int ANDROID_LOG_ERROR = 4;
    private static final int ANDROID_LOG_FATAL_WITHOUT_ABORT = 5;
    private static final int ANDROID_LOG_FATAL = 6;

    public RenderLogger(@Nullable Project project, @Nullable Object credential, boolean logFramework, @NotNull RenderProblem.ActionFixFactory fixFactory, @NotNull Supplier<HtmlLinkManager> linkManagerFactory) {
        this.myProjectBasePath = project == null ? null : project.getBasePath();
        this.myCredential = credential;
        this.myLogFramework = logFramework;
        this.myHtmlLinkManagerFactory = linkManagerFactory;
        this.myRenderProblemBuilder = (throwable, tag, description2) -> RenderProblem.createHtml(ProblemSeverity.ERROR, description2, this.getLinkManager(), throwable, fixFactory).tag(tag);
    }

    public RenderLogger(@Nullable Project project) {
        this(project, null, false, RenderProblem.NOOP_ACTION_FIX_FACTORY, () -> HtmlLinkManager.NOOP_LINK_MANAGER);
    }

    @VisibleForTesting
    public RenderLogger() {
        this(null);
    }

    @VisibleForTesting
    public static void resetFidelityErrorsFilters() {
        ourIgnoreAllFidelityWarnings = false;
        if (ourIgnoredFidelityWarnings != null) {
            ourIgnoredFidelityWarnings.clear();
        }
    }

    public static void ignoreFidelityWarning(@NotNull Object clientData) {
        if (ourIgnoredFidelityWarnings == null) {
            ourIgnoredFidelityWarnings = new HashSet<String>();
        }
        ourIgnoredFidelityWarnings.add((String)clientData);
    }

    public static void ignoreAllFidelityWarnings() {
        ourIgnoreAllFidelityWarnings = true;
    }

    public static void ignoreFragments() {
        ourIgnoreFragments = true;
    }

    @NotNull
    private static String describe(@Nullable String message, @Nullable Throwable throwable) {
        if (StringUtil.isEmptyOrSpaces((String)message)) {
            return throwable != null && throwable.getMessage() != null ? throwable.getMessage() : "";
        }
        return message;
    }

    public static boolean isIssue164378(@Nullable Throwable throwable) {
        StackTraceElement[] stackTrace;
        return throwable instanceof NoSuchFieldError && (stackTrace = throwable.getStackTrace()).length >= 1 && stackTrace[0].getClassName().startsWith("android.support");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logMessageToIdeaLog(@NotNull String message, @Nullable Throwable t) {
        Object logMessage;
        if (t == null) {
            logMessage = message;
        } else {
            StringWriter stringWriter = new StringWriter();
            PrintWriter writer2 = new PrintWriter(stringWriter);
            writer2.println(t.getMessage());
            t.printStackTrace(writer2);
            logMessage = message + "\n" + stringWriter.toString();
        }
        boolean token = RenderSecurityManager.enterSafeRegion(this.myCredential);
        try {
            LOG.debug((String)logMessage);
        }
        finally {
            RenderSecurityManager.exitSafeRegion(token);
        }
    }

    private void logMessageToIdeaLog(@NotNull String message) {
        this.logMessageToIdeaLog(message, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMessage(@NotNull RenderProblem message) {
        List<RenderProblem> list2 = this.myMessages;
        synchronized (list2) {
            if (this.myMessages.size() < RENDER_PROBLEMS_LIMIT) {
                this.myMessages.add(message);
            } else {
                ++this.myMessagesOverflowCounter;
            }
        }
        this.logMessageToIdeaLog(XmlUtils.fromXmlAttributeValue((String)message.getHtml()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<RenderProblem> getMessages() {
        int overflowCounter;
        ImmutableList.Builder builder = ImmutableList.builder();
        List<RenderProblem> list2 = this.myMessages;
        synchronized (list2) {
            builder.addAll(this.myMessages);
            overflowCounter = this.myMessagesOverflowCounter;
        }
        if (overflowCounter > 0) {
            builder.add((Object)RenderProblem.createPlain(ProblemSeverity.WARNING, String.format(Locale.US, "Too many errors (%d more errors not displayed)", overflowCounter)));
        }
        return builder.build();
    }

    public boolean hasProblems() {
        return this.hasErrors() || this.myFidelityWarnings != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasErrors() {
        boolean hasErrorMessage;
        List<RenderProblem> list2 = this.myMessages;
        synchronized (list2) {
            hasErrorMessage = this.myMessages.stream().anyMatch(message -> message.getSeverity().compareTo(ProblemSeverity.ERROR) >= 0);
        }
        return this.myHaveExceptions || hasErrorMessage || this.myBrokenClasses != null || this.myMissingClasses != null || this.myMissingSize || this.myMissingFragments != null;
    }

    @NotNull
    public List<RenderProblem> getFidelityWarnings() {
        return this.myFidelityWarnings != null ? this.myFidelityWarnings : Collections.emptyList();
    }

    public void error(@Nullable String tag, @Nullable String message, @Nullable Object viewCookie, @Nullable Object data2) {
        String description2 = RenderLogger.describe(message, null);
        if (tag == null && message != null && (message.startsWith("Failed to find style ") || message.startsWith("Unable to resolve parent style name: "))) {
            tag = "resources.resolve.theme";
        }
        this.addTag(tag);
        this.addMessage(RenderProblem.createPlain(ProblemSeverity.ERROR, description2).tag(tag));
    }

    @NotNull
    private static StackOverflowError summarizeStackOverFlowException(@NotNull StackOverflowError stackOverflowError) {
        StackTraceElement[] stackTraceElements = stackOverflowError.getStackTrace();
        int traceSize = stackTraceElements.length;
        if (traceSize < STACK_OVERFLOW_TRACE_LIMIT) {
            return stackOverflowError;
        }
        int elementsToCopy = STACK_OVERFLOW_TRACE_LIMIT / 2;
        StackTraceElement[] newStackTraceElements = new StackTraceElement[elementsToCopy * 2 + 1];
        newStackTraceElements[elementsToCopy] = new StackTraceElement("omitted", "omitted", "omitted", -1);
        System.arraycopy(stackTraceElements, 0, newStackTraceElements, 0, elementsToCopy);
        System.arraycopy(stackTraceElements, stackTraceElements.length - elementsToCopy, newStackTraceElements, elementsToCopy + 1, elementsToCopy);
        stackOverflowError.setStackTrace(newStackTraceElements);
        return stackOverflowError;
    }

    public void error(@Nullable String tag, @Nullable String message, @Nullable Throwable throwable, @Nullable Object viewCookie, @Nullable Object data2) {
        Object description2 = RenderLogger.describe(message, throwable);
        if (throwable != null) {
            if (throwable instanceof ClassNotFoundException) {
                return;
            }
            if (RenderLogger.isIssue164378(throwable)) {
                return;
            }
            if ("Unable to find the layout for Action Bar.".equals(description2)) {
                description2 = (String)description2 + "\nConsider updating to a more recent version of appcompat, or switch the rendering library in the IDE down to API 21";
            }
            if (((String)description2).isEmpty()) {
                description2 = "Exception raised during rendering";
            } else if (((String)description2).equals(throwable.getLocalizedMessage()) || ((String)description2).equals(throwable.getMessage())) {
                description2 = "Exception raised during rendering: " + (String)description2;
            } else if (message != null && message.startsWith("Failed to configure parser for ") && message.endsWith(".png")) {
                StackTraceElement[] frames;
                for (StackTraceElement frame : frames = throwable.getStackTrace()) {
                    if (frame.getMethodName().equals("createFromXml") && frame.getClassName().equals("android.content.res.ColorStateList")) {
                        String basePath;
                        String path = message.substring("Failed to configure parser for ".length());
                        RenderProblem.Html problem = RenderProblem.create(ProblemSeverity.WARNING);
                        problem.tag("bitmapAsColor");
                        HtmlBuilder builder = problem.getHtmlBuilder();
                        builder.add("Resource error: Attempted to load a bitmap as a color state list.").newline();
                        builder.add("Verify that your style/theme attributes are correct, and make sure layouts are using the right attributes.");
                        builder.newline().newline();
                        path = FileUtil.toSystemIndependentName((String)path);
                        String string = basePath = this.myProjectBasePath == null ? null : FileUtil.toSystemIndependentName((String)this.myProjectBasePath);
                        if (basePath != null && path.startsWith(basePath)) {
                            path = path.substring(basePath.length());
                            path = StringUtil.trimStart((String)path, (String)File.separator);
                        }
                        path = FileUtil.toSystemDependentName((String)path);
                        builder.add("The relevant image is ").add(path);
                        HashSet widgets = Sets.newHashSet();
                        for (StackTraceElement f : frames) {
                            String className;
                            if (!f.getMethodName().equals("<init>") || !(className = f.getClassName()).startsWith("android.widget.")) continue;
                            widgets.add(className.substring(className.lastIndexOf(46) + 1));
                        }
                        if (!widgets.isEmpty()) {
                            ArrayList sorted = Lists.newArrayList((Iterable)widgets);
                            Collections.sort(sorted);
                            builder.newline().newline().add("Widgets possibly involved: ").add(Joiner.on((String)", ").join((Iterable)sorted));
                        }
                        this.addMessage(problem);
                        return;
                    }
                    if (!frame.getClassName().startsWith("com.android.tools.")) {
                        continue;
                    }
                    break;
                }
            } else {
                if (message != null && message.startsWith("Failed to parse file ") && throwable instanceof XmlPullParserException) {
                    int end;
                    int index;
                    XmlPullParserException e = (XmlPullParserException)throwable;
                    Object msg = e.getMessage();
                    if (((String)msg).startsWith("Binary XML file ") && (index = ((String)msg).indexOf(58)) != -1 && index < ((String)msg).length() - 1) {
                        msg = ((String)msg).substring(index + 1).trim();
                    }
                    int lineNumber = e.getLineNumber();
                    int column2 = e.getColumnNumber();
                    String reader2 = " in java.io.InputStreamReader@";
                    int index2 = ((String)msg).indexOf(reader2);
                    if (index2 != -1 && (end = ((String)msg).indexOf(41, index2 + 1)) != -1) {
                        msg = ((String)msg).substring(0, index2) + ((String)msg).substring(end);
                    }
                    String path = message.substring("Failed to parse file ".length());
                    RenderProblem.Html problem = RenderProblem.create(ProblemSeverity.WARNING);
                    problem.tag("xmlParse");
                    HtmlBuilder builder = problem.getHtmlBuilder();
                    if (lineNumber != -1) {
                        builder.add("Line ").add(Integer.toString(lineNumber)).add(": ");
                    }
                    builder.add((String)msg);
                    if (lineNumber != -1) {
                        builder.add(" (");
                        File file = new File(path);
                        String url = HtmlLinkManager.createFilePositionUrl(file, lineNumber, column2);
                        if (url != null) {
                            builder.addLink("Show", url);
                            builder.add(")");
                        }
                    }
                    this.addMessage(problem);
                    return;
                }
                if (throwable instanceof StackOverflowError) {
                    throwable = RenderLogger.summarizeStackOverFlowException((StackOverflowError)throwable);
                }
            }
            this.myHaveExceptions = true;
        }
        this.addTag(tag);
        this.addMessage(this.myRenderProblemBuilder.build(throwable, tag, (String)description2));
    }

    public void warning(@Nullable String tag, @NotNull String message, @Nullable Object viewCookie, @Nullable Object data2) {
        String description2 = RenderLogger.describe(message, null);
        if ("info".equals(tag)) {
            Logger.getInstance(this.getClass()).info(description2);
            return;
        }
        if ("resources.format".equals(tag)) {
            Pattern pattern;
            Matcher matcher;
            if (description2.equals("You must supply a layout_width attribute.") || description2.equals("You must supply a layout_height attribute.")) {
                this.myMissingSize = true;
                this.addTag(TAG_MISSING_DIMENSION);
                return;
            }
            if (description2.endsWith(" is not a valid value") && (matcher = (pattern = Pattern.compile("\"(.*)\" in attribute \"(.*)\" is not a valid value")).matcher(description2)).matches()) {
                this.addTag(tag);
                RenderProblem.Html problem = RenderProblem.create(ProblemSeverity.WARNING);
                problem.tag(tag);
                String attribute2 = matcher.group(2);
                String value2 = matcher.group(1);
                problem.setClientData(new String[]{attribute2, value2});
                String url = this.getLinkManager().createEditAttributeUrl(attribute2, value2);
                problem.getHtmlBuilder().add(description2).add(" (").addLink("Edit", url).add(")");
                this.addMessage(problem);
                return;
            }
            if (description2.endsWith(" is not a valid format.") && (matcher = (pattern = Pattern.compile("\"(.*)\" in attribute \"(.*)\" is not a valid format.")).matcher(description2)).matches()) {
                this.addTag(tag);
                RenderProblem.Html problem = RenderProblem.create(ProblemSeverity.WARNING);
                problem.tag(tag);
                String attribute3 = matcher.group(2);
                String value3 = matcher.group(1);
                problem.setClientData(new String[]{attribute3, value3});
                String url = this.getLinkManager().createEditAttributeUrl(attribute3, value3);
                problem.getHtmlBuilder().add(description2).add(" (").addLink("Edit", url).add(")");
                problem.setClientData(url);
                this.addMessage(problem);
                return;
            }
        } else {
            if (TAG_MISSING_FRAGMENT.equals(tag)) {
                if (!ourIgnoreFragments) {
                    if (this.myMissingFragments == null) {
                        this.myMissingFragments = new ArrayList<String>();
                    }
                    String name2 = data2 instanceof String ? (String)data2 : null;
                    this.myMissingFragments.add(name2);
                }
                return;
            }
            if ("thread-creation".equals(tag)) {
                this.addTag(tag);
                RenderProblem problem = RenderProblem.createPlain(ProblemSeverity.WARNING, description2).tag(tag);
                if (data2 instanceof Throwable) {
                    problem.throwable((Throwable)data2);
                }
                this.addMessage(problem);
                return;
            }
        }
        this.addTag(tag);
        this.addMessage(RenderProblem.createPlain(ProblemSeverity.WARNING, description2).tag(tag));
    }

    public void fidelityWarning(@Nullable String tag, @Nullable String message, @Nullable Throwable throwable, @Nullable Object viewCookie, @Nullable Object data2) {
        if (ourIgnoreAllFidelityWarnings || ourIgnoredFidelityWarnings != null && ourIgnoredFidelityWarnings.contains(message)) {
            return;
        }
        String description2 = RenderLogger.describe(message, throwable);
        if (this.myFidelityWarningStrings != null && this.myFidelityWarningStrings.contains(description2)) {
            return;
        }
        if (throwable != null) {
            this.myHaveExceptions = true;
        }
        RenderProblem error = RenderProblem.createDeferred(ProblemSeverity.ERROR, tag, description2, throwable);
        error.setClientData(description2);
        if (this.myFidelityWarnings == null) {
            this.myFidelityWarnings = new ArrayList<RenderProblem>();
            this.myFidelityWarningStrings = Sets.newHashSet();
        }
        this.myFidelityWarnings.add(error);
        assert (this.myFidelityWarningStrings != null);
        this.myFidelityWarningStrings.add(description2);
        this.addTag(tag);
    }

    private void addTag(@Nullable String tag) {
        if (tag == null) {
            return;
        }
        if (this.myTags == null) {
            this.myTags = HashMultiset.create();
        }
        this.myTags.add((Object)tag);
    }

    public boolean seenTagPrefix(@NotNull String prefix) {
        if (this.myTags == null) {
            return false;
        }
        return this.myTags.stream().anyMatch(s -> s.startsWith(prefix));
    }

    @Override
    @NotNull
    public HtmlLinkManager getLinkManager() {
        if (this.myLinkManager == null) {
            this.myLinkManager = this.myHtmlLinkManagerFactory.get();
        }
        return this.myLinkManager;
    }

    @Override
    public void setHasLoadedClasses() {
        this.myHasLoadedClasses = true;
    }

    public boolean isMissingSize() {
        return this.myMissingSize;
    }

    public boolean hasLoadedClasses() {
        return this.myHasLoadedClasses;
    }

    public boolean isMissingResourceClass() {
        return this.myMissingResourceClass;
    }

    @Override
    public void setMissingResourceClass() {
        this.myMissingResourceClass = true;
    }

    @Nullable
    public String getResourceClass() {
        return this.myResourceClass;
    }

    @Override
    public void setResourceClass(@NotNull String resourceClass) {
        this.myResourceClass = resourceClass;
    }

    @NotNull
    public Map<String, Throwable> getBrokenClasses() {
        return this.myBrokenClasses != null ? this.myBrokenClasses : Collections.emptyMap();
    }

    @NotNull
    public Set<String> getMissingClasses() {
        return this.myMissingClasses != null ? this.myMissingClasses : Collections.emptySet();
    }

    @Override
    public void addMissingClass(@NotNull String className) {
        if (!className.equals("fragment")) {
            if (this.myMissingClasses == null) {
                this.myMissingClasses = new TreeSet<String>();
            }
            this.myMissingClasses.add(className);
            this.logMessageToIdeaLog("Class not found " + className);
        }
    }

    @Override
    public void addBrokenClass(@NotNull String className, @NotNull Throwable exception) {
        while (exception.getCause() != null && exception.getCause() != exception) {
            exception = exception.getCause();
        }
        if (exception instanceof StackOverflowError) {
            exception = RenderLogger.summarizeStackOverFlowException((StackOverflowError)exception);
        }
        if (this.myBrokenClasses == null) {
            this.myBrokenClasses = new HashMap<String, Throwable>();
        }
        this.myBrokenClasses.put(className, exception);
        this.logMessageToIdeaLog("Broken class " + className, exception);
    }

    @Nullable
    public List<String> getMissingFragments() {
        return this.myMissingFragments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void logAndroidFramework(int priority, String tag, @NotNull String message) {
        if (!this.myLogFramework) return;
        boolean token = RenderSecurityManager.enterSafeRegion(this.myCredential);
        try {
            String fullMessage = tag + ": " + message;
            switch (priority) {
                case 0: 
                case 1: {
                    LOG.debug(fullMessage);
                    return;
                }
                case 2: {
                    LOG.info(fullMessage);
                    return;
                }
                case 3: 
                case 4: {
                    LOG.warn(fullMessage);
                    return;
                }
                case 5: 
                case 6: {
                    LOG.error(fullMessage);
                    return;
                }
            }
            return;
        }
        finally {
            RenderSecurityManager.exitSafeRegion(token);
        }
    }

    private static interface RenderProblemBuilder {
        public RenderProblem build(Throwable var1, String var2, String var3);
    }
}

