/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.property.ptable.impl;

import com.android.tools.property.ptable.PTableColumn;
import com.android.tools.property.ptable.PTableGroupItem;
import com.android.tools.property.ptable.PTableGroupModification;
import com.android.tools.property.ptable.PTableItem;
import com.android.tools.property.ptable.PTableModel;
import com.android.tools.property.ptable.PTableModelUpdateListener;
import com.android.tools.property.ptable.impl.PTableModelEvent;
import com.android.tools.property.ptable.impl.PTableModelRepaintEvent;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.util.ThreeState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0010\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0017H\u0016J\u0018\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0017H\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0017H\u0016J\u0010\u0010\u001e\u001a\u00020\u00172\b\u0010\u001f\u001a\u0004\u0018\u00010\nJ\u0010\u0010 \u001a\u0004\u0018\u00010\r2\u0006\u0010\u001f\u001a\u00020\nJ\u000e\u0010!\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\nJ\u000e\u0010\"\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\rJ\u000e\u0010#\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\rJ\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0017J\u000e\u0010&\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0017J\u000e\u0010'\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0017J\u000e\u0010(\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\nJ\u0016\u0010+\u001a\u00020$2\u0006\u0010,\u001a\u00020\r2\u0006\u0010-\u001a\u00020.J\u0012\u0010/\u001a\u0004\u0018\u00010\r2\u0006\u0010%\u001a\u00020\u0017H\u0002J\u0014\u00100\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0101H\u0002J\u001c\u00102\u001a\u00020$2\u0012\u00103\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0101H\u0002J\u0018\u0010#\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010%\u001a\u00020\u0017H\u0002J\u0018\u0010&\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010%\u001a\u00020\u0017H\u0002J\u0018\u00104\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010%\u001a\u00020\u0017H\u0002J,\u00105\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020\r2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\r072\f\u00108\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u0018\u0010'\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u00109\u001a\u00020\u0017H\u0002J\u0010\u0010:\u001a\u00020\u00172\u0006\u0010,\u001a\u00020\rH\u0002J\b\u0010;\u001a\u00020$H\u0002J\u0010\u0010<\u001a\u00020$2\u0006\u0010,\u001a\u00020\rH\u0002J\u001e\u0010=\u001a\u00020$2\u0006\u0010,\u001a\u00020\r2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\n01H\u0002J\u0016\u0010?\u001a\u00020$2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\n01H\u0002JD\u0010A\u001a\u00020$\"\u0004\b\u0000\u0010B*\b\u0012\u0004\u0012\u0002HB012\f\u0010C\u001a\b\u0012\u0004\u0012\u0002HB0\t2\b\b\u0002\u0010D\u001a\u00020\u00172\b\b\u0002\u0010E\u001a\u00020\u00172\b\b\u0002\u0010F\u001a\u00020\u0017H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u00118\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010)\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u00a8\u0006G"}, d2={"Lcom/android/tools/property/ptable/impl/PTableModelImpl;", "Ljavax/swing/table/AbstractTableModel;", "tableModel", "Lcom/android/tools/property/ptable/PTableModel;", "<init>", "(Lcom/android/tools/property/ptable/PTableModel;)V", "getTableModel", "()Lcom/android/tools/property/ptable/PTableModel;", "items", "", "Lcom/android/tools/property/ptable/PTableItem;", "parentItems", "Ljava/util/IdentityHashMap;", "Lcom/android/tools/property/ptable/PTableGroupItem;", "hasEditableCells", "Lcom/intellij/util/ThreeState;", "expandedItems", "", "getExpandedItems$annotations", "()V", "getExpandedItems", "()Ljava/util/Set;", "getRowCount", "", "getColumnCount", "getValueAt", "rowIndex", "columnIndex", "isCellEditable", "", "indexOf", "item", "parentOf", "isGroupItem", "isExpanded", "toggle", "", "index", "expand", "collapse", "depth", "isEditable", "()Z", "updateGroupItems", "group", "modification", "Lcom/android/tools/property/ptable/PTableGroupModification;", "groupAt", "computeExpandedPaths", "", "restoreExpanded", "previousExpandedPaths", "doExpand", "computeExpanded", "expanded", "", "list", "row", "expandedRowCount", "recomputeParents", "computeParents", "addParents", "added", "removeParents", "removed", "copyInto", "E", "destination", "destinationOffset", "startIndex", "endIndex", "intellij.android.layout-ui"})
@SourceDebugExtension(value={"SMAP\nPTableModelImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PTableModelImpl.kt\ncom/android/tools/property/ptable/impl/PTableModelImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,287:1\n360#2,7:288\n1761#2,3:295\n1563#2:298\n1634#2,3:299\n1869#2,2:302\n1869#2,2:304\n1869#2,2:306\n1869#2,2:308\n*S KotlinDebug\n*F\n+ 1 PTableModelImpl.kt\ncom/android/tools/property/ptable/impl/PTableModelImpl\n*L\n75#1:288,7\n130#1:295,3\n178#1:298\n178#1:299,3\n223#1:302,2\n247#1:304,2\n259#1:306,2\n268#1:308,2\n*E\n"})
public final class PTableModelImpl
extends AbstractTableModel {
    @NotNull
    private final PTableModel tableModel;
    @NotNull
    private final List<PTableItem> items;
    @NotNull
    private final IdentityHashMap<PTableItem, PTableGroupItem> parentItems;
    @NotNull
    private ThreeState hasEditableCells;
    @NotNull
    private final Set<PTableGroupItem> expandedItems;

    public PTableModelImpl(@NotNull PTableModel tableModel2) {
        Intrinsics.checkNotNullParameter((Object)tableModel2, (String)"tableModel");
        this.tableModel = tableModel2;
        this.items = new ArrayList();
        this.parentItems = new IdentityHashMap();
        this.hasEditableCells = ThreeState.UNSURE;
        Set set2 = Collections.newSetFromMap(new IdentityHashMap());
        Intrinsics.checkNotNullExpressionValue(set2, (String)"newSetFromMap(...)");
        this.expandedItems = set2;
        this.items.addAll((Collection<PTableItem>)this.tableModel.getItems());
        this.recomputeParents();
        this.tableModel.addListener(new PTableModelUpdateListener(){

            @Override
            public void itemsUpdated(boolean modelChanged, PTableItem nextEditedItem) {
                if (!modelChanged) {
                    this.fireTableChanged(new PTableModelRepaintEvent(this));
                } else {
                    hasEditableCells = ThreeState.UNSURE;
                    List previousExpandedPaths = this.computeExpandedPaths();
                    items.clear();
                    items.addAll((Collection)this.getTableModel().getItems());
                    this.recomputeParents();
                    this.restoreExpanded(previousExpandedPaths);
                    int index = nextEditedItem != null ? this.indexOf(nextEditedItem) : -1;
                    this.fireTableChanged(new PTableModelEvent(this, index));
                }
            }
        });
    }

    @NotNull
    public final PTableModel getTableModel() {
        return this.tableModel;
    }

    @NotNull
    public final Set<PTableGroupItem> getExpandedItems() {
        return this.expandedItems;
    }

    @VisibleForTesting
    public static /* synthetic */ void getExpandedItems$annotations() {
    }

    @Override
    public int getRowCount() {
        return ((Collection)this.items).size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    @NotNull
    public PTableItem getValueAt(int rowIndex, int columnIndex) {
        return this.items.get(rowIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.tableModel.isCellEditable(this.items.get(rowIndex), PTableColumn.Companion.fromColumn(columnIndex));
    }

    public final int indexOf(@Nullable PTableItem item) {
        int n;
        block4: {
            if (item != null) {
                List<PTableItem> $this$indexOfFirst$iv = this.items;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<PTableItem> iterator2 = $this$indexOfFirst$iv.iterator();
                while (iterator2.hasNext()) {
                    PTableItem item$iv;
                    PTableItem it = item$iv = iterator2.next();
                    boolean bl = false;
                    if (item == it) {
                        n = index$iv;
                        break block4;
                    }
                    ++index$iv;
                }
                n = -1;
            } else {
                n = -1;
            }
        }
        return n;
    }

    @Nullable
    public final PTableGroupItem parentOf(@NotNull PTableItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return this.parentItems.get(item);
    }

    public final boolean isGroupItem(@NotNull PTableItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return item instanceof PTableGroupItem;
    }

    public final boolean isExpanded(@NotNull PTableGroupItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return this.expandedItems.contains(item);
    }

    public final int toggle(@NotNull PTableGroupItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        int index = this.indexOf(item);
        if (index < 0) {
            return index;
        }
        this.toggle(item, index);
        return index;
    }

    public final void toggle(int index) {
        PTableGroupItem pTableGroupItem = this.groupAt(index);
        if (pTableGroupItem == null) {
            return;
        }
        PTableGroupItem item = pTableGroupItem;
        this.toggle(item, index);
    }

    public final void expand(int index) {
        PTableGroupItem pTableGroupItem = this.groupAt(index);
        if (pTableGroupItem == null) {
            return;
        }
        PTableGroupItem item = pTableGroupItem;
        this.expand(item, index);
    }

    public final void collapse(int index) {
        PTableGroupItem pTableGroupItem = this.groupAt(index);
        if (pTableGroupItem == null) {
            return;
        }
        PTableGroupItem item = pTableGroupItem;
        this.collapse(item, index);
    }

    public final int depth(@NotNull PTableItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        PTableGroupItem parent = this.parentItems.get(item);
        int depth = 0;
        while (parent != null) {
            ++depth;
            parent = this.parentItems.get(parent);
        }
        return depth;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isEditable() {
        ThreeState editable = this.hasEditableCells;
        if (editable == ThreeState.UNSURE) {
            boolean bl;
            ThreeState.Companion companion;
            block4: {
                void $this$any$iv;
                Iterable iterable = this.items;
                companion = ThreeState.Companion;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PTableItem it = (PTableItem)element$iv;
                        boolean bl2 = false;
                        if (!(this.tableModel.isCellEditable(it, PTableColumn.VALUE) || this.tableModel.isCellEditable(it, PTableColumn.NAME))) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            boolean bl3 = bl;
            this.hasEditableCells = editable = companion.fromBoolean(bl3);
        }
        return editable.toBoolean();
    }

    public final void updateGroupItems(@NotNull PTableGroupItem group2, @NotNull PTableGroupModification modification) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter((Object)modification, (String)"modification");
        this.removeParents(modification.getRemoved());
        this.addParents(group2, modification.getAdded());
        if (!this.isExpanded(group2)) {
            return;
        }
        int index = this.indexOf(group2);
        if (index < 0) {
            return;
        }
        int first = index + 1;
        int alreadyExpanded = group2.getChildren().size() - modification.getAdded().size() + modification.getRemoved().size();
        int itemsToCopy = Math.min(alreadyExpanded, group2.getChildren().size());
        this.copyInto(group2.getChildren(), this.items, first, 0, itemsToCopy);
        if (alreadyExpanded > group2.getChildren().size()) {
            this.items.subList(first + group2.getChildren().size(), first + alreadyExpanded).clear();
        } else if (alreadyExpanded < group2.getChildren().size()) {
            this.items.addAll(first + itemsToCopy, (Collection<PTableItem>)group2.getChildren().subList(itemsToCopy, group2.getChildren().size()));
        }
        this.fireTableDataChanged();
    }

    private final PTableGroupItem groupAt(int index) {
        PTableGroupItem pTableGroupItem;
        if (index < 0 || index >= this.items.size()) {
            return null;
        }
        PTableItem item = this.items.get(index);
        if (this.isGroupItem(item)) {
            Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type com.android.tools.property.ptable.PTableGroupItem");
            pTableGroupItem = (PTableGroupItem)item;
        } else {
            pTableGroupItem = null;
        }
        return pTableGroupItem;
    }

    /*
     * WARNING - void declaration
     */
    private final List<List<PTableGroupItem>> computeExpandedPaths() {
        void $this$mapTo$iv$iv;
        CollectionsKt.retainAll((Iterable)this.expandedItems, arg_0 -> PTableModelImpl.computeExpandedPaths$lambda$0(this, arg_0));
        Iterable $this$map$iv = this.expandedItems;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void node;
            PTableGroupItem pTableGroupItem = (PTableGroupItem)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(CollectionsKt.reversed((Iterable)SequencesKt.toList((Sequence)SequencesKt.generateSequence((Object)node, arg_0 -> PTableModelImpl.computeExpandedPaths$lambda$1$0(this, arg_0)))));
        }
        return (List)destination$iv$iv;
    }

    private final void restoreExpanded(List<? extends List<? extends PTableGroupItem>> previousExpandedPaths) {
        this.expandedItems.clear();
        for (List<? extends PTableGroupItem> list2 : previousExpandedPaths) {
            for (PTableGroupItem pTableGroupItem : list2) {
                int index = this.items.indexOf(pTableGroupItem);
                this.expand(index);
            }
        }
    }

    private final void toggle(PTableGroupItem item, int index) {
        if (this.expandedItems.contains(item)) {
            this.collapse(item, index);
        } else {
            this.expand(item, index);
        }
    }

    private final void expand(PTableGroupItem item, int index) {
        item.expandWhenPossible((Function1<? super Boolean, Unit>)((Function1)arg_0 -> PTableModelImpl.expand$lambda$0(item, this, index, arg_0)));
    }

    private final void doExpand(PTableGroupItem item, int index) {
        if (this.expandedItems.add(item)) {
            List list2 = new ArrayList();
            this.computeExpanded(item, this.expandedItems, list2);
            this.items.addAll(index + 1, list2);
            this.fireTableDataChanged();
        }
    }

    private final void computeExpanded(PTableGroupItem item, Set<? extends PTableGroupItem> expanded, List<PTableItem> list2) {
        Iterable $this$forEach$iv = item.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PTableItem it = (PTableItem)element$iv;
            boolean bl = false;
            list2.add(it);
            if (!(it instanceof PTableGroupItem) || !expanded.contains(it)) continue;
            this.computeExpanded((PTableGroupItem)it, expanded, list2);
        }
    }

    private final void collapse(PTableGroupItem item, int row) {
        int rowsToRemove = this.expandedRowCount(item);
        if (this.expandedItems.remove(item)) {
            this.items.subList(row + 1, row + 1 + rowsToRemove).clear();
            this.fireTableDataChanged();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int expandedRowCount(PTableGroupItem group2) {
        Iterable iterable = group2.getChildren();
        int n = 0;
        for (Object t : iterable) {
            void it;
            PTableItem pTableItem = (PTableItem)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it instanceof PTableGroupItem && this.expandedItems.contains(it) ? 1 + this.expandedRowCount((PTableGroupItem)it) : 1;
            n = n2 + n3;
        }
        return n;
    }

    private final void recomputeParents() {
        this.parentItems.clear();
        Iterable $this$forEach$iv = this.items;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PTableItem it = (PTableItem)element$iv;
            boolean bl = false;
            if (!(it instanceof PTableGroupItem)) continue;
            this.computeParents((PTableGroupItem)it);
        }
    }

    private final void computeParents(PTableGroupItem group2) {
        this.addParents(group2, group2.getChildren());
    }

    private final void addParents(PTableGroupItem group2, List<? extends PTableItem> added) {
        Iterable $this$forEach$iv = added;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PTableItem it = (PTableItem)element$iv;
            boolean bl = false;
            ((Map)this.parentItems).put(it, group2);
            if (!(it instanceof PTableGroupItem)) continue;
            this.addParents((PTableGroupItem)it, ((PTableGroupItem)it).getChildren());
        }
    }

    private final void removeParents(List<? extends PTableItem> removed) {
        Iterable $this$forEach$iv = removed;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PTableItem it = (PTableItem)element$iv;
            boolean bl = false;
            this.parentItems.remove(it);
            if (!(it instanceof PTableGroupItem)) continue;
            this.removeParents(((PTableGroupItem)it).getChildren());
        }
    }

    private final <E> void copyInto(List<? extends E> $this$copyInto, List<E> destination, int destinationOffset, int startIndex, int endIndex) {
        for (int index = startIndex; index < endIndex; ++index) {
            destination.set(destinationOffset + index - startIndex, $this$copyInto.get(index));
        }
    }

    static /* synthetic */ void copyInto$default(PTableModelImpl pTableModelImpl, List list2, List list3, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n = 0;
        }
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            n3 = list2.size();
        }
        pTableModelImpl.copyInto(list2, list3, n, n2, n3);
    }

    private static final boolean computeExpandedPaths$lambda$0(PTableModelImpl this$0, PTableGroupItem it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.isGroupItem(it);
    }

    private static final PTableGroupItem computeExpandedPaths$lambda$1$0(PTableModelImpl this$0, PTableGroupItem it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.parentOf(it);
    }

    private static final Unit expand$lambda$0(PTableGroupItem $item, PTableModelImpl this$0, int $index, boolean restructured) {
        if ($item == this$0.groupAt($index)) {
            if (restructured) {
                this$0.computeParents($item);
            }
            this$0.doExpand($item, $index);
        }
        return Unit.INSTANCE;
    }
}

