/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profgen;

import com.android.tools.profgen.Apk;
import com.android.tools.profgen.ArtProfile;
import com.android.tools.profgen.DexFile;
import com.android.tools.profgen.DexFileData;
import com.android.tools.profgen.DexMethod;
import com.android.tools.profgen.MethodData;
import com.android.tools.profgen.ObfuscationMap;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a4\u0010\u0000\u001a\u00020\u00012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f\u001a\u0014\u0010\r\u001a\u00020\f*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u001a0\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f\u001a\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a8\u0006\u0015"}, d2={"dumpProfile", "", "os", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "profile", "Lcom/android/tools/profgen/ArtProfile;", "apk", "Lcom/android/tools/profgen/Apk;", "obf", "Lcom/android/tools/profgen/ObfuscationMap;", "strict", "", "compatibleWith", "Lcom/android/tools/profgen/DexFile;", "other", "file", "Ljava/io/File;", "extractName", "", "profileKey", "android.sdktools.profgen"})
@SourceDebugExtension(value={"SMAP\nProfileDumper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfileDumper.kt\ncom/android/tools/profgen/ProfileDumperKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,125:1\n1#2:126\n*E\n"})
public final class ProfileDumperKt {
    public static final void dumpProfile(@NotNull Appendable os, @NotNull ArtProfile profile, @NotNull Apk apk, @NotNull ObfuscationMap obf, boolean strict) {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        Intrinsics.checkNotNullParameter((Object)apk, (String)"apk");
        Intrinsics.checkNotNullParameter((Object)obf, (String)"obf");
        for (Map.Entry<DexFile, DexFileData> entry : profile.getProfileData().entrySet()) {
            DexFile file;
            Object v0;
            DexFileData dexFileData2;
            DexFile dexFile;
            block7: {
                dexFile = entry.getKey();
                dexFileData2 = entry.getValue();
                Iterable iterable = apk.getDexes();
                for (Object object : iterable) {
                    DexFile it = (DexFile)object;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)ProfileDumperKt.extractName(dexFile.getName()))) continue;
                    v0 = object;
                    break block7;
                }
                v0 = null;
            }
            if ((DexFile)v0 == null) {
                if (!strict) continue;
                throw new IllegalStateException("Cannot find Dex File " + dexFile.getName());
            }
            if (strict && !ProfileDumperKt.compatibleWith(dexFile, file)) {
                String message = StringsKt.trimIndent((String)("\n                Profile header not compatible with the Dex header.\n                -----------------------------------------------------------------------------------\n                APK: " + apk.getName() + "\n                Dex: " + dexFile.getName() + "\n                -----------------------------------------------------------------------------------\n                Dex Checksum: " + dexFile.getDexChecksum() + "              | " + file.getDexChecksum() + "\n                Method ids  : " + dexFile.getHeader$android_sdktools_profgen().getMethodIds().getSize() + "    | " + file.getHeader$android_sdktools_profgen().getMethodIds().getSize() + "\n                Type ids    : " + dexFile.getHeader$android_sdktools_profgen().getTypeIds().getSize() + "      | " + file.getHeader$android_sdktools_profgen().getTypeIds().getSize() + "\n                -----------------------------------------------------------------------------------\n            "));
                throw new IllegalStateException(message);
            }
            for (Map.Entry<Integer, MethodData> entry2 : dexFileData2.getMethods().entrySet()) {
                int key = ((Number)entry2.getKey()).intValue();
                MethodData method2 = entry2.getValue();
                if (!file.getDefinedMethods$android_sdktools_profgen().contains(key)) continue;
                DexMethod dexMethod = (DexMethod)CollectionsKt.getOrNull((List)file.getMethodPool$android_sdktools_profgen(), (int)key);
                if (method2.getFlags() == 0 || dexMethod == null) continue;
                DexMethod deobfuscated = obf.deobfuscate$android_sdktools_profgen(dexMethod);
                method2.print(os);
                deobfuscated.print(os);
                os.append('\n');
            }
            Iterator<Object> iterator2 = dexFileData2.getTypeIndexes().iterator();
            while (iterator2.hasNext()) {
                Object object;
                int key = ((Number)iterator2.next()).intValue();
                String dexClass = (String)CollectionsKt.getOrNull((List)file.getTypePool$android_sdktools_profgen(), (int)key);
                if (dexClass == null) continue;
                List<String> deobfuscated = obf.deobfuscate$android_sdktools_profgen(dexClass);
                object = deobfuscated.iterator();
                while (object.hasNext()) {
                    String type = (String)object.next();
                    os.append(type);
                    os.append('\n');
                }
            }
        }
    }

    public static /* synthetic */ void dumpProfile$default(Appendable appendable, ArtProfile artProfile, Apk apk, ObfuscationMap obfuscationMap, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        ProfileDumperKt.dumpProfile(appendable, artProfile, apk, obfuscationMap, bl);
    }

    private static final boolean compatibleWith(DexFile $this$compatibleWith, DexFile other) {
        boolean checkSumsMatch = $this$compatibleWith.getDexChecksum() == other.getDexChecksum();
        boolean methodIdsMatch = $this$compatibleWith.getHeader$android_sdktools_profgen().getMethodIds().getSize() == other.getHeader$android_sdktools_profgen().getMethodIds().getSize();
        boolean typeIdsMatch = $this$compatibleWith.getHeader$android_sdktools_profgen().getTypeIds().getSize() == other.getHeader$android_sdktools_profgen().getTypeIds().getSize() || $this$compatibleWith.getHeader$android_sdktools_profgen().getTypeIds().getSize() <= 0;
        return checkSumsMatch && methodIdsMatch && typeIdsMatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void dumpProfile(@NotNull File file, @NotNull ArtProfile profile, @NotNull Apk apk, @NotNull ObfuscationMap obf, boolean strict) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        Intrinsics.checkNotNullParameter((Object)apk, (String)"apk");
        Intrinsics.checkNotNullParameter((Object)obf, (String)"obf");
        Closeable closeable = new FileOutputStream(file);
        Object object = Charsets.UTF_8;
        Writer writer2 = new OutputStreamWriter((OutputStream)closeable, (Charset)object);
        int n = 8192;
        BufferedWriter writer3 = writer2 instanceof BufferedWriter ? (BufferedWriter)writer2 : new BufferedWriter(writer2, n);
        closeable = writer3;
        object = null;
        try {
            BufferedWriter it = (BufferedWriter)closeable;
            boolean bl = false;
            ProfileDumperKt.dumpProfile(writer3, profile, apk, obf, strict);
            writer2 = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
    }

    public static /* synthetic */ void dumpProfile$default(File file, ArtProfile artProfile, Apk apk, ObfuscationMap obfuscationMap, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        ProfileDumperKt.dumpProfile(file, artProfile, apk, obfuscationMap, bl);
    }

    private static final String extractName(String profileKey) {
        int index = StringsKt.indexOf$default((CharSequence)profileKey, (String)"!", (int)0, (boolean)false, (int)6, null);
        if (index < 0) {
            index = StringsKt.indexOf$default((CharSequence)profileKey, (String)":", (int)0, (boolean)false, (int)6, null);
        }
        if (index < 0 && StringsKt.endsWith$default((String)profileKey, (String)".apk", (boolean)false, (int)2, null)) {
            return "classes.dex";
        }
        String string = profileKey.substring(index + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }
}

