/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.preview.config;

import com.android.sdklib.devices.Device;
import com.android.tools.preview.config.AndroidDimension;
import com.android.tools.preview.config.Cutout;
import com.android.tools.preview.config.DeviceConfigKt;
import com.android.tools.preview.config.DeviceSpecDimensionUtilKt;
import com.android.tools.preview.config.DeviceUtilsKt;
import com.android.tools.preview.config.DimUnit;
import com.android.tools.preview.config.MutableDeviceConfig;
import com.android.tools.preview.config.Navigation;
import com.android.tools.preview.config.Orientation;
import com.android.tools.preview.config.Preview;
import com.android.tools.preview.config.Shape;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 <2\u00020\u0001:\u0001<By\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u0012\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0006\u00103\u001a\u00020\u0003J\u0010\u00104\u001a\u000205*\u000606j\u0002`7H\u0002J\u0013\u00108\u001a\u0002012\b\u00109\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010:\u001a\u00020\nH\u0016J\b\u0010;\u001a\u00020\u000fH\u0002R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001aR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\r\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001aR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0018R\u0011\u0010*\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0018R\u0011\u0010,\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0018R\u0011\u0010.\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u0018R\u0014\u00100\u001a\u0002018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00102\u00a8\u0006="}, d2={"Lcom/android/tools/preview/config/DeviceConfig;", "", "deviceId", "", "width", "", "height", "dimUnit", "Lcom/android/tools/preview/config/DimUnit;", "dpi", "", "shape", "Lcom/android/tools/preview/config/Shape;", "chinSize", "orientation", "Lcom/android/tools/preview/config/Orientation;", "cutout", "Lcom/android/tools/preview/config/Cutout;", "navigation", "Lcom/android/tools/preview/config/Navigation;", "parentDeviceId", "<init>", "(Ljava/lang/String;FFLcom/android/tools/preview/config/DimUnit;ILcom/android/tools/preview/config/Shape;FLcom/android/tools/preview/config/Orientation;Lcom/android/tools/preview/config/Cutout;Lcom/android/tools/preview/config/Navigation;Ljava/lang/String;)V", "getDeviceId", "()Ljava/lang/String;", "getWidth", "()F", "getHeight", "getDimUnit", "()Lcom/android/tools/preview/config/DimUnit;", "getDpi", "()I", "getShape", "()Lcom/android/tools/preview/config/Shape;", "getChinSize", "getOrientation", "()Lcom/android/tools/preview/config/Orientation;", "getCutout", "()Lcom/android/tools/preview/config/Cutout;", "getNavigation", "()Lcom/android/tools/preview/config/Navigation;", "getParentDeviceId", "widthString", "getWidthString", "heightString", "getHeightString", "chinSizeString", "getChinSizeString", "isRound", "", "()Z", "deviceSpec", "addOrientationIfNeeded", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "equals", "other", "hashCode", "getDeviceDefaultOrientation", "Companion", "intellij.android.preview-elements"})
@SourceDebugExtension(value={"SMAP\nDeviceConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceConfig.kt\ncom/android/tools/preview/config/DeviceConfig\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,575:1\n295#2,2:576\n*S KotlinDebug\n*F\n+ 1 DeviceConfig.kt\ncom/android/tools/preview/config/DeviceConfig\n*L\n127#1:576,2\n*E\n"})
public class DeviceConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String deviceId;
    private final float width;
    private final float height;
    @NotNull
    private final DimUnit dimUnit;
    private final int dpi;
    @NotNull
    private final Shape shape;
    private final float chinSize;
    @NotNull
    private final Orientation orientation;
    @NotNull
    private final Cutout cutout;
    @NotNull
    private final Navigation navigation;
    @Nullable
    private final String parentDeviceId;

    public DeviceConfig(@Nullable String deviceId, float width, float height, @NotNull DimUnit dimUnit, int dpi, @NotNull Shape shape, float chinSize, @NotNull Orientation orientation, @NotNull Cutout cutout, @NotNull Navigation navigation, @Nullable String parentDeviceId) {
        Intrinsics.checkNotNullParameter((Object)((Object)dimUnit), (String)"dimUnit");
        Intrinsics.checkNotNullParameter((Object)((Object)shape), (String)"shape");
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        Intrinsics.checkNotNullParameter((Object)((Object)cutout), (String)"cutout");
        Intrinsics.checkNotNullParameter((Object)((Object)navigation), (String)"navigation");
        this.deviceId = deviceId;
        this.width = width;
        this.height = height;
        this.dimUnit = dimUnit;
        this.dpi = dpi;
        this.shape = shape;
        this.chinSize = chinSize;
        this.orientation = orientation;
        this.cutout = cutout;
        this.navigation = navigation;
        this.parentDeviceId = parentDeviceId;
    }

    public /* synthetic */ DeviceConfig(String string, float f, float f2, DimUnit dimUnit, int n, Shape shape, float f3, Orientation orientation, Cutout cutout, Navigation navigation, String string2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            string = null;
        }
        if ((n2 & 2) != 0) {
            f = Preview.DeviceSpec.INSTANCE.getDEFAULT_WIDTH_DP();
        }
        if ((n2 & 4) != 0) {
            f2 = Preview.DeviceSpec.INSTANCE.getDEFAULT_HEIGHT_DP();
        }
        if ((n2 & 8) != 0) {
            dimUnit = Preview.DeviceSpec.INSTANCE.getDEFAULT_UNIT();
        }
        if ((n2 & 0x10) != 0) {
            n = 420;
        }
        if ((n2 & 0x20) != 0) {
            shape = Preview.DeviceSpec.INSTANCE.getDEFAULT_SHAPE();
        }
        if ((n2 & 0x40) != 0) {
            f3 = 0.0f;
        }
        if ((n2 & 0x80) != 0) {
            orientation = Preview.DeviceSpec.INSTANCE.getDEFAULT_ORIENTATION();
        }
        if ((n2 & 0x100) != 0) {
            cutout = Preview.DeviceSpec.INSTANCE.getDEFAULT_CUTOUT();
        }
        if ((n2 & 0x200) != 0) {
            navigation = Preview.DeviceSpec.INSTANCE.getDEFAULT_NAVIGATION();
        }
        if ((n2 & 0x400) != 0) {
            string2 = null;
        }
        this(string, f, f2, dimUnit, n, shape, f3, orientation, cutout, navigation, string2);
    }

    @Nullable
    public final String getDeviceId() {
        return this.deviceId;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    @NotNull
    public DimUnit getDimUnit() {
        return this.dimUnit;
    }

    public int getDpi() {
        return this.dpi;
    }

    @NotNull
    public Shape getShape() {
        return this.shape;
    }

    public float getChinSize() {
        return this.chinSize;
    }

    @NotNull
    public Orientation getOrientation() {
        return this.orientation;
    }

    @NotNull
    public Cutout getCutout() {
        return this.cutout;
    }

    @NotNull
    public Navigation getNavigation() {
        return this.navigation;
    }

    @Nullable
    public String getParentDeviceId() {
        return this.parentDeviceId;
    }

    @NotNull
    public final String getWidthString() {
        return DeviceSpecDimensionUtilKt.convertToDeviceSpecDimension(this.getWidth()).toString();
    }

    @NotNull
    public final String getHeightString() {
        return DeviceSpecDimensionUtilKt.convertToDeviceSpecDimension(this.getHeight()).toString();
    }

    @NotNull
    public final String getChinSizeString() {
        return DeviceSpecDimensionUtilKt.convertToDeviceSpecDimension(this.getChinSize()).toString();
    }

    public boolean isRound() {
        return this.getShape() == Shape.Round;
    }

    @NotNull
    public final String deviceSpec() {
        if (this.deviceId != null) {
            String string;
            Object v0;
            block11: {
                Iterable $this$firstOrNull$iv = DeviceConfigKt.getReferenceDeviceIds().entrySet();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Map.Entry entry = (Map.Entry)element$iv;
                    boolean bl = false;
                    String deviceClassId = (String)entry.getValue();
                    if (!Intrinsics.areEqual((Object)deviceClassId, (Object)this.deviceId)) continue;
                    v0 = element$iv;
                    break block11;
                }
                v0 = null;
            }
            Map.Entry entry = v0;
            if (entry != null && (string = (String)entry.getKey()) != null) {
                String referenceString = string;
                boolean bl = false;
                return referenceString;
            }
        }
        if (this.getParentDeviceId() != null && this.getOrientation() == this.getDeviceDefaultOrientation() && this.getNavigation() == Preview.DeviceSpec.INSTANCE.getDEFAULT_NAVIGATION()) {
            return "id:" + this.getParentDeviceId();
        }
        StringBuilder builder = new StringBuilder("spec:");
        if (this.getParentDeviceId() != null) {
            DeviceConfigKt.access$appendParamValue(builder, "parent", String.valueOf(this.getParentDeviceId()));
            this.addOrientationIfNeeded(builder);
            if (this.getNavigation() != Preview.DeviceSpec.INSTANCE.getDEFAULT_NAVIGATION()) {
                DeviceConfigKt.access$appendSeparator(builder);
                DeviceConfigKt.access$appendParamValue(builder, "navigation", this.getNavigation().name());
            }
            String string = builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        DeviceConfigKt.access$appendParamValue(builder, "width", this.getWidthString() + this.getDimUnit().name());
        DeviceConfigKt.access$appendSeparator(builder);
        DeviceConfigKt.access$appendParamValue(builder, "height", this.getHeightString() + this.getDimUnit().name());
        if (this.getDpi() != 420) {
            DeviceConfigKt.access$appendSeparator(builder);
            DeviceConfigKt.access$appendParamValue(builder, "dpi", String.valueOf(this.getDpi()));
        }
        if (this.isRound()) {
            DeviceConfigKt.access$appendSeparator(builder);
            DeviceConfigKt.access$appendParamValue(builder, "isRound", String.valueOf(this.isRound()));
            if (MathKt.roundToInt((float)this.getChinSize()) != 0) {
                DeviceConfigKt.access$appendSeparator(builder);
                DeviceConfigKt.access$appendParamValue(builder, "chinSize", this.getChinSizeString() + this.getDimUnit().name());
            }
        }
        this.addOrientationIfNeeded(builder);
        if (this.getCutout() != Preview.DeviceSpec.INSTANCE.getDEFAULT_CUTOUT()) {
            DeviceConfigKt.access$appendSeparator(builder);
            DeviceConfigKt.access$appendParamValue(builder, "cutout", this.getCutout().name());
        }
        if (this.getNavigation() != Preview.DeviceSpec.INSTANCE.getDEFAULT_NAVIGATION()) {
            DeviceConfigKt.access$appendSeparator(builder);
            DeviceConfigKt.access$appendParamValue(builder, "navigation", this.getNavigation().name());
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void addOrientationIfNeeded(StringBuilder $this$addOrientationIfNeeded) {
        if (this.getOrientation() != this.getDeviceDefaultOrientation()) {
            DeviceConfigKt.access$appendSeparator($this$addOrientationIfNeeded);
            DeviceConfigKt.access$appendParamValue($this$addOrientationIfNeeded, "orientation", this.getOrientation().name());
        }
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof DeviceConfig)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.deviceSpec(), (Object)((DeviceConfig)other).deviceSpec());
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{Float.valueOf(this.getWidth()), Float.valueOf(this.getHeight()), this.getDpi(), this.getShape(), this.getDimUnit(), Float.valueOf(this.getChinSize()), this.isRound(), this.getOrientation(), this.getCutout(), this.getNavigation(), this.getParentDeviceId()};
        return Objects.hashCode((Object[])objectArray);
    }

    private final Orientation getDeviceDefaultOrientation() {
        return this.getWidth() > this.getHeight() ? Orientation.landscape : Orientation.portrait;
    }

    public DeviceConfig() {
        this(null, 0.0f, 0.0f, null, 0, null, 0.0f, null, null, null, null, 2047, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ \u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ,\u0010\r\u001a\u0004\u0018\u00010\f2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J&\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\n2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000fH\u0002J\u001e\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000fH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/preview/config/DeviceConfig$Companion;", "", "<init>", "()V", "toMutableDeviceConfigOrNull", "Lcom/android/tools/preview/config/MutableDeviceConfig;", "serialized", "", "availableDevices", "", "Lcom/android/sdklib/devices/Device;", "toDeviceConfigOrNull", "Lcom/android/tools/preview/config/DeviceConfig;", "parseDeviceSpecLanguage", "params", "", "parseFromExistingDeviceWithDeviceSpecLanguage", "device", "parseFromCustomDeviceSpecLanguage", "intellij.android.preview-elements"})
    @SourceDebugExtension(value={"SMAP\nDeviceConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceConfig.kt\ncom/android/tools/preview/config/DeviceConfig$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 EnumUtils.kt\ncom/android/ide/common/util/EnumUtilsKt\n*L\n1#1,575:1\n1#2:576\n774#3:577\n865#3,2:578\n1193#3,2:580\n1267#3,4:582\n295#3,2:586\n27#4,5:588\n27#4,5:593\n27#4,5:598\n27#4,5:603\n27#4,5:608\n*S KotlinDebug\n*F\n+ 1 DeviceConfig.kt\ncom/android/tools/preview/config/DeviceConfig$Companion\n*L\n260#1:577\n260#1:578,2\n261#1:580,2\n261#1:582,4\n292#1:586,2\n306#1:588,5\n314#1:593,5\n376#1:598,5\n388#1:603,5\n395#1:608,5\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final MutableDeviceConfig toMutableDeviceConfigOrNull(@Nullable String serialized, @NotNull Collection<Device> availableDevices) {
            Intrinsics.checkNotNullParameter(availableDevices, (String)"availableDevices");
            DeviceConfig deviceConfig = this.toDeviceConfigOrNull(serialized, availableDevices);
            return deviceConfig != null ? DeviceConfigKt.toMutableConfig(deviceConfig) : null;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final DeviceConfig toDeviceConfigOrNull(@Nullable String serialized, @NotNull Collection<Device> availableDevices) {
            void $this$associateTo$iv$iv;
            void $this$associate$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Object object;
            String configString;
            block7: {
                block6: {
                    Intrinsics.checkNotNullParameter(availableDevices, (String)"availableDevices");
                    if (serialized == null || !StringsKt.startsWith$default((String)serialized, (String)"spec:", (boolean)false, (int)2, null)) {
                        return null;
                    }
                    configString = StringsKt.substringAfter$default((String)serialized, (String)"spec:", null, (int)2, null);
                    String referenceDeviceId = DeviceConfigKt.getReferenceDeviceIds().get(serialized);
                    object = referenceDeviceId;
                    if (object == null) break block6;
                    String it = object;
                    boolean bl = false;
                    Map map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"id", (Object)it));
                    object = map2;
                    if (map2 != null) break block7;
                }
                object = MapsKt.emptyMap();
            }
            Object deviceIdMap = object;
            Object object2 = new char[]{','};
            object2 = StringsKt.split$default((CharSequence)configString, (char[])object2, (boolean)false, (int)0, (int)6, null);
            Object object3 = deviceIdMap;
            boolean $i$f$filter = false;
            void bl = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                if (!(it.length() >= 3 && StringsKt.contains$default((CharSequence)it, (char)'=', (boolean)false, (int)2, null))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map3 = destination$iv$iv2;
                String paramString = (String)element$iv$iv;
                boolean bl3 = false;
                Pair pair = new Pair((Object)((Object)StringsKt.trim((CharSequence)StringsKt.substringBefore$default((String)paramString, (char)'=', null, (int)2, null))).toString(), (Object)((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default((String)paramString, (char)'=', null, (int)2, null))).toString());
                map3.put(pair.getFirst(), pair.getSecond());
            }
            Map paramsMap = MapsKt.plus((Map)object3, (Map)destination$iv$iv2);
            return this.parseDeviceSpecLanguage(paramsMap, availableDevices);
        }

        private final DeviceConfig parseDeviceSpecLanguage(Map<String, String> params2, Collection<Device> availableDevices) {
            String parentId = params2.get("parent");
            if (parentId != null) {
                Object v0;
                block3: {
                    Iterable $this$firstOrNull$iv = availableDevices;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Device it = (Device)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getId(), (Object)parentId)) continue;
                        v0 = element$iv;
                        break block3;
                    }
                    v0 = null;
                }
                Device device2 = v0;
                if (device2 == null) {
                    return null;
                }
                Device matchingDevice = device2;
                return this.parseFromExistingDeviceWithDeviceSpecLanguage(matchingDevice, params2);
            }
            return this.parseFromCustomDeviceSpecLanguage(params2);
        }

        private final DeviceConfig parseFromExistingDeviceWithDeviceSpecLanguage(Device device2, Map<String, String> params2) {
            Navigation navigation;
            Orientation orientation;
            DeviceConfig initialConfig = DeviceUtilsKt.toDeviceConfig(device2);
            if (params2.get("orientation") != null) {
                Enum enum_;
                String value$iv = params2.getOrDefault("orientation", "");
                boolean $i$f$enumValueOfOrNull = false;
                try {
                    enum_ = Orientation.valueOf(value$iv);
                }
                catch (Exception exception) {
                    enum_ = null;
                }
                if ((v0 = (Orientation)enum_) == null) {
                    return null;
                }
            } else {
                v0 = orientation = null;
            }
            if (params2.get("navigation") != null) {
                Enum exception;
                String value$iv = params2.getOrDefault("navigation", "");
                boolean $i$f$enumValueOfOrNull = false;
                try {
                    exception = Navigation.valueOf(value$iv);
                }
                catch (Exception exception2) {
                    exception = null;
                }
                if ((v1 = (Navigation)exception) == null) {
                    return null;
                }
            } else {
                v1 = navigation = null;
            }
            if (orientation != null || navigation != null) {
                Enum it;
                MutableDeviceConfig mutableDeviceConfig;
                MutableDeviceConfig $this$parseFromExistingDeviceWithDeviceSpecLanguage_u24lambda_u240 = mutableDeviceConfig = DeviceConfigKt.toMutableConfig(initialConfig);
                boolean bl = false;
                Orientation orientation2 = orientation;
                if (orientation2 != null) {
                    it = orientation2;
                    boolean bl2 = false;
                    $this$parseFromExistingDeviceWithDeviceSpecLanguage_u24lambda_u240.setOrientation((Orientation)it);
                }
                Navigation navigation2 = navigation;
                if (navigation2 != null) {
                    it = navigation2;
                    boolean bl3 = false;
                    $this$parseFromExistingDeviceWithDeviceSpecLanguage_u24lambda_u240.setNavigation((Navigation)it);
                }
                return DeviceConfigKt.toImmutableConfig(mutableDeviceConfig);
            }
            return initialConfig;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final DeviceConfig parseFromCustomDeviceSpecLanguage(Map<String, String> params2) {
            Navigation navigation;
            Cutout cutout;
            Orientation orientation;
            float chinSizeValue;
            boolean isRound;
            int dpi;
            AndroidDimension androidDimension = DeviceConfigKt.access$parseAndroidNumberOrNull(params2.get("width"));
            if (androidDimension == null) {
                return null;
            }
            AndroidDimension width = androidDimension;
            AndroidDimension androidDimension2 = DeviceConfigKt.access$parseAndroidNumberOrNull(params2.get("height"));
            if (androidDimension2 == null) {
                return null;
            }
            AndroidDimension height = androidDimension2;
            AndroidDimension chinSize = DeviceConfigKt.access$parseAndroidNumberOrNull(params2.get("chinSize"));
            if (width.getUnit() != height.getUnit()) {
                return null;
            }
            if (params2.get("chinSize") != null && (chinSize == null || chinSize.getUnit() != width.getUnit())) {
                return null;
            }
            DimUnit dimUnit = width.getUnit();
            if (params2.get("dpi") != null) {
                Object object = params2.get("dpi");
                if (object == null || (object = StringsKt.toIntOrNull((String)object)) == null) return null;
                v3 = (Integer)object;
            } else {
                v3 = dpi = 420;
            }
            if (params2.get("isRound") != null) {
                Object object = params2.get("isRound");
                if (object == null || (object = StringsKt.toBooleanStrictOrNull((String)object)) == null) return null;
                v5 = (Boolean)object;
            } else {
                v5 = isRound = Preview.DeviceSpec.INSTANCE.getDEFAULT_IS_ROUND();
            }
            if (params2.get("chinSize") != null) {
                AndroidDimension androidDimension3 = chinSize;
                if (androidDimension3 == null) return null;
                v7 = androidDimension3.getValue();
            } else {
                v7 = chinSizeValue = 0.0f;
            }
            if (params2.get("orientation") != null) {
                Enum enum_;
                String value$iv = params2.getOrDefault("orientation", "");
                boolean $i$f$enumValueOfOrNull = false;
                try {
                    enum_ = Orientation.valueOf(value$iv);
                }
                catch (Exception exception) {
                    enum_ = null;
                }
                if ((v8 = (Orientation)enum_) == null) {
                    return null;
                }
            } else {
                v8 = orientation = width.getValue() > height.getValue() ? Orientation.landscape : Orientation.portrait;
            }
            if (params2.get("cutout") != null) {
                Enum exception;
                String value$iv = params2.getOrDefault("cutout", "");
                boolean $i$f$enumValueOfOrNull = false;
                try {
                    exception = Cutout.valueOf(value$iv);
                }
                catch (Exception exception2) {
                    exception = null;
                }
                if ((v9 = (Cutout)exception) == null) {
                    return null;
                }
            } else {
                v9 = cutout = Preview.DeviceSpec.INSTANCE.getDEFAULT_CUTOUT();
            }
            if (params2.get("navigation") != null) {
                Enum enum_;
                String value$iv = params2.getOrDefault("navigation", "");
                boolean $i$f$enumValueOfOrNull = false;
                try {
                    enum_ = Navigation.valueOf(value$iv);
                }
                catch (Exception exception) {
                    enum_ = null;
                }
                if ((navigation = (Navigation)enum_) == null) {
                    return null;
                }
            } else {
                navigation = Preview.DeviceSpec.INSTANCE.getDEFAULT_NAVIGATION();
            }
            Navigation navigation2 = navigation;
            return new DeviceConfig(params2.get("id"), width.getValue(), height.getValue(), dimUnit, dpi, isRound || chinSizeValue > 0.0f ? Shape.Round : Shape.Normal, chinSizeValue, orientation, cutout, navigation2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

