/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.nativeSymbolizer;

import com.android.tools.idea.util.StudioPathManager;
import com.android.tools.nativeSymbolizer.LlvmSymbolizer;
import com.android.tools.nativeSymbolizer.NativeSymbolizer;
import com.android.tools.nativeSymbolizer.SymbolFilesLocator;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0006\u0010\u0004\u001a\u00020\u0005\u001a\b\u0010\u0006\u001a\u00020\u0007H\u0000\u00a8\u0006\b"}, d2={"createNativeSymbolizer", "Lcom/android/tools/nativeSymbolizer/NativeSymbolizer;", "locator", "Lcom/android/tools/nativeSymbolizer/SymbolFilesLocator;", "getLlvmSymbolizerPath", "", "getLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "native-symbolizer"})
public final class NativeSymbolizerKt {
    @NotNull
    public static final NativeSymbolizer createNativeSymbolizer(@NotNull SymbolFilesLocator locator) {
        Intrinsics.checkNotNullParameter((Object)locator, (String)"locator");
        String symbolizerPath = NativeSymbolizerKt.getLlvmSymbolizerPath();
        NativeSymbolizerKt.getLogger().info("Creating a native symbolizer. Executable path: " + symbolizerPath);
        return new LlvmSymbolizer(symbolizerPath, locator, 0L, 4, null);
    }

    @NotNull
    public static final String getLlvmSymbolizerPath() {
        Path path;
        String exe = null;
        String os = null;
        if (SystemInfo.isLinux) {
            os = "linux-x86_64";
            exe = "llvm-symbolizer";
        } else if (SystemInfo.isMac) {
            os = "darwin-x86_64";
            exe = "llvm-symbolizer";
        } else if (SystemInfo.isWindows) {
            os = "windows-x86_64";
            exe = "llvm-symbolizer.exe";
        } else {
            throw new IllegalStateException("Unknown operating system");
        }
        if (StudioPathManager.isRunningFromSources()) {
            path = StudioPathManager.resolvePathFromSourcesRoot((String)("prebuilts/tools/" + os + "/lldb/bin/" + exe));
        } else {
            String[] stringArray = new String[]{"plugins/android-ndk/resources/lldb/bin/" + exe};
            path = Paths.get(PathManager.getHomePath(), stringArray);
        }
        Path result2 = path;
        return ((Object)result2).toString();
    }

    @NotNull
    public static final Logger getLogger() {
        Logger logger = Logger.getInstance((String)"NativeSymbolizer");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }
}

