/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard.deprecated;

import com.android.tools.idea.welcome.wizard.ConsoleHighlighter;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.jetbrains.annotations.NotNull;

public class ProgressStepForm
implements Disposable {
    private final ConsoleHighlighter myHighlighter;
    private final EditorEx myConsoleEditor;
    private JPanel myRoot;
    private JProgressBar myProgressBar;
    private JButton myShowDetailsButton;
    private JLabel myLabel;
    private JPanel myConsole;
    private JLabel myLabel2;
    private double myFraction = 0.0;

    public ProgressStepForm() {
        this.setupUI();
        this.myLabel.setText("Installing");
        this.myConsoleEditor = ConsoleViewUtil.setupConsoleEditor((Project)null, (boolean)false, (boolean)false);
        this.myConsoleEditor.getSettings().setUseSoftWraps(true);
        this.myConsoleEditor.reinitSettings();
        this.myConsoleEditor.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 0));
        this.myHighlighter = new ConsoleHighlighter();
        this.myHighlighter.setModalityState(ModalityState.stateForComponent((Component)this.myLabel));
        this.myConsoleEditor.setHighlighter((EditorHighlighter)this.myHighlighter);
        JComponent editorComponent = this.myConsoleEditor.getComponent();
        this.myConsole.add((Component)editorComponent, "Center");
        editorComponent.setVisible(false);
        this.myShowDetailsButton.addActionListener(e -> this.showConsole());
    }

    public void print(@NotNull String s, @NotNull ConsoleViewContentType contentType) {
        this.myHighlighter.setModalityState(ModalityState.stateForComponent((Component)this.myConsole));
        this.myHighlighter.print(s + (s.endsWith("\n") ? "" : "\n"), contentType.getAttributes());
    }

    public void attachToProcess(ProcessHandler processHandler) {
        this.myHighlighter.attachToProcess(processHandler);
    }

    public void showConsole() {
        ApplicationManager.getApplication().invokeLater(() -> {
            JComponent editorComponent = this.myConsoleEditor.getComponent();
            if (!editorComponent.isVisible()) {
                this.myShowDetailsButton.getParent().remove(this.myShowDetailsButton);
                editorComponent.setVisible(true);
            }
        });
    }

    public void setFraction(double fraction) {
        this.myFraction = fraction;
        this.myProgressBar.setMaximum(1000);
        this.myProgressBar.setValue((int)(1000.0 * fraction));
    }

    public double getFraction() {
        return this.myFraction;
    }

    public JComponent getRoot() {
        return this.myRoot;
    }

    public JLabel getLabel() {
        return this.myLabel;
    }

    public JLabel getLabel2() {
        return this.myLabel2;
    }

    public JButton getShowDetailsButton() {
        return this.myShowDetailsButton;
    }

    @NotNull
    public JProgressBar getProgressBar() {
        return this.myProgressBar;
    }

    public void dispose() {
        EditorFactory.getInstance().releaseEditor((Editor)this.myConsoleEditor);
    }

    private void setupUI() {
        this.myRoot = new JPanel();
        this.myRoot.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myRoot.add((Component)panel1, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myLabel = new JLabel();
        panel1.add((Component)this.myLabel, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null, 0, false));
        this.myProgressBar = new JProgressBar();
        this.myProgressBar.setIndeterminate(true);
        panel1.add((Component)this.myProgressBar, new GridConstraints(2, 0, 1, 1, 0, 1, 0, 0, null, null, null, 0, false));
        this.myLabel2 = new JLabel();
        panel1.add((Component)this.myLabel2, new GridConstraints(1, 0, 1, 1, 0, 1, 0, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.myRoot.add((Component)spacer1, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 1, null, new Dimension(5, -1), null, 0, false));
        Spacer spacer2 = new Spacer();
        this.myRoot.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 0, 1, null, new Dimension(5, -1), null, 0, false));
        this.myShowDetailsButton = new JButton();
        this.myShowDetailsButton.setText("Show Details");
        this.myRoot.add((Component)this.myShowDetailsButton, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        Spacer spacer3 = new Spacer();
        this.myRoot.add((Component)spacer3, new GridConstraints(2, 0, 1, 1, 0, 1, 0, 1, null, new Dimension(5, -1), null, 0, false));
        this.myConsole = new JPanel();
        this.myConsole.setLayout(new BorderLayout(0, 0));
        this.myRoot.add((Component)this.myConsole, new GridConstraints(2, 1, 1, 1, 0, 3, 5, 5, null, null, null, 0, false));
        Spacer spacer4 = new Spacer();
        this.myRoot.add((Component)spacer4, new GridConstraints(2, 2, 1, 1, 0, 1, 0, 1, null, new Dimension(5, -1), null, 0, false));
    }
}

