/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard;

import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.sdk.wizard.LicenseAgreementModel;
import com.android.tools.idea.welcome.SdkLocationUtils;
import com.android.tools.idea.welcome.install.WizardException;
import com.android.tools.idea.welcome.wizard.AbstractProgressStep;
import com.android.tools.idea.welcome.wizard.FirstRunWizardModel;
import com.android.tools.idea.welcome.wizard.FirstRunWizardTracker;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.google.wireless.android.sdk.stats.SetupWizardEvent;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class InstallComponentsProgressStep
extends AbstractProgressStep<FirstRunWizardModel> {
    private final BoolProperty myIsBusyProperty = new BoolProperty(this){
        private final AtomicBoolean myIsBusy = new AtomicBoolean(false);

        @Override
        protected void setDirectly(@NotNull Boolean value2) {
            this.myIsBusy.set(value2);
        }

        @Override
        @NotNull
        public Boolean get() {
            return this.myIsBusy.get();
        }
    };
    private final LicenseAgreementModel myLicenseAgreementModel;
    private final FirstRunWizardTracker myTracker;

    public InstallComponentsProgressStep(@NotNull FirstRunWizardModel model, @NotNull LicenseAgreementModel licenseAgreementModel, @NotNull FirstRunWizardTracker tracker) {
        super(model, "Downloading Components");
        this.myLicenseAgreementModel = licenseAgreementModel;
        this.myTracker = tracker;
    }

    @Override
    protected void onWizardStarting(@NotNull ModelWizard.Facade wizard2) {
        super.onWizardStarting(wizard2);
        wizard2.updateNavigationProperties();
    }

    @Override
    protected boolean shouldShow() {
        Path sdkLocation = ((FirstRunWizardModel)this.getModel()).getSdkInstallLocation();
        return sdkLocation != null && SdkLocationUtils.isWritable(sdkLocation);
    }

    @Override
    protected void onShowing() {
        super.onShowing();
        this.myTracker.trackStepShowing(SetupWizardEvent.WizardStep.WizardStepKind.INSTALL_SDK);
    }

    @Override
    protected boolean canGoBack() {
        return false;
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        return this.myIsBusyProperty.not().and(super.canGoForward());
    }

    @Override
    protected void execute() {
        this.myIsBusyProperty.set(true);
        Application application = ApplicationManager.getApplication();
        application.assertIsDispatchThread();
        Task.Backgroundable task2 = new Task.Backgroundable(null, "Android Studio Setup Wizard", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                boolean wasSuccess = false;
                InstallComponentsProgressStep.this.myTracker.trackInstallingComponentsStarted();
                try {
                    InstallComponentsProgressStep.this.myLicenseAgreementModel.acceptLicenses();
                    ((FirstRunWizardModel)InstallComponentsProgressStep.this.getModel()).installComponents(InstallComponentsProgressStep.this);
                    wasSuccess = true;
                }
                catch (WizardException e) {
                    Logger.getInstance(((Object)((Object)this)).getClass()).error((Throwable)e);
                    InstallComponentsProgressStep.this.showConsole();
                    InstallComponentsProgressStep.this.print(e.getMessage() + "\n", ConsoleViewContentType.ERROR_OUTPUT);
                }
                finally {
                    if (InstallComponentsProgressStep.this.isCanceled()) {
                        InstallComponentsProgressStep.this.myTracker.trackInstallingComponentsFinished(SetupWizardEvent.SdkInstallationMetrics.SdkInstallationResult.CANCELED);
                    } else if (wasSuccess) {
                        InstallComponentsProgressStep.this.myTracker.trackInstallingComponentsFinished(SetupWizardEvent.SdkInstallationMetrics.SdkInstallationResult.SUCCESS);
                    } else {
                        InstallComponentsProgressStep.this.myTracker.trackInstallingComponentsFinished(SetupWizardEvent.SdkInstallationMetrics.SdkInstallationResult.ERROR);
                    }
                    InstallComponentsProgressStep.this.myIsBusyProperty.set(false);
                }
            }
        };
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(task2, this.getProgressIndicator());
    }
}

