/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard;

import com.android.annotations.concurrency.AnyThread;
import com.android.tools.analytics.UsageTracker;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.SetupWizardEvent;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@AnyThread
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0013J\u000e\u0010\u001a\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u001b\u001a\u00020\u0017J\u0014\u0010\u001c\u001a\u00020\u00172\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eJ\u0006\u0010 \u001a\u00020\u0017J\u000e\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&J\b\u0010'\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/android/tools/idea/welcome/wizard/FirstRunWizardTracker;", "", "mode", "Lcom/google/wireless/android/sdk/stats/SetupWizardEvent$SetupWizardMode;", "isDeprecatedWizard", "", "<init>", "(Lcom/google/wireless/android/sdk/stats/SetupWizardEvent$SetupWizardMode;Z)V", "eventBuilder", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$Builder;", "kotlin.jvm.PlatformType", "wizardStartedTime", "Ljava/time/Instant;", "installationMode", "Lcom/google/wireless/android/sdk/stats/SetupWizardEvent$InstallationMode;", "sdkInstallationMetricsBuilder", "Lcom/google/wireless/android/sdk/stats/SetupWizardEvent$SdkInstallationMetrics$Builder;", "installingComponentsStartTime", "lastStepShown", "Lcom/google/wireless/android/sdk/stats/SetupWizardEvent$WizardStep$WizardStepKind;", "lastStepShownAtTimeMs", "", "trackWizardStarted", "", "trackStepShowing", "wizardStepKind", "trackInstallationMode", "trackSdkInstallLocationChanged", "trackSdkComponentsToInstall", "sdkComponentsToInstall", "", "Lcom/google/wireless/android/sdk/stats/SetupWizardEvent$SdkInstallationMetrics$SdkComponentKind;", "trackInstallingComponentsStarted", "trackInstallingComponentsFinished", "sdkInstallationResult", "Lcom/google/wireless/android/sdk/stats/SetupWizardEvent$SdkInstallationMetrics$SdkInstallationResult;", "trackWizardFinished", "completionStatus", "Lcom/google/wireless/android/sdk/stats/SetupWizardEvent$CompletionStatus;", "addCurrentStep", "intellij.android.core"})
public final class FirstRunWizardTracker {
    @NotNull
    private final SetupWizardEvent.SetupWizardMode mode;
    private final boolean isDeprecatedWizard;
    private final AndroidStudioEvent.Builder eventBuilder;
    @Nullable
    private Instant wizardStartedTime;
    @NotNull
    private SetupWizardEvent.InstallationMode installationMode;
    @NotNull
    private final SetupWizardEvent.SdkInstallationMetrics.Builder sdkInstallationMetricsBuilder;
    @Nullable
    private Instant installingComponentsStartTime;
    @Nullable
    private SetupWizardEvent.WizardStep.WizardStepKind lastStepShown;
    private long lastStepShownAtTimeMs;

    public FirstRunWizardTracker(@NotNull SetupWizardEvent.SetupWizardMode mode, boolean isDeprecatedWizard) {
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        this.mode = mode;
        this.isDeprecatedWizard = isDeprecatedWizard;
        this.eventBuilder = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.SETUP_WIZARD_EVENT);
        this.installationMode = SetupWizardEvent.InstallationMode.UNKNOWN_INSTALLATION_MODE;
        SetupWizardEvent.SdkInstallationMetrics.Builder builder = this.eventBuilder.getSetupWizardEventBuilder().getSdkInstallationMetricsBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"getSdkInstallationMetricsBuilder(...)");
        this.sdkInstallationMetricsBuilder = builder;
        this.lastStepShownAtTimeMs = -1L;
    }

    public final void trackWizardStarted() {
        if (this.wizardStartedTime != null) {
            return;
        }
        this.wizardStartedTime = Instant.now();
    }

    public final void trackStepShowing(@NotNull SetupWizardEvent.WizardStep.WizardStepKind wizardStepKind) {
        Intrinsics.checkNotNullParameter((Object)wizardStepKind, (String)"wizardStepKind");
        if (wizardStepKind == this.lastStepShown) {
            return;
        }
        this.addCurrentStep();
        this.lastStepShown = wizardStepKind;
        this.lastStepShownAtTimeMs = System.currentTimeMillis();
    }

    public final void trackInstallationMode(@NotNull SetupWizardEvent.InstallationMode installationMode) {
        Intrinsics.checkNotNullParameter((Object)installationMode, (String)"installationMode");
        this.installationMode = installationMode;
    }

    public final void trackSdkInstallLocationChanged() {
        this.sdkInstallationMetricsBuilder.setSdkInstallLocationChanged(true);
    }

    public final void trackSdkComponentsToInstall(@NotNull List<? extends SetupWizardEvent.SdkInstallationMetrics.SdkComponentKind> sdkComponentsToInstall) {
        Intrinsics.checkNotNullParameter(sdkComponentsToInstall, (String)"sdkComponentsToInstall");
        this.sdkInstallationMetricsBuilder.clearSdkComponentsToInstall();
        this.sdkInstallationMetricsBuilder.addAllSdkComponentsToInstall((Iterable)sdkComponentsToInstall);
    }

    public final void trackInstallingComponentsStarted() {
        this.installingComponentsStartTime = Instant.now();
    }

    public final void trackInstallingComponentsFinished(@NotNull SetupWizardEvent.SdkInstallationMetrics.SdkInstallationResult sdkInstallationResult) {
        Intrinsics.checkNotNullParameter((Object)sdkInstallationResult, (String)"sdkInstallationResult");
        this.sdkInstallationMetricsBuilder.setSdkInstallationResult(sdkInstallationResult);
        if (this.installingComponentsStartTime != null) {
            Duration duration = Duration.between(this.installingComponentsStartTime, Instant.now());
            this.sdkInstallationMetricsBuilder.setTimeSpentInstallingSdkComponentsMs(duration.toMillis());
        }
    }

    public final void trackWizardFinished(@NotNull SetupWizardEvent.CompletionStatus completionStatus) {
        Intrinsics.checkNotNullParameter((Object)completionStatus, (String)"completionStatus");
        if (this.eventBuilder.getSetupWizardEventBuilder().hasTimeSpentInWizardMs()) {
            return;
        }
        this.addCurrentStep();
        this.eventBuilder.getSetupWizardEventBuilder().setMode(this.mode);
        this.eventBuilder.getSetupWizardEventBuilder().setInstallationMode(this.installationMode);
        this.eventBuilder.getSetupWizardEventBuilder().setCompletionStatus(completionStatus);
        Duration timeSpentInWizardMs = Duration.between(this.wizardStartedTime, Instant.now());
        this.eventBuilder.getSetupWizardEventBuilder().setTimeSpentInWizardMs(timeSpentInWizardMs.toMillis());
        this.eventBuilder.getSetupWizardEventBuilder().setIsDeprecatedWizard(this.isDeprecatedWizard);
        AndroidStudioEvent.Builder builder = this.eventBuilder;
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"eventBuilder");
        UsageTracker.log((AndroidStudioEvent.Builder)builder);
    }

    private final void addCurrentStep() {
        if (this.lastStepShown != null && this.lastStepShownAtTimeMs != -1L) {
            long timeInPreviousStepMs = System.currentTimeMillis() - this.lastStepShownAtTimeMs;
            this.eventBuilder.getSetupWizardEventBuilder().addWizardSteps(SetupWizardEvent.WizardStep.newBuilder().setWizardStepKind(this.lastStepShown).setTimeSpentInStepMs(timeInPreviousStepMs));
        }
    }
}

