/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wear.dwf.inspections;

import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.util.ModuleExtensionsKt;
import com.android.tools.idea.wear.dwf.WearDwfBundle;
import com.android.tools.idea.wear.dwf.inspections.UnknownWFFVersionInspectionKt;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.dom.manifest.ManifestDomFileDescription;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016J\f\u0010\r\u001a\u00020\u0005*\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0010H\u0002J\u000e\u0010\u0013\u001a\u00020\u0005*\u0004\u0018\u00010\u0010H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/wear/dwf/inspections/UnknownWFFVersionInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "isAvailableForFile", "", "file", "Lcom/intellij/psi/PsiFile;", "buildVisitor", "Lcom/intellij/psi/XmlElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "isWFFVersionProperty", "Lcom/intellij/psi/xml/XmlTag;", "resolvePlaceholders", "", "Lorg/jetbrains/android/facet/AndroidFacet;", "value", "isInteger", "intellij.android.wear-dwf"})
public final class UnknownWFFVersionInspection
extends LocalInspectionTool {
    public boolean isAvailableForFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        XmlFile xmlFile = file instanceof XmlFile ? (XmlFile)file : null;
        if (xmlFile == null) {
            return false;
        }
        XmlFile file2 = xmlFile;
        AndroidFacet androidFacet = ModuleExtensionsKt.getAndroidFacet((PsiElement)((PsiElement)file2));
        if (androidFacet == null) {
            return false;
        }
        AndroidFacet facet = androidFacet;
        return ManifestDomFileDescription.isManifestFile(file2, facet);
    }

    @NotNull
    public XmlElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new XmlElementVisitor(this, holder){
            final /* synthetic */ UnknownWFFVersionInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitXmlTag(XmlTag tag) {
                Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                AndroidFacet androidFacet = ModuleExtensionsKt.getAndroidFacet((PsiElement)((PsiElement)tag));
                if (androidFacet == null) {
                    return;
                }
                AndroidFacet androidFacet2 = androidFacet;
                if (!UnknownWFFVersionInspection.access$isWFFVersionProperty(this.this$0, tag)) {
                    return;
                }
                XmlAttribute xmlAttribute = tag.getAttribute("value", "http://schemas.android.com/apk/res/android");
                if (xmlAttribute == null) {
                    return;
                }
                XmlAttribute wffVersionAttribute = xmlAttribute;
                String wffVersion = UnknownWFFVersionInspection.access$resolvePlaceholders(this.this$0, androidFacet2, wffVersionAttribute.getValue());
                if (!UnknownWFFVersionInspection.access$isInteger(this.this$0, wffVersion)) {
                    return;
                }
                if (!CollectionsKt.contains((Iterable)UnknownWFFVersionInspectionKt.access$getKnownWffVersions$p(), (Object)wffVersion)) {
                    this.$holder.registerProblem((PsiElement)wffVersionAttribute, WearDwfBundle.INSTANCE.message("inspection.unknown.wff.version.description", new Object[0]), ProblemHighlightType.WARNING, new LocalQuickFix[0]);
                }
            }
        };
    }

    private final boolean isWFFVersionProperty(XmlTag $this$isWFFVersionProperty) {
        return Intrinsics.areEqual((Object)$this$isWFFVersionProperty.getName(), (Object)"property") && Intrinsics.areEqual((Object)$this$isWFFVersionProperty.getAttributeValue("name", "http://schemas.android.com/apk/res/android"), (Object)"com.google.wear.watchface.format.version");
    }

    private final String resolvePlaceholders(AndroidFacet $this$resolvePlaceholders, String value2) {
        return value2 == null ? null : ProjectSystemUtil.getModuleSystem($this$resolvePlaceholders).getManifestOverrides().resolvePlaceholders(value2);
    }

    private final boolean isInteger(String $this$isInteger) {
        String string = $this$isInteger;
        return (string != null ? StringsKt.toIntOrNull((String)string) : null) != null;
    }

    public static final /* synthetic */ boolean access$isWFFVersionProperty(UnknownWFFVersionInspection $this, XmlTag $receiver) {
        return $this.isWFFVersionProperty($receiver);
    }

    public static final /* synthetic */ String access$resolvePlaceholders(UnknownWFFVersionInspection $this, AndroidFacet $receiver, String value2) {
        return $this.resolvePlaceholders($receiver, value2);
    }

    public static final /* synthetic */ boolean access$isInteger(UnknownWFFVersionInspection $this, String $receiver) {
        return $this.isInteger($receiver);
    }
}

