/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wear.dwf.importer.wfs.extractors;

import com.android.ide.common.xml.XmlPrettyPrinter;
import com.android.tools.idea.wear.dwf.importer.wfs.WFSImportException;
import com.android.tools.idea.wear.dwf.importer.wfs.extractors.WFSFileExtractorKt;
import com.android.tools.idea.wear.dwf.importer.wfs.honeyface.HoneyFace;
import com.android.tools.idea.wear.dwf.importer.wfs.honeyface.HoneyFaceParser;
import com.android.tools.idea.wear.dwf.importer.wfs.honeyface.HoneyFaceXmlConverter;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.Decompressor;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ&\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0086@\u00a2\u0006\u0002\u0010\u0011J \u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0018\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/wear/dwf/importer/wfs/extractors/WFSFileExtractor;", "", "ioDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "parser", "Lcom/android/tools/idea/wear/dwf/importer/wfs/honeyface/HoneyFaceParser;", "xmlConverter", "Lcom/android/tools/idea/wear/dwf/importer/wfs/honeyface/HoneyFaceXmlConverter;", "<init>", "(Lkotlinx/coroutines/CoroutineDispatcher;Lcom/android/tools/idea/wear/dwf/importer/wfs/honeyface/HoneyFaceParser;Lcom/android/tools/idea/wear/dwf/importer/wfs/honeyface/HoneyFaceXmlConverter;)V", "extract", "", "wfsFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "mainFolderPath", "Ljava/nio/file/Path;", "resFolderPath", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/nio/file/Path;Ljava/nio/file/Path;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "extractWFSFiles", "generateRawWatchFaceFile", "intellij.android.wear-dwf"})
public final class WFSFileExtractor {
    @NotNull
    private final CoroutineDispatcher ioDispatcher;
    @NotNull
    private final HoneyFaceParser parser;
    @NotNull
    private final HoneyFaceXmlConverter xmlConverter;

    public WFSFileExtractor(@NotNull CoroutineDispatcher ioDispatcher, @NotNull HoneyFaceParser parser, @NotNull HoneyFaceXmlConverter xmlConverter) {
        Intrinsics.checkNotNullParameter((Object)ioDispatcher, (String)"ioDispatcher");
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        Intrinsics.checkNotNullParameter((Object)xmlConverter, (String)"xmlConverter");
        this.ioDispatcher = ioDispatcher;
        this.parser = parser;
        this.xmlConverter = xmlConverter;
    }

    public /* synthetic */ WFSFileExtractor(CoroutineDispatcher coroutineDispatcher, HoneyFaceParser honeyFaceParser, HoneyFaceXmlConverter honeyFaceXmlConverter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            honeyFaceParser = new HoneyFaceParser(null, 1, null);
        }
        if ((n & 4) != 0) {
            honeyFaceXmlConverter = new HoneyFaceXmlConverter();
        }
        this(coroutineDispatcher, honeyFaceParser, honeyFaceXmlConverter);
    }

    @Nullable
    public final Object extract(@NotNull VirtualFile wfsFile, @NotNull Path mainFolderPath, @NotNull Path resFolderPath, @NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)this.ioDispatcher), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, wfsFile, mainFolderPath, resFolderPath, null){
            int label;
            final /* synthetic */ WFSFileExtractor this$0;
            final /* synthetic */ VirtualFile $wfsFile;
            final /* synthetic */ Path $mainFolderPath;
            final /* synthetic */ Path $resFolderPath;
            {
                this.this$0 = $receiver;
                this.$wfsFile = $wfsFile;
                this.$mainFolderPath = $mainFolderPath;
                this.$resFolderPath = $resFolderPath;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        WFSFileExtractor.access$extractWFSFiles(this.this$0, this.$wfsFile, this.$mainFolderPath, this.$resFolderPath);
                        WFSFileExtractor.access$generateRawWatchFaceFile(this.this$0, this.$mainFolderPath, this.$resFolderPath);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void extractWFSFiles(VirtualFile wfsFile, Path mainFolderPath, Path resFolderPath) {
        new Decompressor.Zip(wfsFile.toNioPath()).entryFilter(arg_0 -> WFSFileExtractor.extractWFSFiles$lambda$1(WFSFileExtractor::extractWFSFiles$lambda$0, arg_0)).extract(mainFolderPath);
        File wfsPreviewFile = mainFolderPath.resolve("latest_preview.png").toFile();
        if (wfsPreviewFile.exists()) {
            File previewFileDestination = resFolderPath.resolve("preview.png").toFile();
            FileUtil.copy((File)previewFileDestination, (File)previewFileDestination);
            FileUtil.delete((File)wfsPreviewFile);
        }
    }

    private final void generateRawWatchFaceFile(Path mainFolderPath, Path resFolderPath) {
        File honeyFaceFile = new File(mainFolderPath.toFile(), "honeyface.json");
        HoneyFace honeyFace = this.parser.parse(honeyFaceFile);
        if (honeyFace == null) {
            throw new WFSImportException.InvalidHoneyFaceFileException("Failed to parse the HoneyFace file.");
        }
        HoneyFace honeyFace2 = honeyFace;
        FileUtil.delete((File)honeyFaceFile);
        Document rawWatchFaceXmlDocument = this.xmlConverter.toXml(honeyFace2);
        File rawWatchFaceFile = resFolderPath.resolve("raw").resolve("watchface.xml").toFile();
        FileUtil.createIfDoesntExist((File)rawWatchFaceFile);
        FileUtil.writeToFile((File)rawWatchFaceFile, (String)XmlPrettyPrinter.prettyPrint((Node)rawWatchFaceXmlDocument, (boolean)false));
    }

    private static final boolean extractWFSFiles$lambda$0(Decompressor.Entry it) {
        return !WFSFileExtractorKt.access$getEXCLUDED_FILES$p().contains(it.name);
    }

    private static final boolean extractWFSFiles$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$extractWFSFiles(WFSFileExtractor $this, VirtualFile wfsFile, Path mainFolderPath, Path resFolderPath) {
        $this.extractWFSFiles(wfsFile, mainFolderPath, resFolderPath);
    }

    public static final /* synthetic */ void access$generateRawWatchFaceFile(WFSFileExtractor $this, Path mainFolderPath, Path resFolderPath) {
        $this.generateRawWatchFaceFile(mainFolderPath, resFolderPath);
    }
}

