/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wear.dwf.dom.raw;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.wear.dwf.analytics.DeclarativeWatchFaceUsageTracker;
import com.android.tools.idea.wear.dwf.dom.raw.CurrentWFFVersion;
import com.android.tools.idea.wear.dwf.dom.raw.CurrentWFFVersionService;
import com.android.tools.idea.wear.dwf.dom.raw.RawWatchFaceXmlSchemaProviderKt;
import com.android.tools.idea.wear.dwf.dom.raw.RawWatchFaceXmlSchemaUpdater;
import com.android.tools.wear.wff.WFFVersion;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.xml.XmlSchemaProvider;
import com.intellij.xml.util.XmlUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.dom.WatchFaceUtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u000b\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/wear/dwf/dom/raw/RawWatchfaceXmlSchemaProvider;", "Lcom/intellij/xml/XmlSchemaProvider;", "<init>", "()V", "getSchema", "Lcom/intellij/psi/xml/XmlFile;", "url", "", "Lorg/jetbrains/annotations/NonNls;", "module", "Lcom/intellij/openapi/module/Module;", "baseFile", "Lcom/intellij/psi/PsiFile;", "isAvailable", "", "file", "intellij.android.wear-dwf"})
public final class RawWatchfaceXmlSchemaProvider
extends XmlSchemaProvider {
    @Nullable
    public XmlFile getSchema(@NotNull String url, @Nullable Module module, @NotNull PsiFile baseFile) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)baseFile, (String)"baseFile");
        if (module == null) {
            return null;
        }
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RawWatchFaceXmlSchemaUpdater.Companion.initializeService(project);
        baseFile.putUserData(RawWatchFaceXmlSchemaProviderKt.access$getDWF_FILE_IN_USE$p(), (Object)true);
        CurrentWFFVersion currentWFFVersion = CurrentWFFVersionService.Companion.getInstance().getCurrentWFFVersion(module);
        if (currentWFFVersion == null) {
            return null;
        }
        CurrentWFFVersion currentWFFVersion2 = currentWFFVersion;
        WFFVersion schemaVersion = currentWFFVersion2.component1();
        boolean isFallback = currentWFFVersion2.component2();
        DeclarativeWatchFaceUsageTracker.Companion.getInstance().trackXmlSchemaUsed(schemaVersion, isFallback);
        return XmlUtil.findXmlFile((PsiFile)baseFile, (String)VfsUtilCore.urlToPath((String)VfsUtilCore.toIdeaUrl((String)FileUtil.unquote((String)schemaVersion.getSchemaUrl().toExternalForm()), (boolean)false)));
    }

    public boolean isAvailable(@NotNull XmlFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return (Boolean)StudioFlags.WEAR_DECLARATIVE_WATCH_FACE_XML_EDITOR_SUPPORT.get() != false && WatchFaceUtilKt.isDeclarativeWatchFaceFile(file);
    }
}

