/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.util;

import com.android.annotations.concurrency.UiThread;
import com.android.ide.common.repository.GoogleMavenArtifactId;
import com.android.ide.common.repository.WellKnownMavenArtifactId;
import com.android.support.AndroidxName;
import com.android.tools.idea.projectsystem.DependencyManagementException;
import com.android.tools.idea.projectsystem.DependencyType;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.RegisteredDependencyCompatibilityResult;
import com.android.tools.idea.projectsystem.RegisteredDependencyId;
import com.android.tools.idea.projectsystem.RegisteredDependencyQueryId;
import com.android.tools.idea.projectsystem.RegisteringModuleSystem;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\u0005\u001a\u00020\u0001*\u00020\u0002\u001a\u0014\u0010\u0006\u001a\u00020\u0007*\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\t\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\u0002\u001a<\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f*\u00020\u00022\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010\u000e\u001a\u00020\u00012\b\b\u0002\u0010\u000f\u001a\u00020\u00012\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0007\u001a&\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\f2\b\b\u0002\u0010\u0016\u001a\u00020\u0007\u001a \u0010\u0017\u001a\u00020\u00072\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\f2\b\b\u0002\u0010\u0016\u001a\u00020\u0007H\u0007\u00a8\u0006\u0019"}, d2={"dependsOn", "", "Lcom/intellij/openapi/module/Module;", "artifactId", "Lcom/android/ide/common/repository/GoogleMavenArtifactId;", "dependsOnAndroidx", "mapAndroidxName", "", "name", "Lcom/android/support/AndroidxName;", "dependsOnAppCompat", "addDependenciesWithUiConfirmation", "", "artifacts", "promptUserBeforeAdding", "requestSync", "dependencyType", "Lcom/android/tools/idea/projectsystem/DependencyType;", "userWantsToAdd", "project", "Lcom/intellij/openapi/project/Project;", "ids", "warning", "createAddDependencyMessage", "coordinates", "intellij.android.core"})
@JvmName(name="DependencyManagementUtil")
@SourceDebugExtension(value={"SMAP\nDependencyManagement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DependencyManagement.kt\ncom/android/tools/idea/util/DependencyManagementUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CollectionsUtils.kt\ncom/android/utils/CollectionsUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,201:1\n774#2:202\n865#2,2:203\n1617#2,9:206\n1869#2:215\n1870#2:217\n1626#2:218\n1617#2,9:219\n1869#2:228\n1870#2:230\n1626#2:231\n1563#2:232\n1634#2,3:233\n1617#2,9:236\n1869#2:245\n1870#2:247\n1626#2:248\n40#3:205\n1#4:216\n1#4:229\n1#4:246\n*S KotlinDebug\n*F\n+ 1 DependencyManagement.kt\ncom/android/tools/idea/util/DependencyManagementUtil\n*L\n120#1:202\n120#1:203,2\n121#1:206,9\n121#1:215\n121#1:217\n121#1:218\n140#1:219,9\n140#1:228\n140#1:230\n140#1:231\n177#1:232\n177#1:233,3\n177#1:236,9\n177#1:245\n177#1:247\n177#1:248\n121#1:205\n121#1:216\n140#1:229\n177#1:246\n*E\n"})
public final class DependencyManagementUtil {
    public static final boolean dependsOn(@NotNull Module $this$dependsOn, @NotNull GoogleMavenArtifactId artifactId) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$dependsOn, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
            try {
                return ProjectSystemUtil.getModuleSystem($this$dependsOn).hasResolvedDependency((WellKnownMavenArtifactId)artifactId);
            }
            catch (DependencyManagementException e) {
                Logger.getInstance((String)$this$dependsOn.getClass().getName()).warn(e.getMessage());
            }
            catch (Throwable e) {
                if ($this$dependsOn.isDisposed()) break block3;
                throw e;
            }
        }
        return false;
    }

    public static final boolean dependsOnAndroidx(@NotNull Module $this$dependsOnAndroidx) {
        Intrinsics.checkNotNullParameter((Object)$this$dependsOnAndroidx, (String)"<this>");
        return ProjectSystemUtil.getModuleSystem($this$dependsOnAndroidx).getUseAndroidX();
    }

    @NotNull
    public static final String mapAndroidxName(@Nullable Module $this$mapAndroidxName, @NotNull AndroidxName name2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Module module = $this$mapAndroidxName;
        if (module == null) {
            String string2 = name2.defaultName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"defaultName(...)");
            return string2;
        }
        boolean dependsOnAndroidx = DependencyManagementUtil.dependsOnAndroidx(module);
        if (dependsOnAndroidx) {
            String string3 = name2.newName();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"newName(...)");
        } else {
            String string4 = name2.oldName();
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"oldName(...)");
        }
        return string;
    }

    public static final boolean dependsOnAppCompat(@NotNull Module $this$dependsOnAppCompat) {
        Intrinsics.checkNotNullParameter((Object)$this$dependsOnAppCompat, (String)"<this>");
        return DependencyManagementUtil.dependsOn($this$dependsOnAppCompat, GoogleMavenArtifactId.SUPPORT_APPCOMPAT_V7) || DependencyManagementUtil.dependsOn($this$dependsOnAppCompat, GoogleMavenArtifactId.ANDROIDX_APPCOMPAT);
    }

    /*
     * WARNING - void declaration
     */
    @UiThread
    @JvmOverloads
    @NotNull
    public static final Set<GoogleMavenArtifactId> addDependenciesWithUiConfirmation(@NotNull Module $this$addDependenciesWithUiConfirmation, @NotNull Set<? extends GoogleMavenArtifactId> artifacts, boolean promptUserBeforeAdding, boolean requestSync2, @NotNull DependencyType dependencyType) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Collection<RegisteredDependencyId> collection2;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Pair idToException2;
        Object errorMessage;
        List idsToExceptions;
        void $this$mapNotNullTo$iv$iv$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$addDependenciesWithUiConfirmation, (String)"<this>");
        Intrinsics.checkNotNullParameter(artifacts, (String)"artifacts");
        Intrinsics.checkNotNullParameter((Object)((Object)dependencyType), (String)"dependencyType");
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (artifacts.isEmpty()) {
            return SetsKt.emptySet();
        }
        RegisteringModuleSystem<RegisteredDependencyQueryId, RegisteredDependencyId> registeringModuleSystem = ProjectSystemUtil.getModuleSystem($this$addDependenciesWithUiConfirmation).getRegisteringModuleSystem();
        if (registeringModuleSystem == null) {
            return artifacts;
        }
        RegisteringModuleSystem<RegisteredDependencyQueryId, RegisteredDependencyId> moduleSystem = registeringModuleSystem;
        Iterable $this$filter$iv = artifacts;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GoogleMavenArtifactId it = (GoogleMavenArtifactId)element$iv$iv;
            boolean bl = false;
            if (!(moduleSystem.getRegisteredDependencyId((WellKnownMavenArtifactId)it) == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List unnamed = (List)destination$iv$iv;
        Iterable $this$associateByNotNull$iv = artifacts;
        boolean $i$f$associateByNotNull = false;
        Iterable $this$mapNotNull$iv$iv = $this$associateByNotNull$iv;
        boolean $i$f$mapNotNull = false;
        Iterable iterable2 = $this$mapNotNull$iv$iv;
        Iterable destination$iv$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv$iv = $this$mapNotNullTo$iv$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv$iv;
            Object element$iv$iv$iv = element$iv$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Object value$iv = element$iv$iv$iv;
            boolean bl2 = false;
            GoogleMavenArtifactId it = (GoogleMavenArtifactId)value$iv;
            boolean bl3 = false;
            if (moduleSystem.getRegisteredDependencyId((WellKnownMavenArtifactId)it) != null) {
                RegisteredDependencyId it$iv;
                boolean bl4 = false;
                pair = TuplesKt.to((Object)it$iv, value$iv);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv$iv = pair;
            boolean bl5 = false;
            destination$iv$iv$iv.add(it$iv$iv$iv);
        }
        Map dependencyMap = MapsKt.toMap((Iterable)((List)destination$iv$iv$iv));
        List dependencies2 = CollectionsKt.toList((Iterable)dependencyMap.keySet());
        RegisteredDependencyCompatibilityResult registeredDependencyCompatibilityResult = (RegisteredDependencyCompatibilityResult)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> DependencyManagementUtil.addDependenciesWithUiConfirmation$lambda$2(moduleSystem, dependencies2), "Analyzing Dependency Compatibility", false, $this$addDependenciesWithUiConfirmation.getProject());
        Map compatibleDependencies = registeredDependencyCompatibilityResult.component1();
        List incompatibleDependencies = registeredDependencyCompatibilityResult.component2();
        String warning = registeredDependencyCompatibilityResult.component3();
        if (promptUserBeforeAdding) {
            Project project = $this$addDependenciesWithUiConfirmation.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            if (!DependencyManagementUtil.userWantsToAdd(project, artifacts, warning)) {
                return artifacts;
            }
        } else if (!((Collection)incompatibleDependencies).isEmpty()) {
            Messages.showErrorDialog((String)warning, (String)"Compatibility Issues Detected");
            if (compatibleDependencies.isEmpty()) {
                void $this$mapNotNullTo$iv$iv2;
                void $this$mapNotNull$iv2;
                destination$iv$iv$iv = incompatibleDependencies;
                Collection collection3 = unnamed;
                boolean $i$f$mapNotNull2 = false;
                $this$forEach$iv$iv$iv$iv = $this$mapNotNull$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo2 = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
                boolean $i$f$forEach2 = false;
                Iterator bl = $this$forEach$iv$iv$iv.iterator();
                while (bl.hasNext()) {
                    GoogleMavenArtifactId it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = bl.next();
                    boolean bl6 = false;
                    RegisteredDependencyId it = (RegisteredDependencyId)element$iv$iv;
                    boolean bl7 = false;
                    if ((GoogleMavenArtifactId)dependencyMap.get(it) == null) continue;
                    boolean bl8 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                return CollectionsKt.toSet((Iterable)CollectionsKt.plus((Collection)collection3, (Iterable)((List)destination$iv$iv2)));
            }
        }
        boolean shouldSync = (idsToExceptions = (List)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> DependencyManagementUtil.addDependenciesWithUiConfirmation$lambda$4(compatibleDependencies, moduleSystem, dependencyType), "Adding Dependencies", false, $this$addDependenciesWithUiConfirmation.getProject())).size() < compatibleDependencies.size() && requestSync2;
        Intrinsics.checkNotNull((Object)idsToExceptions);
        if (!((Collection)idsToExceptions).isEmpty()) {
            errorMessage = "The following dependencies could not be added:\n";
            for (Pair idToException2 : idsToExceptions) {
                errorMessage = (String)errorMessage + idToException2.getFirst() + " Reason: " + ((DependencyManagementException)idToException2.getSecond()).getMessage() + "\n";
            }
            if (shouldSync) {
                errorMessage = (String)errorMessage + "\nA sync will be still be performed to resolve the dependencies that were added successfully.";
            }
            Messages.showErrorDialog((String)errorMessage, (String)"Could Not Add Dependency");
        }
        if (shouldSync) {
            Project project = $this$addDependenciesWithUiConfirmation.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            ProjectSystemUtil.getSyncManager(project).requestSyncProject(ProjectSystemSyncManager.SyncReason.PROJECT_MODIFIED);
        }
        errorMessage = idsToExceptions;
        Collection collection4 = incompatibleDependencies;
        Collection collection5 = unnamed;
        boolean $i$f$map = false;
        idToException2 = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair element$iv$iv = (Pair)item$iv$iv;
            collection2 = destination$iv$iv3;
            boolean bl = false;
            collection2.add((RegisteredDependencyId)it.getFirst());
        }
        collection2 = (List)destination$iv$iv3;
        $this$map$iv = CollectionsKt.plus((Collection)collection4, (Iterable)collection2);
        boolean $i$f$mapNotNull3 = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv3 = new ArrayList();
        boolean $i$f$mapNotNullTo3 = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach3 = false;
        Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
        while (iterator3.hasNext()) {
            GoogleMavenArtifactId it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator3.next();
            boolean bl = false;
            RegisteredDependencyId it = (RegisteredDependencyId)element$iv$iv;
            boolean bl9 = false;
            if ((GoogleMavenArtifactId)dependencyMap.get(it) == null) continue;
            boolean bl10 = false;
            destination$iv$iv3.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)CollectionsKt.plus((Collection)collection5, (Iterable)((List)destination$iv$iv3)));
    }

    public static /* synthetic */ Set addDependenciesWithUiConfirmation$default(Module module, Set set2, boolean bl, boolean bl2, DependencyType dependencyType, int n, Object object) {
        if ((n & 4) != 0) {
            bl2 = true;
        }
        if ((n & 8) != 0) {
            dependencyType = DependencyType.IMPLEMENTATION;
        }
        return DependencyManagementUtil.addDependenciesWithUiConfirmation(module, set2, bl, bl2, dependencyType);
    }

    public static final boolean userWantsToAdd(@NotNull Project project, @NotNull Set<? extends GoogleMavenArtifactId> ids, @NotNull String warning) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Intrinsics.checkNotNullParameter((Object)warning, (String)"warning");
        return Messages.showOkCancelDialog((Project)project, (String)DependencyManagementUtil.createAddDependencyMessage(ids, warning), (String)"Add Project Dependency", (Icon)Messages.getErrorIcon()) == 0;
    }

    public static /* synthetic */ boolean userWantsToAdd$default(Project project, Set set2, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = "";
        }
        return DependencyManagementUtil.userWantsToAdd(project, set2, string);
    }

    @VisibleForTesting
    @NotNull
    public static final String createAddDependencyMessage(@NotNull Set<? extends GoogleMavenArtifactId> coordinates, @NotNull String warning) {
        Intrinsics.checkNotNullParameter(coordinates, (String)"coordinates");
        Intrinsics.checkNotNullParameter((Object)warning, (String)"warning");
        String libraryNames = CollectionsKt.joinToString$default((Iterable)coordinates, (CharSequence)", ", null, null, (int)0, null, DependencyManagementUtil::createAddDependencyMessage$lambda$0, (int)30, null);
        String string = StringUtil.pluralize((String)"this", (int)coordinates.size());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pluralize(...)");
        String these = string;
        String string2 = StringUtil.pluralize((String)"library", (int)coordinates.size());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"pluralize(...)");
        String libraries = string2;
        String requires = "This operation requires the " + libraries + " " + libraryNames + ".";
        if (((CharSequence)warning).length() == 0) {
            return requires + "\n\nWould you like to add " + these + " now?";
        }
        String them = coordinates.size() > 1 ? "them" : "it";
        return requires + "\n\nProblem: " + warning + "\n\nThe project may not compile after adding " + these + " " + libraries + ".\nWould you like to add " + them + " anyway?";
    }

    public static /* synthetic */ String createAddDependencyMessage$default(Set set2, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        return DependencyManagementUtil.createAddDependencyMessage(set2, string);
    }

    @UiThread
    @JvmOverloads
    @NotNull
    public static final Set<GoogleMavenArtifactId> addDependenciesWithUiConfirmation(@NotNull Module $this$addDependenciesWithUiConfirmation, @NotNull Set<? extends GoogleMavenArtifactId> artifacts, boolean promptUserBeforeAdding, boolean requestSync2) {
        Intrinsics.checkNotNullParameter((Object)$this$addDependenciesWithUiConfirmation, (String)"<this>");
        Intrinsics.checkNotNullParameter(artifacts, (String)"artifacts");
        return DependencyManagementUtil.addDependenciesWithUiConfirmation$default($this$addDependenciesWithUiConfirmation, artifacts, promptUserBeforeAdding, requestSync2, null, 8, null);
    }

    @UiThread
    @JvmOverloads
    @NotNull
    public static final Set<GoogleMavenArtifactId> addDependenciesWithUiConfirmation(@NotNull Module $this$addDependenciesWithUiConfirmation, @NotNull Set<? extends GoogleMavenArtifactId> artifacts, boolean promptUserBeforeAdding) {
        Intrinsics.checkNotNullParameter((Object)$this$addDependenciesWithUiConfirmation, (String)"<this>");
        Intrinsics.checkNotNullParameter(artifacts, (String)"artifacts");
        return DependencyManagementUtil.addDependenciesWithUiConfirmation$default($this$addDependenciesWithUiConfirmation, artifacts, promptUserBeforeAdding, false, null, 12, null);
    }

    private static final RegisteredDependencyCompatibilityResult addDependenciesWithUiConfirmation$lambda$2(RegisteringModuleSystem $moduleSystem, List $dependencies) {
        return (RegisteredDependencyCompatibilityResult)$moduleSystem.analyzeDependencyCompatibility($dependencies).get();
    }

    private static final List addDependenciesWithUiConfirmation$lambda$4(Map $compatibleDependencies, RegisteringModuleSystem $moduleSystem, DependencyType $dependencyType) {
        ArrayList<Pair> idsToExceptions = new ArrayList<Pair>();
        for (Map.Entry coordinate : $compatibleDependencies.entrySet()) {
            try {
                $moduleSystem.registerDependency((RegisteredDependencyId)coordinate.getValue(), $dependencyType);
            }
            catch (DependencyManagementException e) {
                idsToExceptions.add(new Pair(coordinate.getKey(), (Object)e));
            }
        }
        return idsToExceptions;
    }

    private static final CharSequence createAddDependencyMessage$lambda$0(GoogleMavenArtifactId it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.toString();
    }
}

