/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.validation.validators;

import com.android.io.CancellableFileIo;
import com.android.tools.idea.ui.validation.validators.PathValidator;
import com.android.tools.idea.ui.validation.validators.PathValidatorKt;
import com.android.tools.idea.ui.validation.validators.Rule;
import com.google.common.base.CharMatcher;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\"*\u0002\u0005\u000f\u001a;\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00a2\u0006\u0002\u0010\r\u001a;\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00a2\u0006\u0002\u0010\u0010\u001a\"\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\f2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t0\u0007\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0013\u001a\u00020\u0014X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u001b\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0011\u0010\u001e\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001d\"\u0011\u0010 \u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001d\"\u0011\u0010\"\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001d\"\u0011\u0010$\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u001d\"\u0011\u0010&\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u001d\"\u0011\u0010(\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u001d\"\u0011\u0010*\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u001d\"\u0011\u0010,\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u001d\"\u0011\u0010.\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u001d\"\u0011\u00100\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\u001d\"\u0011\u00102\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u001d\"\u0011\u00104\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u001d\"\u0011\u00106\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010\u001d\"\u0011\u00108\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010\u001d\u00a8\u0006:"}, d2={"logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "createSimpleRule", "com/android/tools/idea/ui/validation/validators/PathValidatorKt$createSimpleRule$1", "matches", "Lkotlin/Function1;", "Ljava/nio/file/Path;", "", "getMessage", "Lkotlin/Function2;", "", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;)Lcom/android/tools/idea/ui/validation/validators/PathValidatorKt$createSimpleRule$1;", "createRecursiveRule", "com/android/tools/idea/ui/validation/validators/PathValidatorKt$createRecursiveRule$1", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;)Lcom/android/tools/idea/ui/validation/validators/PathValidatorKt$createRecursiveRule$1;", "RESERVED_WINDOWS_FILENAMES", "", "WINDOWS_PATH_LENGTH_LIMIT", "", "ILLEGAL_CHARACTER_MATCHER", "Lcom/google/common/base/CharMatcher;", "filenameRule", "Lcom/android/tools/idea/ui/validation/validators/Rule;", "description", "filenameIsAllowed", "IS_EMPTY", "getIS_EMPTY", "()Lcom/android/tools/idea/ui/validation/validators/Rule;", "INVALID_SLASHES", "getINVALID_SLASHES", "LOCATION_IS_A_FILE", "getLOCATION_IS_A_FILE", "LOCATION_IS_NOT_A_FILE", "getLOCATION_IS_NOT_A_FILE", "LOCATION_IS_ROOT", "getLOCATION_IS_ROOT", "PARENT_IS_NOT_A_DIRECTORY", "getPARENT_IS_NOT_A_DIRECTORY", "PATH_NOT_WRITABLE", "getPATH_NOT_WRITABLE", "PATH_INSIDE_ANDROID_STUDIO", "getPATH_INSIDE_ANDROID_STUDIO", "NON_EMPTY_DIRECTORY", "getNON_EMPTY_DIRECTORY", "WINDOWS_PATH_TOO_LONG", "getWINDOWS_PATH_TOO_LONG", "WHITESPACE", "getWHITESPACE", "NON_ASCII_CHARS", "getNON_ASCII_CHARS", "PARENT_DIRECTORY_NOT_WRITABLE", "getPARENT_DIRECTORY_NOT_WRITABLE", "ILLEGAL_WINDOWS_FILENAME", "getILLEGAL_WINDOWS_FILENAME", "ILLEGAL_CHARACTER", "getILLEGAL_CHARACTER", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nPathValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathValidator.kt\ncom/android/tools/idea/ui/validation/validators/PathValidatorKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,316:1\n14#2:317\n1#3:318\n*S KotlinDebug\n*F\n+ 1 PathValidator.kt\ncom/android/tools/idea/ui/validation/validators/PathValidatorKt\n*L\n37#1:317\n*E\n"})
public final class PathValidatorKt {
    @NotNull
    private static final Set<String> RESERVED_WINDOWS_FILENAMES;
    private static final int WINDOWS_PATH_LENGTH_LIMIT = 240;
    @NotNull
    private static final CharMatcher ILLEGAL_CHARACTER_MATCHER;
    @NotNull
    private static final Rule IS_EMPTY;
    @NotNull
    private static final Rule INVALID_SLASHES;
    @NotNull
    private static final Rule LOCATION_IS_A_FILE;
    @NotNull
    private static final Rule LOCATION_IS_NOT_A_FILE;
    @NotNull
    private static final Rule LOCATION_IS_ROOT;
    @NotNull
    private static final Rule PARENT_IS_NOT_A_DIRECTORY;
    @NotNull
    private static final Rule PATH_NOT_WRITABLE;
    @NotNull
    private static final Rule PATH_INSIDE_ANDROID_STUDIO;
    @NotNull
    private static final Rule NON_EMPTY_DIRECTORY;
    @NotNull
    private static final Rule WINDOWS_PATH_TOO_LONG;
    @NotNull
    private static final Rule WHITESPACE;
    @NotNull
    private static final Rule NON_ASCII_CHARS;
    @NotNull
    private static final Rule PARENT_DIRECTORY_NOT_WRITABLE;
    @NotNull
    private static final Rule ILLEGAL_WINDOWS_FILENAME;
    @NotNull
    private static final Rule ILLEGAL_CHARACTER;

    private static final Logger getLogger() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PathValidator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    private static final createSimpleRule.1 createSimpleRule(Function1<? super Path, Boolean> matches, Function2<? super Path, ? super String, String> getMessage) {
        return new Rule(matches, getMessage){
            final /* synthetic */ Function1<Path, Boolean> $matches;
            final /* synthetic */ Function2<Path, String, String> $getMessage;
            {
                this.$matches = $matches;
                this.$getMessage = $getMessage;
            }

            public Path getMatchingFile(Path path) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Path path2 = path;
                Function1<Path, Boolean> function1 = this.$matches;
                Path it = path2;
                boolean bl = false;
                return (Boolean)function1.invoke((Object)path) != false ? path2 : null;
            }

            public String getMessage(Path path, String fieldName) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
                return (String)this.$getMessage.invoke((Object)path, (Object)fieldName);
            }
        };
    }

    private static final createRecursiveRule.1 createRecursiveRule(Function1<? super Path, Boolean> matches, Function2<? super Path, ? super String, String> getMessage) {
        return new Rule(matches, getMessage){
            final /* synthetic */ Function1<Path, Boolean> $matches;
            final /* synthetic */ Function2<Path, String, String> $getMessage;
            {
                this.$matches = $matches;
                this.$getMessage = $getMessage;
            }

            /*
             * WARNING - void declaration
             */
            public Path getMatchingFile(Path path) {
                Object v0;
                block1: {
                    void $this$firstOrNull$iv;
                    Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                    Sequence sequence = SequencesKt.generateSequence((Object)path, createRecursiveRule.1::getMatchingFile$lambda$0);
                    Function1<Path, Boolean> function1 = this.$matches;
                    boolean $i$f$firstOrNull = false;
                    for (E element$iv : $this$firstOrNull$iv) {
                        Path it = (Path)element$iv;
                        boolean bl = false;
                        if (!((Boolean)function1.invoke((Object)it)).booleanValue()) continue;
                        v0 = element$iv;
                        break block1;
                    }
                    v0 = null;
                }
                return v0;
            }

            public String getMessage(Path path, String fieldName) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
                return (String)this.$getMessage.invoke((Object)path, (Object)fieldName);
            }

            private static final Path getMatchingFile$lambda$0(Path it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getParent();
            }
        };
    }

    @NotNull
    public static final Rule filenameRule(@NotNull String description2, @NotNull Function1<? super String, Boolean> filenameIsAllowed) {
        Intrinsics.checkNotNullParameter((Object)description2, (String)"description");
        Intrinsics.checkNotNullParameter(filenameIsAllowed, (String)"filenameIsAllowed");
        return PathValidatorKt.createSimpleRule((Function1<? super Path, Boolean>)((Function1)arg_0 -> PathValidatorKt.filenameRule$lambda$0(filenameIsAllowed, arg_0)), (Function2<? super Path, ? super String, String>)((Function2)(arg_0, arg_1) -> PathValidatorKt.filenameRule$lambda$1(description2, arg_0, arg_1)));
    }

    @NotNull
    public static final Rule getIS_EMPTY() {
        return IS_EMPTY;
    }

    @NotNull
    public static final Rule getINVALID_SLASHES() {
        return INVALID_SLASHES;
    }

    @NotNull
    public static final Rule getLOCATION_IS_A_FILE() {
        return LOCATION_IS_A_FILE;
    }

    @NotNull
    public static final Rule getLOCATION_IS_NOT_A_FILE() {
        return LOCATION_IS_NOT_A_FILE;
    }

    @NotNull
    public static final Rule getLOCATION_IS_ROOT() {
        return LOCATION_IS_ROOT;
    }

    @NotNull
    public static final Rule getPARENT_IS_NOT_A_DIRECTORY() {
        return PARENT_IS_NOT_A_DIRECTORY;
    }

    @NotNull
    public static final Rule getPATH_NOT_WRITABLE() {
        return PATH_NOT_WRITABLE;
    }

    @NotNull
    public static final Rule getPATH_INSIDE_ANDROID_STUDIO() {
        return PATH_INSIDE_ANDROID_STUDIO;
    }

    @NotNull
    public static final Rule getNON_EMPTY_DIRECTORY() {
        return NON_EMPTY_DIRECTORY;
    }

    @NotNull
    public static final Rule getWINDOWS_PATH_TOO_LONG() {
        return WINDOWS_PATH_TOO_LONG;
    }

    @NotNull
    public static final Rule getWHITESPACE() {
        return WHITESPACE;
    }

    @NotNull
    public static final Rule getNON_ASCII_CHARS() {
        return NON_ASCII_CHARS;
    }

    @NotNull
    public static final Rule getPARENT_DIRECTORY_NOT_WRITABLE() {
        return PARENT_DIRECTORY_NOT_WRITABLE;
    }

    @NotNull
    public static final Rule getILLEGAL_WINDOWS_FILENAME() {
        return ILLEGAL_WINDOWS_FILENAME;
    }

    @NotNull
    public static final Rule getILLEGAL_CHARACTER() {
        return ILLEGAL_CHARACTER;
    }

    private static final boolean filenameRule$lambda$0(Function1 $filenameIsAllowed, Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Object object = path.getFileName();
        if (object == null || (object = object.toString()) == null) {
            object = "";
        }
        return (Boolean)$filenameIsAllowed.invoke(object) == false;
    }

    private static final String filenameRule$lambda$1(String $description, Path path, String fieldName) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        return "The " + fieldName + " specified " + $description + ".";
    }

    private static final boolean IS_EMPTY$lambda$0(Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path path2 = path.getFileName();
        CharSequence charSequence = path2 != null ? ((Object)path2).toString() : null;
        return charSequence == null || charSequence.length() == 0;
    }

    private static final String IS_EMPTY$lambda$1(Path path, String fieldName) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        return "Please specify a " + fieldName + ".";
    }

    private static final boolean INVALID_SLASHES$lambda$0(Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return File.separatorChar == '/' && StringsKt.contains$default((CharSequence)((Object)path).toString(), (CharSequence)"\\", (boolean)false, (int)2, null) || File.separatorChar == '\\' && StringsKt.contains$default((CharSequence)((Object)path).toString(), (CharSequence)"/", (boolean)false, (int)2, null);
    }

    private static final String INVALID_SLASHES$lambda$1(Path path, String fieldName) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        char incorrectSlash = File.separatorChar == '\\' ? (char)'/' : '\\';
        return "Your " + fieldName + " contains incorrect slashes ('" + incorrectSlash + "').";
    }

    private static final String LOCATION_IS_A_FILE$lambda$0(Path path, String fieldName) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        return "The " + fieldName + " specified already exists.";
    }

    private static final boolean LOCATION_IS_NOT_A_FILE$lambda$0(Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return !CancellableFileIo.isRegularFile((Path)path, (LinkOption[])new LinkOption[0]);
    }

    private static final String LOCATION_IS_NOT_A_FILE$lambda$1(Path path, String fieldName) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        return "The " + fieldName + " specified does not exist.";
    }

    private static final boolean LOCATION_IS_ROOT$lambda$0(Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return path.getParent() == null;
    }

    private static final String LOCATION_IS_ROOT$lambda$1(Path path, String fieldName) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        return "The " + fieldName + " cannot be at the filesystem root.";
    }

    private static final boolean PARENT_IS_NOT_A_DIRECTORY$lambda$0(Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path parent = path.getParent();
        return parent != null && CancellableFileIo.exists((Path)parent, (LinkOption[])new LinkOption[0]) && !CancellableFileIo.isDirectory((Path)parent, (LinkOption[])new LinkOption[0]);
    }

    private static final String PARENT_IS_NOT_A_DIRECTORY$lambda$1(Path path, String fieldName) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        return "The " + fieldName + "'s parent must be a directory, not a plain file.";
    }

    private static final boolean PATH_NOT_WRITABLE$lambda$0(Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return CancellableFileIo.exists((Path)path, (LinkOption[])new LinkOption[0]) && !CancellableFileIo.isWritable((Path)path);
    }

    private static final String PATH_NOT_WRITABLE$lambda$1(Path path, String string) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        return "The path '" + path + "' is not writable.";
    }

    private static final boolean PATH_INSIDE_ANDROID_STUDIO$lambda$0(Path path) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string = PathManager.getHomePathFor(Application.class);
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            bl = FileUtil.isAncestor((String)it, (String)((Object)path).toString(), (boolean)false);
        } else {
            bl = false;
        }
        return bl;
    }

    private static final String PATH_INSIDE_ANDROID_STUDIO$lambda$1(Path path, String fieldName) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        return "The " + fieldName + " is inside " + ApplicationNamesInfo.getInstance().getProductName() + "'s install location.";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean NON_EMPTY_DIRECTORY$lambda$0(Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (!CancellableFileIo.isDirectory((Path)path, (LinkOption[])new LinkOption[0])) return false;
        List list2 = CancellableFileIo.list((Path)path).toList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"toList(...)");
        if (((Collection)list2).isEmpty()) return false;
        return true;
    }

    private static final String NON_EMPTY_DIRECTORY$lambda$1(Path path, String fieldName) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        return "'" + path.getFileName() + "' already exists at the specified " + fieldName + " and it is not empty.";
    }

    private static final boolean WINDOWS_PATH_TOO_LONG$lambda$0(Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return ((Object)path.toAbsolutePath()).toString().length() > 240;
    }

    private static final String WINDOWS_PATH_TOO_LONG$lambda$1(Path path, String fieldName) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        return "The length of the " + fieldName + " exceeds the limit of 240 characters.";
    }

    private static final boolean WHITESPACE$lambda$0(Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        CharMatcher charMatcher = CharMatcher.whitespace();
        Object object = path.getFileName();
        if (object == null || (object = object.toString()) == null) {
            object = "";
        }
        return charMatcher.matchesAnyOf((CharSequence)object);
    }

    private static final String WHITESPACE$lambda$1(Path path, String fieldName) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        return fieldName + " should not contain whitespace, as this can cause problems with the NDK tools.";
    }

    private static final boolean NON_ASCII_CHARS$lambda$0(Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        CharMatcher charMatcher = CharMatcher.ascii();
        Object object = path.getFileName();
        if (object == null || (object = object.toString()) == null) {
            object = "";
        }
        return !charMatcher.matchesAllOf((CharSequence)object);
    }

    private static final String NON_ASCII_CHARS$lambda$1(Path path, String fieldName) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        return "Your " + fieldName + " contains non-ASCII characters.";
    }

    private static final boolean PARENT_DIRECTORY_NOT_WRITABLE$lambda$0(Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path parent = path.getParent();
        return CancellableFileIo.notExists((Path)path, (LinkOption[])new LinkOption[0]) && parent != null && CancellableFileIo.exists((Path)parent, (LinkOption[])new LinkOption[0]) && !CancellableFileIo.isWritable((Path)parent);
    }

    private static final String PARENT_DIRECTORY_NOT_WRITABLE$lambda$1(Path file, String string) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        return "The path '" + file.getParent() + "' is not writable. Please choose a new location.";
    }

    private static final boolean ILLEGAL_WINDOWS_FILENAME$lambda$0(Path path) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                object = path.getFileName();
                if (object == null || (object = object.toString()) == null) break block2;
                Object object2 = object;
                Locale locale = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                String string = ((String)object2).toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        return RESERVED_WINDOWS_FILENAMES.contains(object);
    }

    private static final String ILLEGAL_WINDOWS_FILENAME$lambda$1(Path path, String fieldName) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        return "Illegal (Windows) filename in " + fieldName + " path: " + path.getFileName() + ".";
    }

    private static final boolean ILLEGAL_CHARACTER$lambda$0(Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Object object = path.getFileName();
        if (object == null || (object = object.toString()) == null) {
            object = "";
        }
        return ILLEGAL_CHARACTER_MATCHER.matchesAnyOf((CharSequence)object);
    }

    private static final String ILLEGAL_CHARACTER$lambda$1(Path file, String fieldName) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        String name2 = ((Object)file.getFileName()).toString();
        char illegalChar = name2.charAt(ILLEGAL_CHARACTER_MATCHER.indexIn((CharSequence)name2));
        return "Illegal character in " + fieldName + " path: '" + illegalChar + "' in filename " + name2 + ".";
    }

    public static final /* synthetic */ Logger access$getLogger() {
        return PathValidatorKt.getLogger();
    }

    static {
        Object[] objectArray = new String[]{"con", "prn", "aux", "clock$", "nul", "com1", "com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9", "$mft", "$mftmirr", "$logfile", "$volume", "$attrdef", "$bitmap", "$boot", "$badclus", "$secure", "$upcase", "$extend", "$quota", "$objid", "$reparse"};
        RESERVED_WINDOWS_FILENAMES = SetsKt.setOf((Object[])objectArray);
        CharMatcher charMatcher = CharMatcher.anyOf((CharSequence)"[/\\?%*:|\"<>!;]");
        Intrinsics.checkNotNullExpressionValue((Object)charMatcher, (String)"anyOf(...)");
        ILLEGAL_CHARACTER_MATCHER = charMatcher;
        IS_EMPTY = PathValidatorKt.createSimpleRule((Function1<? super Path, Boolean>)((Function1)PathValidatorKt::IS_EMPTY$lambda$0), (Function2<? super Path, ? super String, String>)((Function2)PathValidatorKt::IS_EMPTY$lambda$1));
        INVALID_SLASHES = PathValidatorKt.createSimpleRule((Function1<? super Path, Boolean>)((Function1)PathValidatorKt::INVALID_SLASHES$lambda$0), (Function2<? super Path, ? super String, String>)((Function2)PathValidatorKt::INVALID_SLASHES$lambda$1));
        LOCATION_IS_A_FILE = PathValidatorKt.createSimpleRule((Function1<? super Path, Boolean>)((Function1)LOCATION_IS_A_FILE.1.INSTANCE), (Function2<? super Path, ? super String, String>)((Function2)PathValidatorKt::LOCATION_IS_A_FILE$lambda$0));
        LOCATION_IS_NOT_A_FILE = PathValidatorKt.createSimpleRule((Function1<? super Path, Boolean>)((Function1)PathValidatorKt::LOCATION_IS_NOT_A_FILE$lambda$0), (Function2<? super Path, ? super String, String>)((Function2)PathValidatorKt::LOCATION_IS_NOT_A_FILE$lambda$1));
        LOCATION_IS_ROOT = PathValidatorKt.createSimpleRule((Function1<? super Path, Boolean>)((Function1)PathValidatorKt::LOCATION_IS_ROOT$lambda$0), (Function2<? super Path, ? super String, String>)((Function2)PathValidatorKt::LOCATION_IS_ROOT$lambda$1));
        PARENT_IS_NOT_A_DIRECTORY = PathValidatorKt.createSimpleRule((Function1<? super Path, Boolean>)((Function1)PathValidatorKt::PARENT_IS_NOT_A_DIRECTORY$lambda$0), (Function2<? super Path, ? super String, String>)((Function2)PathValidatorKt::PARENT_IS_NOT_A_DIRECTORY$lambda$1));
        PATH_NOT_WRITABLE = PathValidatorKt.createSimpleRule((Function1<? super Path, Boolean>)((Function1)PathValidatorKt::PATH_NOT_WRITABLE$lambda$0), (Function2<? super Path, ? super String, String>)((Function2)PathValidatorKt::PATH_NOT_WRITABLE$lambda$1));
        PATH_INSIDE_ANDROID_STUDIO = PathValidatorKt.createSimpleRule((Function1<? super Path, Boolean>)((Function1)PathValidatorKt::PATH_INSIDE_ANDROID_STUDIO$lambda$0), (Function2<? super Path, ? super String, String>)((Function2)PathValidatorKt::PATH_INSIDE_ANDROID_STUDIO$lambda$1));
        NON_EMPTY_DIRECTORY = PathValidatorKt.createSimpleRule((Function1<? super Path, Boolean>)((Function1)PathValidatorKt::NON_EMPTY_DIRECTORY$lambda$0), (Function2<? super Path, ? super String, String>)((Function2)PathValidatorKt::NON_EMPTY_DIRECTORY$lambda$1));
        WINDOWS_PATH_TOO_LONG = PathValidatorKt.createSimpleRule((Function1<? super Path, Boolean>)((Function1)PathValidatorKt::WINDOWS_PATH_TOO_LONG$lambda$0), (Function2<? super Path, ? super String, String>)((Function2)PathValidatorKt::WINDOWS_PATH_TOO_LONG$lambda$1));
        WHITESPACE = PathValidatorKt.createRecursiveRule((Function1<? super Path, Boolean>)((Function1)PathValidatorKt::WHITESPACE$lambda$0), (Function2<? super Path, ? super String, String>)((Function2)PathValidatorKt::WHITESPACE$lambda$1));
        NON_ASCII_CHARS = PathValidatorKt.createRecursiveRule((Function1<? super Path, Boolean>)((Function1)PathValidatorKt::NON_ASCII_CHARS$lambda$0), (Function2<? super Path, ? super String, String>)((Function2)PathValidatorKt::NON_ASCII_CHARS$lambda$1));
        PARENT_DIRECTORY_NOT_WRITABLE = PathValidatorKt.createRecursiveRule((Function1<? super Path, Boolean>)((Function1)PathValidatorKt::PARENT_DIRECTORY_NOT_WRITABLE$lambda$0), (Function2<? super Path, ? super String, String>)((Function2)PathValidatorKt::PARENT_DIRECTORY_NOT_WRITABLE$lambda$1));
        ILLEGAL_WINDOWS_FILENAME = PathValidatorKt.createRecursiveRule((Function1<? super Path, Boolean>)((Function1)PathValidatorKt::ILLEGAL_WINDOWS_FILENAME$lambda$0), (Function2<? super Path, ? super String, String>)((Function2)PathValidatorKt::ILLEGAL_WINDOWS_FILENAME$lambda$1));
        ILLEGAL_CHARACTER = PathValidatorKt.createRecursiveRule((Function1<? super Path, Boolean>)((Function1)PathValidatorKt::ILLEGAL_CHARACTER$lambda$0), (Function2<? super Path, ? super String, String>)((Function2)PathValidatorKt::ILLEGAL_CHARACTER$lambda$1));
    }
}

