/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.screenshot;

import com.android.annotations.concurrency.UiThread;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.containers.DisposableWrapperList;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UiThread
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0006J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0006J\u0012\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0013\u001a\u00020\u0014*\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/ui/screenshot/DialogLocationArbiter;", "", "<init>", "()V", "shownDialogs", "Lcom/intellij/util/containers/DisposableWrapperList;", "Lcom/intellij/openapi/ui/DialogWrapper;", "suggestLocation", "Ljava/awt/Point;", "dialog", "dialogShown", "", "calculateSuggestedLocation", "size", "Ljava/awt/Dimension;", "calculateAdjustedLocation", "baseLocation", "graphicsConfiguration", "Ljava/awt/GraphicsConfiguration;", "adjustedBounds", "Ljava/awt/Rectangle;", "getAdjustedBounds", "(Ljava/awt/GraphicsConfiguration;)Ljava/awt/Rectangle;", "intellij.android.adb.ui"})
public final class DialogLocationArbiter {
    @NotNull
    private final DisposableWrapperList<DialogWrapper> shownDialogs = new DisposableWrapperList();

    @Nullable
    public final Point suggestLocation(@NotNull DialogWrapper dialog2) {
        Intrinsics.checkNotNullParameter((Object)dialog2, (String)"dialog");
        Dimension dimension2 = dialog2.getSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"getSize(...)");
        Point location = this.calculateSuggestedLocation(dimension2);
        this.shownDialogs.add((Object)dialog2, dialog2.getDisposable());
        return location;
    }

    public final void dialogShown(@NotNull DialogWrapper dialog2) {
        Intrinsics.checkNotNullParameter((Object)dialog2, (String)"dialog");
        if (!this.shownDialogs.contains((Object)dialog2)) {
            this.shownDialogs.add((Object)dialog2, dialog2.getDisposable());
        }
    }

    private final Point calculateSuggestedLocation(Dimension size) {
        if (this.shownDialogs.isEmpty()) {
            return null;
        }
        Point location = null;
        ArrayList sortedDialogs = new ArrayList((Collection)this.shownDialogs);
        Object object = new Comparator(){

            public final int compare(T a, T b) {
                DialogWrapper it = (DialogWrapper)a;
                boolean bl = false;
                it = (DialogWrapper)b;
                Comparable comparable = Integer.valueOf(it.getLocation().y);
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(it.getLocation().y));
            }
        };
        CollectionsKt.sortWith((List)sortedDialogs, (Comparator)new Comparator((Comparator)object){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    DialogWrapper it = (DialogWrapper)a;
                    boolean bl = false;
                    it = (DialogWrapper)b;
                    Comparable comparable = Integer.valueOf(it.getLocation().x);
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(it.getLocation().x));
                }
                return n;
            }
        });
        Iterator iterator2 = sortedDialogs.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        object = iterator2;
        while (object.hasNext()) {
            DialogWrapper dialog2 = (DialogWrapper)object.next();
            if (location != null && !Intrinsics.areEqual(location, (Object)dialog2.getLocation())) continue;
            Point point = dialog2.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getLocation(...)");
            GraphicsConfiguration graphicsConfiguration = dialog2.getWindow().getGraphicsConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)graphicsConfiguration, (String)"getGraphicsConfiguration(...)");
            location = this.calculateAdjustedLocation(point, size, graphicsConfiguration);
        }
        return location;
    }

    @NotNull
    public final Point calculateAdjustedLocation(@NotNull Point baseLocation, @NotNull Dimension size, @NotNull GraphicsConfiguration graphicsConfiguration) {
        Intrinsics.checkNotNullParameter((Object)baseLocation, (String)"baseLocation");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Intrinsics.checkNotNullParameter((Object)graphicsConfiguration, (String)"graphicsConfiguration");
        Rectangle bounds = this.getAdjustedBounds(graphicsConfiguration);
        int offset = JBUIScale.scale((int)40);
        return new Point(RangesKt.coerceIn((int)(baseLocation.x + offset), (int)bounds.x, (int)(bounds.x + bounds.width - size.width)), RangesKt.coerceIn((int)(baseLocation.y + offset), (int)bounds.y, (int)(bounds.y + bounds.height - size.height)));
    }

    private final Rectangle getAdjustedBounds(GraphicsConfiguration $this$adjustedBounds) {
        Rectangle bounds = $this$adjustedBounds.getBounds();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets($this$adjustedBounds);
        bounds.x += insets.left;
        bounds.y += insets.top;
        bounds.width -= insets.left + insets.right;
        bounds.height -= insets.top + insets.bottom;
        Intrinsics.checkNotNull((Object)bounds);
        return bounds;
    }
}

