/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.screenshot;

import com.android.annotations.concurrency.Slow;
import com.android.tools.adtui.ImageUtils;
import com.android.tools.adtui.device.DeviceArtDescriptor;
import com.android.tools.adtui.device.DeviceArtPainter;
import com.android.tools.adtui.device.SkinDefinition;
import com.android.tools.adtui.device.SkinDefinitionCache;
import com.android.tools.idea.ui.screenshot.DeviceFramingOption;
import com.android.tools.idea.ui.screenshot.FramingOption;
import com.android.tools.idea.ui.screenshot.ScreenshotDecorator;
import com.android.tools.idea.ui.screenshot.ScreenshotImage;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0017J\u0018\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0016\u001a\u00020\u00062\b\u0010\u0019\u001a\u0004\u0018\u00010\bH\u0002J\u001c\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00060\u00072\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J\u0018\u0010\u001b\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R&\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00060\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/ui/screenshot/DeviceScreenshotDecorator;", "Lcom/android/tools/idea/ui/screenshot/ScreenshotDecorator;", "<init>", "()V", "skinSubfolderInfo", "", "Ljava/nio/file/Path;", "", "Ljava/awt/Dimension;", "decorate", "Ljava/awt/image/BufferedImage;", "screenshotImage", "Lcom/android/tools/idea/ui/screenshot/ScreenshotImage;", "framingOption", "Lcom/android/tools/idea/ui/screenshot/FramingOption;", "backgroundColor", "Ljava/awt/Color;", "canClipToDisplayShape", "", "getCanClipToDisplayShape", "()Z", "addSkinBasedFrame", "skinFolder", "getSkinDefinition", "Lcom/android/tools/adtui/device/SkinDefinition;", "displaySize", "getSubfolderSkinInfo", "addDeviceArtBasedFrame", "frameDescriptor", "Lcom/android/tools/adtui/device/DeviceArtDescriptor;", "intellij.android.adb.ui"})
@SourceDebugExtension(value={"SMAP\nDeviceScreenshotDecorator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceScreenshotDecorator.kt\ncom/android/tools/idea/ui/screenshot/DeviceScreenshotDecorator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n1#2:94\n*E\n"})
public final class DeviceScreenshotDecorator
implements ScreenshotDecorator {
    @NotNull
    private final Map<Path, Map<Dimension, Path>> skinSubfolderInfo = new LinkedHashMap();

    @Override
    @Slow
    @NotNull
    public BufferedImage decorate(@NotNull ScreenshotImage screenshotImage, @Nullable FramingOption framingOption, @Nullable Color backgroundColor) {
        Intrinsics.checkNotNullParameter((Object)screenshotImage, (String)"screenshotImage");
        if (framingOption == null) {
            BufferedImage bufferedImage;
            if (screenshotImage.isRoundDisplay()) {
                BufferedImage bufferedImage2 = ImageUtils.ellipticalClip((BufferedImage)screenshotImage.getImage(), (Color)backgroundColor);
                bufferedImage = bufferedImage2;
                Intrinsics.checkNotNullExpressionValue((Object)bufferedImage2, (String)"ellipticalClip(...)");
            } else {
                bufferedImage = screenshotImage.getImage();
            }
            return bufferedImage;
        }
        DeviceFramingOption cfr_ignored_0 = (DeviceFramingOption)framingOption;
        Path skinFolder = ((DeviceFramingOption)framingOption).getSkinFolder();
        return skinFolder != null ? this.addSkinBasedFrame(screenshotImage, skinFolder) : (((DeviceFramingOption)framingOption).getDeviceArtDescriptor() != null ? this.addDeviceArtBasedFrame(screenshotImage, ((DeviceFramingOption)framingOption).getDeviceArtDescriptor()) : screenshotImage.getImage());
    }

    @Override
    public boolean getCanClipToDisplayShape() {
        return false;
    }

    private final BufferedImage addSkinBasedFrame(ScreenshotImage screenshotImage, Path skinFolder) {
        SkinDefinition skinDefinition = this.getSkinDefinition(skinFolder, screenshotImage.getDisplaySize());
        if (skinDefinition == null) {
            return screenshotImage.getImage();
        }
        SkinDefinition skinDefinition2 = skinDefinition;
        return screenshotImage.decorate(true, skinDefinition2, null);
    }

    private final SkinDefinition getSkinDefinition(Path skinFolder, Dimension displaySize) {
        SkinDefinition skinDefinition;
        SkinDefinition skinDefinition2;
        if (Files.exists(skinFolder.resolve("layout"), new LinkOption[0]) && ((skinDefinition2 = SkinDefinitionCache.Companion.getInstance().getSkinDefinition(skinFolder)) != null || displaySize == null)) {
            return skinDefinition2;
        }
        Map map2 = this.skinSubfolderInfo.computeIfAbsent(skinFolder, arg_0 -> DeviceScreenshotDecorator.getSkinDefinition$lambda$1(arg_0 -> DeviceScreenshotDecorator.getSkinDefinition$lambda$0(this, skinFolder, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"computeIfAbsent(...)");
        Map subfolderInfo = map2;
        Path path = (Path)subfolderInfo.get(displaySize);
        if (path != null) {
            Path it = path;
            boolean bl = false;
            skinDefinition = SkinDefinitionCache.Companion.getInstance().getSkinDefinition(it);
        } else {
            skinDefinition = null;
        }
        return skinDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<Dimension, Path> getSubfolderSkinInfo(Path skinFolder) {
        Map map2 = new LinkedHashMap();
        AutoCloseable autoCloseable = Files.list(skinFolder);
        Throwable throwable = null;
        try {
            Stream stream = (Stream)autoCloseable;
            boolean bl = false;
            stream.filter(arg_0 -> DeviceScreenshotDecorator.getSubfolderSkinInfo$lambda$0$1(DeviceScreenshotDecorator::getSubfolderSkinInfo$lambda$0$0, arg_0)).forEach(arg_0 -> DeviceScreenshotDecorator.getSubfolderSkinInfo$lambda$0$3(arg_0 -> DeviceScreenshotDecorator.getSubfolderSkinInfo$lambda$0$2(map2, arg_0), arg_0));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return map2;
    }

    private final BufferedImage addDeviceArtBasedFrame(ScreenshotImage screenshotImage, DeviceArtDescriptor frameDescriptor) {
        BufferedImage bufferedImage = DeviceArtPainter.createFrame((BufferedImage)screenshotImage.getImage(), (DeviceArtDescriptor)frameDescriptor);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"createFrame(...)");
        BufferedImage framedImage = bufferedImage;
        BufferedImage bufferedImage2 = ImageUtils.cropBlank((BufferedImage)framedImage, null);
        if (bufferedImage2 == null) {
            throw new IllegalArgumentException("The screenshot is completely transparent");
        }
        return bufferedImage2;
    }

    private static final Map getSkinDefinition$lambda$0(DeviceScreenshotDecorator this$0, Path $skinFolder, Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.getSubfolderSkinInfo($skinFolder);
    }

    private static final Map getSkinDefinition$lambda$1(Function1 $tmp0, Object p0) {
        return (Map)$tmp0.invoke(p0);
    }

    private static final boolean getSubfolderSkinInfo$lambda$0$0(Path it) {
        return Files.isDirectory(it, new LinkOption[0]);
    }

    private static final boolean getSubfolderSkinInfo$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit getSubfolderSkinInfo$lambda$0$2(Map $map, Path dir) {
        try {
            Intrinsics.checkNotNull((Object)dir);
            Dimension displaySize = SkinDefinition.Companion.getSkinDisplaySize(dir);
            $map.put(displaySize, dir);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Unit.INSTANCE;
    }

    private static final void getSubfolderSkinInfo$lambda$0$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

