/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.save;

import com.android.tools.idea.ui.AndroidAdbUiBundle;
import com.android.tools.idea.ui.save.PostSaveAction;
import com.android.tools.idea.ui.save.SaveConfiguration;
import com.android.tools.idea.ui.save.SaveConfigurationPanelKt;
import com.android.tools.idea.ui.save.SaveConfigurationResolver;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.ui.TextAccessor;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ComboBoxKt;
import com.intellij.ui.dsl.builder.HyperlinkEventAction;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.ui.dsl.builder.TextFieldWithBrowseButtonKt;
import com.intellij.ui.layout.ValidationInfoBuilder;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u00020\u0005H\u0002J\u0018\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005H\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001b\u001a\u00020\u0005H\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\u00052\u0006\u0010\"\u001a\u00020\u0005H\u0002J\u0014\u0010#\u001a\u00020$*\u00020\u00152\u0006\u0010%\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/android/tools/idea/ui/save/SaveConfigurationPanel;", "", "saveConfig", "Lcom/android/tools/idea/ui/save/SaveConfiguration;", "fileExtension", "", "timestamp", "Ljava/time/Instant;", "sequentialNumber", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/android/tools/idea/ui/save/SaveConfiguration;Ljava/lang/String;Ljava/time/Instant;ILcom/intellij/openapi/project/Project;)V", "saveConfigResolver", "Lcom/android/tools/idea/ui/save/SaveConfigurationResolver;", "preview", "Ljavax/swing/JEditorPane;", "saveLocationField", "Lcom/intellij/ui/TextAccessor;", "filenameTemplateField", "Ljavax/swing/JTextField;", "hyperlinkAction", "Lcom/intellij/ui/dsl/builder/HyperlinkEventAction;", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "generatePreview", "saveLocation", "filenameTemplate", "normalizeFilename", "filename", "checkSaveLocation", "checkFilenameTemplate", "checkPath", "path", "insertText", "", "textToInsert", "intellij.android.adb.ui"})
@SourceDebugExtension(value={"SMAP\nSaveConfigurationPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SaveConfigurationPanel.kt\ncom/android/tools/idea/ui/save/SaveConfigurationPanel\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,184:1\n30#2,2:185\n1#3:187\n774#4:188\n865#4,2:189\n*S KotlinDebug\n*F\n+ 1 SaveConfigurationPanel.kt\ncom/android/tools/idea/ui/save/SaveConfigurationPanel\n*L\n53#1:185,2\n119#1:188\n119#1:189,2\n*E\n"})
public final class SaveConfigurationPanel {
    @NotNull
    private final SaveConfiguration saveConfig;
    @NotNull
    private final String fileExtension;
    @NotNull
    private final Instant timestamp;
    private final int sequentialNumber;
    @NotNull
    private final SaveConfigurationResolver saveConfigResolver;
    private JEditorPane preview;
    private TextAccessor saveLocationField;
    private JTextField filenameTemplateField;
    @NotNull
    private final HyperlinkEventAction hyperlinkAction;

    public SaveConfigurationPanel(@NotNull SaveConfiguration saveConfig, @NotNull String fileExtension, @NotNull Instant timestamp, int sequentialNumber, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)saveConfig, (String)"saveConfig");
        Intrinsics.checkNotNullParameter((Object)fileExtension, (String)"fileExtension");
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.saveConfig = saveConfig;
        this.fileExtension = fileExtension;
        this.timestamp = timestamp;
        this.sequentialNumber = sequentialNumber;
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<SaveConfigurationResolver> serviceClass$iv = SaveConfigurationResolver.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.saveConfigResolver = (SaveConfigurationResolver)object;
        this.hyperlinkAction = arg_0 -> SaveConfigurationPanel.hyperlinkAction$lambda$0(this, arg_0);
    }

    @NotNull
    public final DialogPanel createPanel() {
        return BuilderKt.panel(arg_0 -> SaveConfigurationPanel.createPanel$lambda$0(this, arg_0));
    }

    private final String generatePreview() {
        TextAccessor textAccessor = this.saveLocationField;
        if (textAccessor == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"saveLocationField");
            textAccessor = null;
        }
        String string = textAccessor.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        JTextField jTextField = this.filenameTemplateField;
        if (jTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"filenameTemplateField");
            jTextField = null;
        }
        String string2 = jTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        return this.generatePreview(string, string2);
    }

    private final String generatePreview(String saveLocation, String filenameTemplate) {
        return this.saveConfigResolver.expandFilenamePattern(((Object)StringsKt.trim((CharSequence)saveLocation)).toString(), this.normalizeFilename(filenameTemplate), this.fileExtension, this.timestamp, this.sequentialNumber);
    }

    private final String normalizeFilename(String filename) {
        String string;
        String trimmed = StringsKt.replace$default((String)((Object)StringsKt.trim((CharSequence)filename)).toString(), (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null);
        if (StringsKt.equals((String)FileUtilRt.getExtension((String)trimmed), (String)this.fileExtension, (boolean)true)) {
            String string2 = FileUtilRt.getNameWithoutExtension((String)trimmed);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getNameWithoutExtension(...)");
        } else {
            string = trimmed;
        }
        return string;
    }

    private final String checkSaveLocation(String saveLocation) {
        String string;
        String string2 = this.checkPath(StringsKt.replace$default((String)((Object)StringsKt.trim((CharSequence)saveLocation)).toString(), (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null));
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            Object[] objectArray = new Object[]{it};
            string = AndroidAdbUiBundle.message("configure.screenshot.dialog.error.invalid.directory", objectArray);
        } else {
            string = null;
        }
        return string;
    }

    private final String checkFilenameTemplate(String filenameTemplate) {
        String string;
        String filename = this.normalizeFilename(filenameTemplate);
        if (((CharSequence)filename).length() == 0) {
            string = AndroidAdbUiBundle.message("configure.screenshot.dialog.error.empty.filename", new Object[0]);
        } else {
            String string2 = File.separator;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"separator");
            if (StringsKt.startsWith$default((String)filename, (String)string2, (boolean)false, (int)2, null)) {
                string = AndroidAdbUiBundle.message("configure.screenshot.dialog.error.leading.separator", new Object[0]);
            } else {
                String string3 = File.separator;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"separator");
                if (StringsKt.endsWith$default((String)filename, (String)string3, (boolean)false, (int)2, null)) {
                    string = AndroidAdbUiBundle.message("configure.screenshot.dialog.error.trailing.separator", new Object[0]);
                } else if (StringsKt.contains$default((CharSequence)filename, (CharSequence)"..", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)filename, (CharSequence)":", (boolean)false, (int)2, null)) {
                    string = AndroidAdbUiBundle.message("configure.screenshot.dialog.error.invalid.filename.generic", new Object[0]);
                } else {
                    String string4 = this.checkPath(this.generatePreview(this.saveConfig.getSaveLocation(), filename));
                    if (string4 != null) {
                        String it = string4;
                        boolean bl = false;
                        Object[] objectArray = new Object[]{it};
                        string = AndroidAdbUiBundle.message("configure.screenshot.dialog.error.invalid.filename", objectArray);
                    } else {
                        string = null;
                    }
                }
            }
        }
        return string;
    }

    private final String checkPath(String path) {
        try {
            Paths.get(path, new String[0]);
            return null;
        }
        catch (InvalidPathException e) {
            return e.getReason();
        }
    }

    private final void insertText(JTextField $this$insertText, String textToInsert) {
        int selectionStart = $this$insertText.getSelectionStart();
        String string = $this$insertText.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = string;
        int n = $this$insertText.getSelectionEnd();
        $this$insertText.setText(((Object)StringsKt.replaceRange((CharSequence)string2, (int)selectionStart, (int)n, (CharSequence)textToInsert)).toString());
        $this$insertText.setCaretPosition(selectionStart + textToInsert.length());
    }

    private static final void hyperlinkAction$lambda$0(SaveConfigurationPanel this$0, HyperlinkEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (Intrinsics.areEqual((Object)event.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
            JTextField jTextField = this$0.filenameTemplateField;
            if (jTextField == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"filenameTemplateField");
                jTextField = null;
            }
            String string = Intrinsics.areEqual((Object)event.getDescription(), (Object)"%Nd") ? "%3d" : event.getDescription();
            Intrinsics.checkNotNull((Object)string);
            this$0.insertText(jTextField, string);
        }
    }

    private static final Unit createPanel$lambda$0(SaveConfigurationPanel this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        $this$panel.row(AndroidAdbUiBundle.message("configure.screenshot.dialog.save.location", new Object[0]), arg_0 -> SaveConfigurationPanel.createPanel$lambda$0$0(this$0, arg_0));
        $this$panel.row(AndroidAdbUiBundle.message("configure.screenshot.dialog.filename", new Object[0]), arg_0 -> SaveConfigurationPanel.createPanel$lambda$0$1(this$0, arg_0));
        $this$panel.row(AndroidAdbUiBundle.message("configure.screenshot.dialog.preview", new Object[0]), arg_0 -> SaveConfigurationPanel.createPanel$lambda$0$2(this$0, arg_0));
        $this$panel.row("", SaveConfigurationPanel::createPanel$lambda$0$3);
        $this$panel.row("", arg_0 -> SaveConfigurationPanel.createPanel$lambda$0$4(this$0, arg_0));
        $this$panel.row("After Saving:", arg_0 -> SaveConfigurationPanel.createPanel$lambda$0$5(this$0, arg_0));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createPanel$lambda$0$0(SaveConfigurationPanel this$0, Row $this$row) {
        void it;
        FileChooserDescriptor fileChooserDescriptor;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        FileChooserDescriptor fileChooserDescriptor2 = fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        Row row = $this$row;
        boolean bl = false;
        it.putUserData(PathChooserDialog.PREFER_LAST_OVER_EXPLICIT, (Object)false);
        FileChooserDescriptor fileChooserDescriptor3 = fileChooserDescriptor;
        Intrinsics.checkNotNullExpressionValue((Object)fileChooserDescriptor3, (String)"also(...)");
        TextFieldWithBrowseButtonKt.bindText((Cell)TextFieldWithBrowseButtonKt.columns((Cell)Row.textFieldWithBrowseButton$default((Row)row, (FileChooserDescriptor)fileChooserDescriptor3, null, null, (int)6, null), (int)36), () -> SaveConfigurationPanel.createPanel$lambda$0$0$1(this$0), arg_0 -> SaveConfigurationPanel.createPanel$lambda$0$0$2(this$0, arg_0)).validationOnInput((arg_0, arg_1) -> SaveConfigurationPanel.createPanel$lambda$0$0$3(this$0, arg_0, arg_1)).onChanged(arg_0 -> SaveConfigurationPanel.createPanel$lambda$0$0$4(this$0, arg_0)).applyToComponent(arg_0 -> SaveConfigurationPanel.createPanel$lambda$0$0$5(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final String createPanel$lambda$0$0$1(SaveConfigurationPanel this$0) {
        return this$0.saveConfigResolver.expandSaveLocation(this$0.saveConfig.getSaveLocation());
    }

    private static final Unit createPanel$lambda$0$0$2(SaveConfigurationPanel this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (this$0.checkSaveLocation(it) == null) {
            this$0.saveConfig.setSaveLocation(this$0.saveConfigResolver.generalizeSaveLocation(((Object)StringsKt.trim((CharSequence)it)).toString()));
        }
        return Unit.INSTANCE;
    }

    private static final ValidationInfo createPanel$lambda$0$0$3(SaveConfigurationPanel this$0, ValidationInfoBuilder $this$validationOnInput, TextFieldWithBrowseButton it) {
        ValidationInfo validationInfo;
        Intrinsics.checkNotNullParameter((Object)$this$validationOnInput, (String)"$this$validationOnInput");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = this$0.checkSaveLocation(string);
        if (string2 != null) {
            String msg = string2;
            boolean bl = false;
            validationInfo = new ValidationInfo(msg, (JComponent)it);
        } else {
            validationInfo = null;
        }
        return validationInfo;
    }

    private static final Unit createPanel$lambda$0$0$4(SaveConfigurationPanel this$0, TextFieldWithBrowseButton it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        JEditorPane jEditorPane = this$0.preview;
        if (jEditorPane == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preview");
            jEditorPane = null;
        }
        jEditorPane.setText(this$0.generatePreview());
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$0$5(SaveConfigurationPanel this$0, TextFieldWithBrowseButton $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        this$0.saveLocationField = (TextAccessor)$this$applyToComponent;
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$1(SaveConfigurationPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        TextFieldKt.columns((Cell)TextFieldKt.bindText((Cell)$this$row.textField(), () -> SaveConfigurationPanel.createPanel$lambda$0$1$0(this$0), arg_0 -> SaveConfigurationPanel.createPanel$lambda$0$1$1(this$0, arg_0)), (int)36).validationOnInput((arg_0, arg_1) -> SaveConfigurationPanel.createPanel$lambda$0$1$2(this$0, arg_0, arg_1)).onChanged(arg_0 -> SaveConfigurationPanel.createPanel$lambda$0$1$3(this$0, arg_0)).applyToComponent(arg_0 -> SaveConfigurationPanel.createPanel$lambda$0$1$4(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final String createPanel$lambda$0$1$0(SaveConfigurationPanel this$0) {
        return StringsKt.replace$default((String)this$0.saveConfig.getFilenameTemplate(), (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null);
    }

    private static final Unit createPanel$lambda$0$1$1(SaveConfigurationPanel this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (this$0.checkFilenameTemplate(it) == null) {
            this$0.saveConfig.setFilenameTemplate(StringsKt.replace$default((String)((Object)StringsKt.trim((CharSequence)it)).toString(), (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null));
        }
        return Unit.INSTANCE;
    }

    private static final ValidationInfo createPanel$lambda$0$1$2(SaveConfigurationPanel this$0, ValidationInfoBuilder $this$validationOnInput, JBTextField it) {
        ValidationInfo validationInfo;
        Intrinsics.checkNotNullParameter((Object)$this$validationOnInput, (String)"$this$validationOnInput");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = this$0.checkFilenameTemplate(string);
        if (string2 != null) {
            String msg = string2;
            boolean bl = false;
            validationInfo = new ValidationInfo(msg, (JComponent)it);
        } else {
            validationInfo = null;
        }
        return validationInfo;
    }

    private static final Unit createPanel$lambda$0$1$3(SaveConfigurationPanel this$0, JBTextField it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        JEditorPane jEditorPane = this$0.preview;
        if (jEditorPane == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preview");
            jEditorPane = null;
        }
        jEditorPane.setText(this$0.generatePreview());
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$1$4(SaveConfigurationPanel this$0, JBTextField $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        this$0.filenameTemplateField = (JTextField)$this$applyToComponent;
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$2(SaveConfigurationPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Row.text$default((Row)$this$row, (String)this$0.generatePreview(), (int)0, null, (int)6, null).applyToComponent(arg_0 -> SaveConfigurationPanel.createPanel$lambda$0$2$0(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$2$0(SaveConfigurationPanel this$0, JEditorPane $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        this$0.preview = $this$applyToComponent;
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$3(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Row.text$default((Row)$this$row, (String)AndroidAdbUiBundle.message("configure.screenshot.dialog.placeholders.description", new Object[0]), (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$4(SaveConfigurationPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.panel(arg_0 -> SaveConfigurationPanel.createPanel$lambda$0$4$0(this$0, arg_0));
        $this$row.panel(arg_0 -> SaveConfigurationPanel.createPanel$lambda$0$4$1(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$4$0(SaveConfigurationPanel this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> SaveConfigurationPanel.createPanel$lambda$0$4$0$0(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$4$0$0(SaveConfigurationPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Row.text$default((Row)$this$row, (String)(SaveConfigurationPanelKt.access$toPaddedHtmlLink("<yyyy>", 10) + " " + AndroidAdbUiBundle.message("configure.screenshot.dialog.year.4.digits", new Object[0]) + "<br>" + SaveConfigurationPanelKt.access$toPaddedHtmlLink("<yy>", 10) + " " + AndroidAdbUiBundle.message("configure.screenshot.dialog.year.2.digits", new Object[0]) + "<br>" + SaveConfigurationPanelKt.access$toPaddedHtmlLink("<MM>", 10) + " " + AndroidAdbUiBundle.message("configure.screenshot.dialog.month", new Object[0]) + "<br>" + SaveConfigurationPanelKt.access$toPaddedHtmlLink("<dd>", 10) + " " + AndroidAdbUiBundle.message("configure.screenshot.dialog.day", new Object[0]) + "<br>" + SaveConfigurationPanelKt.access$toPaddedHtmlLink("<HH>", 10) + " " + AndroidAdbUiBundle.message("configure.screenshot.dialog.hour", new Object[0]) + "<br>" + SaveConfigurationPanelKt.access$toPaddedHtmlLink("<mm>", 10) + " " + AndroidAdbUiBundle.message("configure.screenshot.dialog.minute", new Object[0]) + "<br>" + SaveConfigurationPanelKt.access$toPaddedHtmlLink("<ss>", 10) + " " + AndroidAdbUiBundle.message("configure.screenshot.dialog.second", new Object[0])), (int)0, (HyperlinkEventAction)this$0.hyperlinkAction, (int)2, null).widthGroup("columns").align((Align)AlignX.LEFT.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$4$1(SaveConfigurationPanel this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> SaveConfigurationPanel.createPanel$lambda$0$4$1$0(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$4$1$0(SaveConfigurationPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = SaveConfigurationPanelKt.access$toPaddedHtmlLink("<zzz>", 10);
        String string2 = AndroidAdbUiBundle.message("configure.screenshot.dialog.millisecond", new Object[0]);
        String string3 = SaveConfigurationPanelKt.access$toPaddedHtmlLink("<#>", 10);
        String string4 = AndroidAdbUiBundle.message("configure.screenshot.dialog.number.line1", new Object[0]);
        String string5 = SaveConfigurationPanelKt.access$toPaddedHtmlLink("", 10);
        String string6 = AndroidAdbUiBundle.message("configure.screenshot.dialog.number.line2", new Object[0]);
        String string7 = SaveConfigurationPanelKt.access$toPaddedHtmlLink("<project>", 10);
        String string8 = AndroidAdbUiBundle.message("configure.screenshot.dialog.project.name", new Object[0]);
        String string9 = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"separator");
        Row.text$default((Row)$this$row, (String)(string + " " + string2 + "<br>" + string3 + " " + string4 + "<br>" + string5 + " " + string6 + "<br>" + string7 + " " + string8 + "<br>" + SaveConfigurationPanelKt.access$toPaddedHtmlLink(string9, 10) + " " + AndroidAdbUiBundle.message("configure.screenshot.dialog.directory.separator", new Object[0])), (int)0, (HyperlinkEventAction)this$0.hyperlinkAction, (int)2, null).widthGroup("columns").align((Align)AlignX.LEFT.INSTANCE);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createPanel$lambda$0$5(SaveConfigurationPanel this$0, Row $this$row) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Iterable iterable = (Iterable)PostSaveAction.getEntries();
        Row row = $this$row;
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PostSaveAction p0 = (PostSaveAction)((Object)element$iv$iv);
            boolean bl = false;
            if (!p0.isSupported()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        ComboBoxKt.bindItem((Cell)Row.comboBox$default((Row)row, (Collection)((List)destination$iv$iv), null, (int)2, null), (Function0)((Function0)new MutablePropertyReference0Impl(this$0.saveConfig){

            public Object get() {
                return ((SaveConfiguration)this.receiver).getPostSaveAction();
            }

            public void set(Object value2) {
                ((SaveConfiguration)this.receiver).setPostSaveAction((PostSaveAction)((Object)value2));
            }
        }), arg_0 -> SaveConfigurationPanel.createPanel$lambda$0$5$0(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$5$0(SaveConfigurationPanel this$0, PostSaveAction it) {
        SaveConfiguration saveConfiguration = this$0.saveConfig;
        PostSaveAction postSaveAction = it;
        Intrinsics.checkNotNull((Object)((Object)postSaveAction));
        saveConfiguration.setPostSaveAction(postSaveAction);
        return Unit.INSTANCE;
    }
}

