/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.rendering;

import com.android.tools.idea.ui.resourcemanager.model.Asset;
import com.android.tools.idea.ui.resourcemanager.model.AssetKey;
import com.android.tools.idea.ui.resourcemanager.rendering.CachedImage;
import com.android.tools.idea.ui.resourcemanager.rendering.ImageCacheKt;
import com.google.common.cache.Cache;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Async;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 $2\u00020\u0001:\u0001$B'\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\f2\b\b\u0002\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u0016H\u0003J\b\u0010\u0017\u001a\u00020\u0011H\u0016J\u000e\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\fJ\u0006\u0010\u0018\u001a\u00020\u0011J\u0006\u0010\u0019\u001a\u00020\u001aJR\u0010\u001b\u001a\u00020\u001c2\b\b\u0001\u0010\u0012\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u00142\u000e\b\u0002\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00162\b\b\u0002\u0010 \u001a\u00020!2\u0016\u0010\"\u001a\u0012\u0012\u000e\u0012\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u001c0\r0\u0016J@\u0010#\u001a\u00020\u00112\u0016\u0010\"\u001a\u0012\u0012\u000e\u0012\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u001c0\r0\u00162\b\b\u0001\u0010\u0012\u001a\u00020\f2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00162\u0006\u0010 \u001a\u00020!H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\n\u001a*\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\r0\u000bj\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/rendering/ImageCache;", "Lcom/intellij/openapi/Disposable;", "mergingUpdateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "objectToImage", "Lcom/google/common/cache/Cache;", "Lcom/android/tools/idea/ui/resourcemanager/model/AssetKey;", "Lcom/android/tools/idea/ui/resourcemanager/rendering/CachedImage;", "<init>", "(Lcom/intellij/util/ui/update/MergingUpdateQueue;Lcom/google/common/cache/Cache;)V", "pendingFutures", "Ljava/util/HashMap;", "Lcom/android/tools/idea/ui/resourcemanager/model/Asset;", "Ljava/util/concurrent/CompletableFuture;", "Lkotlin/collections/HashMap;", "updateQueue", "runOrQueue", "", "asset", "executeImmediately", "", "runnable", "Lkotlin/Function0;", "dispose", "clear", "size", "", "computeAndGet", "Ljava/awt/image/BufferedImage;", "placeholder", "forceComputation", "onImageCached", "executor", "Ljava/util/concurrent/Executor;", "computationFutureProvider", "startComputation", "Companion", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nImageCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageCache.kt\ncom/android/tools/idea/ui/resourcemanager/rendering/ImageCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,167:1\n1869#2,2:168\n*S KotlinDebug\n*F\n+ 1 ImageCache.kt\ncom/android/tools/idea/ui/resourcemanager/rendering/ImageCache\n*L\n91#1:168,2\n*E\n"})
public final class ImageCache
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Cache<AssetKey, CachedImage> objectToImage;
    @NotNull
    private final HashMap<Asset, CompletableFuture<?>> pendingFutures;
    @NotNull
    private final MergingUpdateQueue updateQueue;
    @NotNull
    private static final Lazy<Cache<AssetKey, CachedImage>> objectToImageCache$delegate = LazyKt.lazy(ImageCache::objectToImageCache_delegate$lambda$0);

    private ImageCache(MergingUpdateQueue mergingUpdateQueue, Cache<AssetKey, CachedImage> objectToImage) {
        this.objectToImage = objectToImage;
        this.pendingFutures = new HashMap();
        MergingUpdateQueue mergingUpdateQueue2 = mergingUpdateQueue;
        if (mergingUpdateQueue2 == null) {
            mergingUpdateQueue2 = new MergingUpdateQueue("queue", 3000, true, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this, null, false);
        }
        this.updateQueue = mergingUpdateQueue2;
    }

    @Async.Schedule
    private final void runOrQueue(Asset asset, boolean executeImmediately, Function0<Unit> runnable2) {
        ((Map)this.pendingFutures).put(asset, null);
        if (executeImmediately) {
            runnable2.invoke();
        } else {
            Update update2 = Update.Companion.create((Object)asset.getName(), () -> ImageCache.runOrQueue$lambda$0(runnable2));
            this.updateQueue.queue(update2);
        }
    }

    static /* synthetic */ void runOrQueue$default(ImageCache imageCache, Asset asset, boolean bl, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        imageCache.runOrQueue(asset, bl, (Function0<Unit>)function0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        HashMap<Asset, CompletableFuture<?>> hashMap = this.pendingFutures;
        synchronized (hashMap) {
            boolean bl = false;
            Collection<CompletableFuture<?>> collection2 = this.pendingFutures.values();
            Intrinsics.checkNotNullExpressionValue(collection2, (String)"<get-values>(...)");
            Iterable $this$forEach$iv = collection2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CompletableFuture it = (CompletableFuture)element$iv;
                boolean bl2 = false;
                CompletableFuture completableFuture = it;
                if (completableFuture == null) continue;
                completableFuture.cancel(true);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void clear(@NotNull Asset asset) {
        Intrinsics.checkNotNullParameter((Object)asset, (String)"asset");
        this.objectToImage.invalidate((Object)asset.getKey());
    }

    public final void clear() {
        this.objectToImage.invalidateAll();
    }

    public final long size() {
        return this.objectToImage.size();
    }

    @NotNull
    public final BufferedImage computeAndGet(@Async.Schedule @NotNull Asset asset, @NotNull BufferedImage placeholder, boolean forceComputation, @NotNull Function0<Unit> onImageCached, @NotNull Executor executor, @NotNull Function0<? extends CompletableFuture<? extends BufferedImage>> computationFutureProvider) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)asset, (String)"asset");
        Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
        Intrinsics.checkNotNullParameter(onImageCached, (String)"onImageCached");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(computationFutureProvider, (String)"computationFutureProvider");
        CachedImage cachedImage = (CachedImage)this.objectToImage.getIfPresent((Object)asset.getKey());
        if ((cachedImage == null || cachedImage.getModificationStamp() != asset.getModificationStamp() || forceComputation) && !this.pendingFutures.containsKey(asset)) {
            boolean executeImmediately = cachedImage == null;
            this.runOrQueue(asset, executeImmediately, (Function0<Unit>)((Function0)() -> ImageCache.computeAndGet$lambda$1(this, computationFutureProvider, asset, onImageCached, executor)));
        }
        if ((object = cachedImage) == null || (object = ((CachedImage)object).getImage()) == null) {
            object = placeholder;
        }
        return object;
    }

    public static /* synthetic */ BufferedImage computeAndGet$default(ImageCache imageCache, Asset asset, BufferedImage bufferedImage, boolean bl, Function0 function0, Executor executor, Function0 function02, int n, Object object) {
        if ((n & 8) != 0) {
            function0 = ImageCache::computeAndGet$lambda$0;
        }
        if ((n & 0x10) != 0) {
            EdtExecutorService edtExecutorService = EdtExecutorService.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)edtExecutorService, (String)"getInstance(...)");
            executor = (Executor)edtExecutorService;
        }
        return imageCache.computeAndGet(asset, bufferedImage, bl, (Function0<Unit>)function0, executor, (Function0<? extends CompletableFuture<? extends BufferedImage>>)function02);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void startComputation(Function0<? extends CompletableFuture<? extends BufferedImage>> computationFutureProvider, @Async.Execute Asset asset, Function0<Unit> onImageCached, Executor executor) {
        CompletionStage future2 = ((CompletableFuture)computationFutureProvider.invoke()).thenAccept(arg_0 -> ImageCache.startComputation$lambda$1(arg_0 -> ImageCache.startComputation$lambda$0(this, asset, executor, onImageCached, arg_0), arg_0));
        HashMap<Asset, CompletableFuture<?>> hashMap = this.pendingFutures;
        synchronized (hashMap) {
            boolean bl = false;
            if (!((CompletableFuture)future2).isDone()) {
                ((Map)this.pendingFutures).put(asset, future2);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final void runOrQueue$lambda$0(Function0 $tmp0) {
        $tmp0.invoke();
    }

    private static final Unit computeAndGet$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit computeAndGet$lambda$1(ImageCache this$0, Function0 $computationFutureProvider, Asset $asset, Function0 $onImageCached, Executor $executor) {
        this$0.startComputation((Function0<? extends CompletableFuture<? extends BufferedImage>>)$computationFutureProvider, $asset, (Function0<Unit>)$onImageCached, $executor);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit startComputation$lambda$0(ImageCache this$0, Asset $asset, Executor $executor, Function0 $onImageCached, BufferedImage image) {
        HashMap<Asset, CompletableFuture<?>> hashMap = this$0.pendingFutures;
        synchronized (hashMap) {
            boolean bl = false;
            CompletableFuture<?> completableFuture = this$0.pendingFutures.remove($asset);
        }
        if (image != null) {
            this$0.objectToImage.put((Object)$asset.getKey(), (Object)new CachedImage(image, $asset.getModificationStamp()));
            $executor.execute(() -> ImageCache.startComputation$lambda$0$1($onImageCached));
        } else {
            this$0.objectToImage.invalidate((Object)$asset.getKey());
        }
        return Unit.INSTANCE;
    }

    private static final void startComputation$lambda$0$1(Function0 $tmp0) {
        $tmp0.invoke();
    }

    private static final void startComputation$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Cache objectToImageCache_delegate$lambda$0() {
        return ImageCacheKt.access$createObjectToImageCache(5L, ImageCacheKt.access$getCACHE_WEIGHT_BYTES$p());
    }

    public /* synthetic */ ImageCache(MergingUpdateQueue mergingUpdateQueue, Cache objectToImage, DefaultConstructorMarker $constructor_marker) {
        this(mergingUpdateQueue, (Cache<AssetKey, CachedImage>)objectToImage);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011R'\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/rendering/ImageCache$Companion;", "", "<init>", "()V", "objectToImageCache", "Lcom/google/common/cache/Cache;", "Lcom/android/tools/idea/ui/resourcemanager/model/AssetKey;", "Lcom/android/tools/idea/ui/resourcemanager/rendering/CachedImage;", "getObjectToImageCache", "()Lcom/google/common/cache/Cache;", "objectToImageCache$delegate", "Lkotlin/Lazy;", "createImageCache", "Lcom/android/tools/idea/ui/resourcemanager/rendering/ImageCache;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "mergingUpdateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "intellij.android.core"})
    @SourceDebugExtension(value={"SMAP\nImageCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageCache.kt\ncom/android/tools/idea/ui/resourcemanager/rendering/ImageCache$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,167:1\n1#2:168\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Cache<AssetKey, CachedImage> getObjectToImageCache() {
            Lazy lazy = objectToImageCache$delegate;
            return (Cache)lazy.getValue();
        }

        @NotNull
        public final ImageCache createImageCache(@NotNull Disposable parentDisposable, @Nullable MergingUpdateQueue mergingUpdateQueue) {
            ImageCache imageCache;
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            ImageCache $this$createImageCache_u24lambda_u240 = imageCache = new ImageCache(mergingUpdateQueue, this.getObjectToImageCache(), null);
            boolean bl = false;
            Disposer.register((Disposable)parentDisposable, (Disposable)$this$createImageCache_u24lambda_u240);
            return imageCache;
        }

        public static /* synthetic */ ImageCache createImageCache$default(Companion companion, Disposable disposable, MergingUpdateQueue mergingUpdateQueue, int n, Object object) {
            if ((n & 2) != 0) {
                mergingUpdateQueue = null;
            }
            return companion.createImageCache(disposable, mergingUpdateQueue);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

