/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.rendering;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.SampleDataResourceItem;
import com.android.tools.idea.ui.resourcemanager.model.Asset;
import com.android.tools.idea.ui.resourcemanager.model.DesignAsset;
import com.android.tools.idea.ui.resourcemanager.model.DesignAssetKt;
import com.android.tools.idea.ui.resourcemanager.plugin.DesignAssetRendererManager;
import com.android.tools.idea.ui.resourcemanager.plugin.FrameworkDrawableRenderer;
import com.android.tools.idea.ui.resourcemanager.rendering.ResourceRenderingUtilsKt;
import com.android.tools.idea.ui.resourcemanager.rendering.SlowResourcePreviewProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.scale.JBUIScale;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\"\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J4\u0010\u0017\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000e\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006 "}, d2={"Lcom/android/tools/idea/ui/resourcemanager/rendering/DrawableSlowPreviewProvider;", "Lcom/android/tools/idea/ui/resourcemanager/rendering/SlowResourcePreviewProvider;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "resourceResolver", "Lcom/android/ide/common/resources/ResourceResolver;", "contextFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lorg/jetbrains/android/facet/AndroidFacet;Lcom/android/ide/common/resources/ResourceResolver;Lcom/intellij/openapi/vfs/VirtualFile;)V", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "previewPlaceholder", "Ljava/awt/image/BufferedImage;", "getPreviewPlaceholder", "()Ljava/awt/image/BufferedImage;", "getSlowPreview", "width", "", "height", "asset", "Lcom/android/tools/idea/ui/resourcemanager/model/Asset;", "renderFrameworkDrawable", "Ljava/util/concurrent/CompletableFuture;", "resolvedValue", "Lcom/android/ide/common/rendering/api/ResourceValue;", "configContext", "designAsset", "Lcom/android/tools/idea/ui/resourcemanager/model/DesignAsset;", "dimension", "Ljava/awt/Dimension;", "intellij.android.core"})
public final class DrawableSlowPreviewProvider
implements SlowResourcePreviewProvider {
    @NotNull
    private final AndroidFacet facet;
    @NotNull
    private final ResourceResolver resourceResolver;
    @Nullable
    private final VirtualFile contextFile;
    @NotNull
    private final Project project;
    @NotNull
    private final BufferedImage previewPlaceholder;

    public DrawableSlowPreviewProvider(@NotNull AndroidFacet facet, @NotNull ResourceResolver resourceResolver, @Nullable VirtualFile contextFile) {
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        Intrinsics.checkNotNullParameter((Object)resourceResolver, (String)"resourceResolver");
        this.facet = facet;
        this.resourceResolver = resourceResolver;
        this.contextFile = contextFile;
        Project project = this.facet.getModule().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.project = project;
        this.previewPlaceholder = ResourceRenderingUtilsKt.createDrawablePlaceholderImage(JBUIScale.scale((int)20), JBUIScale.scale((int)20));
    }

    @Override
    @NotNull
    public BufferedImage getPreviewPlaceholder() {
        return this.previewPlaceholder;
    }

    @Override
    @Nullable
    public BufferedImage getSlowPreview(int width, int height, @NotNull Asset asset) {
        Intrinsics.checkNotNullParameter((Object)asset, (String)"asset");
        DesignAsset designAsset = asset instanceof DesignAsset ? (DesignAsset)asset : null;
        if (designAsset == null) {
            return null;
        }
        DesignAsset designAsset2 = designAsset;
        VirtualFile virtualFile = this.contextFile;
        if (virtualFile == null) {
            virtualFile = designAsset2.getFile();
        }
        VirtualFile configContext = virtualFile;
        Dimension dimension2 = new Dimension(width, height);
        if (designAsset2.getResourceItem() instanceof SampleDataResourceItem) {
            VirtualFile file = designAsset2.getFile();
            return DesignAssetRendererManager.Companion.getInstance().getViewer(file).getImage(file, this.facet.getModule(), dimension2, configContext).get();
        }
        ResourceValue resourceValue = DesignAssetKt.resolveValue(this.resourceResolver, designAsset2);
        if (resourceValue == null) {
            return null;
        }
        ResourceValue resolveValue = resourceValue;
        if (resolveValue.isFramework()) {
            CompletableFuture<? extends BufferedImage> completableFuture = this.renderFrameworkDrawable(resolveValue, configContext, designAsset2, dimension2);
            if (completableFuture == null || (completableFuture = completableFuture.get()) == null) {
                return null;
            }
            return completableFuture;
        }
        VirtualFile virtualFile2 = IdeResourcesUtil.resolveDrawable((RenderResources)this.resourceResolver, resolveValue, this.project);
        if (virtualFile2 == null) {
            virtualFile2 = designAsset2.getFile();
        }
        VirtualFile file = virtualFile2;
        return DesignAssetRendererManager.Companion.getInstance().getViewer(file).getImage(file, this.facet.getModule(), dimension2, configContext).get();
    }

    private final CompletableFuture<? extends BufferedImage> renderFrameworkDrawable(ResourceValue resolvedValue, VirtualFile configContext, DesignAsset designAsset, Dimension dimension2) {
        ResourceValue resourceValue;
        if (designAsset.getResourceItem().getType() == ResourceType.ATTR) {
            resourceValue = resolvedValue;
        } else {
            resourceValue = this.resourceResolver.getUnresolvedResource(designAsset.getResourceItem().getReferenceToSelf());
            if (resourceValue == null) {
                return null;
            }
        }
        ResourceValue frameworkValue = resourceValue;
        return FrameworkDrawableRenderer.Companion.getInstance(this.facet).getDrawableRender(frameworkValue, configContext, dimension2);
    }
}

