/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.plugin;

import com.android.tools.configurations.Configuration;
import com.android.tools.idea.layoutlib.RenderingException;
import com.android.tools.idea.rendering.AndroidBuildTargetReference;
import com.android.tools.idea.ui.resourcemanager.plugin.ImageFuturesManager;
import com.android.tools.idea.ui.resourcemanager.plugin.LayoutRenderOptions;
import com.android.tools.idea.ui.resourcemanager.plugin.LayoutRenderer;
import com.android.tools.idea.ui.resourcemanager.plugin.LayoutRendererKt;
import com.android.tools.rendering.RenderResult;
import com.android.tools.rendering.RenderTask;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlFile;
import java.awt.image.BufferedImage;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetScopedService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019BM\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012,\u0010\u0004\u001a(\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n0\u0005\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J*\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\n2\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\b2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\tJ*\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\n2\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\tH\u0002R4\u0010\u0004\u001a(\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/plugin/LayoutRenderer;", "Lorg/jetbrains/android/facet/AndroidFacetScopedService;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "renderTaskProvider", "Lkotlin/Function4;", "Lcom/android/tools/idea/rendering/AndroidBuildTargetReference;", "Lcom/intellij/psi/xml/XmlFile;", "Lcom/android/tools/configurations/Configuration;", "Lcom/android/tools/idea/ui/resourcemanager/plugin/LayoutRenderOptions;", "Ljava/util/concurrent/CompletableFuture;", "Lcom/android/tools/rendering/RenderTask;", "futuresManager", "Lcom/android/tools/idea/ui/resourcemanager/plugin/ImageFuturesManager;", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lorg/jetbrains/android/facet/AndroidFacet;Lkotlin/jvm/functions/Function4;Lcom/android/tools/idea/ui/resourcemanager/plugin/ImageFuturesManager;)V", "onServiceDisposal", "", "getLayoutRender", "Ljava/awt/image/BufferedImage;", "xmlFile", "configuration", "layoutRenderOptions", "getImage", "Companion", "intellij.android.core"})
public final class LayoutRenderer
extends AndroidFacetScopedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function4<AndroidBuildTargetReference, XmlFile, Configuration, LayoutRenderOptions, CompletableFuture<RenderTask>> renderTaskProvider;
    @NotNull
    private final ImageFuturesManager<VirtualFile> futuresManager;

    @VisibleForTesting
    public LayoutRenderer(@NotNull AndroidFacet facet, @NotNull Function4<? super AndroidBuildTargetReference, ? super XmlFile, ? super Configuration, ? super LayoutRenderOptions, ? extends CompletableFuture<RenderTask>> renderTaskProvider, @NotNull ImageFuturesManager<VirtualFile> futuresManager) {
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        Intrinsics.checkNotNullParameter(renderTaskProvider, (String)"renderTaskProvider");
        Intrinsics.checkNotNullParameter(futuresManager, (String)"futuresManager");
        super(facet);
        this.renderTaskProvider = renderTaskProvider;
        this.futuresManager = futuresManager;
        Disposer.register((Disposable)this, (Disposable)this.futuresManager);
    }

    @Override
    protected void onServiceDisposal(@NotNull AndroidFacet facet) {
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
    }

    @NotNull
    public final CompletableFuture<BufferedImage> getLayoutRender(@NotNull XmlFile xmlFile, @NotNull Configuration configuration2, @Nullable LayoutRenderOptions layoutRenderOptions) {
        Intrinsics.checkNotNullParameter((Object)xmlFile, (String)"xmlFile");
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Function0 imageRenderCallback = () -> LayoutRenderer.getLayoutRender$lambda$0(this, xmlFile, configuration2, layoutRenderOptions);
        VirtualFile virtualFile = xmlFile.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        return this.futuresManager.registerAndGet(virtualFile, (Function0<CompletableFuture<BufferedImage>>)imageRenderCallback);
    }

    public static /* synthetic */ CompletableFuture getLayoutRender$default(LayoutRenderer layoutRenderer, XmlFile xmlFile, Configuration configuration2, LayoutRenderOptions layoutRenderOptions, int n, Object object) {
        if ((n & 4) != 0) {
            layoutRenderOptions = null;
        }
        return layoutRenderer.getLayoutRender(xmlFile, configuration2, layoutRenderOptions);
    }

    private final CompletableFuture<BufferedImage> getImage(XmlFile xmlFile, Configuration configuration2, LayoutRenderOptions layoutRenderOptions) {
        LayoutRenderOptions layoutRenderOptions2 = layoutRenderOptions;
        if (layoutRenderOptions2 == null) {
            layoutRenderOptions2 = new LayoutRenderOptions(null, false, false, 7, null);
        }
        LayoutRenderOptions options = layoutRenderOptions2;
        AndroidFacet androidFacet = this.getFacet();
        Intrinsics.checkNotNullExpressionValue((Object)androidFacet, (String)"getFacet(...)");
        CompletableFuture renderTaskFuture = (CompletableFuture)this.renderTaskProvider.invoke((Object)AndroidBuildTargetReference.Companion.gradleOnly(androidFacet), (Object)xmlFile, (Object)configuration2, (Object)options);
        CompletionStage completionStage = ((CompletableFuture)((CompletableFuture)renderTaskFuture.thenCompose(arg_0 -> LayoutRenderer.getImage$lambda$1(LayoutRenderer::getImage$lambda$0, arg_0))).thenApplyAsync(LayoutRenderer::getImage$lambda$2, (Executor)PooledThreadExecutor.INSTANCE)).whenComplete((arg_0, arg_1) -> LayoutRenderer.getImage$lambda$4((arg_0, arg_1) -> LayoutRenderer.getImage$lambda$3(renderTaskFuture, arg_0, arg_1), arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"whenComplete(...)");
        return completionStage;
    }

    private static final CompletableFuture getLayoutRender$lambda$0(LayoutRenderer this$0, XmlFile $xmlFile, Configuration $configuration, LayoutRenderOptions $layoutRenderOptions) {
        return this$0.getImage($xmlFile, $configuration, $layoutRenderOptions);
    }

    private static final CompletionStage getImage$lambda$0(RenderTask it) {
        RenderTask renderTask = it;
        return renderTask != null ? renderTask.render() : null;
    }

    private static final CompletionStage getImage$lambda$1(Function1 $tmp0, Object p0) {
        return (CompletionStage)$tmp0.invoke(p0);
    }

    private static final BufferedImage getImage$lambda$2(RenderResult it) {
        if (it == null) {
            return null;
        }
        if (!it.getRenderResult().isSuccess()) {
            if (it.getRenderResult().getException() != null) {
                Throwable throwable = it.getRenderResult().getException();
                Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"getException(...)");
                throw throwable;
            }
            throw new RenderingException(it.getRenderResult().getStatus().name(), new Throwable[0]);
        }
        return it.getRenderedImage().getCopy();
    }

    private static final Unit getImage$lambda$3(CompletableFuture $renderTaskFuture, BufferedImage bufferedImage, Throwable throwable) {
        block0: {
            RenderTask renderTask = (RenderTask)$renderTaskFuture.get();
            if (renderTask == null) break block0;
            renderTask.dispose();
        }
        return Unit.INSTANCE;
    }

    private static final void getImage$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    @JvmStatic
    @NotNull
    public static final LayoutRenderer getInstance(@NotNull AndroidFacet facet) {
        return Companion.getInstance(facet);
    }

    @VisibleForTesting
    @JvmStatic
    public static final void setInstance(@NotNull AndroidFacet facet, @Nullable LayoutRenderer layoutRenderer) {
        Companion.setInstance(facet, layoutRenderer);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u0005H\u0007\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/plugin/LayoutRenderer$Companion;", "", "<init>", "()V", "getInstance", "Lcom/android/tools/idea/ui/resourcemanager/plugin/LayoutRenderer;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "setInstance", "", "layoutRenderer", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final LayoutRenderer getInstance(@NotNull AndroidFacet facet) {
            Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
            LayoutRenderer manager = (LayoutRenderer)facet.getUserData(LayoutRendererKt.access$getLAYOUT_KEY$p());
            if (manager == null) {
                manager = new LayoutRenderer(facet, (Function4<? super AndroidBuildTargetReference, ? super XmlFile, ? super Configuration, ? super LayoutRenderOptions, ? extends CompletableFuture<RenderTask>>)((Function4)getInstance.1.INSTANCE), new ImageFuturesManager<VirtualFile>());
                this.setInstance(facet, manager);
            }
            return manager;
        }

        @VisibleForTesting
        @JvmStatic
        public final void setInstance(@NotNull AndroidFacet facet, @Nullable LayoutRenderer layoutRenderer) {
            Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
            facet.putUserData(LayoutRendererKt.access$getLAYOUT_KEY$p(), (Object)layoutRenderer);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

