/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.model;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.ui.resourcemanager.ResourceManagerTracking;
import com.android.tools.idea.ui.resourcemanager.model.ResourceDataManagerKt;
import com.android.tools.idea.ui.resourcemanager.model.ResourcePasteProviderKt;
import com.android.tools.idea.ui.resourcemanager.model.SupportedKotlinElement;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.android.tools.idea.util.ReformatUtil;
import com.intellij.ide.PasteProvider;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.actions.PasteAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Producer;
import java.awt.datatransfer.Transferable;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J,\u0010\u000b\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\"\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J,\u0010\u0013\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J \u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J(\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\"\u0010\u001a\u001a\u00020\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\"\u0010\u001d\u001a\u00020\u00192\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\"\u0010 \u001a\u00020\u00192\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J.\u0010#\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J6\u0010%\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0018\u0010&\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010(\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0012\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010.\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010/\u001a\u00020\u0016*\u00020*8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101\u00a8\u00062"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/model/ResourcePasteProvider;", "Lcom/intellij/ide/PasteProvider;", "<init>", "()V", "IMAGE_LIKE_TYPES", "", "Lcom/android/resources/ResourceType;", "performPaste", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "performForKotlinCode", "psiElement", "Lcom/intellij/psi/PsiElement;", "caret", "Lcom/intellij/openapi/editor/Caret;", "project", "Lcom/intellij/openapi/project/Project;", "performForJavaCode", "performForXml", "insertIncludeTag", "resourceReference", "", "insertImageView", "isFixedDimension", "", "processForTag", "xmlTag", "Lcom/intellij/psi/xml/XmlTag;", "processForAttribute", "xmlAttribute", "Lcom/intellij/psi/xml/XmlAttribute;", "processForValue", "xmlAttributeValue", "Lcom/intellij/psi/xml/XmlAttributeValue;", "pasteAtCaret", "type", "replaceAtCaret", "performForImageView", "setSrcAttribute", "dependsOnAppCompat", "getResourceUrl", "Lcom/android/resources/ResourceUrl;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isPastePossible", "isPasteEnabled", "resourceCodeReference", "getResourceCodeReference", "(Lcom/android/resources/ResourceUrl;)Ljava/lang/String;", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nResourcePasteProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourcePasteProvider.kt\ncom/android/tools/idea/ui/resourcemanager/model/ResourcePasteProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,371:1\n1#2:372\n66#3,2:373\n66#3,2:375\n66#3,2:377\n66#3,2:379\n66#3,2:386\n2019#4,5:381\n2019#4,5:388\n*S KotlinDebug\n*F\n+ 1 ResourcePasteProvider.kt\ncom/android/tools/idea/ui/resourcemanager/model/ResourcePasteProvider\n*L\n135#1:373,2\n141#1:375,2\n147#1:377,2\n157#1:379,2\n173#1:386,2\n158#1:381,5\n176#1:388,5\n*E\n"})
public final class ResourcePasteProvider
implements PasteProvider {
    @NotNull
    private final Set<ResourceType> IMAGE_LIKE_TYPES;

    public ResourcePasteProvider() {
        Object[] objectArray = new ResourceType[]{ResourceType.DRAWABLE, ResourceType.MIPMAP, ResourceType.COLOR};
        this.IMAGE_LIKE_TYPES = SetsKt.setOf((Object[])objectArray);
    }

    public void performPaste(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Object object = CommonDataKeys.CARET.getData(dataContext);
        Intrinsics.checkNotNull((Object)object);
        Caret caret = (Caret)object;
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (psiFile == null) {
            return;
        }
        PsiFile psiFile2 = psiFile;
        PsiElement psiElement = (PsiElement)ActionsKt.runReadAction(() -> ResourcePasteProvider.performPaste$lambda$0(psiFile2, caret));
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        FileType fileType = psiFile2.getFileType();
        if (Intrinsics.areEqual((Object)fileType, (Object)XmlFileType.INSTANCE)) {
            this.performForXml(psiElement, dataContext, caret, project);
        } else if (Intrinsics.areEqual((Object)fileType, (Object)JavaFileType.INSTANCE)) {
            this.performForJavaCode(dataContext, caret, project);
        } else if (Intrinsics.areEqual((Object)fileType, (Object)KotlinFileType.INSTANCE)) {
            this.performForKotlinCode(psiElement, dataContext, caret, project);
        }
    }

    private final void performForKotlinCode(PsiElement psiElement, DataContext dataContext, Caret caret, Project project) {
        SupportedKotlinElement supportedKotlinElement;
        PsiElement kotlinParentElement;
        ResourceUrl resourceUrl = this.getResourceUrl(dataContext);
        if (resourceUrl == null) {
            return;
        }
        ResourceUrl resourceUrl2 = resourceUrl;
        if (psiElement == null) {
            return;
        }
        String resourceCodeReference = this.getResourceCodeReference(resourceUrl2);
        Class<? extends PsiElement>[] classArray = SupportedKotlinElement.Companion.getAllSupportedKotlinElementClasses();
        PsiElement psiElement2 = kotlinParentElement = PsiUtilsKt.getParentOfTypes((PsiElement)psiElement, (boolean)false, (Class[])Arrays.copyOf(classArray, classArray.length));
        if (psiElement2 != null) {
            PsiElement psiElement3 = psiElement2;
            SupportedKotlinElement.Companion companion = SupportedKotlinElement.Companion;
            PsiElement p0 = psiElement3;
            boolean bl = false;
            v2 = companion.toSupportedKotlinElement(p0);
        } else {
            v2 = supportedKotlinElement = null;
        }
        if (supportedKotlinElement != null) {
            supportedKotlinElement.getProcessElement().invoke((Object)kotlinParentElement, (Object)caret, (Object)resourceCodeReference);
            ResourceManagerTracking.INSTANCE.logPasteUrlText(project, resourceUrl2.type);
        } else {
            this.pasteAtCaret(caret, resourceCodeReference, resourceUrl2.type, project);
        }
    }

    private final void performForJavaCode(DataContext dataContext, Caret caret, Project project) {
        ResourceUrl resourceUrl = this.getResourceUrl(dataContext);
        if (resourceUrl == null) {
            return;
        }
        ResourceUrl resourceUrl2 = resourceUrl;
        String resourceCodeReference = this.getResourceCodeReference(resourceUrl2);
        this.pasteAtCaret(caret, resourceCodeReference, resourceUrl2.type, project);
    }

    private final void performForXml(PsiElement psiElement, DataContext dataContext, Caret caret, Project project) {
        ResourceUrl resourceUrl = this.getResourceUrl(dataContext);
        Object object = resourceUrl;
        if (object == null || (object = object.toString()) == null) {
            return;
        }
        Object resourceReference = object;
        if (psiElement instanceof PsiWhiteSpace && IdeResourcesUtil.getFolderType(((PsiWhiteSpace)psiElement).getContainingFile()) == ResourceFolderType.LAYOUT) {
            ResourceType resourceType = resourceUrl.type;
            Intrinsics.checkNotNullExpressionValue((Object)resourceType, (String)"type");
            ResourceManagerTracking.INSTANCE.logPasteOnBlank(project, resourceType);
            if (this.IMAGE_LIKE_TYPES.contains(resourceUrl.type)) {
                this.insertImageView((String)resourceReference, psiElement, caret, resourceUrl.type == ResourceType.COLOR);
                return;
            }
            if (resourceUrl.type == ResourceType.LAYOUT) {
                this.insertIncludeTag((String)resourceReference, psiElement, caret);
                return;
            }
        }
        if (!(psiElement instanceof XmlElement)) {
            this.pasteAtCaret(caret, (String)resourceReference, resourceUrl.type, project);
            return;
        }
        PsiElement $this$parentOfType_u24default$iv = psiElement;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        XmlAttributeValue xmlAttributeValue = (XmlAttributeValue)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, XmlAttributeValue.class, (boolean)true);
        if (this.processForValue(xmlAttributeValue, caret, (String)resourceReference)) {
            ResourceType resourceType = resourceUrl.type;
            Intrinsics.checkNotNullExpressionValue((Object)resourceType, (String)"type");
            ResourceManagerTracking.INSTANCE.logPasteOnXmlAttribute(project, resourceType);
            return;
        }
        PsiElement $this$parentOfType_u24default$iv2 = psiElement;
        boolean withSelf$iv2 = false;
        boolean $i$f$parentOfType2 = false;
        XmlAttribute xmlAttribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv2, XmlAttribute.class, (boolean)true);
        if (this.processForAttribute(xmlAttribute, caret, (String)resourceReference)) {
            ResourceType resourceType = resourceUrl.type;
            Intrinsics.checkNotNullExpressionValue((Object)resourceType, (String)"type");
            ResourceManagerTracking.INSTANCE.logPasteOnXmlAttribute(project, resourceType);
            return;
        }
        PsiElement $this$parentOfType_u24default$iv3 = psiElement;
        boolean withSelf$iv3 = false;
        boolean $i$f$parentOfType3 = false;
        XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv3, XmlTag.class, (boolean)true);
        if (this.processForTag(xmlTag, caret, (String)resourceReference)) {
            ResourceType resourceType = resourceUrl.type;
            Intrinsics.checkNotNullExpressionValue((Object)resourceType, (String)"type");
            ResourceManagerTracking.INSTANCE.logPasteOnXmlTag(project, resourceType);
            return;
        }
        this.pasteAtCaret(caret, (String)resourceReference, resourceUrl.type, project);
    }

    private final void insertIncludeTag(String resourceReference, PsiElement psiElement, Caret caret) {
        Object element$iv;
        XmlTag parent;
        block3: {
            PsiElement $this$parentOfType_u24default$iv = psiElement;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, XmlTag.class, (boolean)true);
            if (xmlTag == null) {
                return;
            }
            parent = xmlTag;
            PsiElement[] psiElementArray = parent.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
            Object[] $this$last$iv = psiElementArray;
            boolean $i$f$last = false;
            int n = $this$last$iv.length + -1;
            if (0 <= n) {
                do {
                    int index$iv = n--;
                    element$iv = $this$last$iv[index$iv];
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl = false;
                    if (it.getTextRange().getStartOffset() < caret.getOffset()) break block3;
                } while (0 <= n);
            }
            throw new NoSuchElementException("Array contains no element matching the predicate.");
        }
        Object object = element$iv;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"last(...)");
        PsiElement before = (PsiElement)object;
        ActionsKt.runWriteAction(() -> ResourcePasteProvider.insertIncludeTag$lambda$1(parent, before, resourceReference));
    }

    private final void insertImageView(String resourceReference, PsiElement psiElement, Caret caret, boolean isFixedDimension) {
        Object element$iv;
        boolean dependsOnAppCompat;
        XmlTag parent;
        block3: {
            PsiElement $this$parentOfType_u24default$iv = psiElement;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, XmlTag.class, (boolean)true);
            if (xmlTag == null) {
                return;
            }
            parent = xmlTag;
            dependsOnAppCompat = this.dependsOnAppCompat(parent);
            PsiElement[] psiElementArray = parent.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
            Object[] $this$last$iv = psiElementArray;
            boolean $i$f$last = false;
            int n = $this$last$iv.length + -1;
            if (0 <= n) {
                do {
                    int index$iv = n--;
                    element$iv = $this$last$iv[index$iv];
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl = false;
                    if (it.getTextRange().getStartOffset() < caret.getOffset()) break block3;
                } while (0 <= n);
            }
            throw new NoSuchElementException("Array contains no element matching the predicate.");
        }
        Object object = element$iv;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"last(...)");
        PsiElement before = (PsiElement)object;
        String dimensionValue = isFixedDimension ? "50dp" : "wrap_content";
        ActionsKt.runWriteAction(() -> ResourcePasteProvider.insertImageView$lambda$1(parent, before, dimensionValue, this, dependsOnAppCompat, resourceReference));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean processForTag(XmlTag xmlTag, Caret caret, String resourceReference) {
        XmlTag xmlTag2 = xmlTag;
        if (xmlTag2 == null) return false;
        String string = xmlTag2.getName();
        String string2 = string;
        if (string2 == null) return false;
        switch (string2.hashCode()) {
            case 1125864064: {
                if (!string2.equals("ImageView")) return false;
                boolean bl = this.performForImageView(xmlTag, resourceReference);
                return bl;
            }
            default: {
                return false;
            }
        }
    }

    private final boolean processForAttribute(XmlAttribute xmlAttribute, Caret caret, String resourceReference) {
        if (xmlAttribute == null) {
            return false;
        }
        int replaceStartOffset = ((Number)ActionsKt.runWriteAction(() -> ResourcePasteProvider.processForAttribute$lambda$0(xmlAttribute, caret, resourceReference))).intValue();
        if (replaceStartOffset > -1) {
            ResourcePasteProviderKt.access$selectStringFromOffset(caret, resourceReference, replaceStartOffset);
        }
        return true;
    }

    private final boolean processForValue(XmlAttributeValue xmlAttributeValue, Caret caret, String resourceReference) {
        if (xmlAttributeValue == null) {
            return false;
        }
        PsiElement psiElement = xmlAttributeValue.getParent();
        this.processForAttribute(psiElement instanceof XmlAttribute ? (XmlAttribute)psiElement : null, caret, resourceReference);
        return true;
    }

    private final void pasteAtCaret(Caret caret, String resourceReference, ResourceType type, Project project) {
        ActionsKt.runWriteAction(() -> ResourcePasteProvider.pasteAtCaret$lambda$0(caret, resourceReference));
        ResourcePasteProviderKt.access$selectStringFromOffset(caret, resourceReference, caret.getOffset());
        ResourceManagerTracking.INSTANCE.logPasteUrlText(project, type);
    }

    static /* synthetic */ void pasteAtCaret$default(ResourcePasteProvider resourcePasteProvider, Caret caret, String string, ResourceType resourceType, Project project, int n, Object object) {
        if ((n & 4) != 0) {
            resourceType = null;
        }
        resourcePasteProvider.pasteAtCaret(caret, string, resourceType, project);
    }

    private final void replaceAtCaret(Caret caret, PsiElement psiElement, String resourceReference, ResourceType type, Project project) {
        ActionsKt.runWriteAction(() -> ResourcePasteProvider.replaceAtCaret$lambda$0(caret, psiElement, resourceReference));
        ResourcePasteProviderKt.access$selectStringFromOffset(caret, resourceReference, psiElement.getTextRange().getStartOffset());
        ResourceManagerTracking.INSTANCE.logPasteUrlText(project, type);
    }

    static /* synthetic */ void replaceAtCaret$default(ResourcePasteProvider resourcePasteProvider, Caret caret, PsiElement psiElement, String string, ResourceType resourceType, Project project, int n, Object object) {
        if ((n & 8) != 0) {
            resourceType = null;
        }
        resourcePasteProvider.replaceAtCaret(caret, psiElement, string, resourceType, project);
    }

    private final boolean performForImageView(XmlTag xmlTag, String resourceReference) {
        boolean dependsOnAppCompat = this.dependsOnAppCompat(xmlTag);
        ActionsKt.runWriteAction(() -> ResourcePasteProvider.performForImageView$lambda$0(this, dependsOnAppCompat, xmlTag, resourceReference));
        return true;
    }

    private final void setSrcAttribute(boolean dependsOnAppCompat, XmlTag xmlTag, String resourceReference) {
        if (dependsOnAppCompat) {
            PsiFile psiFile = xmlTag.getContainingFile();
            XmlFile xmlFile = psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
            if (xmlFile != null) {
                XmlFile it = xmlFile;
                boolean bl = false;
                IdeResourcesUtil.ensureNamespaceImported$default(it, "http://schemas.android.com/apk/res-auto", null, 4, null);
            }
            xmlTag.setAttribute("srcCompat", "http://schemas.android.com/apk/res-auto", resourceReference);
            v1 = xmlTag.setAttribute("src", "http://schemas.android.com/apk/res/android", null);
        } else {
            xmlTag.setAttribute("srcCompat", "http://schemas.android.com/apk/res-auto", null);
            v1 = xmlTag.setAttribute("src", "http://schemas.android.com/apk/res/android", resourceReference);
        }
    }

    private final boolean dependsOnAppCompat(XmlTag xmlTag) {
        return Intrinsics.areEqual((Object)ActionsKt.runReadAction(() -> ResourcePasteProvider.dependsOnAppCompat$lambda$0(xmlTag)), (Object)true);
    }

    private final ResourceUrl getResourceUrl(DataContext dataContext) {
        Transferable transferable;
        Producer producer = (Producer)PasteAction.TRANSFERABLE_PROVIDER.getData(dataContext);
        return (ResourceUrl)(producer != null && (transferable = (Transferable)producer.produce()) != null ? transferable.getTransferData(ResourceDataManagerKt.RESOURCE_URL_FLAVOR) : null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        Transferable transferable;
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Producer producer = (Producer)PasteAction.TRANSFERABLE_PROVIDER.getData(dataContext);
        return producer != null && (transferable = (Transferable)producer.produce()) != null ? transferable.isDataFlavorSupported(ResourceDataManagerKt.RESOURCE_URL_FLAVOR) : false;
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return this.isPastePossible(dataContext);
    }

    private final String getResourceCodeReference(ResourceUrl $this$resourceCodeReference) {
        Object object;
        block3: {
            block2: {
                object = $this$resourceCodeReference.namespace;
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                String string = it + ".";
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        return (String)object + "R." + $this$resourceCodeReference.type + "." + $this$resourceCodeReference.name;
    }

    private static final PsiElement performPaste$lambda$0(PsiFile $psiFile, Caret $caret) {
        return $psiFile.findElementAt($caret.getOffset());
    }

    private static final Unit insertIncludeTag$lambda$1(XmlTag $parent, PsiElement $before, String $resourceReference) {
        XmlTag childTag;
        PsiElement psiElement = $parent.addAfter((PsiElement)$parent.createChildTag("include", $parent.getNamespace(), null, false), $before);
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.psi.xml.XmlTag");
        XmlTag $this$insertIncludeTag_u24lambda_u241_u240 = childTag = (XmlTag)psiElement;
        boolean bl = false;
        $this$insertIncludeTag_u24lambda_u241_u240.setAttribute("layout_width", "http://schemas.android.com/apk/res/android", "wrap_content");
        $this$insertIncludeTag_u24lambda_u241_u240.setAttribute("layout_height", "http://schemas.android.com/apk/res/android", "wrap_content");
        $this$insertIncludeTag_u24lambda_u241_u240.setAttribute("layout", $resourceReference);
        $this$insertIncludeTag_u24lambda_u241_u240.collapseIfEmpty();
        Project project = $parent.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ReformatUtil.reformatAndRearrange(project, (PsiElement)$this$insertIncludeTag_u24lambda_u241_u240);
        return Unit.INSTANCE;
    }

    private static final Unit insertImageView$lambda$1(XmlTag $parent, PsiElement $before, String $dimensionValue, ResourcePasteProvider this$0, boolean $dependsOnAppCompat, String $resourceReference) {
        XmlTag childTag;
        PsiElement psiElement = $parent.addAfter((PsiElement)$parent.createChildTag("ImageView", $parent.getNamespace(), null, false), $before);
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.psi.xml.XmlTag");
        XmlTag $this$insertImageView_u24lambda_u241_u240 = childTag = (XmlTag)psiElement;
        boolean bl = false;
        $this$insertImageView_u24lambda_u241_u240.setAttribute("layout_width", "http://schemas.android.com/apk/res/android", $dimensionValue);
        $this$insertImageView_u24lambda_u241_u240.setAttribute("layout_height", "http://schemas.android.com/apk/res/android", $dimensionValue);
        this$0.setSrcAttribute($dependsOnAppCompat, $this$insertImageView_u24lambda_u241_u240, $resourceReference);
        $this$insertImageView_u24lambda_u241_u240.collapseIfEmpty();
        Project project = $parent.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ReformatUtil.reformatAndRearrange(project, (PsiElement)$this$insertImageView_u24lambda_u241_u240);
        return Unit.INSTANCE;
    }

    private static final int processForAttribute$lambda$0(XmlAttribute $xmlAttribute, Caret $caret, String $resourceReference) {
        TextRange textRange;
        XmlAttributeValue xmlAttributeValue = $xmlAttribute.getValueElement();
        Object object = textRange = xmlAttributeValue != null ? xmlAttributeValue.getValueTextRange() : null;
        if (textRange != null) {
            String string = $xmlAttribute.getValue();
            boolean bl = string != null ? StringsKt.startsWith$default((String)string, (String)"@{", (boolean)false, (int)2, null) : false;
            if (bl && $caret.getOffset() > textRange.getStartOffset() + 1 && $caret.getOffset() < textRange.getEndOffset()) {
                $xmlAttribute.setValue("@{" + $resourceReference + "}");
                return textRange.getStartOffset() + 2;
            }
        }
        $xmlAttribute.setValue($resourceReference);
        TextRange textRange2 = textRange;
        return textRange2 != null ? textRange2.getStartOffset() : -1;
    }

    private static final Unit pasteAtCaret$lambda$0(Caret $caret, String $resourceReference) {
        $caret.getEditor().getDocument().insertString($caret.getOffset(), (CharSequence)$resourceReference);
        return Unit.INSTANCE;
    }

    private static final Unit replaceAtCaret$lambda$0(Caret $caret, PsiElement $psiElement, String $resourceReference) {
        $caret.getEditor().getDocument().replaceString($psiElement.getTextRange().getStartOffset(), $psiElement.getTextRange().getEndOffset(), (CharSequence)$resourceReference);
        return Unit.INSTANCE;
    }

    private static final Unit performForImageView$lambda$0(ResourcePasteProvider this$0, boolean $dependsOnAppCompat, XmlTag $xmlTag, String $resourceReference) {
        this$0.setSrcAttribute($dependsOnAppCompat, $xmlTag, $resourceReference);
        Project project = $xmlTag.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ReformatUtil.reformatAndRearrange(project, (PsiElement)$xmlTag);
        return Unit.INSTANCE;
    }

    private static final Boolean dependsOnAppCompat$lambda$0(XmlTag $xmlTag) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)$xmlTag));
        return module != null ? Boolean.valueOf(DependencyManagementUtil.dependsOnAppCompat(module)) : null;
    }
}

