/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.designer.overlays;

import com.android.tools.idea.ui.designer.overlays.OverlayEntry;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@State(name="OverlayPersistentState", storages={@Storage(value="overlayData.xml")})
public final class OverlayPersistentStateService
implements PersistentStateComponent<OverlayPersistentStateService> {
    public List<String> overlayIds = new ArrayList<String>();
    public List<String> overlayNames = new ArrayList<String>();
    public List<String> providers = new ArrayList<String>();

    public static OverlayPersistentStateService getInstance() {
        return (OverlayPersistentStateService)ApplicationManager.getApplication().getService(OverlayPersistentStateService.class);
    }

    public void addOverlayData(@NotNull OverlayEntry overlayEntry, @NotNull String name2) {
        this.overlayIds.add(overlayEntry.getId());
        this.overlayNames.add(name2);
        this.providers.add(overlayEntry.getOverlayProvider().getClass().getSimpleName());
    }

    public void deleteOverlayData(@NotNull OverlayEntry overlayEntry) {
        String provider = overlayEntry.getOverlayProvider().getClass().getSimpleName();
        for (int i = 0; i < this.getSize(); ++i) {
            if (!this.overlayIds.get(i).equals(overlayEntry.getId()) || !this.providers.get(i).equals(provider)) continue;
            this.overlayIds.remove(i);
            this.overlayNames.remove(i);
            this.providers.remove(i);
            break;
        }
    }

    public void updateOverlayName(@NotNull OverlayEntry overlayEntry, @NotNull String overlayName) {
        String provider = overlayEntry.getOverlayProvider().getClass().getSimpleName();
        for (int i = 0; i < this.getSize(); ++i) {
            if (!this.overlayIds.get(i).equals(overlayEntry.getId()) || !this.providers.get(i).equals(provider)) continue;
            this.overlayNames.set(i, overlayName);
        }
    }

    public int getSize() {
        return this.overlayIds.size();
    }

    public OverlayPersistentStateService getState() {
        return this;
    }

    public void loadState(@NotNull OverlayPersistentStateService state2) {
        XmlSerializerUtil.copyBean((Object)state2, (Object)this);
    }
}

