/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.transport;

import com.android.tools.idea.io.grpc.ClientCall;
import com.android.tools.idea.io.grpc.MethodDescriptor;
import com.android.tools.idea.io.grpc.ServerCallHandler;
import com.android.tools.idea.io.grpc.ServerServiceDefinition;
import com.android.tools.idea.io.grpc.ServiceDescriptor;
import com.android.tools.idea.io.grpc.stub.AbstractStub;
import com.android.tools.idea.io.grpc.stub.ClientCalls;
import com.android.tools.idea.io.grpc.stub.ServerCalls;
import com.android.tools.idea.io.grpc.stub.StreamObserver;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class ServiceProxy {
    private final ServiceDescriptor myServiceDescriptor;

    public ServiceProxy(@NotNull ServiceDescriptor serviceDescriptor) {
        this.myServiceDescriptor = serviceDescriptor;
    }

    public abstract ServerServiceDefinition getServiceDefinition();

    public void disconnect() {
    }

    protected final ServerServiceDefinition generatePassThroughDefinitions(@NotNull Map<MethodDescriptor, ServerCallHandler> overrides2, @NotNull AbstractStub blockingStub) {
        ServerServiceDefinition.Builder builder = ServerServiceDefinition.builder((ServiceDescriptor)this.myServiceDescriptor);
        overrides2.forEach((method2, handler2) -> builder.addMethod(method2, handler2));
        this.myServiceDescriptor.getMethods().forEach(descriptor2 -> {
            if (overrides2.containsKey(descriptor2)) {
                return;
            }
            switch (descriptor2.getType()) {
                case UNARY: {
                    builder.addMethod(descriptor2, ServerCalls.asyncUnaryCall((request, observer) -> this.invokeAsyncUnaryCalls((MethodDescriptor)descriptor2, blockingStub, (Object)request, (StreamObserver)observer)));
                    break;
                }
                case CLIENT_STREAMING: 
                case SERVER_STREAMING: 
                case BIDI_STREAMING: 
                case UNKNOWN: {
                    throw new UnsupportedOperationException();
                }
            }
        });
        return builder.build();
    }

    private <Req, Resp> void invokeAsyncUnaryCalls(@NotNull MethodDescriptor descriptor2, @NotNull AbstractStub stubInstance, Req request, @NotNull StreamObserver<Resp> observer) {
        ClientCalls.asyncUnaryCall((ClientCall)stubInstance.getChannel().newCall(descriptor2, stubInstance.getCallOptions()), request, observer);
    }
}

