/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.testsuite.temp;

import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.log.LogWrapper;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidDevice;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidDeviceType;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestCase;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestCaseResult;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestSuite;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestSuiteResult;
import com.android.tools.idea.testartifacts.instrumented.testsuite.view.AndroidTestSuiteView;
import com.android.tools.idea.testartifacts.testsuite.temp.TestSuiteViewAdaptor;
import com.android.utils.ILogger;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.externalSystem.model.task.event.Failure;
import com.intellij.openapi.externalSystem.model.task.event.FailureResult;
import com.intellij.openapi.externalSystem.model.task.event.OperationResult;
import com.intellij.openapi.externalSystem.model.task.event.SkippedResult;
import com.intellij.openapi.externalSystem.model.task.event.SuccessResult;
import com.intellij.openapi.externalSystem.model.task.event.TestAssertionFailure;
import com.intellij.openapi.externalSystem.model.task.event.TestFailure;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 *2\u00020\u0001:\u0001*B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J(\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001e\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f\u0018\u00010$2\u0006\u0010%\u001a\u00020\bH\u0002J\u0018\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010(\u001a\u00020\u00152\u0006\u0010)\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000f0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u001d\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00120\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\n\u00a8\u0006+"}, d2={"Lcom/android/tools/idea/testartifacts/testsuite/temp/AndroidTestSuiteViewAdaptor;", "Lcom/android/tools/idea/testartifacts/testsuite/temp/TestSuiteViewAdaptor;", "runConfiguration", "Lcom/intellij/execution/configurations/RunConfiguration;", "<init>", "(Lcom/intellij/execution/configurations/RunConfiguration;)V", "parentId", "", "", "getParentId", "()Ljava/util/Map;", "deviceMap", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidDevice;", "getDeviceMap", "testSuiteMap", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidTestSuite;", "getTestSuiteMap", "testCaseMap", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidTestCase;", "getTestCaseMap", "onBeforeSuite", "", "testIdentifier", "Lcom/android/tools/idea/testartifacts/testsuite/temp/TestSuiteViewAdaptor$TestIdentifier;", "executionConsole", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/AndroidTestSuiteView;", "onBeforeTest", "onAfterTest", "result", "Lcom/intellij/openapi/externalSystem/model/task/event/OperationResult;", "onAfterSuite", "onOutput", "output", "contentType", "Lcom/android/tools/idea/testartifacts/testsuite/temp/TestSuiteViewAdaptor$OutputContentType;", "getRootTestIdAndDevice", "Lkotlin/Pair;", "testId", "applyResultToTestCase", "testCase", "applyResultToTestSuite", "testSuite", "Companion", "intellij.android.projectSystem.gradle"})
@SourceDebugExtension(value={"SMAP\nAndroidTestSuiteViewAdaptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidTestSuiteViewAdaptor.kt\ncom/android/tools/idea/testartifacts/testsuite/temp/AndroidTestSuiteViewAdaptor\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,248:1\n1321#2,2:249\n1321#2,2:251\n*S KotlinDebug\n*F\n+ 1 AndroidTestSuiteViewAdaptor.kt\ncom/android/tools/idea/testartifacts/testsuite/temp/AndroidTestSuiteViewAdaptor\n*L\n151#1:249,2\n168#1:251,2\n*E\n"})
public final class AndroidTestSuiteViewAdaptor
implements TestSuiteViewAdaptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final RunConfiguration runConfiguration;
    @NotNull
    private final Map<String, String> parentId;
    @NotNull
    private final Map<String, AndroidDevice> deviceMap;
    @NotNull
    private final Map<String, AndroidTestSuite> testSuiteMap;
    @NotNull
    private final Map<String, AndroidTestCase> testCaseMap;
    @NotNull
    private static final ILogger LOGGER = (ILogger)new LogWrapper(AndroidTestSuiteViewAdaptor.class);

    public AndroidTestSuiteViewAdaptor(@Nullable RunConfiguration runConfiguration) {
        this.runConfiguration = runConfiguration;
        this.parentId = new LinkedHashMap();
        this.deviceMap = new LinkedHashMap();
        this.testSuiteMap = new LinkedHashMap();
        this.testCaseMap = new LinkedHashMap();
    }

    @NotNull
    public final Map<String, String> getParentId() {
        return this.parentId;
    }

    @NotNull
    public final Map<String, AndroidDevice> getDeviceMap() {
        return this.deviceMap;
    }

    @NotNull
    public final Map<String, AndroidTestSuite> getTestSuiteMap() {
        return this.testSuiteMap;
    }

    @NotNull
    public final Map<String, AndroidTestCase> getTestCaseMap() {
        return this.testCaseMap;
    }

    @Override
    public void onBeforeSuite(@NotNull TestSuiteViewAdaptor.TestIdentifier testIdentifier, @NotNull AndroidTestSuiteView executionConsole) {
        Intrinsics.checkNotNullParameter((Object)testIdentifier, (String)"testIdentifier");
        Intrinsics.checkNotNullParameter((Object)executionConsole, (String)"executionConsole");
        if (!Intrinsics.areEqual((Object)testIdentifier.getParentId(), (Object)"")) {
            this.parentId.put(testIdentifier.getId(), testIdentifier.getParentId());
        }
        this.testSuiteMap.computeIfAbsent(testIdentifier.getId(), arg_0 -> AndroidTestSuiteViewAdaptor.onBeforeSuite$lambda$1(arg_0 -> AndroidTestSuiteViewAdaptor.onBeforeSuite$lambda$0(testIdentifier, this, arg_0), arg_0));
    }

    @Override
    public void onBeforeTest(@NotNull TestSuiteViewAdaptor.TestIdentifier testIdentifier, @NotNull AndroidTestSuiteView executionConsole) {
        Intrinsics.checkNotNullParameter((Object)testIdentifier, (String)"testIdentifier");
        Intrinsics.checkNotNullParameter((Object)executionConsole, (String)"executionConsole");
        this.parentId.put(testIdentifier.getId(), testIdentifier.getParentId());
        Pair<String, AndroidDevice> pair = this.getRootTestIdAndDevice(testIdentifier.getId());
        if (pair == null) {
            return;
        }
        Pair<String, AndroidDevice> pair2 = pair;
        String rootTestSuiteId = (String)pair2.component1();
        AndroidDevice device2 = (AndroidDevice)pair2.component2();
        AndroidTestSuite androidTestSuite = this.testSuiteMap.get(rootTestSuiteId);
        if (androidTestSuite == null) {
            return;
        }
        AndroidTestSuite rootTestSuite = androidTestSuite;
        AndroidTestCase androidTestCase = this.testCaseMap.computeIfAbsent(testIdentifier.getId(), arg_0 -> AndroidTestSuiteViewAdaptor.onBeforeTest$lambda$1(arg_0 -> AndroidTestSuiteViewAdaptor.onBeforeTest$lambda$0(testIdentifier, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)androidTestCase, (String)"computeIfAbsent(...)");
        AndroidTestCase testCase = androidTestCase;
        rootTestSuite.setTestCaseCount(rootTestSuite.getTestCaseCount() + 1);
        executionConsole.onTestCaseStarted(device2, rootTestSuite, testCase);
    }

    @Override
    public void onAfterTest(@NotNull TestSuiteViewAdaptor.TestIdentifier testIdentifier, @NotNull OperationResult result2, @NotNull AndroidTestSuiteView executionConsole) {
        Intrinsics.checkNotNullParameter((Object)testIdentifier, (String)"testIdentifier");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Intrinsics.checkNotNullParameter((Object)executionConsole, (String)"executionConsole");
        Pair<String, AndroidDevice> pair = this.getRootTestIdAndDevice(testIdentifier.getId());
        if (pair == null) {
            return;
        }
        Pair<String, AndroidDevice> pair2 = pair;
        String rootTestSuiteId = (String)pair2.component1();
        AndroidDevice device2 = (AndroidDevice)pair2.component2();
        AndroidTestSuite androidTestSuite = this.testSuiteMap.get(rootTestSuiteId);
        if (androidTestSuite == null) {
            return;
        }
        AndroidTestSuite rootTestSuite = androidTestSuite;
        AndroidTestCase androidTestCase = this.testCaseMap.computeIfAbsent(testIdentifier.getId(), arg_0 -> AndroidTestSuiteViewAdaptor.onAfterTest$lambda$1(arg_0 -> AndroidTestSuiteViewAdaptor.onAfterTest$lambda$0(testIdentifier, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)androidTestCase, (String)"computeIfAbsent(...)");
        AndroidTestCase testCase = androidTestCase;
        this.applyResultToTestCase(testCase, result2);
        executionConsole.onTestCaseFinished(device2, rootTestSuite, testCase);
    }

    @Override
    public void onAfterSuite(@NotNull TestSuiteViewAdaptor.TestIdentifier testIdentifier, @NotNull OperationResult result2, @NotNull AndroidTestSuiteView executionConsole) {
        Intrinsics.checkNotNullParameter((Object)testIdentifier, (String)"testIdentifier");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Intrinsics.checkNotNullParameter((Object)executionConsole, (String)"executionConsole");
        Pair<String, AndroidDevice> pair = this.getRootTestIdAndDevice(testIdentifier.getId());
        if (pair == null) {
            return;
        }
        Pair<String, AndroidDevice> pair2 = pair;
        String rootTestId = (String)pair2.component1();
        AndroidDevice device2 = (AndroidDevice)pair2.component2();
        if (!Intrinsics.areEqual((Object)rootTestId, (Object)testIdentifier.getId())) {
            return;
        }
        AndroidTestSuite androidTestSuite = this.testSuiteMap.get(rootTestId);
        if (androidTestSuite == null) {
            return;
        }
        AndroidTestSuite rootTestSuite = androidTestSuite;
        this.applyResultToTestSuite(rootTestSuite, result2);
        executionConsole.onTestSuiteFinished(device2, rootTestSuite);
    }

    @Override
    public void onOutput(@NotNull TestSuiteViewAdaptor.TestIdentifier testIdentifier, @NotNull String output, @NotNull TestSuiteViewAdaptor.OutputContentType contentType, @NotNull AndroidTestSuiteView executionConsole) {
        Intrinsics.checkNotNullParameter((Object)testIdentifier, (String)"testIdentifier");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)((Object)contentType), (String)"contentType");
        Intrinsics.checkNotNullParameter((Object)executionConsole, (String)"executionConsole");
        AndroidTestCase testCase = this.testCaseMap.get(testIdentifier.getId());
        if (testCase != null) {
            Sequence $this$forEach$iv = StringsKt.lineSequence((CharSequence)output);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object object;
                String line = (String)element$iv;
                boolean bl = false;
                if (StringsKt.startsWith$default((String)line, (String)"[additionalTestArtifacts]", (boolean)false, (int)2, null)) {
                    Object[] objectArray = new String[]{"="};
                    Collection collection2 = StringsKt.split$default((CharSequence)StringsKt.substringAfter$default((String)line, (String)"[additionalTestArtifacts]", null, (int)2, null), (String[])objectArray, (boolean)false, (int)2, (int)2, null);
                    objectArray = new String[]{"", ""};
                    object = CollectionsKt.plus((Collection)collection2, (Iterable)CollectionsKt.listOf((Object[])objectArray));
                    String key = (String)object.get(0);
                    String value2 = (String)object.get(1);
                    testCase.getAdditionalTestArtifacts().put(key, value2);
                    continue;
                }
                if (!(!StringsKt.isBlank((CharSequence)line))) continue;
                object = testCase;
                ((AndroidTestCase)object).setLogcat(((AndroidTestCase)object).getLogcat() + line + "\n");
            }
        } else {
            ConsoleViewContentType contentType2 = contentType == TestSuiteViewAdaptor.OutputContentType.STD_OUT ? ConsoleViewContentType.NORMAL_OUTPUT : ConsoleViewContentType.ERROR_OUTPUT;
            Sequence $this$forEach$iv = StringsKt.lineSequence((CharSequence)output);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String line = (String)element$iv;
                boolean bl = false;
                if (StringsKt.startsWith$default((String)line, (String)"[additionalTestArtifacts]", (boolean)false, (int)2, null)) {
                    Object[] objectArray = new String[]{"="};
                    Collection collection3 = StringsKt.split$default((CharSequence)StringsKt.substringAfter$default((String)line, (String)"[additionalTestArtifacts]", null, (int)2, null), (String[])objectArray, (boolean)false, (int)2, (int)2, null);
                    objectArray = new String[]{"", ""};
                    List list2 = CollectionsKt.plus((Collection)collection3, (Iterable)CollectionsKt.listOf((Object[])objectArray));
                    String key = (String)list2.get(0);
                    String value3 = (String)list2.get(1);
                    if (Intrinsics.areEqual((Object)key, (Object)"deviceId")) {
                        AndroidTestSuite testSuite;
                        AndroidDevice device2;
                        Intrinsics.checkNotNullExpressionValue((Object)this.deviceMap.computeIfAbsent(testIdentifier.getId(), arg_0 -> AndroidTestSuiteViewAdaptor.onOutput$lambda$1$1(arg_0 -> AndroidTestSuiteViewAdaptor.onOutput$lambda$1$0(value3, arg_0), arg_0)), (String)"computeIfAbsent(...)");
                        if (this.testSuiteMap.get(testIdentifier.getId()) == null) {
                            return;
                        }
                        executionConsole.onTestSuiteScheduled(device2);
                        executionConsole.onTestSuiteStarted(device2, testSuite);
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)key, (Object)"deviceDisplayName")) continue;
                    AndroidDevice androidDevice = this.deviceMap.get(testIdentifier.getId());
                    if (androidDevice != null) {
                        androidDevice.setDeviceName(value3);
                    }
                    continue;
                }
                if (!(!StringsKt.isBlank((CharSequence)line))) continue;
                Intrinsics.checkNotNull((Object)contentType2);
                executionConsole.print(line, contentType2);
            }
        }
    }

    private final Pair<String, AndroidDevice> getRootTestIdAndDevice(String testId) {
        String id2 = testId;
        AndroidDevice device2 = this.deviceMap.get(id2);
        while (device2 == null && !Intrinsics.areEqual((Object)id2, (Object)"")) {
            String string = this.parentId.get(id2);
            if (string == null) {
                string = "";
            }
            id2 = string;
            device2 = this.deviceMap.get(id2);
        }
        return device2 != null ? TuplesKt.to((Object)id2, (Object)device2) : null;
    }

    private final void applyResultToTestCase(AndroidTestCase testCase, OperationResult result2) {
        testCase.setStartTimestampMillis(result2.getStartTime());
        testCase.setEndTimestampMillis(result2.getEndTime());
        OperationResult operationResult = result2;
        if (operationResult instanceof SuccessResult) {
            testCase.setResult(AndroidTestCaseResult.PASSED);
        } else if (operationResult instanceof SkippedResult) {
            testCase.setResult(AndroidTestCaseResult.SKIPPED);
        } else if (operationResult instanceof FailureResult) {
            testCase.setResult(AndroidTestCaseResult.FAILED);
            Failure failure = (Failure)CollectionsKt.firstOrNull((List)((FailureResult)result2).getFailures());
            if (failure instanceof TestAssertionFailure) {
                String string = ((TestAssertionFailure)failure).getStackTrace();
                if (string == null) {
                    string = "";
                }
                testCase.setErrorStackTrace(string);
            } else if (failure instanceof TestFailure) {
                String string = ((TestFailure)failure).getStackTrace();
                if (string == null) {
                    string = "";
                }
                testCase.setErrorStackTrace(string);
            } else if (failure != null) {
                String string = failure.getMessage();
                if (string == null) {
                    string = "";
                }
                testCase.setErrorStackTrace(string);
            }
        } else {
            LOGGER.warning("Unhandled test result: " + result2, new Object[0]);
        }
    }

    private final void applyResultToTestSuite(AndroidTestSuite testSuite, OperationResult result2) {
        OperationResult operationResult = result2;
        if (operationResult instanceof SuccessResult) {
            testSuite.setResult(AndroidTestSuiteResult.PASSED);
        } else if (operationResult instanceof SkippedResult) {
            testSuite.setResult(AndroidTestSuiteResult.CANCELLED);
        } else if (operationResult instanceof FailureResult) {
            testSuite.setResult(AndroidTestSuiteResult.FAILED);
        } else {
            LOGGER.warning("Unhandled test result: " + result2, new Object[0]);
        }
    }

    private static final AndroidTestSuite onBeforeSuite$lambda$0(TestSuiteViewAdaptor.TestIdentifier $testIdentifier, AndroidTestSuiteViewAdaptor this$0, String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        return new AndroidTestSuite(id2, $testIdentifier.getName(), 0, null, this$0.runConfiguration);
    }

    private static final AndroidTestSuite onBeforeSuite$lambda$1(Function1 $tmp0, Object p0) {
        return (AndroidTestSuite)$tmp0.invoke(p0);
    }

    private static final AndroidTestCase onBeforeTest$lambda$0(TestSuiteViewAdaptor.TestIdentifier $testIdentifier, String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        String methodName = $testIdentifier.getName();
        String className = StringsKt.substringAfterLast$default((String)$testIdentifier.getClassName(), (String)".", null, (int)2, null);
        String packageName = StringsKt.contains$default((CharSequence)$testIdentifier.getClassName(), (CharSequence)".", (boolean)false, (int)2, null) ? StringsKt.substringBeforeLast$default((String)$testIdentifier.getClassName(), (String)".", null, (int)2, null) : "";
        return new AndroidTestCase(id2, methodName, className, packageName, AndroidTestCaseResult.IN_PROGRESS, null, null, null, null, null, null, null, null, 8160, null);
    }

    private static final AndroidTestCase onBeforeTest$lambda$1(Function1 $tmp0, Object p0) {
        return (AndroidTestCase)$tmp0.invoke(p0);
    }

    private static final AndroidTestCase onAfterTest$lambda$0(TestSuiteViewAdaptor.TestIdentifier $testIdentifier, String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        return new AndroidTestCase(id2, $testIdentifier.getName(), StringsKt.substringAfterLast$default((String)$testIdentifier.getClassName(), (String)".", null, (int)2, null), StringsKt.substringBeforeLast$default((String)$testIdentifier.getClassName(), (String)".", null, (int)2, null), null, null, null, null, null, null, null, null, null, 8176, null);
    }

    private static final AndroidTestCase onAfterTest$lambda$1(Function1 $tmp0, Object p0) {
        return (AndroidTestCase)$tmp0.invoke(p0);
    }

    private static final AndroidDevice onOutput$lambda$1$0(String $value, String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        AndroidVersion androidVersion = AndroidVersion.DEFAULT;
        Intrinsics.checkNotNullExpressionValue((Object)androidVersion, (String)"DEFAULT");
        return new AndroidDevice($value, $value, "", AndroidDeviceType.LOCAL_EMULATOR, androidVersion, null, 32, null);
    }

    private static final AndroidDevice onOutput$lambda$1$1(Function1 $tmp0, Object p0) {
        return (AndroidDevice)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/testartifacts/testsuite/temp/AndroidTestSuiteViewAdaptor$Companion;", "", "<init>", "()V", "LOGGER", "Lcom/android/utils/ILogger;", "getLOGGER", "()Lcom/android/utils/ILogger;", "intellij.android.projectSystem.gradle"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ILogger getLOGGER() {
            return LOGGER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

