/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.instrumented.testsuite.view;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.testartifacts.instrumented.testsuite.view.ImageWithToolbarPanel;
import com.android.tools.idea.testartifacts.instrumented.testsuite.view.ScreenshotViewType;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0005*\u0001\f\b\u0007\u0018\u0000 T2\u00020\u0001:\u0001TB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010A\u001a\u00020BJ\u0006\u0010C\u001a\u00020BJ\u0006\u0010D\u001a\u00020BJ\u0006\u0010E\u001a\u00020BJ\u000e\u0010F\u001a\u00020B2\u0006\u0010G\u001a\u00020\u0005J\u0006\u0010H\u001a\u00020\u0005J\u000e\u0010I\u001a\u00020B2\u0006\u0010G\u001a\u00020\u0005J\u0006\u0010J\u001a\u00020\u0005J\u0006\u0010K\u001a\u00020\u0005J\u0006\u0010L\u001a\u00020\u0005J\u0006\u0010M\u001a\u00020\u0005J\u0010\u0010N\u001a\u00020B2\u0006\u0010O\u001a\u00020PH\u0007J\u0012\u0010Q\u001a\u00020B2\b\u0010R\u001a\u0004\u0018\u00010\u001cH\u0007J\b\u0010S\u001a\u00020BH\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0015\u001a\u00020\u00168\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001d\u001a\u00020\u001e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u001f\u0010\u0018\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R$\u0010$\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b%\u0010\u0018\u001a\u0004\b$\u0010&\"\u0004\b'\u0010(R\u001c\u0010)\u001a\u00020*8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b+\u0010\u0018\u001a\u0004\b,\u0010-R\u001c\u0010.\u001a\u00020*8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b/\u0010\u0018\u001a\u0004\b0\u0010-R\u001c\u00101\u001a\u00020*8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b2\u0010\u0018\u001a\u0004\b3\u0010-R\u001c\u00104\u001a\u00020*8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b5\u0010\u0018\u001a\u0004\b6\u0010-R\u001c\u00107\u001a\u0002088\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b9\u0010\u0018\u001a\u0004\b:\u0010;R\u001c\u0010<\u001a\u0002088\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b=\u0010\u0018\u001a\u0004\b>\u0010;R\u000e\u0010?\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006U"}, d2={"Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/ImageWithToolbarPanel;", "Ljavax/swing/JPanel;", "title", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/ScreenshotViewType;", "showToolbar", "", "showTitle", "<init>", "(Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/ScreenshotViewType;ZZ)V", "getTitle", "()Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/ScreenshotViewType;", "imageLabel", "com/android/tools/idea/testartifacts/instrumented/testsuite/view/ImageWithToolbarPanel$imageLabel$1", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/ImageWithToolbarPanel$imageLabel$1;", "placeholderLabel", "Lcom/intellij/ui/components/JBLabel;", "scrollPane", "Ljavax/swing/JScrollPane;", "getScrollPane", "()Ljavax/swing/JScrollPane;", "imageContainer", "toolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "getToolbar$annotations", "()V", "getToolbar", "()Lcom/intellij/openapi/actionSystem/ActionToolbar;", "originalImage", "Ljava/awt/image/BufferedImage;", "currentScale", "", "getCurrentScale$annotations", "getCurrentScale", "()D", "setCurrentScale", "(D)V", "isAutoFitting", "isAutoFitting$annotations", "()Z", "setAutoFitting", "(Z)V", "zoomInAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "getZoomInAction$annotations", "getZoomInAction", "()Lcom/intellij/openapi/actionSystem/AnAction;", "zoomOutAction", "getZoomOutAction$annotations", "getZoomOutAction", "oneToOneAction", "getOneToOneAction$annotations", "getOneToOneAction", "fitToScreenAction", "getFitToScreenAction$annotations", "getFitToScreenAction", "toggleGridViewAction", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "getToggleGridViewAction$annotations", "getToggleGridViewAction", "()Lcom/intellij/openapi/actionSystem/ToggleAction;", "toggleChessboardAction", "getToggleChessboardAction$annotations", "getToggleChessboardAction", "dynamicMinScale", "dynamicMaxScale", "zoomIn", "", "zoomOut", "setActualSize", "fitToScreen", "setGridVisible", "visible", "isGridVisible", "setChessboardVisible", "isChessboardVisible", "canZoomIn", "canZoomOut", "hasImage", "setPlaceholder", "text", "", "setImage", "image", "updateImage", "Companion", "intellij.android.testartifacts"})
@StabilityInferred(parameters=0)
public final class ImageWithToolbarPanel
extends JPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ScreenshotViewType title;
    @NotNull
    private final imageLabel.1 imageLabel;
    @NotNull
    private final JBLabel placeholderLabel;
    @NotNull
    private final JScrollPane scrollPane;
    @NotNull
    private final JPanel imageContainer;
    @NotNull
    private final ActionToolbar toolbar;
    @Nullable
    private BufferedImage originalImage;
    private double currentScale;
    private boolean isAutoFitting;
    @NotNull
    private final AnAction zoomInAction;
    @NotNull
    private final AnAction zoomOutAction;
    @NotNull
    private final AnAction oneToOneAction;
    @NotNull
    private final AnAction fitToScreenAction;
    @NotNull
    private final ToggleAction toggleGridViewAction;
    @NotNull
    private final ToggleAction toggleChessboardAction;
    private double dynamicMinScale;
    private double dynamicMaxScale;
    public static final int $stable = 8;
    private static final double ZOOM_FACTOR = 1.2;
    private static final double MAX_ZOOM_FACTOR_BEYOND_ANCHOR = 2.5;
    private static final double MIN_ZOOM_FACTOR_BEYOND_ANCHOR = 2.5;

    /*
     * WARNING - void declaration
     */
    public ImageWithToolbarPanel(@NotNull ScreenshotViewType title2, boolean showToolbar, boolean showTitle) {
        void $this$_init__u24lambda_u241;
        DefaultActionGroup $this$placeholderLabel_u24lambda_u240;
        JBLabel $this$imageLabel_u24lambda_u240;
        Object object;
        Intrinsics.checkNotNullParameter((Object)((Object)title2), (String)"title");
        super(new BorderLayout(0, 4));
        this.title = title2;
        JBLabel jBLabel = object = new JBLabel(this){
            private boolean gridVisible;
            private boolean chessboardVisible;
            final /* synthetic */ ImageWithToolbarPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public final void setGridVisible(boolean visible) {
                if (this.gridVisible != visible) {
                    this.gridVisible = visible;
                    this.repaint();
                }
            }

            public final boolean isGridVisible() {
                return this.gridVisible;
            }

            public final void setChessboardVisible(boolean visible) {
                if (this.chessboardVisible != visible) {
                    this.chessboardVisible = visible;
                    this.repaint();
                }
            }

            public final boolean isChessboardVisible() {
                return this.chessboardVisible;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void paintComponent(Graphics g) {
                int y;
                Graphics2D g2d;
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                if (this.chessboardVisible) {
                    Graphics graphics = g.create();
                    Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
                    g2d = (Graphics2D)graphics;
                    try {
                        Color color = UIUtil.getPanelBackground();
                        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getPanelBackground(...)");
                        Color color1 = color;
                        Color color2 = JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground();
                        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"separatorForeground(...)");
                        Color color22 = color2;
                        int squareSize = 8;
                        for (int x = 0; x < this.getWidth(); x += squareSize) {
                            for (y = 0; y < this.getHeight(); y += squareSize) {
                                g2d.setColor((x / squareSize + y / squareSize) % 2 == 0 ? color1 : color22);
                                g2d.fillRect(x, y, squareSize, squareSize);
                            }
                        }
                    }
                    finally {
                        g2d.dispose();
                    }
                }
                super.paintComponent(g);
                if (this.getIcon() == null) {
                    return;
                }
                Graphics graphics = g.create();
                Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
                g2d = (Graphics2D)graphics;
                try {
                    int iconX = (this.getWidth() - this.getIcon().getIconWidth()) / 2;
                    int iconY = (this.getHeight() - this.getIcon().getIconHeight()) / 2;
                    if (this.this$0.getTitle() == ScreenshotViewType.DIFF) {
                        g2d.setColor(JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground());
                        g2d.drawRect(iconX, iconY, this.getIcon().getIconWidth() - 1, this.getIcon().getIconHeight() - 1);
                    }
                    if (this.gridVisible) {
                        g2d.translate(iconX, iconY);
                        g2d.setColor(new Color(128, 128, 128, 128));
                        int gridSize = RangesKt.coerceAtLeast((int)((int)((double)20 * this.this$0.getCurrentScale())), (int)1);
                        int n = this.getIcon().getIconWidth();
                        if (gridSize <= 0) {
                            throw new IllegalArgumentException("Step must be positive, was: " + gridSize + ".");
                        }
                        int x = 0;
                        int n2 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n, (int)gridSize);
                        if (x <= n2) {
                            while (true) {
                                g2d.drawLine(x, 0, x, this.getIcon().getIconHeight());
                                if (x == n2) break;
                                x += gridSize;
                            }
                        }
                        n = this.getIcon().getIconHeight();
                        if (gridSize <= 0) {
                            throw new IllegalArgumentException("Step must be positive, was: " + gridSize + ".");
                        }
                        y = 0;
                        n2 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n, (int)gridSize);
                        if (y <= n2) {
                            while (true) {
                                g2d.drawLine(0, y, this.getIcon().getIconWidth(), y);
                                if (y != n2) {
                                    y += gridSize;
                                    continue;
                                }
                                break;
                            }
                        }
                    }
                }
                finally {
                    g2d.dispose();
                }
            }
        };
        ImageWithToolbarPanel imageWithToolbarPanel = this;
        boolean bl = false;
        $this$imageLabel_u24lambda_u240.setHorizontalAlignment(0);
        imageWithToolbarPanel.imageLabel = object;
        $this$imageLabel_u24lambda_u240 = object = new JBLabel();
        imageWithToolbarPanel = this;
        boolean bl2 = false;
        $this$placeholderLabel_u24lambda_u240.setHorizontalAlignment(0);
        $this$placeholderLabel_u24lambda_u240.setVerticalAlignment(0);
        imageWithToolbarPanel.placeholderLabel = object;
        this.scrollPane = new JScrollPane();
        this.imageContainer = new JPanel(new BorderLayout());
        this.currentScale = 1.0;
        object = AllIcons.General.ZoomIn;
        this.zoomInAction = new AnAction(this, (Icon)object){
            final /* synthetic */ ImageWithToolbarPanel this$0;
            {
                this.this$0 = $receiver;
                super("Zoom In", null, $super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.zoomIn();
            }

            public void update(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.getPresentation().setEnabled(this.this$0.canZoomIn());
            }
        };
        object = AllIcons.General.ZoomOut;
        this.zoomOutAction = new AnAction(this, (Icon)object){
            final /* synthetic */ ImageWithToolbarPanel this$0;
            {
                this.this$0 = $receiver;
                super("Zoom Out", null, $super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.zoomOut();
            }

            public void update(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.getPresentation().setEnabled(this.this$0.canZoomOut());
            }
        };
        object = AllIcons.General.ActualZoom;
        this.oneToOneAction = new AnAction(this, (Icon)object){
            final /* synthetic */ ImageWithToolbarPanel this$0;
            {
                this.this$0 = $receiver;
                super("1:1", "Actual Size", $super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.setActualSize();
            }

            public void update(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.getPresentation().setEnabled(this.this$0.hasImage());
            }
        };
        object = AllIcons.General.FitContent;
        this.fitToScreenAction = new AnAction(this, (Icon)object){
            final /* synthetic */ ImageWithToolbarPanel this$0;
            {
                this.this$0 = $receiver;
                super("Fit to Screen", "Fit image to screen", $super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.fitToScreen();
            }

            public void update(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.getPresentation().setEnabled(this.this$0.hasImage());
            }
        };
        object = AllIcons.Graph.Grid;
        this.toggleGridViewAction = new ToggleAction(this, (Icon)object){
            final /* synthetic */ ImageWithToolbarPanel this$0;
            {
                this.this$0 = $receiver;
                super("Grid", "Toggle Grid Overlay", $super_call_param$1);
            }

            public boolean isSelected(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                return this.this$0.isGridVisible();
            }

            public void setSelected(AnActionEvent e, boolean state2) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.setGridVisible(state2);
            }

            public void update(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.getPresentation().setEnabled(this.this$0.hasImage());
            }
        };
        object = IconLoader.getIcon((String)"/org/intellij/images/icons/expui/chessboard.svg", ImageWithToolbarPanel.class);
        this.toggleChessboardAction = new ToggleAction(this, (Icon)object){
            final /* synthetic */ ImageWithToolbarPanel this$0;
            {
                this.this$0 = $receiver;
                super("Chessboard", "Toggle Chessboard Background", $super_call_param$1);
            }

            public boolean isSelected(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                return this.this$0.isChessboardVisible();
            }

            public void setSelected(AnActionEvent e, boolean state2) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.setChessboardVisible(state2);
            }

            public void update(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.getPresentation().setEnabled(this.this$0.hasImage());
            }
        };
        this.dynamicMinScale = 0.1;
        this.dynamicMaxScale = 8.0;
        this.setBorder((Border)JBUI.Borders.empty((int)(showTitle ? 10 : 0), (int)10, (int)10, (int)10));
        DefaultActionGroup $this$_init__u24lambda_u240 = $this$placeholderLabel_u24lambda_u240 = new DefaultActionGroup();
        boolean bl3 = false;
        $this$_init__u24lambda_u240.add((AnAction)this.toggleChessboardAction);
        $this$_init__u24lambda_u240.add((AnAction)this.toggleGridViewAction);
        $this$_init__u24lambda_u240.addSeparator();
        $this$_init__u24lambda_u240.add(this.zoomOutAction);
        $this$_init__u24lambda_u240.add(this.zoomInAction);
        $this$_init__u24lambda_u240.add(this.oneToOneAction);
        $this$_init__u24lambda_u240.add(this.fitToScreenAction);
        DefaultActionGroup actionGroup2 = $this$placeholderLabel_u24lambda_u240;
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("ScreenshotImageToolbar", (ActionGroup)actionGroup2, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        $this$_init__u24lambda_u240 = $this$placeholderLabel_u24lambda_u240 = actionToolbar;
        imageWithToolbarPanel = this;
        boolean bl4 = false;
        $this$_init__u24lambda_u241.setTargetComponent((JComponent)this);
        imageWithToolbarPanel.toolbar = $this$placeholderLabel_u24lambda_u240;
        if (showTitle || showToolbar) {
            JPanel headerPanel2 = new JPanel(new BorderLayout());
            if (showTitle) {
                JBLabel titleLabel = new JBLabel(this.title.getDisplayText(), UIUtil.ComponentStyle.LARGE);
                titleLabel.setHorizontalAlignment(2);
                headerPanel2.add((Component)titleLabel, "North");
            }
            if (showToolbar) {
                JPanel toolbarWrapper = new JPanel(new FlowLayout(0, 0, 0));
                toolbarWrapper.add(this.toolbar.getComponent());
                headerPanel2.add((Component)toolbarWrapper, "South");
            }
            this.add((Component)headerPanel2, "North");
        }
        this.imageContainer.setOpaque(false);
        this.imageContainer.add((Component)((Object)this.imageLabel), "Center");
        this.add((Component)this.scrollPane, "Center");
        this.scrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (this.isAutoFitting()) {
                    this.fitToScreen();
                }
            }
        });
    }

    @NotNull
    public final ScreenshotViewType getTitle() {
        return this.title;
    }

    @NotNull
    public final JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    @NotNull
    public final ActionToolbar getToolbar() {
        return this.toolbar;
    }

    @VisibleForTesting
    public static /* synthetic */ void getToolbar$annotations() {
    }

    public final double getCurrentScale() {
        return this.currentScale;
    }

    public final void setCurrentScale(double d) {
        this.currentScale = d;
    }

    @VisibleForTesting
    public static /* synthetic */ void getCurrentScale$annotations() {
    }

    public final boolean isAutoFitting() {
        return this.isAutoFitting;
    }

    public final void setAutoFitting(boolean bl) {
        this.isAutoFitting = bl;
    }

    @VisibleForTesting
    public static /* synthetic */ void isAutoFitting$annotations() {
    }

    @NotNull
    public final AnAction getZoomInAction() {
        return this.zoomInAction;
    }

    @VisibleForTesting
    public static /* synthetic */ void getZoomInAction$annotations() {
    }

    @NotNull
    public final AnAction getZoomOutAction() {
        return this.zoomOutAction;
    }

    @VisibleForTesting
    public static /* synthetic */ void getZoomOutAction$annotations() {
    }

    @NotNull
    public final AnAction getOneToOneAction() {
        return this.oneToOneAction;
    }

    @VisibleForTesting
    public static /* synthetic */ void getOneToOneAction$annotations() {
    }

    @NotNull
    public final AnAction getFitToScreenAction() {
        return this.fitToScreenAction;
    }

    @VisibleForTesting
    public static /* synthetic */ void getFitToScreenAction$annotations() {
    }

    @NotNull
    public final ToggleAction getToggleGridViewAction() {
        return this.toggleGridViewAction;
    }

    @VisibleForTesting
    public static /* synthetic */ void getToggleGridViewAction$annotations() {
    }

    @NotNull
    public final ToggleAction getToggleChessboardAction() {
        return this.toggleChessboardAction;
    }

    @VisibleForTesting
    public static /* synthetic */ void getToggleChessboardAction$annotations() {
    }

    public final void zoomIn() {
        this.isAutoFitting = false;
        this.currentScale = RangesKt.coerceAtMost((double)(this.currentScale * 1.2), (double)this.dynamicMaxScale);
        this.updateImage();
    }

    public final void zoomOut() {
        this.isAutoFitting = false;
        this.currentScale = RangesKt.coerceAtLeast((double)(this.currentScale / 1.2), (double)this.dynamicMinScale);
        this.updateImage();
    }

    public final void setActualSize() {
        this.isAutoFitting = false;
        this.currentScale = 1.0;
        this.updateImage();
    }

    public final void fitToScreen() {
        this.isAutoFitting = true;
        BufferedImage bufferedImage = this.originalImage;
        if (bufferedImage == null) {
            return;
        }
        BufferedImage image = bufferedImage;
        Dimension viewSize = this.scrollPane.getViewport().getExtentSize();
        if (viewSize.width <= 0 || viewSize.height <= 0 || image.getWidth() <= 0 || image.getHeight() <= 0) {
            return;
        }
        double widthScale = (double)viewSize.width / (double)image.getWidth();
        double heightScale = (double)viewSize.height / (double)image.getHeight();
        double fitScale = Math.min(widthScale, heightScale);
        double actualScale = 1.0;
        this.dynamicMaxScale = Math.max(fitScale, actualScale) * 2.5;
        this.dynamicMinScale = Math.min(fitScale, actualScale) / 2.5;
        this.currentScale = fitScale;
        this.updateImage();
    }

    public final void setGridVisible(boolean visible) {
        this.imageLabel.setGridVisible(visible);
    }

    public final boolean isGridVisible() {
        return this.imageLabel.isGridVisible();
    }

    public final void setChessboardVisible(boolean visible) {
        this.imageLabel.setChessboardVisible(visible);
    }

    public final boolean isChessboardVisible() {
        return this.imageLabel.isChessboardVisible();
    }

    public final boolean canZoomIn() {
        return this.originalImage != null && this.currentScale < this.dynamicMaxScale;
    }

    public final boolean canZoomOut() {
        return this.originalImage != null && this.currentScale > this.dynamicMinScale;
    }

    public final boolean hasImage() {
        return this.originalImage != null;
    }

    @UiThread
    public final void setPlaceholder(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.placeholderLabel.setText(text2);
    }

    @UiThread
    public final void setImage(@Nullable BufferedImage image) {
        this.originalImage = image;
        if (image == null) {
            this.imageLabel.setIcon(null);
            this.scrollPane.setViewportView((Component)this.placeholderLabel);
            if (this.toolbar.getComponent().isDisplayable()) {
                this.toolbar.updateActionsAsync();
            }
        } else {
            this.scrollPane.setViewportView(this.imageContainer);
            this.isAutoFitting = true;
            this.fitToScreen();
        }
        this.revalidate();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    private final void updateImage() {
        BufferedImage bufferedImage = this.originalImage;
        if (bufferedImage == null) {
            return;
        }
        BufferedImage image = bufferedImage;
        int newWidth = (int)((double)image.getWidth() * this.currentScale);
        int newHeight = (int)((double)image.getHeight() * this.currentScale);
        if (newWidth > 0 && newHeight > 0) {
            int imageType = image.getType() == 0 ? 2 : image.getType();
            BufferedImage scaledImage = new BufferedImage(newWidth, newHeight, imageType);
            Graphics2D g2d = scaledImage.createGraphics();
            try {
                g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g2d.drawImage(image, 0, 0, newWidth, newHeight, null);
            }
            finally {
                g2d.dispose();
            }
            this.imageLabel.setIcon(new ImageIcon(scaledImage));
        }
        if (this.toolbar.getComponent().isDisplayable()) {
            this.toolbar.updateActionsAsync();
        }
        this.scrollPane.revalidate();
        this.scrollPane.repaint();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/ImageWithToolbarPanel$Companion;", "", "<init>", "()V", "ZOOM_FACTOR", "", "MAX_ZOOM_FACTOR_BEYOND_ANCHOR", "MIN_ZOOM_FACTOR_BEYOND_ANCHOR", "intellij.android.testartifacts"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

