/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.instrumented.testsuite.adapter;

import com.google.testing.platform.proto.api.core.TestArtifactProto;
import com.google.testing.platform.proto.api.core.TestResultProto;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\t\u001a\u0004\u0018\u00010\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\b\b\u0002\u0010\r\u001a\u00020\bJ$\u0010\t\u001a\u0004\u0018\u00010\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fJ&\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fH\u0002J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0014\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/testartifacts/instrumented/testsuite/adapter/ArtifactFileResolver;", "", "parentDir", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "relativePathToFile", "", "", "getArtifactFile", "testResult", "Lcom/google/testing/platform/proto/api/core/TestResultProto$TestResult;", "label", "namespace", "filterFunc", "Lkotlin/Function1;", "Lcom/google/testing/platform/proto/api/core/TestArtifactProto$Artifact;", "", "getRelativePath", "resolveFile", "relativePath", "intellij.android.testartifacts"})
final class ArtifactFileResolver {
    @NotNull
    private final File parentDir;
    @NotNull
    private final Map<String, File> relativePathToFile;

    public ArtifactFileResolver(@NotNull File parentDir) {
        Intrinsics.checkNotNullParameter((Object)parentDir, (String)"parentDir");
        this.parentDir = parentDir;
        this.relativePathToFile = new LinkedHashMap();
    }

    @Nullable
    public final File getArtifactFile(@NotNull TestResultProto.TestResult testResult, @NotNull String label2, @NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)testResult, (String)"testResult");
        Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        return this.getArtifactFile(testResult, (Function1<? super TestArtifactProto.Artifact, Boolean>)((Function1)arg_0 -> ArtifactFileResolver.getArtifactFile$lambda$0(label2, namespace, arg_0)));
    }

    public static /* synthetic */ File getArtifactFile$default(ArtifactFileResolver artifactFileResolver, TestResultProto.TestResult testResult, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = "android";
        }
        return artifactFileResolver.getArtifactFile(testResult, string, string2);
    }

    @Nullable
    public final File getArtifactFile(@NotNull TestResultProto.TestResult testResult, @NotNull Function1<? super TestArtifactProto.Artifact, Boolean> filterFunc) {
        Intrinsics.checkNotNullParameter((Object)testResult, (String)"testResult");
        Intrinsics.checkNotNullParameter(filterFunc, (String)"filterFunc");
        String string = this.getRelativePath(testResult, filterFunc);
        if (string == null) {
            return null;
        }
        String relativePath = string;
        return this.relativePathToFile.computeIfAbsent(relativePath, arg_0 -> ArtifactFileResolver.getArtifactFile$lambda$2(arg_0 -> ArtifactFileResolver.getArtifactFile$lambda$1(this, arg_0), arg_0));
    }

    private final String getRelativePath(TestResultProto.TestResult testResult, Function1<? super TestArtifactProto.Artifact, Boolean> filterFunc) {
        List list2 = testResult.getOutputArtifactList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getOutputArtifactList(...)");
        return (String)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)list2), filterFunc), ArtifactFileResolver::getRelativePath$lambda$0));
    }

    @Nullable
    public final File resolveFile(@NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        if (FileUtil.exists((String)relativePath)) {
            return new File(relativePath);
        }
        File file2 = FilesKt.resolve((File)this.parentDir, (String)relativePath);
        if (file2.exists()) {
            return file2;
        }
        String string = new File(relativePath).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        File file3 = FilesKt.resolve((File)this.parentDir, (String)string);
        if (file3.exists()) {
            return file3;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getArtifactFile$lambda$0(String $label, String $namespace, TestArtifactProto.Artifact artifact) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        if (!Intrinsics.areEqual((Object)artifact.getLabel().getLabel(), (Object)$label)) return false;
        if (!Intrinsics.areEqual((Object)artifact.getLabel().getNamespace(), (Object)$namespace)) return false;
        String string = artifact.getSourcePath().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        if (StringsKt.isBlank((CharSequence)string)) return false;
        return true;
    }

    private static final File getArtifactFile$lambda$1(ArtifactFileResolver this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.resolveFile(it);
    }

    private static final File getArtifactFile$lambda$2(Function1 $tmp0, Object p0) {
        return (File)$tmp0.invoke(p0);
    }

    private static final String getRelativePath$lambda$0(TestArtifactProto.Artifact artifact) {
        return artifact.getSourcePath().getPath();
    }
}

