/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.gradle.dsl.api.util.LanguageLevelUtil;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.impl.SdkVersionUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.lang.JavaVersion;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.android.uipreview.EditorUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.jps.model.java.JdkVersionDetector;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\r2\b\b\u0002\u0010\u0013\u001a\u00020\u000fH\u0007J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\rH\u0007J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\rH\u0007J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\rH\u0007Jg\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\r2M\b\u0002\u0010\u001c\u001aG\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b(\u001a\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b( \u0012\u0004\u0012\u00020\u000f0\u001dH\u0007J \u0010\u001c\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\rH\u0003J\u0018\u0010#\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010$\u001a\u00020\u0011H\u0007J\u001a\u0010%\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010&\u001a\u00020\u0011H\u0007J\u0012\u0010'\u001a\u0004\u0018\u00010\u00112\u0006\u0010(\u001a\u00020)H\u0007R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/android/tools/idea/templates/TemplateUtils;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "openEditors", "", "project", "Lcom/intellij/openapi/project/Project;", "files", "", "Ljava/io/File;", "select", "", "readTextFromDisk", "", "file", "warnIfNotExists", "readTextFromDocument", "Lcom/intellij/openapi/vfs/VirtualFile;", "checkedCreateDirectoryIfMissing", "directory", "checkDirectoryIsWriteable", "copyDirectory", "src", "dest", "copyFile", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "destination", "fileToCopy", "parent", "hasExtension", "extension", "getJavaVersion", "defaultVersion", "convertJavaVersionToGradleString", "javaVersion", "Lcom/intellij/util/lang/JavaVersion;", "intellij.android.templates"})
@SourceDebugExtension(value={"SMAP\nTemplateUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TemplateUtils.kt\ncom/android/tools/idea/templates/TemplateUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,293:1\n774#2:294\n865#2,2:295\n1617#2,9:297\n1869#2:306\n1870#2:308\n1626#2:309\n1869#2,2:310\n1#3:307\n1#3:312\n123#4:313\n112#4,5:314\n*S KotlinDebug\n*F\n+ 1 TemplateUtils.kt\ncom/android/tools/idea/templates/TemplateUtils\n*L\n66#1:294\n66#1:295,2\n67#1:297,9\n67#1:306\n67#1:308\n67#1:309\n68#1:310,2\n67#1:307\n220#1:313\n220#1:314,5\n*E\n"})
public final class TemplateUtils {
    @NotNull
    public static final TemplateUtils INSTANCE = new TemplateUtils();
    @NotNull
    private static final Logger LOG;

    private TemplateUtils() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void openEditors(@NotNull Project project, @NotNull Collection<? extends File> files2, boolean select) {
        void $this$forEach$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        VirtualFile last = null;
        Iterable iterable = files2;
        boolean $i$f$filter = false;
        Iterator iterator2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File p0 = (File)element$iv$iv;
            boolean bl = false;
            if (!p0.exists()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
        while (iterator3.hasNext()) {
            VirtualFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator3.next();
            boolean bl = false;
            File it = (File)element$iv$iv;
            boolean bl2 = false;
            if (VfsUtil.findFileByIoFile((File)it, (boolean)true) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile it = (VirtualFile)element$iv;
            boolean bl = false;
            last = it;
            EditorUtil.openEditor(project, it);
        }
        if (select && last != null) {
            EditorUtil.selectEditor(project, last);
        }
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final String readTextFromDisk(@NotNull File file, boolean warnIfNotExists) {
        String string;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        boolean bl = file.isAbsolute();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        try {
            string = Files.asCharSource((File)file, (Charset)Charsets.UTF_8).read();
        }
        catch (IOException e) {
            if (warnIfNotExists) {
                LOG.warn((Throwable)e);
            }
            string = null;
        }
        return string;
    }

    public static /* synthetic */ String readTextFromDisk$default(File file, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return TemplateUtils.readTextFromDisk(file, bl);
    }

    @JvmStatic
    @Nullable
    public static final String readTextFromDocument(@NotNull Project project, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        boolean bl = project.isInitialized();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(file);
        if (vFile == null) {
            LOG.debug("Cannot find file " + file.getPath() + " in the VFS");
            return null;
        }
        return TemplateUtils.readTextFromDocument(project, vFile);
    }

    @JvmStatic
    @Nullable
    public static final String readTextFromDocument(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        boolean bl = project.isInitialized();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        return (String)ApplicationManager.getApplication().runReadAction(() -> TemplateUtils.readTextFromDocument$lambda$0(file));
    }

    @JvmStatic
    @NotNull
    public static final VirtualFile checkedCreateDirectoryIfMissing(@NotNull File directory) throws IOException {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Object object = WriteCommandAction.runWriteCommandAction(null, () -> TemplateUtils.checkedCreateDirectoryIfMissing$lambda$0(directory));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runWriteCommandAction(...)");
        return (VirtualFile)object;
    }

    @JvmStatic
    public static final void checkDirectoryIsWriteable(@NotNull File directory) throws IOException {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        File d = directory;
        while (!d.exists() || !d.isDirectory()) {
            Intrinsics.checkNotNullExpressionValue((Object)d.getParentFile(), (String)"getParentFile(...)");
        }
        if (!d.canWrite()) {
            throw new IOException("Cannot write to folder: " + d.getAbsolutePath());
        }
    }

    @JvmStatic
    @UiThread
    @JvmOverloads
    public static final void copyDirectory(@NotNull VirtualFile src, @NotNull File dest, @NotNull Function3<? super VirtualFile, ? super VirtualFile, ? super File, Boolean> copyFile) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        Intrinsics.checkNotNullParameter(copyFile, (String)"copyFile");
        VirtualFileVisitor.Option[] optionArray = new VirtualFileVisitor.Option[]{};
        VfsUtilCore.visitChildrenRecursively((VirtualFile)src, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Object>(copyFile, src, dest, optionArray){
            final /* synthetic */ Function3<VirtualFile, VirtualFile, File, Boolean> $copyFile;
            final /* synthetic */ VirtualFile $src;
            final /* synthetic */ File $dest;
            {
                this.$copyFile = $copyFile;
                this.$src = $src;
                this.$dest = $dest;
                super($super_call_param$1);
            }

            public boolean visitFile(VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                try {
                    return (Boolean)this.$copyFile.invoke((Object)file, (Object)this.$src, (Object)this.$dest);
                }
                catch (IOException e) {
                    throw new VirtualFileVisitor.VisitorException((Throwable)e);
                }
            }
        }), IOException.class);
    }

    public static /* synthetic */ void copyDirectory$default(VirtualFile virtualFile, File file, Function3 function3, int n, Object object) {
        if ((n & 4) != 0) {
            function3 = (Function3)new Function3<VirtualFile, VirtualFile, File, Boolean>((Object)INSTANCE){

                public final Boolean invoke(VirtualFile p0, VirtualFile p1, File p2) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                    return TemplateUtils.access$copyFile(p0, p1, p2);
                }
            };
        }
        TemplateUtils.copyDirectory(virtualFile, file, (Function3<? super VirtualFile, ? super VirtualFile, ? super File, Boolean>)function3);
    }

    @JvmStatic
    @UiThread
    private static final boolean copyFile(VirtualFile fileToCopy, VirtualFile parent, File destination) {
        VirtualFile targetVf;
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)fileToCopy, (VirtualFile)parent, (char)File.separatorChar);
        if (!(relativePath != null)) {
            boolean $i$a$-check-TemplateUtils$copyFile$22 = false;
            String $i$a$-check-TemplateUtils$copyFile$22 = fileToCopy.getPath() + " is not a child of " + parent;
            throw new IllegalStateException($i$a$-check-TemplateUtils$copyFile$22.toString());
        }
        if (fileToCopy.isDirectory()) {
            TemplateUtils.checkedCreateDirectoryIfMissing(new File(destination, relativePath));
            return true;
        }
        File target2 = new File(destination, relativePath);
        File file = target2.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
        VirtualFile toDir = TemplateUtils.checkedCreateDirectoryIfMissing(file);
        VirtualFile virtualFile = targetVf = LocalFileSystem.getInstance().findFileByIoFile(target2);
        boolean bl = virtualFile != null ? virtualFile.exists() : false;
        if (bl) {
            return false;
        }
        VfsUtilCore.copyFile((Object)INSTANCE, (VirtualFile)fileToCopy, (VirtualFile)toDir);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final boolean hasExtension(@NotNull File file, @NotNull String extension) {
        CharSequence charSequence;
        String string;
        block1: {
            void $this$trimStart$iv;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
            String string2 = extension;
            string = Files.getFileExtension((String)file.getName());
            boolean $i$f$trimStart = false;
            CharSequence $this$trimStart$iv$iv = (CharSequence)$this$trimStart$iv;
            boolean $i$f$trimStart2 = false;
            int n = $this$trimStart$iv$iv.length();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                char it = $this$trimStart$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                if (it == '.') continue;
                charSequence = $this$trimStart$iv$iv.subSequence(index$iv$iv, $this$trimStart$iv$iv.length());
                break block1;
            }
            charSequence = "";
        }
        return StringsKt.equals((String)string, (String)((Object)charSequence).toString(), (boolean)true);
    }

    @JvmStatic
    @NotNull
    public static final String getJavaVersion(@NotNull Project project, @NotNull String defaultVersion) {
        Object object;
        block8: {
            block7: {
                JavaVersion javaVersion;
                Object object2;
                String jvmPath;
                String string;
                String it;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)defaultVersion, (String)"defaultVersion");
                String string2 = project.getBasePath();
                if (string2 != null) {
                    it = string2;
                    boolean bl = false;
                    string = GradleInstallationManager.Companion.getInstance().getGradleJvmPath(project, it);
                } else {
                    string = null;
                }
                String string3 = jvmPath = string;
                if (string3 != null) {
                    it = string3;
                    boolean bl = false;
                    JdkVersionDetector.JdkVersionInfo jdkVersionInfo = SdkVersionUtil.getJdkVersionInfo((String)it);
                    object2 = jdkVersionInfo != null ? jdkVersionInfo.version : null;
                } else {
                    object2 = null;
                }
                if ((object = (javaVersion = object2)) == null) break block7;
                JavaVersion it2 = object;
                boolean bl = false;
                String string4 = TemplateUtils.convertJavaVersionToGradleString(it2);
                object = string4;
                if (string4 != null) break block8;
            }
            object = defaultVersion;
        }
        return object;
    }

    public static /* synthetic */ String getJavaVersion$default(Project project, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "JavaVersion.VERSION_17";
        }
        return TemplateUtils.getJavaVersion(project, string);
    }

    @JvmStatic
    @VisibleForTesting
    @Nullable
    public static final String convertJavaVersionToGradleString(@NotNull JavaVersion javaVersion) {
        String string;
        LanguageLevel languageLevel;
        Intrinsics.checkNotNullParameter((Object)javaVersion, (String)"javaVersion");
        LanguageLevel languageLevel2 = languageLevel = LanguageLevel.Companion.parse(javaVersion.toString());
        if (languageLevel2 != null) {
            LanguageLevel it = languageLevel2;
            boolean bl = false;
            string = LanguageLevelUtil.convertToGradleString(it, "JavaVersion.VERSION_17").toString();
        } else {
            string = null;
        }
        return string;
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final String readTextFromDisk(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return TemplateUtils.readTextFromDisk$default(file, false, 2, null);
    }

    @JvmStatic
    @UiThread
    @JvmOverloads
    public static final void copyDirectory(@NotNull VirtualFile src, @NotNull File dest) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        TemplateUtils.copyDirectory$default(src, dest, null, 4, null);
    }

    private static final String readTextFromDocument$lambda$0(VirtualFile $file) {
        Document document;
        Document document2 = document = FileDocumentManager.getInstance().getDocument($file);
        return document2 != null ? document2.getText() : null;
    }

    private static final VirtualFile checkedCreateDirectoryIfMissing$lambda$0(File $directory) {
        VirtualFile virtualFile = VfsUtil.createDirectoryIfMissing((String)$directory.getAbsolutePath());
        if (virtualFile == null) {
            throw new IOException("Unable to create " + $directory.getAbsolutePath());
        }
        return virtualFile;
    }

    public static final /* synthetic */ boolean access$copyFile(VirtualFile fileToCopy, VirtualFile parent, File destination) {
        return TemplateUtils.copyFile(fileToCopy, parent, destination);
    }

    static {
        Logger logger = Logger.getInstance((String)"#org.jetbrains.android.templates.DomUtilities");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

