/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.ide.common.signing.KeystoreHelper;
import com.android.ide.common.signing.KeytoolException;
import com.android.io.CancellableFileIo;
import com.android.prefs.AndroidLocationsException;
import com.android.prefs.AndroidLocationsProvider;
import com.android.prefs.AndroidLocationsSingleton;
import com.android.tools.idea.gradle.dsl.android.model.android.AndroidModelUtilsKt;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.android.SigningConfigModel;
import com.android.utils.ILogger;
import com.android.utils.StdLogger;
import com.google.common.base.Strings;
import com.google.common.io.BaseEncoding;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidFacetProperties;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0007J\u001a\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000bJ\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\rH\u0007J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\rH\u0002J(\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\t2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u000bH\u0007J$\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\t2\b\u0010\u0018\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000bH\u0002R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/templates/KeystoreUtils;", "", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "getOrCreateDefaultDebugKeystore", "Ljava/io/File;", "getSha1DebugKeystoreSilently", "", "androidFacet", "Lorg/jetbrains/android/facet/AndroidFacet;", "valueIfNotFound", "getDebugKeystore", "facet", "getGradleDebugKeystore", "sha1", "keyStoreFile", "keyAlias", "keyStorePassword", "getCertificate", "Ljava/security/cert/Certificate;", "certificateAlias", "intellij.android.templates"})
@SourceDebugExtension(value={"SMAP\nKeystoreUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeystoreUtils.kt\ncom/android/tools/idea/templates/KeystoreUtils\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,174:1\n14#2:175\n1#3:176\n295#4,2:177\n*S KotlinDebug\n*F\n+ 1 KeystoreUtils.kt\ncom/android/tools/idea/templates/KeystoreUtils\n*L\n44#1:175\n114#1:177,2\n*E\n"})
public final class KeystoreUtils {
    @NotNull
    public static final KeystoreUtils INSTANCE = new KeystoreUtils();

    private KeystoreUtils() {
    }

    private final Logger getLog() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(KeystoreUtils.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    @JvmStatic
    @NotNull
    public static final File getOrCreateDefaultDebugKeystore() throws KeytoolException, AndroidLocationsException {
        File debugLocation = KeystoreHelper.defaultDebugKeystoreLocation((AndroidLocationsProvider)((AndroidLocationsProvider)AndroidLocationsSingleton.INSTANCE));
        if (!debugLocation.exists()) {
            Path keystoreDirectory = AndroidLocationsSingleton.INSTANCE.getPrefsLocation();
            if (!CancellableFileIo.isWritable((Path)keystoreDirectory)) {
                throw new AndroidLocationsException("Could not create debug keystore because \"" + keystoreDirectory + "\" is not writable", null, 2, null);
            }
            StdLogger logger = new StdLogger(StdLogger.Level.ERROR);
            KeystoreHelper.createDebugStore(null, (File)debugLocation, (String)"android", (String)"android", (String)"AndroidDebugKey", (ILogger)((ILogger)logger));
        }
        if (!debugLocation.exists()) {
            throw new AndroidLocationsException("Could not create debug keystore", null, 2, null);
        }
        Intrinsics.checkNotNull((Object)debugLocation);
        return debugLocation;
    }

    @NotNull
    public final String getSha1DebugKeystoreSilently(@Nullable AndroidFacet androidFacet, @NotNull String valueIfNotFound) {
        Intrinsics.checkNotNullParameter((Object)valueIfNotFound, (String)"valueIfNotFound");
        try {
            Object object;
            block5: {
                block4: {
                    object = androidFacet;
                    if (object == null) break block4;
                    AndroidFacet it = object;
                    boolean bl = false;
                    File file = KeystoreUtils.getDebugKeystore(it);
                    object = file;
                    if (file != null) break block5;
                }
                object = KeystoreUtils.getOrCreateDefaultDebugKeystore();
            }
            Object sha1File = object;
            return KeystoreUtils.sha1$default((File)sha1File, null, null, 6, null);
        }
        catch (Exception ex) {
            this.getLog().warn((Throwable)ex);
            return valueIfNotFound;
        }
    }

    public static /* synthetic */ String getSha1DebugKeystoreSilently$default(KeystoreUtils keystoreUtils, AndroidFacet androidFacet, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "YOUR_SHA1_KEY_STORE";
        }
        return keystoreUtils.getSha1DebugKeystoreSilently(androidFacet, string);
    }

    @JvmStatic
    @NotNull
    public static final File getDebugKeystore(@NotNull AndroidFacet facet) {
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        File gradleDebugKeystore = INSTANCE.getGradleDebugKeystore(facet);
        if (gradleDebugKeystore != null) {
            return gradleDebugKeystore;
        }
        AndroidFacetProperties androidFacetProperties = ((AndroidFacetConfiguration)facet.getConfiguration()).getState();
        Intrinsics.checkNotNullExpressionValue((Object)androidFacetProperties, (String)"getState(...)");
        AndroidFacetProperties state2 = androidFacetProperties;
        return !Strings.isNullOrEmpty((String)state2.CUSTOM_DEBUG_KEYSTORE_PATH) ? new File(state2.CUSTOM_DEBUG_KEYSTORE_PATH) : KeystoreUtils.getOrCreateDefaultDebugKeystore();
    }

    private final File getGradleDebugKeystore(AndroidFacet facet) {
        Object v3;
        block6: {
            ProjectBuildModel projectBuildModel = ProjectBuildModel.get(facet.getModule().getProject());
            Intrinsics.checkNotNullExpressionValue((Object)projectBuildModel, (String)"get(...)");
            ProjectBuildModel projectBuildModel2 = projectBuildModel;
            GradleBuildModel gradleBuildModel = projectBuildModel2.getModuleBuildModel(facet.getModule());
            if (gradleBuildModel == null) {
                return null;
            }
            GradleBuildModel gradleBuildModel2 = gradleBuildModel;
            List<SigningConfigModel> list2 = AndroidModelUtilsKt.android(gradleBuildModel2).signingConfigs();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"signingConfigs(...)");
            Iterable $this$firstOrNull$iv = list2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SigningConfigModel it = (SigningConfigModel)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)"debug", (Object)it.name())) continue;
                v3 = element$iv;
                break block6;
            }
            v3 = null;
        }
        SigningConfigModel signingConfigModel = v3;
        if (signingConfigModel == null) {
            return null;
        }
        SigningConfigModel signingConfig2 = signingConfigModel;
        String string = signingConfig2.storeFile().valueAsString();
        if (string == null) {
            return null;
        }
        String debugStorePath = string;
        File debugStoreFile = new File(debugStorePath);
        if (debugStoreFile.isAbsolute()) {
            return debugStoreFile;
        }
        File file = AndroidRootUtil.findModuleRootFolderPath(facet.getModule());
        if (file == null) {
            return debugStoreFile;
        }
        File moduleRoot = file;
        return new File(moduleRoot, debugStorePath);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String sha1(@NotNull File keyStoreFile, @Nullable String keyAlias2, @Nullable String keyStorePassword) throws Exception {
        Intrinsics.checkNotNullParameter((Object)keyStoreFile, (String)"keyStoreFile");
        Certificate signingCert = INSTANCE.getCertificate(keyStoreFile, keyAlias2, keyStorePassword);
        try {
            byte[] certBytes = MessageDigest.getInstance("SHA1").digest(signingCert.getEncoded());
            String string = BaseEncoding.base16().withSeparator(":", 2).encode(certBytes);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(...)");
            return string;
        }
        catch (Exception e) {
            throw new Exception("Could not compute SHA1 hash from certificate", e);
        }
    }

    public static /* synthetic */ String sha1$default(File file, String string, String string2, int n, Object object) throws Exception {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        return KeystoreUtils.sha1(file, string, string2);
    }

    private final Certificate getCertificate(File keyStoreFile, String certificateAlias, String keyStorePassword) throws Exception {
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            InputStream inputStream = new FileInputStream(keyStoreFile);
            String string = keyStorePassword;
            if (string == null) {
                string = "android";
            }
            char[] cArray = string.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            keyStore.load(inputStream, cArray);
            String string2 = certificateAlias;
            if (string2 == null) {
                string2 = keyStore.aliases().nextElement();
            }
            Certificate certificate = keyStore.getCertificate(string2);
            Intrinsics.checkNotNullExpressionValue((Object)certificate, (String)"getCertificate(...)");
            return certificate;
        }
        catch (GeneralSecurityException exception) {
            throw new Exception("Could not extract certificate from file.", exception);
        }
        catch (IOException exception) {
            throw new Exception("Could not extract certificate from file.", exception);
        }
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String sha1(@NotNull File keyStoreFile, @Nullable String keyAlias2) throws Exception {
        Intrinsics.checkNotNullParameter((Object)keyStoreFile, (String)"keyStoreFile");
        return KeystoreUtils.sha1$default(keyStoreFile, keyAlias2, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String sha1(@NotNull File keyStoreFile) throws Exception {
        Intrinsics.checkNotNullParameter((Object)keyStoreFile, (String)"keyStoreFile");
        return KeystoreUtils.sha1$default(keyStoreFile, null, null, 6, null);
    }
}

