/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.emulator;

import com.android.emulator.control.Velocity;
import com.android.tools.idea.streaming.emulator.EmulatorController;
import com.intellij.openapi.Disposable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\tJ\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\tJ\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0002J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/streaming/emulator/VirtualSceneCameraVelocityController;", "Lcom/intellij/openapi/Disposable;", "emulator", "Lcom/android/tools/idea/streaming/emulator/EmulatorController;", "controlKeys", "", "<init>", "(Lcom/android/tools/idea/streaming/emulator/EmulatorController;Ljava/lang/String;)V", "pressedKeysMask", "", "virtualSceneCameraVelocity", "Lcom/android/emulator/control/Velocity$Builder;", "kotlin.jvm.PlatformType", "dispose", "", "keyPressed", "keyCode", "keyReleased", "keyToMask", "updateCameraVelocity", "mask", "deltaVelocity", "", "intellij.android.streaming"})
public final class VirtualSceneCameraVelocityController
implements Disposable {
    @NotNull
    private final EmulatorController emulator;
    @NotNull
    private final String controlKeys;
    private int pressedKeysMask;
    private final Velocity.Builder virtualSceneCameraVelocity;

    public VirtualSceneCameraVelocityController(@NotNull EmulatorController emulator, @NotNull String controlKeys) {
        Intrinsics.checkNotNullParameter((Object)((Object)emulator), (String)"emulator");
        Intrinsics.checkNotNullParameter((Object)controlKeys, (String)"controlKeys");
        this.emulator = emulator;
        this.controlKeys = controlKeys;
        this.virtualSceneCameraVelocity = Velocity.newBuilder();
    }

    public void dispose() {
        this.pressedKeysMask = 0;
        if (!(this.virtualSceneCameraVelocity.getX() == 0.0f && this.virtualSceneCameraVelocity.getY() == 0.0f && this.virtualSceneCameraVelocity.getZ() == 0.0f)) {
            this.virtualSceneCameraVelocity.clear();
            Velocity velocity = Velocity.getDefaultInstance();
            Intrinsics.checkNotNullExpressionValue((Object)velocity, (String)"getDefaultInstance(...)");
            EmulatorController.setVirtualSceneCameraVelocity$default(this.emulator, velocity, null, 2, null);
        }
    }

    public final void keyPressed(int keyCode) {
        int mask = this.keyToMask(keyCode);
        int newPressed = this.pressedKeysMask | mask;
        if (this.pressedKeysMask != newPressed) {
            this.pressedKeysMask = newPressed;
            this.updateCameraVelocity(mask, 1.0f);
        }
    }

    public final void keyReleased(int keyCode) {
        int mask = this.keyToMask(keyCode);
        int newPressed = this.pressedKeysMask & ~mask;
        if (this.pressedKeysMask != newPressed) {
            this.pressedKeysMask = newPressed;
            this.updateCameraVelocity(mask, -1.0f);
        }
    }

    private final int keyToMask(int keyCode) {
        int index = StringsKt.indexOf$default((CharSequence)this.controlKeys, (char)((char)keyCode), (int)0, (boolean)false, (int)6, null);
        return index >= 0 ? 1 << index : 0;
    }

    private final void updateCameraVelocity(int mask, float deltaVelocity) {
        switch (mask) {
            case 8: {
                Velocity.Builder builder = this.virtualSceneCameraVelocity;
                builder.setX(builder.getX() + deltaVelocity);
                break;
            }
            case 2: {
                Velocity.Builder builder = this.virtualSceneCameraVelocity;
                builder.setX(builder.getX() - deltaVelocity);
                break;
            }
            case 32: {
                Velocity.Builder builder = this.virtualSceneCameraVelocity;
                builder.setY(builder.getY() + deltaVelocity);
                break;
            }
            case 16: {
                Velocity.Builder builder = this.virtualSceneCameraVelocity;
                builder.setY(builder.getY() - deltaVelocity);
                break;
            }
            case 4: {
                Velocity.Builder builder = this.virtualSceneCameraVelocity;
                builder.setZ(builder.getZ() + deltaVelocity);
                break;
            }
            case 1: {
                Velocity.Builder builder = this.virtualSceneCameraVelocity;
                builder.setZ(builder.getZ() - deltaVelocity);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        Velocity velocity = this.virtualSceneCameraVelocity.build();
        Intrinsics.checkNotNullExpressionValue((Object)velocity, (String)"build(...)");
        EmulatorController.setVirtualSceneCameraVelocity$default(this.emulator, velocity, null, 2, null);
    }
}

