/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.emulator;

import com.android.emulator.control.Image;
import com.android.emulator.control.ImageFormat;
import com.android.tools.idea.io.grpc.KnownLength;
import com.android.tools.idea.io.grpc.MethodDescriptor;
import com.android.tools.idea.io.grpc.Status;
import com.android.tools.idea.io.grpc.StatusRuntimeException;
import com.android.tools.idea.protobuf.CodedInputStream;
import com.android.tools.idea.protobuf.InvalidProtocolBufferException;
import com.android.tools.idea.protobuf.MessageLite;
import com.android.tools.idea.protobuf.UnsafeByteOperations;
import com.android.tools.idea.streaming.emulator.EmulatorControllerKt;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\f\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u000eH\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/streaming/emulator/ImageResponseMarshaller;", "Lcom/android/tools/idea/io/grpc/MethodDescriptor$Marshaller;", "Lcom/android/emulator/control/Image;", "<init>", "()V", "reusableBuffer", "Ljava/lang/ThreadLocal;", "Ljava/lang/ref/Reference;", "", "stream", "Ljava/io/InputStream;", "response", "parse", "createCodedInputStream", "Lcom/android/tools/idea/protobuf/CodedInputStream;", "parseImage", "input", "intellij.android.streaming"})
final class ImageResponseMarshaller
implements MethodDescriptor.Marshaller<Image> {
    @NotNull
    private final ThreadLocal<Reference<byte[]>> reusableBuffer = new ThreadLocal();

    @NotNull
    public InputStream stream(@NotNull Image response2) {
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Image parse(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        try {
            CodedInputStream codedInputStream = this.createCodedInputStream(stream);
            if (codedInputStream == null) {
                Image image = Image.getDefaultInstance();
                Intrinsics.checkNotNullExpressionValue((Object)image, (String)"getDefaultInstance(...)");
                return image;
            }
            CodedInputStream codedStream = codedInputStream;
            return this.parseImage(codedStream);
        }
        catch (InvalidProtocolBufferException e) {
            StatusRuntimeException statusRuntimeException = Status.INTERNAL.withDescription("Invalid protobuf byte sequence").withCause((Throwable)e).asRuntimeException();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)statusRuntimeException), (String)"asRuntimeException(...)");
            throw (Throwable)statusRuntimeException;
        }
    }

    private final CodedInputStream createCodedInputStream(InputStream stream) throws InvalidProtocolBufferException {
        CodedInputStream codedStream = null;
        try {
            if (stream instanceof KnownLength) {
                int position;
                int remaining;
                int count;
                byte[] buf;
                int size = ((KnownLength)stream).available();
                if (size == 0) {
                    return null;
                }
                Reference<byte[]> reference = this.reusableBuffer.get();
                Object object = buf = (Object)(reference != null ? reference.get() : null);
                if (buf == null || buf.length < size) {
                    buf = new byte[size];
                    this.reusableBuffer.set(new WeakReference<byte[]>(buf));
                }
                for (remaining = size; remaining > 0 && (count = stream.read(buf, position = size - remaining, remaining)) >= 0; remaining -= count) {
                }
                if (remaining != 0) {
                    position = size - remaining;
                    throw new RuntimeException("Inaccurate size: " + size + " != " + position);
                }
                CodedInputStream codedInputStream = UnsafeByteOperations.unsafeWrap((byte[])buf, (int)0, (int)size).newCodedInput();
                Intrinsics.checkNotNullExpressionValue((Object)codedInputStream, (String)"newCodedInput(...)");
                codedStream = codedInputStream;
                codedStream.enableAliasing(true);
            } else {
                CodedInputStream codedInputStream = CodedInputStream.newInstance((InputStream)stream);
                Intrinsics.checkNotNullExpressionValue((Object)codedInputStream, (String)"newInstance(...)");
                codedStream = codedInputStream;
            }
        }
        catch (IOException e) {
            throw new InvalidProtocolBufferException(e);
        }
        codedStream.setSizeLimit(Integer.MAX_VALUE);
        return codedStream;
    }

    /*
     * Unable to fully structure code
     */
    private final Image parseImage(CodedInputStream input) throws InvalidProtocolBufferException {
        builder = Image.newBuilder();
        try {
            block10: while (true) {
                tag = input.readTag();
                switch (tag) {
                    case 0: {
                        break block10;
                    }
                    case 10: {
                        v0 = input.readMessage(ImageFormat.parser(), EmulatorControllerKt.access$getEMPTY_REGISTRY$p());
                        Intrinsics.checkNotNull((Object)v0, (String)"null cannot be cast to non-null type com.android.emulator.control.ImageFormat");
                        builder.setFormat((ImageFormat)v0);
                        continue block10;
                    }
                    case 34: {
                        builder.setImage(input.readBytes());
                        continue block10;
                    }
                    case 40: {
                        builder.setSeq(input.readUInt32());
                        continue block10;
                    }
                    case 48: {
                        builder.setTimestampUs(input.readUInt64());
                        continue block10;
                    }
                    default: {
                        if (!input.skipField(tag)) ** break;
                        continue block10;
                        break block10;
                    }
                }
                break;
            }
            input.checkLastTagWas(0);
            v1 = builder.build();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"build(...)");
            return v1;
        }
        catch (InvalidProtocolBufferException e) {
            v2 = e.setUnfinishedMessage((MessageLite)builder.build());
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"setUnfinishedMessage(...)");
            throw (Throwable)v2;
        }
        catch (IOException e) {
            v3 = new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.build());
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"setUnfinishedMessage(...)");
            throw (Throwable)v3;
        }
    }
}

