/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.emulator;

import com.android.annotations.concurrency.AnyThread;
import com.android.annotations.concurrency.Slow;
import com.android.emulator.control.AudioPacket;
import com.android.emulator.control.ClipData;
import com.android.emulator.control.DisplayConfigurations;
import com.android.emulator.control.DisplayMode;
import com.android.emulator.control.DisplayModeValue;
import com.android.emulator.control.EmulatorControllerGrpc;
import com.android.emulator.control.EmulatorStatus;
import com.android.emulator.control.ExtendedControlsStatus;
import com.android.emulator.control.Image;
import com.android.emulator.control.ImageFormat;
import com.android.emulator.control.InputEvent;
import com.android.emulator.control.Notification;
import com.android.emulator.control.PaneEntry;
import com.android.emulator.control.PhysicalModelValue;
import com.android.emulator.control.Posture;
import com.android.emulator.control.RotationRadian;
import com.android.emulator.control.SnapshotFilter;
import com.android.emulator.control.SnapshotList;
import com.android.emulator.control.SnapshotPackage;
import com.android.emulator.control.SnapshotServiceGrpc;
import com.android.emulator.control.ThemingStyle;
import com.android.emulator.control.UiControllerGrpc;
import com.android.emulator.control.Velocity;
import com.android.emulator.control.VmRunState;
import com.android.emulator.control.XrOptions;
import com.android.ide.common.util.Cancelable;
import com.android.tools.adtui.device.SkinDefinition;
import com.android.tools.adtui.device.SkinDefinitionCache;
import com.android.tools.idea.avdmanager.RunningAvdTracker;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.io.grpc.CallCredentials;
import com.android.tools.idea.io.grpc.Channel;
import com.android.tools.idea.io.grpc.ClientCall;
import com.android.tools.idea.io.grpc.CompressorRegistry;
import com.android.tools.idea.io.grpc.ConnectivityState;
import com.android.tools.idea.io.grpc.DecompressorRegistry;
import com.android.tools.idea.io.grpc.ManagedChannel;
import com.android.tools.idea.io.grpc.MethodDescriptor;
import com.android.tools.idea.io.grpc.Status;
import com.android.tools.idea.io.grpc.StatusRuntimeException;
import com.android.tools.idea.io.grpc.stub.AbstractStub;
import com.android.tools.idea.io.grpc.stub.ClientCallStreamObserver;
import com.android.tools.idea.io.grpc.stub.ClientCalls;
import com.android.tools.idea.io.grpc.stub.ClientResponseObserver;
import com.android.tools.idea.io.grpc.stub.StreamObserver;
import com.android.tools.idea.protobuf.Empty;
import com.android.tools.idea.protobuf.MessageOrBuilder;
import com.android.tools.idea.protobuf.TextFormat;
import com.android.tools.idea.streaming.emulator.EmptyStreamObserver;
import com.android.tools.idea.streaming.emulator.EmulatorConfiguration;
import com.android.tools.idea.streaming.emulator.EmulatorControllerKt;
import com.android.tools.idea.streaming.emulator.EmulatorId;
import com.android.tools.idea.streaming.emulator.GrpcChannelBuilderFactory;
import com.android.tools.idea.streaming.emulator.ImageResponseMarshaller;
import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.ActivityTracker;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.Alarm;
import com.intellij.util.containers.DisposableWrapperList;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.awt.Dimension;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00e0\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u000b\u0018\u00002\u00020\u00012\u00020\u0002:\u0012\u00a6\u0001\u00a7\u0001\u00a8\u0001\u00a9\u0001\u00aa\u0001\u00ab\u0001\u00ac\u0001\u00ad\u0001\u00ae\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020#2\u0006\u0010D\u001a\u00020\u0002H\u0007J\u0010\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020#H\u0007J\u0010\u0010E\u001a\u00020B2\u0006\u0010C\u001a\u00020#H\u0007J\u0018\u0010F\u001a\u0002032\u0006\u0010G\u001a\u00020\u001e2\u0006\u0010H\u001a\u00020\u001eH\u0002J\b\u0010I\u001a\u00020BH\u0007J\b\u0010J\u001a\u000203H\u0007J\u0010\u0010K\u001a\u00020B2\u0006\u0010L\u001a\u00020\u0015H\u0002J\u0012\u0010M\u001a\u00020B2\b\b\u0002\u0010N\u001a\u00020OH\u0007J\u001b\u0010P\u001a\u0004\u0018\u00010\u00172\n\b\u0002\u0010Q\u001a\u0004\u0018\u00010\u001aH\u0000\u00a2\u0006\u0002\bRJ\u0006\u0010W\u001a\u00020BJ\b\u0010X\u001a\u00020BH\u0002J\u0017\u0010Y\u001a\u00020B2\u0006\u0010Z\u001a\u00020[H\u0001\u00a2\u0006\u0004\b\\\u0010]J \u0010^\u001a\b\u0012\u0004\u0012\u00020_0'2\u0012\u0010`\u001a\u000e\u0012\u0004\u0012\u00020_\u0012\u0004\u0012\u00020b0aJ\u001e\u0010c\u001a\u00020B2\u0006\u0010d\u001a\u00020e2\u000e\b\u0002\u0010`\u001a\b\u0012\u0004\u0012\u00020b0'J\u0014\u0010f\u001a\u00020g2\f\u0010`\u001a\b\u0012\u0004\u0012\u00020e0'J\u001e\u0010h\u001a\u00020B2\u0006\u0010i\u001a\u00020j2\u000e\b\u0002\u0010`\u001a\b\u0012\u0004\u0012\u00020b0'J\u001e\u0010k\u001a\u00020B2\u0006\u0010l\u001a\u00020m2\u000e\b\u0002\u0010`\u001a\b\u0012\u0004\u0012\u00020b0'J\u0014\u0010n\u001a\u00020B2\f\u0010`\u001a\b\u0012\u0004\u0012\u00020m0'J\u001e\u0010o\u001a\b\u0012\u0004\u0012\u00020(0'2\u000e\b\u0002\u0010`\u001a\b\u0012\u0004\u0012\u00020b0'H\u0002J\f\u0010p\u001a\b\u0012\u0004\u0012\u00020(0'J\u0014\u0010q\u001a\u00020g2\f\u0010`\u001a\b\u0012\u0004\u0012\u00020r0'J\u001c\u0010s\u001a\u00020B2\u0006\u0010t\u001a\u00020u2\f\u0010`\u001a\b\u0012\u0004\u0012\u00020v0'J\u001e\u0010w\u001a\u00020B2\u0006\u0010x\u001a\u00020v2\u000e\b\u0002\u0010`\u001a\b\u0012\u0004\u0012\u00020b0'J\u001c\u0010y\u001a\u00020B2\u0006\u0010z\u001a\u00020\u000e2\f\u0010`\u001a\b\u0012\u0004\u0012\u00020\u00100'J\u001c\u0010{\u001a\u00020g2\u0006\u0010z\u001a\u00020\u000e2\f\u0010`\u001a\b\u0012\u0004\u0012\u00020\u00100'J\u0014\u0010|\u001a\u00020B2\f\u0010`\u001a\b\u0012\u0004\u0012\u00020}0'J\u001f\u0010~\u001a\u00020B2\u0007\u0010\u007f\u001a\u00030\u0080\u00012\u000e\b\u0002\u0010`\u001a\b\u0012\u0004\u0012\u00020b0'J\u0016\u0010\u0081\u0001\u001a\u00020B2\r\u0010`\u001a\t\u0012\u0005\u0012\u00030\u0082\u00010'J\"\u0010\u0083\u0001\u001a\u00020B2\b\u0010\u0084\u0001\u001a\u00030\u0082\u00012\u000f\b\u0002\u0010`\u001a\t\u0012\u0005\u0012\u00030\u0082\u00010'J!\u0010\u0085\u0001\u001a\u00020B2\b\u0010\u0086\u0001\u001a\u00030\u0087\u00012\u000e\b\u0002\u0010`\u001a\b\u0012\u0004\u0012\u00020b0'J!\u0010\u0088\u0001\u001a\u00020B2\b\u0010\u0089\u0001\u001a\u00030\u008a\u00012\u000e\b\u0002\u0010`\u001a\b\u0012\u0004\u0012\u00020b0'J\"\u0010\u008b\u0001\u001a\u00020B2\b\u0010\u008c\u0001\u001a\u00030\u008d\u00012\u000f\b\u0002\u0010`\u001a\t\u0012\u0005\u0012\u00030\u008e\u00010'J\"\u0010\u008f\u0001\u001a\u00020B2\b\u0010\u0090\u0001\u001a\u00030\u0091\u00012\u000f\b\u0002\u0010`\u001a\t\u0012\u0005\u0012\u00030\u0092\u00010'J$\u0010\u0093\u0001\u001a\t\u0012\u0005\u0012\u00030\u0092\u00010'2\u0014\u0010`\u001a\u0010\u0012\u0005\u0012\u00030\u0092\u0001\u0012\u0005\u0012\u00030\u0092\u00010aJ\"\u0010\u0094\u0001\u001a\u00020B2\b\u0010\u0090\u0001\u001a\u00030\u0091\u00012\u000f\b\u0002\u0010`\u001a\t\u0012\u0005\u0012\u00030\u0092\u00010'J\"\u0010\u0095\u0001\u001a\u00020B2\b\u0010\u0090\u0001\u001a\u00030\u0091\u00012\u000f\b\u0002\u0010`\u001a\t\u0012\u0005\u0012\u00030\u0092\u00010'J\"\u0010\u0096\u0001\u001a\u00020B2\b\u0010\u0097\u0001\u001a\u00030\u0098\u00012\u000f\b\u0002\u0010`\u001a\t\u0012\u0005\u0012\u00030\u0099\u00010'J\u0018\u0010\u009a\u0001\u001a\u00020B2\u000f\b\u0002\u0010`\u001a\t\u0012\u0005\u0012\u00030\u0099\u00010'J!\u0010\u009b\u0001\u001a\u00020B2\b\u0010\u009c\u0001\u001a\u00030\u009d\u00012\u000e\b\u0002\u0010`\u001a\b\u0012\u0004\u0012\u00020b0'J\t\u0010\u009e\u0001\u001a\u00020BH\u0002J\n\u0010\u009f\u0001\u001a\u00030\u00a0\u0001H\u0002J\t\u0010\u00a1\u0001\u001a\u00020BH\u0016J\u0016\u0010\u00a2\u0001\u001a\u0002032\n\u0010\u00a3\u0001\u001a\u0005\u0018\u00010\u00a4\u0001H\u0096\u0002J\t\u0010\u00a5\u0001\u001a\u00020OH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\f\u001aB\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00100\u0010 \u000f* \u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00100\u0010\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00170\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001d\u001a\u0010\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u001e0\u001e0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001f\u001a\u0010\u0012\f\u0012\n \u000f*\u0004\u0018\u00010 0 0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010&\u001a\n\u0012\u0004\u0012\u00020(\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R%\u0010*\u001a\u00020\u00152\u0006\u0010)\u001a\u00020\u00158F@\u00c2\u0002X\u0086\u000e\u00a2\u0006\f\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u0011\u0010/\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0011\u00102\u001a\u0002038F\u00a2\u0006\u0006\u001a\u0004\b2\u00104R\u0011\u00105\u001a\u0002068F\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u0011\u00109\u001a\u00020:8F\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R\u0011\u0010=\u001a\u00020>8F\u00a2\u0006\u0006\u001a\u0004\b?\u0010@R\u0016\u0010S\u001a\u0004\u0018\u00010T8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bU\u0010V\u00a8\u0006\u00af\u0001"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorController;", "Lcom/intellij/openapi/util/UserDataHolderBase;", "Lcom/intellij/openapi/Disposable;", "emulatorId", "Lcom/android/tools/idea/streaming/emulator/EmulatorId;", "parentDisposable", "<init>", "(Lcom/android/tools/idea/streaming/emulator/EmulatorId;Lcom/intellij/openapi/Disposable;)V", "getEmulatorId", "()Lcom/android/tools/idea/streaming/emulator/EmulatorId;", "imageResponseMarshaller", "Lcom/android/tools/idea/streaming/emulator/ImageResponseMarshaller;", "streamScreenshotMethod", "Lcom/android/tools/idea/io/grpc/MethodDescriptor;", "Lcom/android/emulator/control/ImageFormat;", "kotlin.jvm.PlatformType", "Lcom/android/emulator/control/Image;", "connectionReference", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/android/tools/idea/streaming/emulator/EmulatorController$Connection;", "emulatorConfigInternal", "Lcom/android/tools/idea/streaming/emulator/EmulatorConfiguration;", "defaultSkin", "Lcom/android/tools/adtui/device/SkinDefinition;", "postureSkins", "", "Lcom/android/emulator/control/Posture$PostureValue;", "alarm", "Lcom/intellij/util/Alarm;", "connectionStateReference", "Lcom/android/tools/idea/streaming/emulator/EmulatorController$ConnectionState;", "emulatorState", "Lcom/android/tools/idea/streaming/emulator/EmulatorController$EmulatorState;", "connectionStateListeners", "Lcom/intellij/util/containers/DisposableWrapperList;", "Lcom/android/tools/idea/streaming/emulator/EmulatorController$ConnectionStateListener;", "runningAvdTracker", "Lcom/android/tools/idea/avdmanager/RunningAvdTracker;", "inputEventSender", "Lcom/android/tools/idea/io/grpc/stub/StreamObserver;", "Lcom/android/emulator/control/InputEvent;", "value", "emulatorConfig", "getEmulatorConfig", "()Lcom/android/tools/idea/streaming/emulator/EmulatorConfiguration;", "setEmulatorConfig", "(Lcom/android/tools/idea/streaming/emulator/EmulatorConfiguration;)V", "connectionState", "getConnectionState", "()Lcom/android/tools/idea/streaming/emulator/EmulatorController$ConnectionState;", "isShuttingDown", "", "()Z", "emulatorControllerStub", "Lcom/android/emulator/control/EmulatorControllerGrpc$EmulatorControllerStub;", "getEmulatorControllerStub", "()Lcom/android/emulator/control/EmulatorControllerGrpc$EmulatorControllerStub;", "snapshotServiceStub", "Lcom/android/emulator/control/SnapshotServiceGrpc$SnapshotServiceStub;", "getSnapshotServiceStub", "()Lcom/android/emulator/control/SnapshotServiceGrpc$SnapshotServiceStub;", "uiControllerStub", "Lcom/android/emulator/control/UiControllerGrpc$UiControllerStub;", "getUiControllerStub", "()Lcom/android/emulator/control/UiControllerGrpc$UiControllerStub;", "addConnectionStateListener", "", "listener", "disposable", "removeConnectionStateListener", "updateConnectionState", "oldState", "newState", "connect", "loadEmulatorConfiguration", "loadSkins", "config", "connectGrpcOrIncreaseMaxInboundMessageSize", "maxInboundMessageSize", "", "getSkin", "posture", "getSkin$intellij_android_streaming", "channel", "Lcom/android/tools/idea/io/grpc/ManagedChannel;", "getChannel", "()Lcom/android/tools/idea/io/grpc/ManagedChannel;", "shutdown", "sendShutdown", "awaitTermination", "timeout", "Lkotlin/time/Duration;", "awaitTermination-LRDsOJo$intellij_android_streaming", "(J)V", "injectAudio", "Lcom/android/emulator/control/AudioPacket;", "streamObserver", "Lcom/android/tools/idea/io/grpc/stub/ClientResponseObserver;", "Lcom/android/tools/idea/protobuf/Empty;", "setClipboard", "clipData", "Lcom/android/emulator/control/ClipData;", "streamClipboard", "Lcom/android/ide/common/util/Cancelable;", "setDisplayMode", "displayModeValue", "Lcom/android/emulator/control/DisplayModeValue;", "setXrOptions", "xrOptions", "Lcom/android/emulator/control/XrOptions;", "getXrOptions", "streamInputEvent", "getOrCreateInputEventSender", "streamNotification", "Lcom/android/emulator/control/Notification;", "getPhysicalModel", "physicalType", "Lcom/android/emulator/control/PhysicalModelValue$PhysicalType;", "Lcom/android/emulator/control/PhysicalModelValue;", "setPhysicalModel", "modelValue", "getScreenshot", "imageFormat", "streamScreenshot", "getStatus", "Lcom/android/emulator/control/EmulatorStatus;", "setVmState", "vmState", "Lcom/android/emulator/control/VmRunState;", "getDisplayConfigurations", "Lcom/android/emulator/control/DisplayConfigurations;", "setDisplayConfigurations", "displayConfigurations", "rotateVirtualSceneCamera", "cameraRotation", "Lcom/android/emulator/control/RotationRadian;", "setVirtualSceneCameraVelocity", "cameraVelocity", "Lcom/android/emulator/control/Velocity;", "listSnapshots", "snapshotFilter", "Lcom/android/emulator/control/SnapshotFilter;", "Lcom/android/emulator/control/SnapshotList;", "loadSnapshot", "snapshotId", "", "Lcom/android/emulator/control/SnapshotPackage;", "pushSnapshot", "saveSnapshot", "deleteSnapshot", "showExtendedControls", "pane", "Lcom/android/emulator/control/PaneEntry;", "Lcom/android/emulator/control/ExtendedControlsStatus;", "closeExtendedControls", "setUiTheme", "style", "Lcom/android/emulator/control/ThemingStyle$Style;", "sendKeepAlive", "throwNotYetConnected", "", "dispose", "equals", "other", "", "hashCode", "Connection", "ConnectionState", "EmulatorState", "CancelableClientCall", "DelegatingStreamObserver", "DelegatingClientResponseObserver", "RetryException", "ConnectionStateListener", "TokenCallCredentials", "intellij.android.streaming"})
@SourceDebugExtension(value={"SMAP\nEmulatorController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmulatorController.kt\ncom/android/tools/idea/streaming/emulator/EmulatorController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,972:1\n120#1,2:974\n1#2:973\n40#3,3:976\n*S KotlinDebug\n*F\n+ 1 EmulatorController.kt\ncom/android/tools/idea/streaming/emulator/EmulatorController\n*L\n217#1:974,2\n264#1:976,3\n*E\n"})
public final class EmulatorController
extends UserDataHolderBase
implements Disposable {
    @NotNull
    private final EmulatorId emulatorId;
    @NotNull
    private final ImageResponseMarshaller imageResponseMarshaller;
    private final MethodDescriptor<ImageFormat, Image> streamScreenshotMethod;
    @NotNull
    private AtomicReference<Connection> connectionReference;
    @Nullable
    private volatile EmulatorConfiguration emulatorConfigInternal;
    @Nullable
    private volatile SkinDefinition defaultSkin;
    @NotNull
    private volatile Map<Posture.PostureValue, SkinDefinition> postureSkins;
    @NotNull
    private final Alarm alarm;
    @NotNull
    private final AtomicReference<ConnectionState> connectionStateReference;
    @NotNull
    private final AtomicReference<EmulatorState> emulatorState;
    @NotNull
    private final DisposableWrapperList<ConnectionStateListener> connectionStateListeners;
    @NotNull
    private final RunningAvdTracker runningAvdTracker;
    @Nullable
    private StreamObserver<InputEvent> inputEventSender;

    public EmulatorController(@NotNull EmulatorId emulatorId, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)emulatorId, (String)"emulatorId");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.emulatorId = emulatorId;
        this.imageResponseMarshaller = new ImageResponseMarshaller();
        this.streamScreenshotMethod = EmulatorControllerGrpc.getStreamScreenshotMethod().toBuilder(EmulatorControllerGrpc.getStreamScreenshotMethod().getRequestMarshaller(), (MethodDescriptor.Marshaller)this.imageResponseMarshaller).build();
        this.connectionReference = new AtomicReference();
        this.postureSkins = MapsKt.emptyMap();
        this.alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.connectionStateReference = new AtomicReference<ConnectionState>(ConnectionState.NOT_INITIALIZED);
        this.emulatorState = new AtomicReference<EmulatorState>(EmulatorState.RUNNING);
        this.connectionStateListeners = new DisposableWrapperList();
        this.runningAvdTracker = RunningAvdTracker.Companion.getInstance();
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    @NotNull
    public final EmulatorId getEmulatorId() {
        return this.emulatorId;
    }

    @NotNull
    public final EmulatorConfiguration getEmulatorConfig() {
        EmulatorConfiguration emulatorConfiguration = this.emulatorConfigInternal;
        if (emulatorConfiguration == null) {
            throw new IllegalStateException("Emulator configuration has not been loaded");
        }
        return emulatorConfiguration;
    }

    private final void setEmulatorConfig(EmulatorConfiguration value2) {
        boolean $i$f$setEmulatorConfig = false;
        this.emulatorConfigInternal = value2;
    }

    @NotNull
    public final ConnectionState getConnectionState() {
        ConnectionState connectionState = this.connectionStateReference.get();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)connectionState), (String)"get(...)");
        return connectionState;
    }

    public final boolean isShuttingDown() {
        return this.emulatorState.get() != EmulatorState.RUNNING;
    }

    @NotNull
    public final EmulatorControllerGrpc.EmulatorControllerStub getEmulatorControllerStub() {
        Connection connection2 = this.connectionReference.get();
        if (connection2 == null || (connection2 = connection2.getEmulatorControllerStub()) == null) {
            this.throwNotYetConnected();
            throw new KotlinNothingValueException();
        }
        return connection2;
    }

    @NotNull
    public final SnapshotServiceGrpc.SnapshotServiceStub getSnapshotServiceStub() {
        Connection connection2 = this.connectionReference.get();
        if (connection2 == null || (connection2 = connection2.getSnapshotServiceStub()) == null) {
            this.throwNotYetConnected();
            throw new KotlinNothingValueException();
        }
        return connection2;
    }

    @NotNull
    public final UiControllerGrpc.UiControllerStub getUiControllerStub() {
        Connection connection2 = this.connectionReference.get();
        if (connection2 == null || (connection2 = connection2.getUiControllerStub()) == null) {
            this.throwNotYetConnected();
            throw new KotlinNothingValueException();
        }
        return connection2;
    }

    @AnyThread
    public final void addConnectionStateListener(@NotNull ConnectionStateListener listener2, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.connectionStateListeners.add((Object)listener2, disposable);
        listener2.connectionStateChanged(this, this.getConnectionState());
    }

    @AnyThread
    public final void addConnectionStateListener(@NotNull ConnectionStateListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        if (listener2 instanceof Disposable) {
            this.addConnectionStateListener(listener2, (Disposable)listener2);
        } else {
            this.connectionStateListeners.add((Object)listener2);
            listener2.connectionStateChanged(this, this.getConnectionState());
        }
    }

    @AnyThread
    public final void removeConnectionStateListener(@NotNull ConnectionStateListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.connectionStateListeners.remove((Object)listener2);
    }

    private final boolean updateConnectionState(ConnectionState oldState, ConnectionState newState2) {
        if (this.connectionStateReference.compareAndSet(oldState, newState2)) {
            if (newState2 == ConnectionState.DISCONNECTED) {
                if (oldState == ConnectionState.CONNECTED) {
                    EmulatorControllerKt.access$getLOG$p().info("Disconnected from " + this.getEmulatorConfig().getAvdName() + " on port " + this.emulatorId.getGrpcPort());
                } else {
                    EmulatorControllerKt.access$getLOG$p().warn("Unable to connect to " + this.getEmulatorConfig().getAvdName() + " on port " + this.emulatorId.getGrpcPort());
                }
            }
            Iterator iterator2 = this.connectionStateListeners.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"iterator(...)");
            Iterator iterator3 = iterator2;
            while (iterator3.hasNext()) {
                ConnectionStateListener listener2 = (ConnectionStateListener)iterator3.next();
                ActivityTracker.getInstance().inc();
                listener2.connectionStateChanged(this, this.getConnectionState());
            }
            return true;
        }
        return false;
    }

    @Slow
    public final void connect() {
        int n;
        Comparable comparable;
        EmulatorConfiguration config;
        if (this.emulatorConfigInternal == null) {
            this.loadEmulatorConfiguration();
        }
        if (!(config = this.getEmulatorConfig()).isValid()) {
            this.updateConnectionState(ConnectionState.NOT_INITIALIZED, ConnectionState.DISCONNECTED);
            return;
        }
        try {
            this.loadSkins(config);
        }
        catch (Throwable e) {
            EmulatorControllerKt.access$getLOG$p().warn("Unable to load skins", e);
        }
        Iterator iterator2 = ((Iterable)config.getDisplayModes()).iterator();
        if (!iterator2.hasNext()) {
            comparable = null;
        } else {
            EmulatorConfiguration.DisplayMode it = (EmulatorConfiguration.DisplayMode)iterator2.next();
            boolean bl = false;
            Comparable comparable2 = Integer.valueOf(it.getDisplaySize().width * it.getDisplaySize().height);
            while (iterator2.hasNext()) {
                EmulatorConfiguration.DisplayMode it2 = (EmulatorConfiguration.DisplayMode)iterator2.next();
                $i$a$-maxOfOrNull-EmulatorController$connect$maxDisplayPixels$1 = false;
                Comparable comparable3 = Integer.valueOf(it2.getDisplaySize().width * it2.getDisplaySize().height);
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Integer n2 = (Integer)comparable;
        if (n2 != null) {
            n = n2;
        } else {
            Comparable comparable4;
            int n3 = config.getDisplayWidth() * config.getDisplayHeight();
            Iterator iterator3 = ((Iterable)config.getAdditionalDisplays().values()).iterator();
            if (!iterator3.hasNext()) {
                comparable4 = null;
            } else {
                Dimension it = (Dimension)iterator3.next();
                boolean bl = false;
                Comparable comparable5 = Integer.valueOf(it.width * it.height);
                while (iterator3.hasNext()) {
                    Dimension it3 = (Dimension)iterator3.next();
                    $i$a$-maxOfOrNull-EmulatorController$connect$maxDisplayPixels$2 = false;
                    Comparable comparable6 = Integer.valueOf(it3.width * it3.height);
                    if (comparable5.compareTo(comparable6) >= 0) continue;
                    comparable5 = comparable6;
                }
                comparable4 = comparable5;
            }
            Integer n4 = (Integer)comparable4;
            int n5 = n4 != null ? n4 : 0;
            n = Math.max(n3, n5);
        }
        int maxDisplayPixels = n;
        int maxInboundMessageSize = maxDisplayPixels * 3 + 100;
        this.connectGrpcOrIncreaseMaxInboundMessageSize(maxInboundMessageSize);
    }

    @Slow
    public final boolean loadEmulatorConfiguration() {
        EmulatorConfiguration emulatorConfiguration;
        EmulatorController emulatorController = this;
        try {
            emulatorConfiguration = EmulatorConfiguration.Companion.readAvdDefinition(this.emulatorId.getAvdFolder());
        }
        catch (Exception e) {
            String string = e.getMessage();
            if (string == null) {
                string = e.getClass().getName();
            }
            String message = string;
            EmulatorControllerKt.access$getLOG$p().warn("Error while loading configuration for " + this.emulatorId.getAvdName() + " - " + message);
            emulatorConfiguration = EmulatorConfiguration.Companion.createStub(this.emulatorId.getAvdName(), this.emulatorId.getAvdFolder());
        }
        EmulatorConfiguration value$iv = emulatorConfiguration;
        boolean $i$f$setEmulatorConfig = false;
        this_$iv.emulatorConfigInternal = value$iv;
        return this.getEmulatorConfig().isValid();
    }

    private final void loadSkins(EmulatorConfiguration config) {
        Path skinFolder = config.getSkinFolder();
        if (skinFolder != null) {
            if (config.getPostures().isEmpty()) {
                this.defaultSkin = SkinDefinitionCache.Companion.getInstance().getSkinDefinition(skinFolder);
            } else {
                this.defaultSkin = SkinDefinitionCache.Companion.getInstance().getSkinDefinition(skinFolder.resolve("default"));
                Object2ObjectArrayMap skins2 = new Object2ObjectArrayMap();
                for (EmulatorConfiguration.PostureDescriptor posture : config.getPostures()) {
                    SkinDefinition skin;
                    String dir;
                    String string = StringsKt.substringAfter$default((String)posture.getPosture().name(), (String)"_", null, (int)2, null);
                    Locale locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)string.toLowerCase(locale), (String)"toLowerCase(...)");
                    Path folder = skinFolder.resolve(dir);
                    if (!Files.exists(folder.resolve("layout"), new LinkOption[0]) || (skin = SkinDefinitionCache.Companion.getInstance().getSkinDefinition(folder)) == null) continue;
                    ((Map)skins2).put(posture.getPosture(), skin);
                }
                this.postureSkins = (Map)skins2;
            }
        }
    }

    @Slow
    public final void connectGrpcOrIncreaseMaxInboundMessageSize(int maxInboundMessageSize) {
        Connection oldConnection = this.connectionReference.get();
        if (oldConnection != null && oldConnection.getMaxInboundMessageSize() >= maxInboundMessageSize) {
            return;
        }
        this.updateConnectionState(ConnectionState.NOT_INITIALIZED, ConnectionState.CONNECTING);
        boolean $i$f$service = false;
        Class<GrpcChannelBuilderFactory> serviceClass$iv = GrpcChannelBuilderFactory.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        ManagedChannel channel = ((GrpcChannelBuilderFactory)object).newGrpcChannelBuilder("localhost", this.emulatorId.getGrpcPort()).usePlaintext().maxInboundMessageSize(maxInboundMessageSize).compressorRegistry(CompressorRegistry.newEmptyInstance()).decompressorRegistry(DecompressorRegistry.emptyInstance()).build();
        EmulatorControllerGrpc.EmulatorControllerStub emulatorControllerStub = null;
        SnapshotServiceGrpc.SnapshotServiceStub snapshotServiceStub = null;
        UiControllerGrpc.UiControllerStub uiControllerStub = null;
        String token = this.emulatorId.getGrpcToken();
        if (token == null) {
            EmulatorControllerGrpc.EmulatorControllerStub emulatorControllerStub2 = EmulatorControllerGrpc.newStub((Channel)((Channel)channel));
            Intrinsics.checkNotNullExpressionValue((Object)emulatorControllerStub2, (String)"newStub(...)");
            emulatorControllerStub = emulatorControllerStub2;
            SnapshotServiceGrpc.SnapshotServiceStub snapshotServiceStub2 = SnapshotServiceGrpc.newStub((Channel)((Channel)channel));
            Intrinsics.checkNotNullExpressionValue((Object)snapshotServiceStub2, (String)"newStub(...)");
            snapshotServiceStub = snapshotServiceStub2;
            UiControllerGrpc.UiControllerStub uiControllerStub2 = UiControllerGrpc.newStub((Channel)((Channel)channel));
            Intrinsics.checkNotNullExpressionValue((Object)uiControllerStub2, (String)"newStub(...)");
            uiControllerStub = uiControllerStub2;
        } else {
            TokenCallCredentials credentials = new TokenCallCredentials(token);
            AbstractStub abstractStub = EmulatorControllerGrpc.newStub((Channel)((Channel)channel)).withCallCredentials((CallCredentials)credentials);
            Intrinsics.checkNotNullExpressionValue((Object)abstractStub, (String)"withCallCredentials(...)");
            emulatorControllerStub = (EmulatorControllerGrpc.EmulatorControllerStub)abstractStub;
            AbstractStub abstractStub2 = SnapshotServiceGrpc.newStub((Channel)((Channel)channel)).withCallCredentials((CallCredentials)credentials);
            Intrinsics.checkNotNullExpressionValue((Object)abstractStub2, (String)"withCallCredentials(...)");
            snapshotServiceStub = (SnapshotServiceGrpc.SnapshotServiceStub)abstractStub2;
            AbstractStub abstractStub3 = UiControllerGrpc.newStub((Channel)((Channel)channel)).withCallCredentials((CallCredentials)credentials);
            Intrinsics.checkNotNullExpressionValue((Object)abstractStub3, (String)"withCallCredentials(...)");
            uiControllerStub = (UiControllerGrpc.UiControllerStub)abstractStub3;
        }
        Intrinsics.checkNotNull((Object)channel);
        Connection connection2 = new Connection(channel, maxInboundMessageSize, emulatorControllerStub, snapshotServiceStub, uiControllerStub);
        var connectivityStateWatcher2 = new Runnable(connection2, this, channel, oldConnection){
            final /* synthetic */ Connection $connection;
            final /* synthetic */ EmulatorController this$0;
            final /* synthetic */ ManagedChannel $channel;
            final /* synthetic */ Connection $oldConnection;
            {
                this.$connection = $connection;
                this.this$0 = $receiver;
                this.$channel = $channel;
                this.$oldConnection = $oldConnection;
            }

            public void run() {
                if (!Intrinsics.areEqual((Object)this.$connection, EmulatorController.access$getConnectionReference$p(this.this$0).get())) {
                    return;
                }
                ConnectivityState state2 = this.$channel.getState(false);
                if (state2 == ConnectivityState.SHUTDOWN) {
                    if (!EmulatorController.access$updateConnectionState(this.this$0, ConnectionState.CONNECTING, ConnectionState.DISCONNECTED)) {
                        EmulatorController.access$updateConnectionState(this.this$0, ConnectionState.CONNECTED, ConnectionState.DISCONNECTED);
                    }
                } else {
                    if (state2 == ConnectivityState.READY) {
                        EmulatorController.access$getConnectionReference$p(this.this$0).compareAndSet(this.$oldConnection, this.$connection);
                        EmulatorController.access$updateConnectionState(this.this$0, ConnectionState.CONNECTING, ConnectionState.CONNECTED);
                    }
                    this.$channel.notifyWhenStateChanged(state2, (Runnable)this);
                }
            }
        };
        if (this.connectionReference.compareAndSet(oldConnection, connection2)) {
            this.inputEventSender = null;
            connectivityStateWatcher2.run();
            this.sendKeepAlive();
            Connection connection3 = oldConnection;
            v8 = connection3 != null && (connection3 = connection3.getChannel()) != null ? connection3.shutdown() : null;
        } else {
            v8 = connection2.getChannel().shutdown();
        }
    }

    public static /* synthetic */ void connectGrpcOrIncreaseMaxInboundMessageSize$default(EmulatorController emulatorController, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0x400000;
        }
        emulatorController.connectGrpcOrIncreaseMaxInboundMessageSize(n);
    }

    @Nullable
    public final SkinDefinition getSkin$intellij_android_streaming(@Nullable Posture.PostureValue posture) {
        Posture.PostureValue postureValue;
        block3: {
            block2: {
                postureValue = posture;
                if (postureValue == null) break block2;
                Posture.PostureValue it = postureValue;
                boolean bl = false;
                SkinDefinition skinDefinition = this.postureSkins.get(posture);
                postureValue = skinDefinition;
                if (skinDefinition != null) break block3;
            }
            postureValue = this.defaultSkin;
        }
        return postureValue;
    }

    public static /* synthetic */ SkinDefinition getSkin$intellij_android_streaming$default(EmulatorController emulatorController, Posture.PostureValue postureValue, int n, Object object) {
        if ((n & 1) != 0) {
            postureValue = null;
        }
        return emulatorController.getSkin$intellij_android_streaming(postureValue);
    }

    private final ManagedChannel getChannel() {
        Connection connection2 = this.connectionReference.get();
        return connection2 != null ? connection2.getChannel() : null;
    }

    public final void shutdown() {
        block1: {
            if (!this.emulatorState.compareAndSet(EmulatorState.RUNNING, EmulatorState.SHUTDOWN_REQUESTED) || this.getConnectionState() != ConnectionState.CONNECTED) break block1;
            this.sendShutdown();
            ManagedChannel managedChannel = this.getChannel();
            if (managedChannel != null) {
                managedChannel.shutdown();
            }
        }
    }

    private final void sendShutdown() {
        if (this.emulatorState.compareAndSet(EmulatorState.SHUTDOWN_REQUESTED, EmulatorState.SHUTDOWN_SENT)) {
            this.alarm.cancelAllRequests();
            VmRunState vmRunState = VmRunState.newBuilder().setState(VmRunState.RunState.SHUTDOWN).build();
            Intrinsics.checkNotNull((Object)vmRunState);
            EmulatorController.setVmState$default(this, vmRunState, null, 2, null);
            this.runningAvdTracker.shuttingDown(this.emulatorId.getAvdFolder());
        }
    }

    @TestOnly
    public final void awaitTermination-LRDsOJo$intellij_android_streaming(long l) {
        block0: {
            ManagedChannel managedChannel = this.getChannel();
            if (managedChannel == null) break block0;
            managedChannel.awaitTermination(Duration.toLong-impl((long)l, (DurationUnit)DurationUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
        }
    }

    @NotNull
    public final StreamObserver<AudioPacket> injectAudio(@NotNull ClientResponseObserver<AudioPacket, Empty> streamObserver) {
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        if (((Boolean)StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("injectAudio()");
        }
        EmulatorControllerGrpc.EmulatorControllerStub emulatorControllerStub = this.getEmulatorControllerStub();
        MethodDescriptor methodDescriptor = EmulatorControllerGrpc.getInjectAudioMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getInjectAudioMethod(...)");
        StreamObserver streamObserver2 = emulatorControllerStub.injectAudio((StreamObserver)new DelegatingClientResponseObserver<AudioPacket, Empty>(streamObserver, methodDescriptor));
        Intrinsics.checkNotNullExpressionValue((Object)streamObserver2, (String)"injectAudio(...)");
        return streamObserver2;
    }

    public final void setClipboard(@NotNull ClipData clipData, @NotNull StreamObserver<Empty> streamObserver) {
        Intrinsics.checkNotNullParameter((Object)clipData, (String)"clipData");
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        if (((Boolean)StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()).booleanValue()) {
            String clipDataForLogging = TextFormat.shortDebugString((MessageOrBuilder)((MessageOrBuilder)clipData.toBuilder().setText("<clipboard contents>").build()));
            EmulatorControllerKt.access$getLOG$p().info("setClipboard(" + clipDataForLogging + ")");
        }
        EmulatorControllerGrpc.EmulatorControllerStub emulatorControllerStub = this.getEmulatorControllerStub();
        MethodDescriptor methodDescriptor = EmulatorControllerGrpc.getSetClipboardMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getSetClipboardMethod(...)");
        emulatorControllerStub.setClipboard(clipData, (StreamObserver)new DelegatingStreamObserver(streamObserver, methodDescriptor));
    }

    public static /* synthetic */ void setClipboard$default(EmulatorController emulatorController, ClipData clipData, StreamObserver streamObserver, int n, Object object) {
        if ((n & 2) != 0) {
            streamObserver = EmulatorControllerKt.access$getEmptyObserver();
        }
        emulatorController.setClipboard(clipData, (StreamObserver<Empty>)streamObserver);
    }

    @NotNull
    public final Cancelable streamClipboard(@NotNull StreamObserver<ClipData> streamObserver) {
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        if (((Boolean)StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("streamClipboard()");
        }
        MethodDescriptor method2 = EmulatorControllerGrpc.getStreamClipboardMethod();
        ClientCall call = this.getEmulatorControllerStub().getChannel().newCall(method2, this.getEmulatorControllerStub().getCallOptions());
        Empty empty2 = EmulatorControllerKt.access$getEMPTY_PROTO$p();
        Intrinsics.checkNotNull((Object)method2);
        ClientCalls.asyncServerStreamingCall((ClientCall)call, (Object)empty2, (StreamObserver)new DelegatingStreamObserver(streamObserver, method2));
        Intrinsics.checkNotNull((Object)call);
        return new CancelableClientCall(call);
    }

    public final void setDisplayMode(@NotNull DisplayModeValue displayModeValue, @NotNull StreamObserver<Empty> streamObserver) {
        Intrinsics.checkNotNullParameter((Object)displayModeValue, (String)"displayModeValue");
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        DisplayMode displayMode = DisplayMode.newBuilder().setValue(displayModeValue).build();
        if (((Boolean)StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("setDisplayMode(" + TextFormat.shortDebugString((MessageOrBuilder)((MessageOrBuilder)displayMode)) + ")");
        }
        EmulatorControllerGrpc.EmulatorControllerStub emulatorControllerStub = this.getEmulatorControllerStub();
        MethodDescriptor methodDescriptor = EmulatorControllerGrpc.getSetDisplayModeMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getSetDisplayModeMethod(...)");
        emulatorControllerStub.setDisplayMode(displayMode, (StreamObserver)new DelegatingStreamObserver(streamObserver, methodDescriptor));
    }

    public static /* synthetic */ void setDisplayMode$default(EmulatorController emulatorController, DisplayModeValue displayModeValue, StreamObserver streamObserver, int n, Object object) {
        if ((n & 2) != 0) {
            streamObserver = EmulatorControllerKt.access$getEmptyObserver();
        }
        emulatorController.setDisplayMode(displayModeValue, (StreamObserver<Empty>)streamObserver);
    }

    public final void setXrOptions(@NotNull XrOptions xrOptions, @NotNull StreamObserver<Empty> streamObserver) {
        Intrinsics.checkNotNullParameter((Object)xrOptions, (String)"xrOptions");
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        if (((Boolean)StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("setXrOptions(" + TextFormat.shortDebugString((MessageOrBuilder)((MessageOrBuilder)xrOptions)) + ")");
        }
        EmulatorControllerGrpc.EmulatorControllerStub emulatorControllerStub = this.getEmulatorControllerStub();
        MethodDescriptor methodDescriptor = EmulatorControllerGrpc.getSetXrOptionsMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getSetXrOptionsMethod(...)");
        emulatorControllerStub.setXrOptions(xrOptions, (StreamObserver)new DelegatingStreamObserver(streamObserver, methodDescriptor));
    }

    public static /* synthetic */ void setXrOptions$default(EmulatorController emulatorController, XrOptions xrOptions, StreamObserver streamObserver, int n, Object object) {
        if ((n & 2) != 0) {
            streamObserver = EmulatorControllerKt.access$getEmptyObserver();
        }
        emulatorController.setXrOptions(xrOptions, (StreamObserver<Empty>)streamObserver);
    }

    public final void getXrOptions(@NotNull StreamObserver<XrOptions> streamObserver) {
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        if (((Boolean)StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("getXrOptions()");
        }
        EmulatorControllerGrpc.EmulatorControllerStub emulatorControllerStub = this.getEmulatorControllerStub();
        Empty empty2 = EmulatorControllerKt.access$getEMPTY_PROTO$p();
        MethodDescriptor methodDescriptor = EmulatorControllerGrpc.getGetXrOptionsMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getGetXrOptionsMethod(...)");
        emulatorControllerStub.getXrOptions(empty2, (StreamObserver)new DelegatingStreamObserver(streamObserver, methodDescriptor));
    }

    private final StreamObserver<InputEvent> streamInputEvent(StreamObserver<Empty> streamObserver) {
        if (((Boolean)StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("streamInputEvent()");
        }
        EmulatorControllerGrpc.EmulatorControllerStub emulatorControllerStub = this.getEmulatorControllerStub();
        MethodDescriptor methodDescriptor = EmulatorControllerGrpc.getStreamInputEventMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getStreamInputEventMethod(...)");
        StreamObserver sender = emulatorControllerStub.streamInputEvent((StreamObserver)new DelegatingStreamObserver(streamObserver, methodDescriptor));
        return new EmptyStreamObserver<InputEvent>((StreamObserver<InputEvent>)sender){
            final /* synthetic */ StreamObserver<InputEvent> $sender;
            {
                this.$sender = $sender;
            }

            public void onNext(InputEvent message) {
                block1: {
                    Boolean loggingEnabled;
                    Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                    Boolean bl = loggingEnabled = message.hasKeyEvent() || message.hasAndroidEvent() || message.hasXrCommand() || message.hasXrHeadAngularVelocityEvent() || message.hasXrHeadVelocityEvent() ? (Boolean)StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get() : (Boolean)StudioFlags.EMBEDDED_EMULATOR_TRACE_HIGH_VOLUME_GRPC_CALLS.get();
                    if (loggingEnabled.booleanValue()) {
                        EmulatorControllerKt.access$getLOG$p().info("streamInputEvent: sending " + TextFormat.shortDebugString((MessageOrBuilder)((MessageOrBuilder)message)) + ")");
                    }
                    StreamObserver<InputEvent> streamObserver = this.$sender;
                    if (streamObserver == null) break block1;
                    streamObserver.onNext((Object)message);
                }
            }
        };
    }

    static /* synthetic */ StreamObserver streamInputEvent$default(EmulatorController emulatorController, StreamObserver streamObserver, int n, Object object) {
        if ((n & 1) != 0) {
            streamObserver = EmulatorControllerKt.access$getEmptyObserver();
        }
        return emulatorController.streamInputEvent((StreamObserver<Empty>)streamObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final StreamObserver<InputEvent> getOrCreateInputEventSender() {
        EmulatorController emulatorController = this;
        synchronized (emulatorController) {
            boolean bl = false;
            StreamObserver streamObserver = this.inputEventSender;
            if (streamObserver == null) {
                StreamObserver streamObserver2;
                StreamObserver it = streamObserver2 = EmulatorController.streamInputEvent$default(this, null, 1, null);
                boolean bl2 = false;
                this.inputEventSender = it;
                streamObserver = streamObserver2;
            }
            StreamObserver streamObserver3 = streamObserver;
            return streamObserver3;
        }
    }

    @NotNull
    public final Cancelable streamNotification(@NotNull StreamObserver<Notification> streamObserver) {
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        if (((Boolean)StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("streamNotification()");
        }
        MethodDescriptor method2 = EmulatorControllerGrpc.getStreamNotificationMethod();
        ClientCall call = this.getEmulatorControllerStub().getChannel().newCall(method2, this.getEmulatorControllerStub().getCallOptions());
        Empty empty2 = EmulatorControllerKt.access$getEMPTY_PROTO$p();
        Intrinsics.checkNotNull((Object)method2);
        ClientCalls.asyncServerStreamingCall((ClientCall)call, (Object)empty2, (StreamObserver)new DelegatingStreamObserver(streamObserver, method2));
        Intrinsics.checkNotNull((Object)call);
        return new CancelableClientCall(call);
    }

    public final void getPhysicalModel(@NotNull PhysicalModelValue.PhysicalType physicalType, @NotNull StreamObserver<PhysicalModelValue> streamObserver) {
        Intrinsics.checkNotNullParameter((Object)physicalType, (String)"physicalType");
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        PhysicalModelValue modelValue = PhysicalModelValue.newBuilder().setTarget(physicalType).build();
        if (((Boolean)StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("getPhysicalModel(" + TextFormat.shortDebugString((MessageOrBuilder)((MessageOrBuilder)modelValue)) + ")");
        }
        EmulatorControllerGrpc.EmulatorControllerStub emulatorControllerStub = this.getEmulatorControllerStub();
        MethodDescriptor methodDescriptor = EmulatorControllerGrpc.getGetPhysicalModelMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getGetPhysicalModelMethod(...)");
        emulatorControllerStub.getPhysicalModel(modelValue, (StreamObserver)new DelegatingStreamObserver(streamObserver, methodDescriptor));
    }

    public final void setPhysicalModel(@NotNull PhysicalModelValue modelValue, @NotNull StreamObserver<Empty> streamObserver) {
        Intrinsics.checkNotNullParameter((Object)modelValue, (String)"modelValue");
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        if (((Boolean)StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("setPhysicalModel(" + TextFormat.shortDebugString((MessageOrBuilder)((MessageOrBuilder)modelValue)) + ")");
        }
        EmulatorControllerGrpc.EmulatorControllerStub emulatorControllerStub = this.getEmulatorControllerStub();
        MethodDescriptor methodDescriptor = EmulatorControllerGrpc.getSetPhysicalModelMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getSetPhysicalModelMethod(...)");
        emulatorControllerStub.setPhysicalModel(modelValue, (StreamObserver)new DelegatingStreamObserver(streamObserver, methodDescriptor));
    }

    public static /* synthetic */ void setPhysicalModel$default(EmulatorController emulatorController, PhysicalModelValue physicalModelValue, StreamObserver streamObserver, int n, Object object) {
        if ((n & 2) != 0) {
            streamObserver = EmulatorControllerKt.access$getEmptyObserver();
        }
        emulatorController.setPhysicalModel(physicalModelValue, (StreamObserver<Empty>)streamObserver);
    }

    public final void getScreenshot(@NotNull ImageFormat imageFormat, @NotNull StreamObserver<Image> streamObserver) {
        Intrinsics.checkNotNullParameter((Object)imageFormat, (String)"imageFormat");
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        if (((Boolean)StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("getScreenshot(" + TextFormat.shortDebugString((MessageOrBuilder)((MessageOrBuilder)imageFormat)) + ")");
        }
        EmulatorControllerGrpc.EmulatorControllerStub emulatorControllerStub = this.getEmulatorControllerStub();
        MethodDescriptor methodDescriptor = EmulatorControllerGrpc.getGetScreenshotMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getGetScreenshotMethod(...)");
        emulatorControllerStub.getScreenshot(imageFormat, (StreamObserver)new DelegatingStreamObserver(streamObserver, methodDescriptor));
    }

    @NotNull
    public final Cancelable streamScreenshot(@NotNull ImageFormat imageFormat, @NotNull StreamObserver<Image> streamObserver) {
        Intrinsics.checkNotNullParameter((Object)imageFormat, (String)"imageFormat");
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        if (((Boolean)StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("streamScreenshot(" + TextFormat.shortDebugString((MessageOrBuilder)((MessageOrBuilder)imageFormat)) + ")");
        }
        ClientCall call = this.getEmulatorControllerStub().getChannel().newCall(this.streamScreenshotMethod, this.getEmulatorControllerStub().getCallOptions());
        MethodDescriptor<ImageFormat, Image> methodDescriptor = this.streamScreenshotMethod;
        Intrinsics.checkNotNullExpressionValue(methodDescriptor, (String)"streamScreenshotMethod");
        ClientCalls.asyncServerStreamingCall((ClientCall)call, (Object)imageFormat, (StreamObserver)new DelegatingStreamObserver<ImageFormat, Image>(streamObserver, methodDescriptor));
        Intrinsics.checkNotNull((Object)call);
        return new CancelableClientCall(call);
    }

    public final void getStatus(@NotNull StreamObserver<EmulatorStatus> streamObserver) {
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        if (((Boolean)StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("getStatus()");
        }
        EmulatorControllerGrpc.EmulatorControllerStub emulatorControllerStub = this.getEmulatorControllerStub();
        Empty empty2 = EmulatorControllerKt.access$getEMPTY_PROTO$p();
        MethodDescriptor methodDescriptor = EmulatorControllerGrpc.getGetStatusMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getGetStatusMethod(...)");
        emulatorControllerStub.getStatus(empty2, (StreamObserver)new DelegatingStreamObserver(streamObserver, methodDescriptor));
    }

    public final void setVmState(@NotNull VmRunState vmState2, @NotNull StreamObserver<Empty> streamObserver) {
        Intrinsics.checkNotNullParameter((Object)vmState2, (String)"vmState");
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        if (((Boolean)StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("setVmState(" + TextFormat.shortDebugString((MessageOrBuilder)((MessageOrBuilder)vmState2)) + ")");
        }
        EmulatorControllerGrpc.EmulatorControllerStub emulatorControllerStub = this.getEmulatorControllerStub();
        MethodDescriptor methodDescriptor = EmulatorControllerGrpc.getSetVmStateMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getSetVmStateMethod(...)");
        emulatorControllerStub.setVmState(vmState2, (StreamObserver)new DelegatingStreamObserver(streamObserver, methodDescriptor));
    }

    public static /* synthetic */ void setVmState$default(EmulatorController emulatorController, VmRunState vmRunState, StreamObserver streamObserver, int n, Object object) {
        if ((n & 2) != 0) {
            streamObserver = EmulatorControllerKt.access$getEmptyObserver();
        }
        emulatorController.setVmState(vmRunState, (StreamObserver<Empty>)streamObserver);
    }

    public final void getDisplayConfigurations(@NotNull StreamObserver<DisplayConfigurations> streamObserver) {
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        if (((Boolean)StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("getDisplayConfigurations()");
        }
        EmulatorControllerGrpc.EmulatorControllerStub emulatorControllerStub = this.getEmulatorControllerStub();
        Empty empty2 = EmulatorControllerKt.access$getEMPTY_PROTO$p();
        MethodDescriptor methodDescriptor = EmulatorControllerGrpc.getGetDisplayConfigurationsMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getGetDisplayConfigurationsMethod(...)");
        emulatorControllerStub.getDisplayConfigurations(empty2, (StreamObserver)new DelegatingStreamObserver(streamObserver, methodDescriptor));
    }

    public final void setDisplayConfigurations(@NotNull DisplayConfigurations displayConfigurations, @NotNull StreamObserver<DisplayConfigurations> streamObserver) {
        Intrinsics.checkNotNullParameter((Object)displayConfigurations, (String)"displayConfigurations");
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        if (((Boolean)StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("setDisplayConfigurations(" + TextFormat.shortDebugString((MessageOrBuilder)((MessageOrBuilder)displayConfigurations)) + ")");
        }
        EmulatorControllerGrpc.EmulatorControllerStub emulatorControllerStub = this.getEmulatorControllerStub();
        MethodDescriptor methodDescriptor = EmulatorControllerGrpc.getSetDisplayConfigurationsMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getSetDisplayConfigurationsMethod(...)");
        emulatorControllerStub.setDisplayConfigurations(displayConfigurations, (StreamObserver)new DelegatingStreamObserver(streamObserver, methodDescriptor));
    }

    public static /* synthetic */ void setDisplayConfigurations$default(EmulatorController emulatorController, DisplayConfigurations displayConfigurations, StreamObserver streamObserver, int n, Object object) {
        if ((n & 2) != 0) {
            streamObserver = EmulatorControllerKt.access$getEmptyObserver();
        }
        emulatorController.setDisplayConfigurations(displayConfigurations, (StreamObserver<DisplayConfigurations>)streamObserver);
    }

    public final void rotateVirtualSceneCamera(@NotNull RotationRadian cameraRotation, @NotNull StreamObserver<Empty> streamObserver) {
        Intrinsics.checkNotNullParameter((Object)cameraRotation, (String)"cameraRotation");
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        if (((Boolean)StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("rotateVirtualSceneCamera(" + TextFormat.shortDebugString((MessageOrBuilder)((MessageOrBuilder)cameraRotation)) + ")");
        }
        EmulatorControllerGrpc.EmulatorControllerStub emulatorControllerStub = this.getEmulatorControllerStub();
        MethodDescriptor methodDescriptor = EmulatorControllerGrpc.getRotateVirtualSceneCameraMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getRotateVirtualSceneCameraMethod(...)");
        emulatorControllerStub.rotateVirtualSceneCamera(cameraRotation, (StreamObserver)new DelegatingStreamObserver(streamObserver, methodDescriptor));
    }

    public static /* synthetic */ void rotateVirtualSceneCamera$default(EmulatorController emulatorController, RotationRadian rotationRadian, StreamObserver streamObserver, int n, Object object) {
        if ((n & 2) != 0) {
            streamObserver = EmulatorControllerKt.access$getEmptyObserver();
        }
        emulatorController.rotateVirtualSceneCamera(rotationRadian, (StreamObserver<Empty>)streamObserver);
    }

    public final void setVirtualSceneCameraVelocity(@NotNull Velocity cameraVelocity, @NotNull StreamObserver<Empty> streamObserver) {
        Intrinsics.checkNotNullParameter((Object)cameraVelocity, (String)"cameraVelocity");
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        if (((Boolean)StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("setVirtualSceneCameraVelocity(" + TextFormat.shortDebugString((MessageOrBuilder)((MessageOrBuilder)cameraVelocity)) + ")");
        }
        EmulatorControllerGrpc.EmulatorControllerStub emulatorControllerStub = this.getEmulatorControllerStub();
        MethodDescriptor methodDescriptor = EmulatorControllerGrpc.getSetVirtualSceneCameraVelocityMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getSetVirtualSceneCameraVelocityMethod(...)");
        emulatorControllerStub.setVirtualSceneCameraVelocity(cameraVelocity, (StreamObserver)new DelegatingStreamObserver(streamObserver, methodDescriptor));
    }

    public static /* synthetic */ void setVirtualSceneCameraVelocity$default(EmulatorController emulatorController, Velocity velocity, StreamObserver streamObserver, int n, Object object) {
        if ((n & 2) != 0) {
            streamObserver = EmulatorControllerKt.access$getEmptyObserver();
        }
        emulatorController.setVirtualSceneCameraVelocity(velocity, (StreamObserver<Empty>)streamObserver);
    }

    public final void listSnapshots(@NotNull SnapshotFilter snapshotFilter, @NotNull StreamObserver<SnapshotList> streamObserver) {
        Intrinsics.checkNotNullParameter((Object)snapshotFilter, (String)"snapshotFilter");
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        if (((Boolean)StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("listSnapshots()");
        }
        SnapshotServiceGrpc.SnapshotServiceStub snapshotServiceStub = this.getSnapshotServiceStub();
        MethodDescriptor methodDescriptor = SnapshotServiceGrpc.getListSnapshotsMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getListSnapshotsMethod(...)");
        snapshotServiceStub.listSnapshots(snapshotFilter, (StreamObserver)new DelegatingStreamObserver(streamObserver, methodDescriptor));
    }

    public static /* synthetic */ void listSnapshots$default(EmulatorController emulatorController, SnapshotFilter snapshotFilter, StreamObserver streamObserver, int n, Object object) {
        if ((n & 2) != 0) {
            streamObserver = EmulatorControllerKt.access$getEmptyObserver();
        }
        emulatorController.listSnapshots(snapshotFilter, (StreamObserver<SnapshotList>)streamObserver);
    }

    public final void loadSnapshot(@NotNull String snapshotId, @NotNull StreamObserver<SnapshotPackage> streamObserver) {
        Intrinsics.checkNotNullParameter((Object)snapshotId, (String)"snapshotId");
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        SnapshotPackage snapshot = SnapshotPackage.newBuilder().setSnapshotId(snapshotId).build();
        if (((Boolean)StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("loadSnapshot(" + TextFormat.shortDebugString((MessageOrBuilder)((MessageOrBuilder)snapshot)) + ")");
        }
        SnapshotServiceGrpc.SnapshotServiceStub snapshotServiceStub = this.getSnapshotServiceStub();
        MethodDescriptor methodDescriptor = SnapshotServiceGrpc.getLoadSnapshotMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getLoadSnapshotMethod(...)");
        snapshotServiceStub.loadSnapshot(snapshot, (StreamObserver)new DelegatingStreamObserver(streamObserver, methodDescriptor));
    }

    public static /* synthetic */ void loadSnapshot$default(EmulatorController emulatorController, String string, StreamObserver streamObserver, int n, Object object) {
        if ((n & 2) != 0) {
            streamObserver = EmulatorControllerKt.access$getEmptyObserver();
        }
        emulatorController.loadSnapshot(string, (StreamObserver<SnapshotPackage>)streamObserver);
    }

    @NotNull
    public final StreamObserver<SnapshotPackage> pushSnapshot(@NotNull ClientResponseObserver<SnapshotPackage, SnapshotPackage> streamObserver) {
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        if (((Boolean)StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("pushSnapshot()");
        }
        SnapshotServiceGrpc.SnapshotServiceStub snapshotServiceStub = this.getSnapshotServiceStub();
        MethodDescriptor methodDescriptor = SnapshotServiceGrpc.getPushSnapshotMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getPushSnapshotMethod(...)");
        StreamObserver streamObserver2 = snapshotServiceStub.pushSnapshot((StreamObserver)new DelegatingClientResponseObserver<SnapshotPackage, SnapshotPackage>(streamObserver, methodDescriptor));
        Intrinsics.checkNotNullExpressionValue((Object)streamObserver2, (String)"pushSnapshot(...)");
        return streamObserver2;
    }

    public final void saveSnapshot(@NotNull String snapshotId, @NotNull StreamObserver<SnapshotPackage> streamObserver) {
        Intrinsics.checkNotNullParameter((Object)snapshotId, (String)"snapshotId");
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        SnapshotPackage snapshot = SnapshotPackage.newBuilder().setSnapshotId(snapshotId).build();
        if (((Boolean)StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("saveSnapshot(" + TextFormat.shortDebugString((MessageOrBuilder)((MessageOrBuilder)snapshot)) + ")");
        }
        SnapshotServiceGrpc.SnapshotServiceStub snapshotServiceStub = this.getSnapshotServiceStub();
        MethodDescriptor methodDescriptor = SnapshotServiceGrpc.getSaveSnapshotMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getSaveSnapshotMethod(...)");
        snapshotServiceStub.saveSnapshot(snapshot, (StreamObserver)new DelegatingStreamObserver(streamObserver, methodDescriptor));
    }

    public static /* synthetic */ void saveSnapshot$default(EmulatorController emulatorController, String string, StreamObserver streamObserver, int n, Object object) {
        if ((n & 2) != 0) {
            streamObserver = EmulatorControllerKt.access$getEmptyObserver();
        }
        emulatorController.saveSnapshot(string, (StreamObserver<SnapshotPackage>)streamObserver);
    }

    public final void deleteSnapshot(@NotNull String snapshotId, @NotNull StreamObserver<SnapshotPackage> streamObserver) {
        Intrinsics.checkNotNullParameter((Object)snapshotId, (String)"snapshotId");
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        SnapshotPackage snapshot = SnapshotPackage.newBuilder().setSnapshotId(snapshotId).build();
        if (((Boolean)StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("deleteSnapshot(" + TextFormat.shortDebugString((MessageOrBuilder)((MessageOrBuilder)snapshot)) + ")");
        }
        SnapshotServiceGrpc.SnapshotServiceStub snapshotServiceStub = this.getSnapshotServiceStub();
        MethodDescriptor methodDescriptor = SnapshotServiceGrpc.getSaveSnapshotMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getSaveSnapshotMethod(...)");
        snapshotServiceStub.deleteSnapshot(snapshot, (StreamObserver)new DelegatingStreamObserver(streamObserver, methodDescriptor));
    }

    public static /* synthetic */ void deleteSnapshot$default(EmulatorController emulatorController, String string, StreamObserver streamObserver, int n, Object object) {
        if ((n & 2) != 0) {
            streamObserver = EmulatorControllerKt.access$getEmptyObserver();
        }
        emulatorController.deleteSnapshot(string, (StreamObserver<SnapshotPackage>)streamObserver);
    }

    public final void showExtendedControls(@NotNull PaneEntry pane, @NotNull StreamObserver<ExtendedControlsStatus> streamObserver) {
        Intrinsics.checkNotNullParameter((Object)pane, (String)"pane");
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        if (((Boolean)StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("showExtendedControls(" + TextFormat.shortDebugString((MessageOrBuilder)((MessageOrBuilder)pane)) + ")");
        }
        UiControllerGrpc.UiControllerStub uiControllerStub = this.getUiControllerStub();
        MethodDescriptor methodDescriptor = UiControllerGrpc.getShowExtendedControlsMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getShowExtendedControlsMethod(...)");
        uiControllerStub.showExtendedControls(pane, (StreamObserver)new DelegatingStreamObserver(streamObserver, methodDescriptor));
    }

    public static /* synthetic */ void showExtendedControls$default(EmulatorController emulatorController, PaneEntry paneEntry, StreamObserver streamObserver, int n, Object object) {
        if ((n & 2) != 0) {
            streamObserver = EmulatorControllerKt.access$getEmptyObserver();
        }
        emulatorController.showExtendedControls(paneEntry, (StreamObserver<ExtendedControlsStatus>)streamObserver);
    }

    public final void closeExtendedControls(@NotNull StreamObserver<ExtendedControlsStatus> streamObserver) {
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        if (((Boolean)StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("closeExtendedControls()");
        }
        UiControllerGrpc.UiControllerStub uiControllerStub = this.getUiControllerStub();
        Empty empty2 = EmulatorControllerKt.access$getEMPTY_PROTO$p();
        MethodDescriptor methodDescriptor = UiControllerGrpc.getCloseExtendedControlsMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getCloseExtendedControlsMethod(...)");
        uiControllerStub.closeExtendedControls(empty2, (StreamObserver)new DelegatingStreamObserver(streamObserver, methodDescriptor));
    }

    public static /* synthetic */ void closeExtendedControls$default(EmulatorController emulatorController, StreamObserver streamObserver, int n, Object object) {
        if ((n & 1) != 0) {
            streamObserver = EmulatorControllerKt.access$getEmptyObserver();
        }
        emulatorController.closeExtendedControls((StreamObserver<ExtendedControlsStatus>)streamObserver);
    }

    public final void setUiTheme(@NotNull ThemingStyle.Style style, @NotNull StreamObserver<Empty> streamObserver) {
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        ThemingStyle themingStyle = ThemingStyle.newBuilder().setStyle(style).build();
        if (((Boolean)StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("setUiTheme(" + TextFormat.shortDebugString((MessageOrBuilder)((MessageOrBuilder)themingStyle)) + ")");
        }
        UiControllerGrpc.UiControllerStub uiControllerStub = this.getUiControllerStub();
        MethodDescriptor methodDescriptor = UiControllerGrpc.getSetUiThemeMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getSetUiThemeMethod(...)");
        uiControllerStub.setUiTheme(themingStyle, (StreamObserver)new DelegatingStreamObserver(streamObserver, methodDescriptor));
    }

    public static /* synthetic */ void setUiTheme$default(EmulatorController emulatorController, ThemingStyle.Style style, StreamObserver streamObserver, int n, Object object) {
        if ((n & 2) != 0) {
            streamObserver = EmulatorControllerKt.access$getEmptyObserver();
        }
        emulatorController.setUiTheme(style, (StreamObserver<Empty>)streamObserver);
    }

    private final void sendKeepAlive() {
        EmptyStreamObserver<VmRunState> responseObserver2 = new EmptyStreamObserver<VmRunState>(this){
            final /* synthetic */ EmulatorController this$0;
            {
                this.this$0 = $receiver;
            }

            public void onNext(VmRunState message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                if (EmulatorController.access$getEmulatorState$p(this.this$0).get() == EmulatorState.SHUTDOWN_REQUESTED) {
                    EmulatorController.access$sendShutdown(this.this$0);
                } else {
                    EmulatorController.access$getAlarm$p(this.this$0).cancelAllRequests();
                    EmulatorController.access$getAlarm$p(this.this$0).addRequest(() -> EmulatorController.access$sendKeepAlive(this.this$0), EmulatorControllerKt.access$getKEEP_ALIVE_INTERVAL_MILLIS$p());
                }
            }
        };
        if (((Boolean)StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("getVmState()");
        }
        long timeout = this.getConnectionState() == ConnectionState.CONNECTED ? 3L : 15L;
        EmulatorControllerGrpc.EmulatorControllerStub emulatorControllerStub = (EmulatorControllerGrpc.EmulatorControllerStub)this.getEmulatorControllerStub().withDeadlineAfter(timeout, TimeUnit.SECONDS);
        Empty empty2 = EmulatorControllerKt.access$getEMPTY_PROTO$p();
        StreamObserver streamObserver = responseObserver2;
        MethodDescriptor methodDescriptor = EmulatorControllerGrpc.getGetVmStateMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getGetVmStateMethod(...)");
        emulatorControllerStub.getVmState(empty2, (StreamObserver)new DelegatingStreamObserver(streamObserver, methodDescriptor));
    }

    private final Void throwNotYetConnected() {
        throw new IllegalStateException("Not yet connected to the Emulator");
    }

    public void dispose() {
        block1: {
            StreamObserver<InputEvent> streamObserver = this.inputEventSender;
            if (streamObserver != null) {
                streamObserver.onCompleted();
            }
            this.inputEventSender = null;
            ManagedChannel managedChannel = this.getChannel();
            if (managedChannel == null) break block1;
            managedChannel.shutdown();
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(((Object)((Object)this)).getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.android.tools.idea.streaming.emulator.EmulatorController");
        EmulatorController cfr_ignored_0 = (EmulatorController)((Object)object2);
        return Intrinsics.areEqual((Object)this.emulatorId, (Object)((EmulatorController)((Object)other)).emulatorId);
    }

    public int hashCode() {
        return this.emulatorId.hashCode();
    }

    public static final /* synthetic */ void access$sendShutdown(EmulatorController $this) {
        $this.sendShutdown();
    }

    public static final /* synthetic */ Alarm access$getAlarm$p(EmulatorController $this) {
        return $this.alarm;
    }

    public static final /* synthetic */ void access$sendKeepAlive(EmulatorController $this) {
        $this.sendKeepAlive();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016R\u0016\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorController$CancelableClientCall;", "Lcom/android/ide/common/util/Cancelable;", "call", "Lcom/android/tools/idea/io/grpc/ClientCall;", "<init>", "(Lcom/android/tools/idea/io/grpc/ClientCall;)V", "cancel", "", "intellij.android.streaming"})
    public static final class CancelableClientCall
    implements Cancelable {
        @NotNull
        private final ClientCall<?, ?> call;

        public CancelableClientCall(@NotNull ClientCall<?, ?> call) {
            Intrinsics.checkNotNullParameter(call, (String)"call");
            this.call = call;
        }

        public void cancel() {
            this.call.cancel("Canceled by consumer", null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorController$Connection;", "", "channel", "Lcom/android/tools/idea/io/grpc/ManagedChannel;", "maxInboundMessageSize", "", "emulatorControllerStub", "Lcom/android/emulator/control/EmulatorControllerGrpc$EmulatorControllerStub;", "snapshotServiceStub", "Lcom/android/emulator/control/SnapshotServiceGrpc$SnapshotServiceStub;", "uiControllerStub", "Lcom/android/emulator/control/UiControllerGrpc$UiControllerStub;", "<init>", "(Lcom/android/tools/idea/io/grpc/ManagedChannel;ILcom/android/emulator/control/EmulatorControllerGrpc$EmulatorControllerStub;Lcom/android/emulator/control/SnapshotServiceGrpc$SnapshotServiceStub;Lcom/android/emulator/control/UiControllerGrpc$UiControllerStub;)V", "getChannel", "()Lcom/android/tools/idea/io/grpc/ManagedChannel;", "getMaxInboundMessageSize", "()I", "getEmulatorControllerStub", "()Lcom/android/emulator/control/EmulatorControllerGrpc$EmulatorControllerStub;", "getSnapshotServiceStub", "()Lcom/android/emulator/control/SnapshotServiceGrpc$SnapshotServiceStub;", "getUiControllerStub", "()Lcom/android/emulator/control/UiControllerGrpc$UiControllerStub;", "intellij.android.streaming"})
    private static final class Connection {
        @NotNull
        private final ManagedChannel channel;
        private final int maxInboundMessageSize;
        @NotNull
        private final EmulatorControllerGrpc.EmulatorControllerStub emulatorControllerStub;
        @NotNull
        private final SnapshotServiceGrpc.SnapshotServiceStub snapshotServiceStub;
        @NotNull
        private final UiControllerGrpc.UiControllerStub uiControllerStub;

        public Connection(@NotNull ManagedChannel channel, int maxInboundMessageSize, @NotNull EmulatorControllerGrpc.EmulatorControllerStub emulatorControllerStub, @NotNull SnapshotServiceGrpc.SnapshotServiceStub snapshotServiceStub, @NotNull UiControllerGrpc.UiControllerStub uiControllerStub) {
            Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
            Intrinsics.checkNotNullParameter((Object)emulatorControllerStub, (String)"emulatorControllerStub");
            Intrinsics.checkNotNullParameter((Object)snapshotServiceStub, (String)"snapshotServiceStub");
            Intrinsics.checkNotNullParameter((Object)uiControllerStub, (String)"uiControllerStub");
            this.channel = channel;
            this.maxInboundMessageSize = maxInboundMessageSize;
            this.emulatorControllerStub = emulatorControllerStub;
            this.snapshotServiceStub = snapshotServiceStub;
            this.uiControllerStub = uiControllerStub;
        }

        @NotNull
        public final ManagedChannel getChannel() {
            return this.channel;
        }

        public final int getMaxInboundMessageSize() {
            return this.maxInboundMessageSize;
        }

        @NotNull
        public final EmulatorControllerGrpc.EmulatorControllerStub getEmulatorControllerStub() {
            return this.emulatorControllerStub;
        }

        @NotNull
        public final SnapshotServiceGrpc.SnapshotServiceStub getSnapshotServiceStub() {
            return this.snapshotServiceStub;
        }

        @NotNull
        public final UiControllerGrpc.UiControllerStub getUiControllerStub() {
            return this.uiControllerStub;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorController$ConnectionState;", "", "<init>", "(Ljava/lang/String;I)V", "NOT_INITIALIZED", "CONNECTING", "CONNECTED", "DISCONNECTED", "intellij.android.streaming"})
    public static final class ConnectionState
    extends Enum<ConnectionState> {
        public static final /* enum */ ConnectionState NOT_INITIALIZED = new ConnectionState();
        public static final /* enum */ ConnectionState CONNECTING = new ConnectionState();
        public static final /* enum */ ConnectionState CONNECTED = new ConnectionState();
        public static final /* enum */ ConnectionState DISCONNECTED = new ConnectionState();
        private static final /* synthetic */ ConnectionState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ConnectionState[] values() {
            return (ConnectionState[])$VALUES.clone();
        }

        public static ConnectionState valueOf(String value2) {
            return Enum.valueOf(ConnectionState.class, value2);
        }

        @NotNull
        public static EnumEntries<ConnectionState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = connectionStateArray = new ConnectionState[]{ConnectionState.NOT_INITIALIZED, ConnectionState.CONNECTING, ConnectionState.CONNECTED, ConnectionState.DISCONNECTED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H'\u00a8\u0006\b\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorController$ConnectionStateListener;", "", "connectionStateChanged", "", "emulator", "Lcom/android/tools/idea/streaming/emulator/EmulatorController;", "connectionState", "Lcom/android/tools/idea/streaming/emulator/EmulatorController$ConnectionState;", "intellij.android.streaming"})
    public static interface ConnectionStateListener {
        @AnyThread
        public void connectionStateChanged(@NotNull EmulatorController var1, @NotNull ConnectionState var2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u0012\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003R\u00020\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0005B5\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0005\u0012\u0016\u0010\u0007\u001a\u0012\u0012\u0006\b\u0000\u0012\u00028\u0000\u0012\u0006\b\u0000\u0012\u00028\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0010H\u0016R\"\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorController$DelegatingClientResponseObserver;", "RequestT", "ResponseT", "Lcom/android/tools/idea/streaming/emulator/EmulatorController$DelegatingStreamObserver;", "Lcom/android/tools/idea/streaming/emulator/EmulatorController;", "Lcom/android/tools/idea/io/grpc/stub/ClientResponseObserver;", "delegate", "method", "Lcom/android/tools/idea/io/grpc/MethodDescriptor;", "<init>", "(Lcom/android/tools/idea/streaming/emulator/EmulatorController;Lcom/android/tools/idea/io/grpc/stub/ClientResponseObserver;Lcom/android/tools/idea/io/grpc/MethodDescriptor;)V", "getDelegate", "()Lcom/android/tools/idea/io/grpc/stub/ClientResponseObserver;", "beforeStart", "", "requestStream", "Lcom/android/tools/idea/io/grpc/stub/ClientCallStreamObserver;", "intellij.android.streaming"})
    public final class DelegatingClientResponseObserver<RequestT, ResponseT>
    extends DelegatingStreamObserver<RequestT, ResponseT>
    implements ClientResponseObserver<RequestT, ResponseT> {
        @Nullable
        private final ClientResponseObserver<RequestT, ResponseT> delegate;

        public DelegatingClientResponseObserver(@NotNull ClientResponseObserver<RequestT, ResponseT> delegate2, MethodDescriptor<? super RequestT, ? super ResponseT> method2) {
            Intrinsics.checkNotNullParameter(method2, (String)"method");
            super((StreamObserver)delegate2, method2);
            this.delegate = delegate2;
        }

        @Nullable
        public ClientResponseObserver<RequestT, ResponseT> getDelegate() {
            return this.delegate;
        }

        public void beforeStart(@Nullable ClientCallStreamObserver<RequestT> requestStream) {
            block0: {
                ClientResponseObserver<RequestT, ResponseT> clientResponseObserver = this.getDelegate();
                if (clientResponseObserver == null) break block0;
                clientResponseObserver.beforeStart(requestStream);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0096\u0004\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\b\u0012\u0004\u0012\u0002H\u00020\u0003B1\u0012\u0010\u0010\u0004\u001a\f\u0012\u0006\b\u0000\u0012\u00028\u0001\u0018\u00010\u0003\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0006\b\u0000\u0012\u00028\u0000\u0012\u0006\b\u0000\u0012\u00028\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0011H\u0016R\u001e\u0010\u0004\u001a\f\u0012\u0006\b\u0000\u0012\u00028\u0001\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR!\u0010\u0005\u001a\u0012\u0012\u0006\b\u0000\u0012\u00028\u0000\u0012\u0006\b\u0000\u0012\u00028\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorController$DelegatingStreamObserver;", "RequestT", "ResponseT", "Lcom/android/tools/idea/io/grpc/stub/StreamObserver;", "delegate", "method", "Lcom/android/tools/idea/io/grpc/MethodDescriptor;", "<init>", "(Lcom/android/tools/idea/streaming/emulator/EmulatorController;Lcom/android/tools/idea/io/grpc/stub/StreamObserver;Lcom/android/tools/idea/io/grpc/MethodDescriptor;)V", "getDelegate", "()Lcom/android/tools/idea/io/grpc/stub/StreamObserver;", "getMethod", "()Lcom/android/tools/idea/io/grpc/MethodDescriptor;", "connection", "Lcom/android/tools/idea/streaming/emulator/EmulatorController$Connection;", "kotlin.jvm.PlatformType", "onNext", "", "response", "(Ljava/lang/Object;)V", "onError", "t", "", "onCompleted", "intellij.android.streaming"})
    public class DelegatingStreamObserver<RequestT, ResponseT>
    implements StreamObserver<ResponseT> {
        @Nullable
        private final StreamObserver<? super ResponseT> delegate;
        @NotNull
        private final MethodDescriptor<? super RequestT, ? super ResponseT> method;
        private final Connection connection;

        public DelegatingStreamObserver(@NotNull StreamObserver<? super ResponseT> delegate2, MethodDescriptor<? super RequestT, ? super ResponseT> method2) {
            Intrinsics.checkNotNullParameter(method2, (String)"method");
            this.delegate = delegate2;
            this.method = method2;
            this.connection = (Connection)EmulatorController.this.connectionReference.get();
        }

        @Nullable
        public StreamObserver<? super ResponseT> getDelegate() {
            return this.delegate;
        }

        @NotNull
        public final MethodDescriptor<? super RequestT, ? super ResponseT> getMethod() {
            return this.method;
        }

        public void onNext(ResponseT response2) {
            block0: {
                StreamObserver<ResponseT> streamObserver = this.getDelegate();
                if (streamObserver == null) break block0;
                streamObserver.onNext(response2);
            }
        }

        public void onError(@NotNull Throwable t) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            ManagedChannel managedChannel = EmulatorController.this.getChannel();
            boolean bl = managedChannel != null ? !managedChannel.isShutdown() : false;
            if (bl && (!(t instanceof StatusRuntimeException) || ((StatusRuntimeException)t).getStatus().getCode() != Status.Code.CANCELLED && (((StatusRuntimeException)t).getStatus().getCode() != Status.Code.UNAVAILABLE || EmulatorController.this.emulatorState.get() == EmulatorState.RUNNING))) {
                EmulatorControllerKt.access$getLOG$p().warn(this.method.getFullMethodName() + " call failed - " + t.getMessage());
            }
            Throwable error = Intrinsics.areEqual((Object)this.connection, EmulatorController.this.connectionReference.get()) ? t : (Throwable)new RetryException();
            StreamObserver<ResponseT> streamObserver = this.getDelegate();
            if (streamObserver != null) {
                streamObserver.onError(error);
            }
            if (t instanceof StatusRuntimeException && ((StatusRuntimeException)t).getStatus().getCode() == Status.Code.UNAVAILABLE && Intrinsics.areEqual((Object)this.connection, EmulatorController.this.connectionReference.get())) {
                EmulatorController.this.updateConnectionState(ConnectionState.CONNECTED, ConnectionState.DISCONNECTED);
            }
        }

        public void onCompleted() {
            block0: {
                StreamObserver<ResponseT> streamObserver = this.getDelegate();
                if (streamObserver == null) break block0;
                streamObserver.onCompleted();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorController$EmulatorState;", "", "<init>", "(Ljava/lang/String;I)V", "RUNNING", "SHUTDOWN_REQUESTED", "SHUTDOWN_SENT", "intellij.android.streaming"})
    public static final class EmulatorState
    extends Enum<EmulatorState> {
        public static final /* enum */ EmulatorState RUNNING = new EmulatorState();
        public static final /* enum */ EmulatorState SHUTDOWN_REQUESTED = new EmulatorState();
        public static final /* enum */ EmulatorState SHUTDOWN_SENT = new EmulatorState();
        private static final /* synthetic */ EmulatorState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static EmulatorState[] values() {
            return (EmulatorState[])$VALUES.clone();
        }

        public static EmulatorState valueOf(String value2) {
            return Enum.valueOf(EmulatorState.class, value2);
        }

        @NotNull
        public static EnumEntries<EmulatorState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = emulatorStateArray = new EmulatorState[]{EmulatorState.RUNNING, EmulatorState.SHUTDOWN_REQUESTED, EmulatorState.SHUTDOWN_SENT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorController$RetryException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "<init>", "()V", "intellij.android.streaming"})
    public static final class RetryException
    extends RuntimeException {
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorController$TokenCallCredentials;", "Lcom/android/tools/idea/io/grpc/CallCredentials;", "token", "", "<init>", "(Ljava/lang/String;)V", "applyRequestMetadata", "", "requestInfo", "Lcom/android/tools/idea/io/grpc/CallCredentials$RequestInfo;", "executor", "Ljava/util/concurrent/Executor;", "applier", "Lcom/android/tools/idea/io/grpc/CallCredentials$MetadataApplier;", "intellij.android.streaming"})
    private static final class TokenCallCredentials
    extends CallCredentials {
        @NotNull
        private final String token;

        public TokenCallCredentials(@NotNull String token) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            this.token = token;
        }

        public void applyRequestMetadata(@NotNull CallCredentials.RequestInfo requestInfo, @NotNull Executor executor, @NotNull CallCredentials.MetadataApplier applier) {
            Intrinsics.checkNotNullParameter((Object)requestInfo, (String)"requestInfo");
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            Intrinsics.checkNotNullParameter((Object)applier, (String)"applier");
            executor.execute(() -> TokenCallCredentials.applyRequestMetadata$lambda$0(this, applier));
        }

        private static final void applyRequestMetadata$lambda$0(TokenCallCredentials this$0, CallCredentials.MetadataApplier $applier) {
            try {
                com.android.tools.idea.io.grpc.Metadata headers = new com.android.tools.idea.io.grpc.Metadata();
                headers.put(EmulatorControllerKt.access$getAUTHORIZATION_METADATA_KEY$p(), (Object)("Bearer " + this$0.token));
                $applier.apply(headers);
            }
            catch (Throwable e) {
                EmulatorControllerKt.access$getLOG$p().error(e);
                $applier.fail(Status.UNAUTHENTICATED.withCause(e));
            }
        }
    }
}

