/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.emulator;

import com.android.emulator.control.DisplayModeValue;
import com.android.emulator.control.Posture;
import com.android.sdklib.AndroidApiLevel;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SystemImageTags;
import com.android.sdklib.deviceprovisioner.DeviceType;
import com.android.tools.idea.streaming.core.StreamingConstants;
import com.android.tools.idea.streaming.emulator.KeyValueFiles;
import com.android.utils.StringHelper;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Dimension;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b'\u0018\u0000 ?2\u00020\u0001:\u0003?@AB\u00a5\u0001\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000b0\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u0012\u0006\u0010\u0014\u001a\u00020\u0012\u0012\u0006\u0010\u0015\u001a\u00020\u0012\u0012\u0006\u0010\u0016\u001a\u00020\r\u0012\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018\u0012\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0018\u0012\b\u0010\u001c\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000b0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010 R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0011\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010/R\u0011\u0010\u0014\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010/R\u0011\u0010\u0015\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010/R\u0011\u0010\u0016\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010*R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00105R\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010(R\u0011\u00108\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b9\u0010*R\u0011\u0010:\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b;\u0010*R\u0011\u0010<\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b<\u0010/R\u0011\u0010=\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b>\u0010*\u00a8\u0006B"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorConfiguration;", "", "avdFolder", "Ljava/nio/file/Path;", "avdName", "", "deviceType", "Lcom/android/sdklib/deviceprovisioner/DeviceType;", "androidVersion", "Lcom/android/sdklib/AndroidVersion;", "displaySize", "Ljava/awt/Dimension;", "density", "", "additionalDisplays", "", "skinFolder", "hasOrientationSensors", "", "hasAudioOutput", "hasTransparentDisplay", "hasTouchScreen", "initialOrientationQuadrants", "displayModes", "", "Lcom/android/tools/idea/streaming/emulator/EmulatorConfiguration$DisplayMode;", "postures", "Lcom/android/tools/idea/streaming/emulator/EmulatorConfiguration$PostureDescriptor;", "touchpadSize", "<init>", "(Ljava/nio/file/Path;Ljava/lang/String;Lcom/android/sdklib/deviceprovisioner/DeviceType;Lcom/android/sdklib/AndroidVersion;Ljava/awt/Dimension;ILjava/util/Map;Ljava/nio/file/Path;ZZZZILjava/util/List;Ljava/util/List;Ljava/awt/Dimension;)V", "getAvdFolder", "()Ljava/nio/file/Path;", "getAvdName", "()Ljava/lang/String;", "getDeviceType", "()Lcom/android/sdklib/deviceprovisioner/DeviceType;", "getAndroidVersion", "()Lcom/android/sdklib/AndroidVersion;", "getDisplaySize", "()Ljava/awt/Dimension;", "getDensity", "()I", "getAdditionalDisplays", "()Ljava/util/Map;", "getSkinFolder", "getHasOrientationSensors", "()Z", "getHasAudioOutput", "getHasTransparentDisplay", "getHasTouchScreen", "getInitialOrientationQuadrants", "getDisplayModes", "()Ljava/util/List;", "getPostures", "getTouchpadSize", "displayWidth", "getDisplayWidth", "displayHeight", "getDisplayHeight", "isValid", "api", "getApi", "Companion", "DisplayMode", "PostureDescriptor", "intellij.android.streaming"})
public final class EmulatorConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path avdFolder;
    @NotNull
    private final String avdName;
    @NotNull
    private final DeviceType deviceType;
    @NotNull
    private final AndroidVersion androidVersion;
    @NotNull
    private final Dimension displaySize;
    private final int density;
    @NotNull
    private final Map<Integer, Dimension> additionalDisplays;
    @Nullable
    private final Path skinFolder;
    private final boolean hasOrientationSensors;
    private final boolean hasAudioOutput;
    private final boolean hasTransparentDisplay;
    private final boolean hasTouchScreen;
    private final int initialOrientationQuadrants;
    @NotNull
    private final List<DisplayMode> displayModes;
    @NotNull
    private final List<PostureDescriptor> postures;
    @Nullable
    private final Dimension touchpadSize;

    private EmulatorConfiguration(Path avdFolder, String avdName, DeviceType deviceType, AndroidVersion androidVersion, Dimension displaySize, int density, Map<Integer, ? extends Dimension> additionalDisplays, Path skinFolder, boolean hasOrientationSensors, boolean hasAudioOutput, boolean hasTransparentDisplay, boolean hasTouchScreen, int initialOrientationQuadrants, List<DisplayMode> displayModes, List<PostureDescriptor> postures, Dimension touchpadSize) {
        this.avdFolder = avdFolder;
        this.avdName = avdName;
        this.deviceType = deviceType;
        this.androidVersion = androidVersion;
        this.displaySize = displaySize;
        this.density = density;
        this.additionalDisplays = additionalDisplays;
        this.skinFolder = skinFolder;
        this.hasOrientationSensors = hasOrientationSensors;
        this.hasAudioOutput = hasAudioOutput;
        this.hasTransparentDisplay = hasTransparentDisplay;
        this.hasTouchScreen = hasTouchScreen;
        this.initialOrientationQuadrants = initialOrientationQuadrants;
        this.displayModes = displayModes;
        this.postures = postures;
        this.touchpadSize = touchpadSize;
    }

    @NotNull
    public final Path getAvdFolder() {
        return this.avdFolder;
    }

    @NotNull
    public final String getAvdName() {
        return this.avdName;
    }

    @NotNull
    public final DeviceType getDeviceType() {
        return this.deviceType;
    }

    @NotNull
    public final AndroidVersion getAndroidVersion() {
        return this.androidVersion;
    }

    @NotNull
    public final Dimension getDisplaySize() {
        return this.displaySize;
    }

    public final int getDensity() {
        return this.density;
    }

    @NotNull
    public final Map<Integer, Dimension> getAdditionalDisplays() {
        return this.additionalDisplays;
    }

    @Nullable
    public final Path getSkinFolder() {
        return this.skinFolder;
    }

    public final boolean getHasOrientationSensors() {
        return this.hasOrientationSensors;
    }

    public final boolean getHasAudioOutput() {
        return this.hasAudioOutput;
    }

    public final boolean getHasTransparentDisplay() {
        return this.hasTransparentDisplay;
    }

    public final boolean getHasTouchScreen() {
        return this.hasTouchScreen;
    }

    public final int getInitialOrientationQuadrants() {
        return this.initialOrientationQuadrants;
    }

    @NotNull
    public final List<DisplayMode> getDisplayModes() {
        return this.displayModes;
    }

    @NotNull
    public final List<PostureDescriptor> getPostures() {
        return this.postures;
    }

    @Nullable
    public final Dimension getTouchpadSize() {
        return this.touchpadSize;
    }

    public final int getDisplayWidth() {
        return this.displaySize.width;
    }

    public final int getDisplayHeight() {
        return this.displaySize.height;
    }

    public final boolean isValid() {
        return this.displaySize.width > 0 && this.displaySize.height > 0 && this.androidVersion.getAndroidApiLevel().getMajorVersion() > 0;
    }

    public final int getApi() {
        return this.androidVersion.getAndroidApiLevel().getMajorVersion();
    }

    public /* synthetic */ EmulatorConfiguration(Path avdFolder, String avdName, DeviceType deviceType, AndroidVersion androidVersion, Dimension displaySize, int density, Map additionalDisplays, Path skinFolder, boolean hasOrientationSensors, boolean hasAudioOutput, boolean hasTransparentDisplay, boolean hasTouchScreen, int initialOrientationQuadrants, List displayModes, List postures, Dimension touchpadSize, DefaultConstructorMarker $constructor_marker) {
        this(avdFolder, avdName, deviceType, androidVersion, displaySize, density, additionalDisplays, skinFolder, hasOrientationSensors, hasAudioOutput, hasTransparentDisplay, hasTouchScreen, initialOrientationQuadrants, displayModes, postures, touchpadSize);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001a\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\tH\u0002J\u0016\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007J&\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u00112\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00142\u0006\u0010\u001d\u001a\u00020\u000bH\u0002J\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u000bH\u0002J\"\u0010 \u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\"0!0\u00142\u0006\u0010#\u001a\u00020\u000bH\u0002J\u001c\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\"0!2\u0006\u0010%\u001a\u00020\u000bH\u0002\u00a8\u0006&"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorConfiguration$Companion;", "", "<init>", "()V", "readAvdDefinition", "Lcom/android/tools/idea/streaming/emulator/EmulatorConfiguration;", "avdFolder", "Ljava/nio/file/Path;", "getConfigBoolean", "", "value", "", "defaultValue", "createStub", "avdName", "getSkinPath", "configIni", "", "androidSdkRoot", "parseDisplayModes", "", "Lcom/android/tools/idea/streaming/emulator/EmulatorConfiguration$DisplayMode;", "modes", "postureMode", "", "parseDisplayMode", "mode", "parsePostures", "Lcom/android/emulator/control/Posture$PostureValue;", "postures", "postureForNumber", "postureIndex", "parseRanges", "Lkotlin/Pair;", "", "ranges", "parseRange", "range", "intellij.android.streaming"})
    @SourceDebugExtension(value={"SMAP\nEmulatorConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmulatorConfiguration.kt\ncom/android/tools/idea/streaming/emulator/EmulatorConfiguration$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,314:1\n1#2:315\n1563#3:316\n1634#3,3:317\n1563#3:320\n1634#3,3:321\n1563#3:324\n1634#3,3:325\n1563#3:328\n1634#3,3:329\n*S KotlinDebug\n*F\n+ 1 EmulatorConfiguration.kt\ncom/android/tools/idea/streaming/emulator/EmulatorConfiguration$Companion\n*L\n248#1:316\n248#1:317,3\n262#1:320\n262#1:321,3\n272#1:324\n272#1:325,3\n275#1:328\n275#1:329,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final EmulatorConfiguration readAvdDefinition(@NotNull Path avdFolder) {
            block43: {
                block42: {
                    block30: {
                        block37: {
                            block36: {
                                block35: {
                                    block34: {
                                        block33: {
                                            block32: {
                                                block31: {
                                                    block29: {
                                                        Intrinsics.checkNotNullParameter((Object)avdFolder, (String)"avdFolder");
                                                        hardwareIniFile = avdFolder.resolve("hardware-qemu.ini");
                                                        var4_3 = new String[]{"android.sdk.root", "hw.audioOutput", "hw.lcd.height", "hw.lcd.width", "hw.lcd.density", "hw.sensor.hinge.resizable.config"};
                                                        keysToExtract = SetsKt.setOf((Object[])var4_3);
                                                        Intrinsics.checkNotNull((Object)hardwareIniFile);
                                                        hardwareIni = KeyValueFiles.readKeyValueFile(hardwareIniFile, keysToExtract);
                                                        v0 = hardwareIni.get("android.sdk.root");
                                                        if (v0 == null && (v0 = System.getenv("ANDROID_HOME")) == null) {
                                                            v0 = "";
                                                        }
                                                        sdkPath = v0;
                                                        androidSdkRoot = avdFolder.resolve(sdkPath);
                                                        displayWidth = StringUtil.parseInt((String)hardwareIni.get("hw.lcd.width"), (int)0);
                                                        displayHeight = StringUtil.parseInt((String)hardwareIni.get("hw.lcd.height"), (int)0);
                                                        if (displayWidth <= 0 || displayHeight <= 0) {
                                                            throw new RuntimeException("Invalid display size: " + displayWidth + " x " + displayHeight);
                                                        }
                                                        density = StringUtil.parseInt((String)hardwareIni.get("hw.lcd.density"), (int)0);
                                                        v1 = hardwareIni.get("hw.audioOutput");
                                                        hasAudioOutput = v1 != null ? Boolean.parseBoolean(v1) : true;
                                                        configIniFile = avdFolder.resolve("config.ini");
                                                        Intrinsics.checkNotNull((Object)configIniFile);
                                                        configIni = KeyValueFiles.readKeyValueFile$default(configIniFile, null, 2, null);
                                                        v2 = (String)configIni.get("avd.ini.displayname");
                                                        if (v2 == null) {
                                                            v2 = StringsKt.replace$default((String)StringsKt.removeSuffix((String)avdFolder.getFileName().toString(), (CharSequence)".avd"), (char)'_', (char)' ', (boolean)false, (int)4, null);
                                                        }
                                                        avdName = v2;
                                                        initialOrientation = StringsKt.equals((String)"landscape", (String)((String)configIni.get("hw.initialOrientation")), (boolean)true) != false ? 1 : 0;
                                                        Intrinsics.checkNotNull((Object)androidSdkRoot);
                                                        skinPath = this.getSkinPath(configIni, androidSdkRoot);
                                                        v3 = (String)configIni.get("tag.ids");
                                                        if (v3 == null) {
                                                            v3 = (String)configIni.get("tag.id");
                                                        }
                                                        tagIds = v3;
                                                        if (tagIds != null) break block29;
                                                        v4 = DeviceType.HANDHELD;
                                                        break block30;
                                                    }
                                                    v5 = tagIds;
                                                    v6 = SystemImageTags.AUTOMOTIVE_TAG.getId();
                                                    Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getId(...)");
                                                    if (StringHelper.asSeparatedListContains$default((CharSequence)v5, (CharSequence)v6, null, (int)2, null)) break block31;
                                                    v7 = tagIds;
                                                    v8 = SystemImageTags.AUTOMOTIVE_PLAY_STORE_TAG.getId();
                                                    Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"getId(...)");
                                                    if (StringHelper.asSeparatedListContains$default((CharSequence)v7, (CharSequence)v8, null, (int)2, null)) break block31;
                                                    v9 = tagIds;
                                                    v10 = SystemImageTags.AUTOMOTIVE_DISTANT_DISPLAY_TAG.getId();
                                                    Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"getId(...)");
                                                    if (!StringHelper.asSeparatedListContains$default((CharSequence)v9, (CharSequence)v10, null, (int)2, null)) break block32;
                                                }
                                                v4 = DeviceType.AUTOMOTIVE;
                                                break block30;
                                            }
                                            v11 = tagIds;
                                            v12 = SystemImageTags.DESKTOP_TAG.getId();
                                            Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"getId(...)");
                                            if (!StringHelper.asSeparatedListContains$default((CharSequence)v11, (CharSequence)v12, null, (int)2, null)) break block33;
                                            v4 = DeviceType.DESKTOP;
                                            break block30;
                                        }
                                        v13 = tagIds;
                                        v14 = SystemImageTags.GOOGLE_TV_TAG.getId();
                                        Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"getId(...)");
                                        if (StringHelper.asSeparatedListContains$default((CharSequence)v13, (CharSequence)v14, null, (int)2, null)) break block34;
                                        v15 = tagIds;
                                        v16 = SystemImageTags.ANDROID_TV_TAG.getId();
                                        Intrinsics.checkNotNullExpressionValue((Object)v16, (String)"getId(...)");
                                        if (!StringHelper.asSeparatedListContains$default((CharSequence)v15, (CharSequence)v16, null, (int)2, null)) break block35;
                                    }
                                    v4 = DeviceType.TV;
                                    break block30;
                                }
                                v17 = tagIds;
                                v18 = SystemImageTags.WEAR_TAG.getId();
                                Intrinsics.checkNotNullExpressionValue((Object)v18, (String)"getId(...)");
                                if (!StringHelper.asSeparatedListContains$default((CharSequence)v17, (CharSequence)v18, null, (int)2, null)) break block36;
                                v4 = DeviceType.WEAR;
                                break block30;
                            }
                            v19 = tagIds;
                            v20 = SystemImageTags.XR_HEADSET_TAG.getId();
                            Intrinsics.checkNotNullExpressionValue((Object)v20, (String)"getId(...)");
                            if (!StringHelper.asSeparatedListContains$default((CharSequence)v19, (CharSequence)v20, null, (int)2, null)) break block37;
                            v4 = DeviceType.XR_HEADSET;
                            break block30;
                        }
                        v21 = tagIds;
                        v22 = SystemImageTags.DEPRECATED_AI_GLASSES_TAG.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)v22, (String)"getId(...)");
                        if (StringHelper.asSeparatedListContains$default((CharSequence)v21, (CharSequence)v22, null, (int)2, null)) ** GOTO lbl-1000
                        v23 = tagIds;
                        v24 = SystemImageTags.AI_GLASSES_TAG.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)v24, (String)"getId(...)");
                        if (StringHelper.asSeparatedListContains$default((CharSequence)v23, (CharSequence)v24, null, (int)2, null)) lbl-1000:
                        // 2 sources

                        {
                            v4 = DeviceType.AI_GLASSES;
                        } else {
                            v4 = DeviceType.HANDHELD;
                        }
                    }
                    deviceType = v4;
                    hasOrientationSensors = this.getConfigBoolean((String)configIni.get("hw.sensors.orientation"), true);
                    hasTransparentDisplay = this.getConfigBoolean((String)configIni.get("hw.lcd.transparent"), false);
                    hasTouchScreen = "no-touch".equals(configIni.get("hw.screen")) == false;
                    postureMode = StringUtil.parseInt((String)hardwareIni.get("hw.sensor.hinge.resizable.config"), (int)-1);
                    try {
                        block39: {
                            block38: {
                                v25 = (String)configIni.get("hw.resizable.configs");
                                if (v25 == null) break block38;
                                it = v25;
                                $i$a$-let-EmulatorConfiguration$Companion$readAvdDefinition$displayModes$1 = false;
                                v26 = EmulatorConfiguration.Companion.parseDisplayModes(it, postureMode);
                                v25 = v26;
                                if (v26 != null) break block39;
                            }
                            v25 = CollectionsKt.emptyList();
                        }
                        var23_27 = v25;
                    }
                    catch (Exception <unused var>) {
                        throw new RuntimeException("Unrecognized value of the hw.resizable.configs property, \"" + configIni.get("hw.resizable.configs") + "\", in " + configIniFile);
                    }
                    displayModes = var23_27;
                    try {
                        block41: {
                            block40: {
                                v27 = (String)configIni.get("hw.sensor.posture_list");
                                if (v27 == null) break block40;
                                p0 = v27;
                                $i$a$-let-EmulatorConfiguration$Companion$readAvdDefinition$postureValues$1 = false;
                                v28 = this.parsePostures(p0);
                                v27 = v28;
                                if (v28 != null) break block41;
                            }
                            v27 = CollectionsKt.emptyList();
                        }
                        <unused var> = v27;
                    }
                    catch (Exception <unused var>) {
                        throw new RuntimeException("Unrecognized value of the hw.sensor.posture_list property, \"" + configIni.get("hw.sensor.posture_list") + "\", in " + configIniFile);
                    }
                    postureValues = <unused var>;
                    postures = CollectionsKt.emptyList();
                    for (PostureDescriptor.ValueType type : PostureDescriptor.ValueType.getEntries()) {
                        key = WhenMappings.$EnumSwitchMapping$0[type.ordinal()] == 1 ? "hw.sensor.hinge_angles_posture_definitions" : "hw.sensor.roll_percentages_posture_definitions";
                        ranges = (String)configIni.get(key);
                        if (ranges == null) continue;
                        try {
                            postureRanges = this.parseRanges(ranges);
                            if (postureValues.size() != postureRanges.size()) break;
                            var30_38 = postureValues.size();
                            var31_40 = new ArrayList<PostureDescriptor>(var30_38);
                            var32_41 = 0;
                            while (var32_41 < var30_38) {
                                var34_44 = var33_42 = var32_41++;
                                var45_49 = var31_40;
                                $i$a$-List-EmulatorConfiguration$Companion$readAvdDefinition$1 = false;
                                var45_49.add(new PostureDescriptor(postureValues.get((int)i), type, ((Number)postureRanges.get((int)i).getFirst()).doubleValue(), ((Number)postureRanges.get((int)i).getSecond()).doubleValue()));
                            }
                            postures = var31_40;
                            break;
                        }
                        catch (Exception <unused var>) {
                            throw new RuntimeException("Unrecognized value of the " + key + " property, \"" + ranges + "\", in " + configIniFile);
                        }
                    }
                    v29 = (String)configIni.get("image.sysdir.1");
                    if (v29 == null) {
                        throw new RuntimeException("System image is not defined");
                    }
                    systemImage = v29;
                    sourcePropertiesFile = androidSdkRoot.resolve(systemImage).resolve("source.properties");
                    ranges = new String[]{"AndroidVersion.ApiLevel", "AndroidVersion.CodeName", "AndroidVersion.ExtensionLevel", "AndroidVersion.IsBaseSdk"};
                    versionKeys = SetsKt.setOf((Object[])ranges);
                    Intrinsics.checkNotNull((Object)sourcePropertiesFile);
                    sourceProperties = KeyValueFiles.readKeyValueFile(sourcePropertiesFile, versionKeys);
                    v30 = sourceProperties.get("AndroidVersion.ApiLevel");
                    if (v30 == null) break block42;
                    it = v30;
                    $i$a$-let-EmulatorConfiguration$Companion$readAvdDefinition$api$1 = false;
                    v31 = AndroidApiLevel.Companion.fromString(it);
                    v30 = v31;
                    if (v31 != null) break block43;
                }
                throw new RuntimeException("Missing or invalid API level");
            }
            api = v30;
            codeName = sourceProperties.get("AndroidVersion.CodeName");
            v32 = sourceProperties.get("AndroidVersion.ExtensionLevel");
            if (v32 != null) {
                it = v32;
                $i$a$-let-EmulatorConfiguration$Companion$readAvdDefinition$extensionLevel$1 = false;
                v33 = StringUtil.parseInt((String)it, (int)0);
            } else {
                v33 = null;
            }
            extensionLevel = v33;
            v34 = sourceProperties.get("AndroidVersion.IsBaseSdk");
            isBaseSdk = v34 != null ? Boolean.parseBoolean(v34) : true;
            androidVersion = new AndroidVersion((AndroidApiLevel)api, codeName, extensionLevel, isBaseSdk);
            additionalDisplays = new LinkedHashMap<K, V>();
            for (Map.Entry<K, V> var36_50 : configIni.entrySet()) {
                key = (String)var36_50.getKey();
                value = (String)var36_50.getValue();
                if (!StringsKt.startsWith$default((String)key, (String)"hw.display", (boolean)false, (int)2, null) || (dotPos = StringsKt.indexOf$default((CharSequence)key, (char)'.', (int)(prefixLength = 10), (boolean)false, (int)4, null)) <= prefixLength || dotPos >= key.length() - 1) continue;
                v35 = key.substring(prefixLength, dotPos);
                Intrinsics.checkNotNullExpressionValue((Object)v35, (String)"substring(...)");
                displayId = StringUtil.parseInt((String)v35, (int)0);
                if (displayId <= 0 || (dim = StringUtil.parseInt((String)value, (int)0)) <= 0) continue;
                Intrinsics.checkNotNullExpressionValue((Object)key.substring(dotPos + 1), (String)"substring(...)");
                var44_60 = suffix;
                if (Intrinsics.areEqual((Object)var44_60, (Object)"width")) {
                    additionalDisplays.computeIfAbsent(Integer.valueOf((int)displayId), (Function<Object, Dimension>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, readAvdDefinition$lambda$5(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)Ljava/awt/Dimension;)((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, readAvdDefinition$lambda$4(java.lang.Integer ), (Ljava/lang/Integer;)Ljava/awt/Dimension;)())).width = dim;
                    continue;
                }
                if (!Intrinsics.areEqual((Object)var44_60, (Object)"height")) continue;
                additionalDisplays.computeIfAbsent(Integer.valueOf((int)displayId), (Function<Object, Dimension>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, readAvdDefinition$lambda$7(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)Ljava/awt/Dimension;)((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, readAvdDefinition$lambda$6(java.lang.Integer ), (Ljava/lang/Integer;)Ljava/awt/Dimension;)())).height = dim;
            }
            iter = additionalDisplays.entrySet().iterator();
            while (iter.hasNext()) {
                size = (Dimension)iter.next().getValue();
                if (size.width > 0 && size.height > 0) continue;
                iter.remove();
            }
            touchpadWidth = StringUtil.parseInt((String)((String)configIni.get("hw.touchpad0.width")), (int)0);
            touchpadHeight = StringUtil.parseInt((String)((String)configIni.get("hw.touchpad0.height")), (int)0);
            touchpadSize = touchpadWidth > 0 && touchpadHeight > 0 ? new Dimension(touchpadWidth, touchpadHeight) : null;
            v36 = new Dimension(displayWidth, displayHeight);
            v37 = ImmutableMap.copyOf((Map)additionalDisplays);
            Intrinsics.checkNotNullExpressionValue((Object)v37, (String)"copyOf(...)");
            return new EmulatorConfiguration(avdFolder, avdName, deviceType, androidVersion, v36, density, (Map)v37, skinPath, hasOrientationSensors, hasAudioOutput, hasTransparentDisplay, hasTouchScreen, initialOrientation, displayModes, postures, touchpadSize, null);
        }

        private final boolean getConfigBoolean(String value2, boolean defaultValue) {
            String string = value2;
            return string != null ? StringsKt.equals((String)string, (String)"yes", (boolean)true) : defaultValue;
        }

        @NotNull
        public final EmulatorConfiguration createStub(@NotNull String avdName, @NotNull Path avdFolder) {
            Intrinsics.checkNotNullParameter((Object)avdName, (String)"avdName");
            Intrinsics.checkNotNullParameter((Object)avdFolder, (String)"avdFolder");
            return new EmulatorConfiguration(avdFolder, avdName, DeviceType.HANDHELD, new AndroidVersion(0, 0), new Dimension(), 0, MapsKt.emptyMap(), null, false, false, false, false, 0, CollectionsKt.emptyList(), CollectionsKt.emptyList(), null, null);
        }

        private final Path getSkinPath(Map<String, String> configIni, Path androidSdkRoot) {
            if (!this.getConfigBoolean(configIni.get("showDeviceFrame"), true)) {
                return null;
            }
            String skinPath = configIni.get("skin.path");
            return skinPath == null || Intrinsics.areEqual((Object)skinPath, (Object)"_no_skin") ? null : androidSdkRoot.resolve(skinPath);
        }

        /*
         * WARNING - void declaration
         */
        private final List<DisplayMode> parseDisplayModes(String modes, int postureMode) {
            void $this$mapTo$iv$iv;
            List list2 = Splitter.on((char)',').trimResults().splitToList((CharSequence)modes);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"splitToList(...)");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection2.add(Companion.parseDisplayMode((String)it, postureMode));
            }
            return (List)destination$iv$iv;
        }

        private final DisplayMode parseDisplayMode(String mode, int postureMode) {
            List segments = Splitter.on((char)'-').splitToList((CharSequence)mode);
            Object e = segments.get(1);
            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
            DisplayModeValue displayModeId = (DisplayModeValue)EntriesMappings.entries$0.get(Integer.parseInt((String)e));
            Object e2 = segments.get(2);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"get(...)");
            int width = Integer.parseInt((String)e2);
            Object e3 = segments.get(3);
            Intrinsics.checkNotNullExpressionValue(e3, (String)"get(...)");
            int height = Integer.parseInt((String)e3);
            if (width <= 0 || height <= 0) {
                throw new IllegalArgumentException();
            }
            return new DisplayMode(displayModeId, width, height, displayModeId.getNumber() == postureMode);
        }

        /*
         * WARNING - void declaration
         */
        private final List<Posture.PostureValue> parsePostures(String postures) {
            void $this$mapTo$iv$iv;
            List list2 = Splitter.on((char)',').trimResults().splitToList((CharSequence)postures);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"splitToList(...)");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                String string = (String)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(this.postureForNumber((String)p0));
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final Posture.PostureValue postureForNumber(String postureIndex) {
            void var2_2;
            Posture.PostureValue posture;
            Posture.PostureValue postureValue = posture = Posture.PostureValue.forNumber((int)Integer.parseInt(postureIndex));
            switch (postureValue == null ? -1 : WhenMappings.$EnumSwitchMapping$1[postureValue.ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    throw new IllegalArgumentException();
                }
            }
            Intrinsics.checkNotNull((Object)posture);
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        private final List<Pair<Double, Double>> parseRanges(String ranges) {
            void $this$mapTo$iv$iv;
            List list2 = Splitter.on((char)',').trimResults().splitToList((CharSequence)ranges);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"splitToList(...)");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                String string = (String)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(this.parseRange((String)p0));
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final Pair<Double, Double> parseRange(String range) {
            void $this$mapTo$iv$iv;
            Iterable iterable = Splitter.on((char)'-').trimResults().split((CharSequence)range);
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"split(...)");
            Iterable $this$map$iv = iterable;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                String string = (String)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(Double.parseDouble((String)p0));
            }
            List values = (List)destination$iv$iv;
            if (values.size() != 2) {
                throw new IllegalArgumentException();
            }
            return new Pair(values.get(0), values.get(1));
        }

        private static final Dimension readAvdDefinition$lambda$4(Integer it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new Dimension();
        }

        private static final Dimension readAvdDefinition$lambda$5(Function1 $tmp0, Object p0) {
            return (Dimension)$tmp0.invoke(p0);
        }

        private static final Dimension readAvdDefinition$lambda$6(Integer it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new Dimension();
        }

        private static final Dimension readAvdDefinition$lambda$7(Function1 $tmp0, Object p0) {
            return (Dimension)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public static final class EntriesMappings {
            public static final /* synthetic */ EnumEntries<DisplayModeValue> entries$0;

            static {
                entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])DisplayModeValue.values()));
            }
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[PostureDescriptor.ValueType.values().length];
                try {
                    nArray[PostureDescriptor.ValueType.HINGE_ANGLE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[Posture.PostureValue.values().length];
                try {
                    nArray[Posture.PostureValue.POSTURE_UNKNOWN.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Posture.PostureValue.UNRECOGNIZED.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Posture.PostureValue.POSTURE_MAX.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\rJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u00072\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u000bH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\f\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0015\u00a8\u0006 "}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorConfiguration$DisplayMode;", "", "displayModeId", "Lcom/android/emulator/control/DisplayModeValue;", "displaySize", "Ljava/awt/Dimension;", "hasPostures", "", "<init>", "(Lcom/android/emulator/control/DisplayModeValue;Ljava/awt/Dimension;Z)V", "width", "", "height", "(Lcom/android/emulator/control/DisplayModeValue;IIZ)V", "getDisplayModeId", "()Lcom/android/emulator/control/DisplayModeValue;", "getDisplaySize", "()Ljava/awt/Dimension;", "getHasPostures", "()Z", "getWidth", "()I", "getHeight", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "toString", "", "intellij.android.streaming"})
    public static final class DisplayMode {
        @NotNull
        private final DisplayModeValue displayModeId;
        @NotNull
        private final Dimension displaySize;
        private final boolean hasPostures;

        public DisplayMode(@NotNull DisplayModeValue displayModeId, @NotNull Dimension displaySize, boolean hasPostures) {
            Intrinsics.checkNotNullParameter((Object)displayModeId, (String)"displayModeId");
            Intrinsics.checkNotNullParameter((Object)displaySize, (String)"displaySize");
            this.displayModeId = displayModeId;
            this.displaySize = displaySize;
            this.hasPostures = hasPostures;
        }

        @NotNull
        public final DisplayModeValue getDisplayModeId() {
            return this.displayModeId;
        }

        @NotNull
        public final Dimension getDisplaySize() {
            return this.displaySize;
        }

        public final boolean getHasPostures() {
            return this.hasPostures;
        }

        public DisplayMode(@NotNull DisplayModeValue displayModeId, int width, int height, boolean hasPostures) {
            Intrinsics.checkNotNullParameter((Object)displayModeId, (String)"displayModeId");
            this(displayModeId, new Dimension(width, height), hasPostures);
        }

        public final int getWidth() {
            return this.displaySize.width;
        }

        public final int getHeight() {
            return this.displaySize.height;
        }

        @NotNull
        public final DisplayModeValue component1() {
            return this.displayModeId;
        }

        @NotNull
        public final Dimension component2() {
            return this.displaySize;
        }

        public final boolean component3() {
            return this.hasPostures;
        }

        @NotNull
        public final DisplayMode copy(@NotNull DisplayModeValue displayModeId, @NotNull Dimension displaySize, boolean hasPostures) {
            Intrinsics.checkNotNullParameter((Object)displayModeId, (String)"displayModeId");
            Intrinsics.checkNotNullParameter((Object)displaySize, (String)"displaySize");
            return new DisplayMode(displayModeId, displaySize, hasPostures);
        }

        public static /* synthetic */ DisplayMode copy$default(DisplayMode displayMode, DisplayModeValue displayModeValue, Dimension dimension2, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                displayModeValue = displayMode.displayModeId;
            }
            if ((n & 2) != 0) {
                dimension2 = displayMode.displaySize;
            }
            if ((n & 4) != 0) {
                bl = displayMode.hasPostures;
            }
            return displayMode.copy(displayModeValue, dimension2, bl);
        }

        @NotNull
        public String toString() {
            return "DisplayMode(displayModeId=" + this.displayModeId + ", displaySize=" + this.displaySize + ", hasPostures=" + this.hasPostures + ")";
        }

        public int hashCode() {
            int result2 = this.displayModeId.hashCode();
            result2 = result2 * 31 + this.displaySize.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.hasPostures);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DisplayMode)) {
                return false;
            }
            DisplayMode displayMode = (DisplayMode)other;
            if (this.displayModeId != displayMode.displayModeId) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.displaySize, (Object)displayMode.displaySize)) {
                return false;
            }
            return this.hasPostures == displayMode.hasPostures;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0001%B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\t\u0010$\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006&"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorConfiguration$PostureDescriptor;", "", "posture", "Lcom/android/emulator/control/Posture$PostureValue;", "valueType", "Lcom/android/tools/idea/streaming/emulator/EmulatorConfiguration$PostureDescriptor$ValueType;", "minValue", "", "maxValue", "<init>", "(Lcom/android/emulator/control/Posture$PostureValue;Lcom/android/tools/idea/streaming/emulator/EmulatorConfiguration$PostureDescriptor$ValueType;DD)V", "getPosture", "()Lcom/android/emulator/control/Posture$PostureValue;", "getValueType", "()Lcom/android/tools/idea/streaming/emulator/EmulatorConfiguration$PostureDescriptor$ValueType;", "getMinValue", "()D", "getMaxValue", "displayName", "", "getDisplayName", "()Ljava/lang/String;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "ValueType", "intellij.android.streaming"})
    public static final class PostureDescriptor {
        @NotNull
        private final Posture.PostureValue posture;
        @NotNull
        private final ValueType valueType;
        private final double minValue;
        private final double maxValue;
        @NotNull
        private final String displayName;
        @Nullable
        private final Icon icon;

        public PostureDescriptor(@NotNull Posture.PostureValue posture, @NotNull ValueType valueType, double minValue, double maxValue) {
            Intrinsics.checkNotNullParameter((Object)posture, (String)"posture");
            Intrinsics.checkNotNullParameter((Object)((Object)valueType), (String)"valueType");
            this.posture = posture;
            this.valueType = valueType;
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.displayName = switch (WhenMappings.$EnumSwitchMapping$0[this.posture.ordinal()]) {
                case 1 -> "Closed";
                case 2 -> "Half-Open";
                case 3 -> "Open";
                case 4 -> "Flipped";
                case 5 -> "Tent";
                default -> "Unknown";
            };
            this.icon = StreamingConstants.getFOLDING_STATE_ICONS().get(this.displayName);
        }

        @NotNull
        public final Posture.PostureValue getPosture() {
            return this.posture;
        }

        @NotNull
        public final ValueType getValueType() {
            return this.valueType;
        }

        public final double getMinValue() {
            return this.minValue;
        }

        public final double getMaxValue() {
            return this.maxValue;
        }

        @NotNull
        public final String getDisplayName() {
            return this.displayName;
        }

        @Nullable
        public final Icon getIcon() {
            return this.icon;
        }

        @NotNull
        public final Posture.PostureValue component1() {
            return this.posture;
        }

        @NotNull
        public final ValueType component2() {
            return this.valueType;
        }

        public final double component3() {
            return this.minValue;
        }

        public final double component4() {
            return this.maxValue;
        }

        @NotNull
        public final PostureDescriptor copy(@NotNull Posture.PostureValue posture, @NotNull ValueType valueType, double minValue, double maxValue) {
            Intrinsics.checkNotNullParameter((Object)posture, (String)"posture");
            Intrinsics.checkNotNullParameter((Object)((Object)valueType), (String)"valueType");
            return new PostureDescriptor(posture, valueType, minValue, maxValue);
        }

        public static /* synthetic */ PostureDescriptor copy$default(PostureDescriptor postureDescriptor, Posture.PostureValue postureValue, ValueType valueType, double d, double d2, int n, Object object) {
            if ((n & 1) != 0) {
                postureValue = postureDescriptor.posture;
            }
            if ((n & 2) != 0) {
                valueType = postureDescriptor.valueType;
            }
            if ((n & 4) != 0) {
                d = postureDescriptor.minValue;
            }
            if ((n & 8) != 0) {
                d2 = postureDescriptor.maxValue;
            }
            return postureDescriptor.copy(postureValue, valueType, d, d2);
        }

        @NotNull
        public String toString() {
            return "PostureDescriptor(posture=" + this.posture + ", valueType=" + this.valueType + ", minValue=" + this.minValue + ", maxValue=" + this.maxValue + ")";
        }

        public int hashCode() {
            int result2 = this.posture.hashCode();
            result2 = result2 * 31 + this.valueType.hashCode();
            result2 = result2 * 31 + Double.hashCode(this.minValue);
            result2 = result2 * 31 + Double.hashCode(this.maxValue);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PostureDescriptor)) {
                return false;
            }
            PostureDescriptor postureDescriptor = (PostureDescriptor)other;
            if (this.posture != postureDescriptor.posture) {
                return false;
            }
            if (this.valueType != postureDescriptor.valueType) {
                return false;
            }
            if (Double.compare(this.minValue, postureDescriptor.minValue) != 0) {
                return false;
            }
            return Double.compare(this.maxValue, postureDescriptor.maxValue) == 0;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorConfiguration$PostureDescriptor$ValueType;", "", "<init>", "(Ljava/lang/String;I)V", "HINGE_ANGLE", "ROLL_PERCENTAGE", "intellij.android.streaming"})
        public static final class ValueType
        extends Enum<ValueType> {
            public static final /* enum */ ValueType HINGE_ANGLE = new ValueType();
            public static final /* enum */ ValueType ROLL_PERCENTAGE = new ValueType();
            private static final /* synthetic */ ValueType[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static ValueType[] values() {
                return (ValueType[])$VALUES.clone();
            }

            public static ValueType valueOf(String value2) {
                return Enum.valueOf(ValueType.class, value2);
            }

            @NotNull
            public static EnumEntries<ValueType> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = valueTypeArray = new ValueType[]{ValueType.HINGE_ANGLE, ValueType.ROLL_PERCENTAGE};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Posture.PostureValue.values().length];
                try {
                    nArray[Posture.PostureValue.POSTURE_CLOSED.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Posture.PostureValue.POSTURE_HALF_OPENED.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Posture.PostureValue.POSTURE_OPENED.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Posture.PostureValue.POSTURE_FLIPPED.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Posture.PostureValue.POSTURE_TENT.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

