/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.device.xr;

import com.android.tools.idea.streaming.actions.HardwareInputStateStorage;
import com.android.tools.idea.streaming.device.DeviceClient;
import com.android.tools.idea.streaming.device.xr.DeviceXrInputController;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/streaming/device/xr/DeviceXrInputControllerService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "xrControllers", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/android/tools/idea/streaming/device/DeviceClient;", "Lcom/android/tools/idea/streaming/device/xr/DeviceXrInputController;", "hardwareInputStateStorage", "Lcom/android/tools/idea/streaming/actions/HardwareInputStateStorage;", "getXrInputController", "deviceClient", "dispose", "", "intellij.android.streaming"})
@SourceDebugExtension(value={"SMAP\nDeviceXrInputController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceXrInputController.kt\ncom/android/tools/idea/streaming/device/xr/DeviceXrInputControllerService\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,191:1\n30#2,2:192\n*S KotlinDebug\n*F\n+ 1 DeviceXrInputController.kt\ncom/android/tools/idea/streaming/device/xr/DeviceXrInputControllerService\n*L\n176#1:192,2\n*E\n"})
public final class DeviceXrInputControllerService
implements Disposable {
    @NotNull
    private final ConcurrentHashMap<DeviceClient, DeviceXrInputController> xrControllers;
    @NotNull
    private final HardwareInputStateStorage hardwareInputStateStorage;

    public DeviceXrInputControllerService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.xrControllers = new ConcurrentHashMap();
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<HardwareInputStateStorage> serviceClass$iv = HardwareInputStateStorage.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.hardwareInputStateStorage = (HardwareInputStateStorage)object;
    }

    @NotNull
    public final DeviceXrInputController getXrInputController(@NotNull DeviceClient deviceClient) {
        Intrinsics.checkNotNullParameter((Object)deviceClient, (String)"deviceClient");
        DeviceXrInputController deviceXrInputController = this.xrControllers.computeIfAbsent(deviceClient, arg_0 -> DeviceXrInputControllerService.getXrInputController$lambda$1(arg_0 -> DeviceXrInputControllerService.getXrInputController$lambda$0(deviceClient, this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)deviceXrInputController, (String)"computeIfAbsent(...)");
        return deviceXrInputController;
    }

    public void dispose() {
        this.xrControllers.clear();
    }

    private static final DeviceXrInputController getXrInputController$lambda$0(DeviceClient $deviceClient, DeviceXrInputControllerService this$0, DeviceClient it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Disposer.register((Disposable)$deviceClient, () -> DeviceXrInputControllerService.getXrInputController$lambda$0$0(this$0, $deviceClient));
        return new DeviceXrInputController($deviceClient);
    }

    private static final void getXrInputController$lambda$0$0(DeviceXrInputControllerService this$0, DeviceClient $deviceClient) {
        this$0.xrControllers.remove($deviceClient);
    }

    private static final DeviceXrInputController getXrInputController$lambda$1(Function1 $tmp0, Object p0) {
        return (DeviceXrInputController)$tmp0.invoke(p0);
    }
}

