/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.device;

import com.android.tools.idea.streaming.device.ControlMessage;
import com.android.utils.Base128InputStream;
import com.android.utils.Base128OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0080\b\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0005H\u0016J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/streaming/device/StartClipboardSyncMessage;", "Lcom/android/tools/idea/streaming/device/ControlMessage;", "maxSyncedLength", "", "text", "", "<init>", "(ILjava/lang/String;)V", "getMaxSyncedLength", "()I", "getText", "()Ljava/lang/String;", "serialize", "", "stream", "Lcom/android/utils/Base128OutputStream;", "toString", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "Companion", "intellij.android.streaming"})
public final class StartClipboardSyncMessage
extends ControlMessage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int maxSyncedLength;
    @NotNull
    private final String text;
    public static final int TYPE = 10;

    public StartClipboardSyncMessage(int maxSyncedLength, @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        super(10, null);
        this.maxSyncedLength = maxSyncedLength;
        this.text = text2;
    }

    public final int getMaxSyncedLength() {
        return this.maxSyncedLength;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @Override
    public void serialize(@NotNull Base128OutputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        super.serialize(stream);
        stream.writeInt(this.maxSyncedLength);
        byte[] byArray = this.text.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        stream.writeBytes(byArray);
    }

    @Override
    @NotNull
    public String toString() {
        return "StartClipboardSyncMessage(maxSyncedLength=" + this.maxSyncedLength + ", text='" + this.text + "')";
    }

    public final int component1() {
        return this.maxSyncedLength;
    }

    @NotNull
    public final String component2() {
        return this.text;
    }

    @NotNull
    public final StartClipboardSyncMessage copy(int maxSyncedLength, @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return new StartClipboardSyncMessage(maxSyncedLength, text2);
    }

    public static /* synthetic */ StartClipboardSyncMessage copy$default(StartClipboardSyncMessage startClipboardSyncMessage, int n, String string, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = startClipboardSyncMessage.maxSyncedLength;
        }
        if ((n2 & 2) != 0) {
            string = startClipboardSyncMessage.text;
        }
        return startClipboardSyncMessage.copy(n, string);
    }

    @Override
    public int hashCode() {
        int result2 = Integer.hashCode(this.maxSyncedLength);
        result2 = result2 * 31 + this.text.hashCode();
        return result2;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StartClipboardSyncMessage)) {
            return false;
        }
        StartClipboardSyncMessage startClipboardSyncMessage = (StartClipboardSyncMessage)other;
        if (this.maxSyncedLength != startClipboardSyncMessage.maxSyncedLength) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.text, (Object)startClipboardSyncMessage.text);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/streaming/device/StartClipboardSyncMessage$Companion;", "Lcom/android/tools/idea/streaming/device/ControlMessage$Deserializer;", "<init>", "()V", "TYPE", "", "deserialize", "Lcom/android/tools/idea/streaming/device/StartClipboardSyncMessage;", "stream", "Lcom/android/utils/Base128InputStream;", "intellij.android.streaming"})
    public static final class Companion
    implements ControlMessage.Deserializer {
        private Companion() {
        }

        @Override
        @NotNull
        public StartClipboardSyncMessage deserialize(@NotNull Base128InputStream stream) {
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            int maxSyncedLength = stream.readInt();
            byte[] bytes2 = stream.readBytes();
            return new StartClipboardSyncMessage(maxSyncedLength, new String(bytes2, Charsets.UTF_8));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

