/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.core;

import com.android.sdklib.SystemImageTags;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.adtui.util.AwtUtilsKt;
import com.android.tools.idea.streaming.actions.StreamingAction;
import com.intellij.ide.actions.ShowLogAction;
import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.dsl.builder.HyperlinkEventAction;
import com.intellij.ui.dsl.builder.components.DslLabel;
import com.intellij.ui.dsl.builder.components.DslLabelType;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.nio.ByteBuffer;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u009e\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u00a2\u0006\u0002\u0010\u0003\u001a\u0019\u0010\u0004\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a\u0014\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u001e\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0016\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0014\u0010\u0011\u001a\u00020\u0010*\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0014\u0010\u0017\u001a\u00020\u0018*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u001a\u0014\u0010\u001b\u001a\u00020\u0018*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u001a\u001c\u0010\u0017\u001a\u00020\u0018*\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0018H\u0000\u001a\u001c\u0010\u001e\u001a\u00020\u0018*\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u0018H\u0000\u001a\u001c\u0010\u001e\u001a\u00020!*\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0000\u001a0\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020\u00182\u0006\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\u00182\u0006\u0010)\u001a\u00020\u00182\u0006\u0010*\u001a\u00020\u001aH\u0000\u001a\u0014\u0010+\u001a\u00020#*\u00020#2\u0006\u0010,\u001a\u00020#H\u0000\u001a\u0014\u00101\u001a\u00020!*\u00020!2\u0006\u00102\u001a\u00020#H\u0000\u001a\u0015\u00103\u001a\u00020\u0010*\u00020#2\u0006\u00104\u001a\u00020!H\u0080\u0002\u001a\u0014\u0010?\u001a\u00020\u000e*\u00020\u000e2\u0006\u0010@\u001a\u00020AH\u0000\u001a\b\u0010B\u001a\u00020\u000eH\u0000\u001a\b\u0010C\u001a\u00020DH\u0000\u001a&\u0010E\u001a\u00020F2\b\b\u0001\u0010G\u001a\u00020\u000e2\b\b\u0002\u0010H\u001a\u00020\u00182\b\b\u0002\u0010\u000b\u001a\u00020IH\u0000\u001a\f\u0010J\u001a\u00020\u0010*\u00020\tH\u0000\u001a\u0018\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020!2\u0006\u0010N\u001a\u00020\u0018H\u0000\u001a\u001c\u0010O\u001a\u00020P*\u00020Q2\u0006\u0010M\u001a\u00020!2\u0006\u0010N\u001a\u00020\u0018H\u0000\u001a\u001c\u0010R\u001a\u00020P*\u00020Q2\u0006\u0010M\u001a\u00020!2\u0006\u0010N\u001a\u00020\u0018H\u0000\"\u0018\u0010\u0012\u001a\u00020\u0013*\u00020\u00148@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\"\u0018\u0010-\u001a\u00020#*\u00020.8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100\"\u0018\u00105\u001a\u00020\u0018*\u0002068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108\"\u0018\u00109\u001a\u00020\u0018*\u0002068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u00108\"\u0018\u0010;\u001a\u00020!*\u00020<8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b=\u0010>\u00a8\u0006S"}, d2={"getUInt", "Lkotlin/UInt;", "Ljava/nio/ByteBuffer;", "(Ljava/nio/ByteBuffer;)I", "putUInt", "value", "putUInt-Qn1smSk", "(Ljava/nio/ByteBuffer;I)Ljava/nio/ByteBuffer;", "findComponentForAction", "Ljava/awt/Component;", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "toolWindowId", "", "isComponentForAction", "", "isEquivalentTo", "icon", "Ljavax/swing/Icon;", "Lcom/android/sdklib/internal/avd/AvdInfo;", "getIcon", "(Lcom/android/sdklib/internal/avd/AvdInfo;)Ljavax/swing/Icon;", "scaledDown", "", "scale", "", "scaledUp", "numerator", "denominator", "scaledUnbiased", "fromRange", "toRange", "Ljava/awt/Point;", "fromDim", "Ljava/awt/Dimension;", "toDim", "isSameAspectRatio", "width1", "height1", "width2", "height2", "tolerance", "coerceAtMost", "maximumValue", "sizeWithoutInsets", "Ljava/awt/Container;", "getSizeWithoutInsets", "(Ljava/awt/Container;)Ljava/awt/Dimension;", "constrainInside", "d", "contains", "p", "right", "Ljava/awt/Rectangle;", "getRight", "(Ljava/awt/Rectangle;)I", "bottom", "getBottom", "location", "Ljava/awt/event/MouseEvent;", "getLocation", "(Ljava/awt/event/MouseEvent;)Ljava/awt/Point;", "htmlColored", "color", "Ljava/awt/Color;", "getShowLogHyperlink", "createShowLogHyperlinkListener", "Ljavax/swing/event/HyperlinkListener;", "textComponent", "Ljavax/swing/JEditorPane;", "text", "maxLineLength", "Lcom/intellij/ui/dsl/builder/HyperlinkEventAction;", "containsFocus", "createCircle", "Ljava/awt/geom/Ellipse2D;", "center", "radius", "drawCircle", "", "Ljava/awt/Graphics;", "fillCircle", "intellij.android.streaming"})
@SourceDebugExtension(value={"SMAP\nStreamingUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StreamingUtils.kt\ncom/android/tools/idea/streaming/core/StreamingUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,257:1\n1#2:258\n*E\n"})
public final class StreamingUtilsKt {
    public static final int getUInt(@NotNull ByteBuffer $this$getUInt) {
        Intrinsics.checkNotNullParameter((Object)$this$getUInt, (String)"<this>");
        return UInt.constructor-impl((int)$this$getUInt.getInt());
    }

    @NotNull
    public static final ByteBuffer putUInt-Qn1smSk(@NotNull ByteBuffer $this$putUInt_u2dQn1smSk, int n) {
        Intrinsics.checkNotNullParameter((Object)$this$putUInt_u2dQn1smSk, (String)"$this$putUInt");
        ByteBuffer byteBuffer = $this$putUInt_u2dQn1smSk.putInt(n);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"putInt(...)");
        return byteBuffer;
    }

    @Nullable
    public static final Component findComponentForAction(@NotNull AnActionEvent $this$findComponentForAction, @NotNull AnAction action2) {
        Intrinsics.checkNotNullParameter((Object)$this$findComponentForAction, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        return StreamingUtilsKt.findComponentForAction($this$findComponentForAction, action2, "Running Devices");
    }

    private static final Component findComponentForAction(AnActionEvent $this$findComponentForAction, AnAction action2, String toolWindowId) {
        Component component;
        Project project = $this$findComponentForAction.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        InputEvent inputEvent = $this$findComponentForAction.getInputEvent();
        Component component2 = component = inputEvent != null ? inputEvent.getComponent() : null;
        if (component instanceof ActionButtonComponent) {
            return component;
        }
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project2).getToolWindow(toolWindowId);
        if (toolWindow == null) {
            return null;
        }
        ToolWindow toolWindow2 = toolWindow;
        Container container = toolWindow2.getComponent().getParent();
        return container != null ? StreamingUtilsKt.findComponentForAction(container, action2) : null;
    }

    private static final Component findComponentForAction(Component $this$findComponentForAction, AnAction action2) {
        if (StreamingUtilsKt.isComponentForAction($this$findComponentForAction, action2)) {
            return $this$findComponentForAction;
        }
        if ($this$findComponentForAction instanceof Container) {
            Component[] componentArray;
            Component[] it = componentArray = new ArrayDeque();
            boolean bl = false;
            it.add((Object)$this$findComponentForAction);
            Component[] queue = componentArray;
            while (!((Collection)queue).isEmpty()) {
                Intrinsics.checkNotNullExpressionValue((Object)((Container)queue.removeFirst()).getComponents(), (String)"getComponents(...)");
                for (Component child : componentArray) {
                    Intrinsics.checkNotNull((Object)child);
                    if (StreamingUtilsKt.isComponentForAction(child, action2)) {
                        return child;
                    }
                    if (!(child instanceof Container)) continue;
                    queue.add((Object)child);
                }
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isComponentForAction(Component $this$isComponentForAction, AnAction action2) {
        if (!($this$isComponentForAction instanceof AnActionHolder)) return false;
        AnAction anAction = ((AnActionHolder)$this$isComponentForAction).getAction();
        Intrinsics.checkNotNullExpressionValue((Object)anAction, (String)"getAction(...)");
        if (!StreamingUtilsKt.isEquivalentTo(anAction, action2)) return false;
        return true;
    }

    private static final boolean isEquivalentTo(AnAction $this$isEquivalentTo, AnAction action2) {
        return $this$isEquivalentTo == action2 || $this$isEquivalentTo instanceof StreamingAction && ((StreamingAction)$this$isEquivalentTo).mayDelegate(action2);
    }

    @NotNull
    public static final Icon getIcon(@NotNull AvdInfo $this$icon) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)$this$icon, (String)"<this>");
        if (SystemImageTags.isTvImage((Collection)$this$icon.getTags())) {
            Icon icon2 = StudioIcons.DeviceExplorer.VIRTUAL_DEVICE_TV;
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"VIRTUAL_DEVICE_TV");
        } else if (SystemImageTags.isAutomotiveImage((Collection)$this$icon.getTags())) {
            Icon icon3 = StudioIcons.DeviceExplorer.VIRTUAL_DEVICE_CAR;
            icon = icon3;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"VIRTUAL_DEVICE_CAR");
        } else if (SystemImageTags.isWearImage((Collection)$this$icon.getTags())) {
            Icon icon4 = StudioIcons.DeviceExplorer.VIRTUAL_DEVICE_WEAR;
            icon = icon4;
            Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"VIRTUAL_DEVICE_WEAR");
        } else if (SystemImageTags.isXrHeadsetImage((Collection)$this$icon.getTags())) {
            Icon icon5 = StudioIcons.DeviceExplorer.VIRTUAL_DEVICE_HEADSET;
            icon = icon5;
            Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"VIRTUAL_DEVICE_HEADSET");
        } else if (SystemImageTags.isAiGlassesImage((Collection)$this$icon.getTags())) {
            Icon icon6 = StudioIcons.DeviceExplorer.VIRTUAL_DEVICE_GLASS;
            icon = icon6;
            Intrinsics.checkNotNullExpressionValue((Object)icon6, (String)"VIRTUAL_DEVICE_GLASS");
        } else {
            Icon icon7 = StudioIcons.DeviceExplorer.VIRTUAL_DEVICE_PHONE;
            icon = icon7;
            Intrinsics.checkNotNullExpressionValue((Object)icon7, (String)"VIRTUAL_DEVICE_PHONE");
        }
        return icon;
    }

    public static final int scaledDown(int $this$scaledDown, double scale) {
        return (int)((double)$this$scaledDown * scale);
    }

    public static final int scaledUp(int $this$scaledUp, double scale) {
        return MathKt.roundToInt((double)Math.ceil((double)$this$scaledUp * scale));
    }

    public static final int scaledDown(int $this$scaledDown, int numerator, int denominator) {
        return (int)((long)$this$scaledDown * (long)numerator / (long)denominator);
    }

    public static final int scaledUnbiased(int $this$scaledUnbiased, int fromRange, int toRange) {
        return (int)(((long)$this$scaledUnbiased * 2L + 1L) * (long)toRange / (long)(2 * fromRange));
    }

    @NotNull
    public static final Point scaledUnbiased(@NotNull Point $this$scaledUnbiased, @NotNull Dimension fromDim, @NotNull Dimension toDim) {
        Intrinsics.checkNotNullParameter((Object)$this$scaledUnbiased, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fromDim, (String)"fromDim");
        Intrinsics.checkNotNullParameter((Object)toDim, (String)"toDim");
        return new Point(StreamingUtilsKt.scaledUnbiased($this$scaledUnbiased.x, fromDim.width, toDim.width), StreamingUtilsKt.scaledUnbiased($this$scaledUnbiased.y, fromDim.height, toDim.height));
    }

    public static final boolean isSameAspectRatio(int width1, int height1, int width2, int height2, double tolerance) {
        double a = (double)width1 * (double)height2;
        double b = (double)width2 * (double)height1;
        double d = a - b;
        return Math.abs(d) <= tolerance * Math.abs(a + b) / (double)2;
    }

    @NotNull
    public static final Dimension coerceAtMost(@NotNull Dimension $this$coerceAtMost, @NotNull Dimension maximumValue) {
        Intrinsics.checkNotNullParameter((Object)$this$coerceAtMost, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)maximumValue, (String)"maximumValue");
        if ($this$coerceAtMost.width <= maximumValue.width && $this$coerceAtMost.height <= maximumValue.height) {
            return $this$coerceAtMost;
        }
        double scale = RangesKt.coerceAtMost((double)Math.min((double)maximumValue.width / (double)$this$coerceAtMost.width, (double)maximumValue.height / (double)$this$coerceAtMost.height), (double)1.0);
        return new Dimension(RangesKt.coerceAtMost((int)AwtUtilsKt.scaled((int)$this$coerceAtMost.width, (double)scale), (int)maximumValue.width), RangesKt.coerceAtMost((int)AwtUtilsKt.scaled((int)$this$coerceAtMost.height, (double)scale), (int)maximumValue.height));
    }

    @NotNull
    public static final Dimension getSizeWithoutInsets(@NotNull Container $this$sizeWithoutInsets) {
        Intrinsics.checkNotNullParameter((Object)$this$sizeWithoutInsets, (String)"<this>");
        return new Dimension(Math.max($this$sizeWithoutInsets.getWidth() - $this$sizeWithoutInsets.getInsets().left - $this$sizeWithoutInsets.getInsets().right, 0), Math.max($this$sizeWithoutInsets.getHeight() - $this$sizeWithoutInsets.getInsets().top - $this$sizeWithoutInsets.getInsets().bottom, 0));
    }

    @NotNull
    public static final Point constrainInside(@NotNull Point $this$constrainInside, @NotNull Dimension d) {
        Intrinsics.checkNotNullParameter((Object)$this$constrainInside, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        return StreamingUtilsKt.contains(d, $this$constrainInside) ? $this$constrainInside : new Point(RangesKt.coerceIn((int)$this$constrainInside.x, (int)0, (int)(d.width - 1)), RangesKt.coerceIn((int)$this$constrainInside.y, (int)0, (int)(d.height - 1)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean contains(@NotNull Dimension $this$contains, @NotNull Point p) {
        Intrinsics.checkNotNullParameter((Object)$this$contains, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        int n = $this$contains.width;
        int n2 = p.x;
        if (0 > n2) return false;
        if (n2 >= n) return false;
        boolean bl = true;
        if (!bl) return false;
        n = $this$contains.height;
        n2 = p.y;
        if (0 > n2) return false;
        if (n2 >= n) return false;
        return true;
    }

    public static final int getRight(@NotNull Rectangle $this$right) {
        Intrinsics.checkNotNullParameter((Object)$this$right, (String)"<this>");
        return $this$right.x + $this$right.width;
    }

    public static final int getBottom(@NotNull Rectangle $this$bottom) {
        Intrinsics.checkNotNullParameter((Object)$this$bottom, (String)"<this>");
        return $this$bottom.y + $this$bottom.height;
    }

    @NotNull
    public static final Point getLocation(@NotNull MouseEvent $this$location) {
        Intrinsics.checkNotNullParameter((Object)$this$location, (String)"<this>");
        return new Point($this$location.getX(), $this$location.getY());
    }

    @NotNull
    public static final String htmlColored(@NotNull String $this$htmlColored, @NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)$this$htmlColored, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        String string = Integer.toString(color.getRGB() & 0xFFFFFF, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return "<font color=" + string + ">" + $this$htmlColored + "</font>";
    }

    @NotNull
    public static final String getShowLogHyperlink() {
        String string;
        if (ShowLogAction.isSupported()) {
            Color color = JBUI.CurrentTheme.Link.Foreground.ENABLED;
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"ENABLED");
            string = StreamingUtilsKt.htmlColored("<a href='ShowLog'>log</a>", color);
        } else {
            string = "log";
        }
        return string;
    }

    @NotNull
    public static final HyperlinkListener createShowLogHyperlinkListener() {
        return StreamingUtilsKt::createShowLogHyperlinkListener$lambda$0;
    }

    @NotNull
    public static final JEditorPane textComponent(@NlsContexts.Label @NotNull String text2, int maxLineLength, @NotNull HyperlinkEventAction action2) {
        DslLabel dslLabel;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        DslLabel $this$textComponent_u24lambda_u240 = dslLabel = new DslLabel(DslLabelType.LABEL);
        boolean bl = false;
        $this$textComponent_u24lambda_u240.setAction(action2);
        $this$textComponent_u24lambda_u240.setMaxLineLength(maxLineLength);
        if (maxLineLength == -1) {
            $this$textComponent_u24lambda_u240.setLimitPreferredSize(true);
        }
        $this$textComponent_u24lambda_u240.setText(text2);
        return (JEditorPane)dslLabel;
    }

    public static /* synthetic */ JEditorPane textComponent$default(String string, int n, HyperlinkEventAction hyperlinkEventAction, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        if ((n2 & 4) != 0) {
            hyperlinkEventAction = HyperlinkEventAction.HTML_HYPERLINK_INSTANCE;
        }
        return StreamingUtilsKt.textComponent(string, n, hyperlinkEventAction);
    }

    public static final boolean containsFocus(@NotNull Component $this$containsFocus) {
        Intrinsics.checkNotNullParameter((Object)$this$containsFocus, (String)"<this>");
        for (Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(); component != null; component = (Component)component.getParent()) {
            if (!Intrinsics.areEqual((Object)component, (Object)$this$containsFocus)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static final Ellipse2D createCircle(@NotNull Point center, int radius) {
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        double diameter = (double)radius * 2.0;
        return new Ellipse2D.Double(center.x - radius, center.y - radius, diameter, diameter);
    }

    public static final void drawCircle(@NotNull Graphics $this$drawCircle, @NotNull Point center, int radius) {
        Intrinsics.checkNotNullParameter((Object)$this$drawCircle, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        $this$drawCircle.drawOval(center.x - radius, center.y - radius, radius * 2, radius * 2);
    }

    public static final void fillCircle(@NotNull Graphics $this$fillCircle, @NotNull Point center, int radius) {
        Intrinsics.checkNotNullParameter((Object)$this$fillCircle, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        $this$fillCircle.fillOval(center.x - radius, center.y - radius, radius * 2, radius * 2);
    }

    private static final void createShowLogHyperlinkListener$lambda$0(HyperlinkEvent event) {
        if (Intrinsics.areEqual((Object)event.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED) && Intrinsics.areEqual((Object)event.getDescription(), (Object)"ShowLog")) {
            ShowLogAction.showLog();
        }
    }
}

