/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.core;

import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\u0011\u001a\u00020\u0012H\u0096\u0002J\u0015\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0002H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0002R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/streaming/core/PartitionGenerator;", "", "Lkotlin/Pair;", "", "array", "<init>", "([I)V", "getArray", "()[I", "size", "", "getSize", "()I", "setSize", "(I)V", "indices", "getIndices", "hasNext", "", "next", "decrementSize", "", "intellij.android.streaming"})
final class PartitionGenerator
implements Iterator<Pair<? extends int[], ? extends int[]>>,
KMappedMarker {
    @NotNull
    private final int[] array;
    private int size;
    @NotNull
    private final int[] indices;

    public PartitionGenerator(@NotNull int[] array) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        this.array = array;
        this.size = this.array.length;
        this.indices = new int[this.array.length];
    }

    @NotNull
    public final int[] getArray() {
        return this.array;
    }

    public final int getSize() {
        return this.size;
    }

    public final void setSize(int n) {
        this.size = n;
    }

    @NotNull
    public final int[] getIndices() {
        return this.indices;
    }

    @Override
    public boolean hasNext() {
        return this.size > 1 || this.size > 0 && (this.array.length == 1 || this.array.length - this.size > 1);
    }

    @Override
    @NotNull
    public Pair<int[], int[]> next() {
        int[] second;
        int[] first;
        block5: {
            int n;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.size == this.array.length) {
                this.decrementSize();
                return new Pair((Object)this.array, (Object)new int[0]);
            }
            int n2 = 0;
            int n3 = this.size;
            int[] nArray = new int[n3];
            while (n2 < n3) {
                n = n2++;
                nArray[n] = this.array[this.indices[n]];
            }
            first = nArray;
            second = new int[this.array.length - this.size];
            int i = 0;
            n = this.array.length;
            for (int index = 0; index < n; ++index) {
                if (ArraysKt.contains((int[])this.indices, (int)index)) continue;
                second[i++] = this.array[index];
            }
            i = this.size;
            do {
                if (--i > 0) continue;
                this.decrementSize();
                break block5;
            } while (this.indices[i] >= this.indices[i + 1] - 1);
            int[] nArray2 = this.indices;
            n = i;
            int n4 = nArray2[n];
            nArray2[n] = n4 + 1;
        }
        return new Pair((Object)first, (Object)second);
    }

    private final void decrementSize() {
        int n = this.size;
        this.size = n + -1;
        this.indices[this.size] = this.array.length;
        int n2 = this.size;
        for (int i = 0; i < n2; ++i) {
            this.indices[i] = i;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

