/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.core;

import com.android.tools.adtui.util.ActionToolbarUtilKt;
import com.android.tools.adtui.util.AwtUtilsKt;
import com.android.tools.idea.streaming.core.VolatileImageBufferingPainter;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.actionSystem.toolbarLayout.ToolbarLayoutStrategy;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.openapi.wm.impl.IdeGlassPaneEx;
import com.intellij.ui.ComponentUtil;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.Animator;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u0000 B2\u00020\u0001:\u0007<=>?@ABB;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0016\b\u0002\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010(\u001a\u00020)2\b\b\u0001\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\u000e\u0010.\u001a\u00020)2\u0006\u0010/\u001a\u000200J\u0006\u00101\u001a\u00020)J\u001a\u00102\u001a\u00020)2\b\b\u0002\u00103\u001a\u00020\r2\b\b\u0002\u00104\u001a\u00020\u0003J\u0006\u00105\u001a\u00020)J\u0010\u00106\u001a\u00020)2\u0006\u00107\u001a\u00020\u0014H\u0002J\u0010\u00108\u001a\u00020)2\u0006\u00109\u001a\u00020:H\u0002J\b\u0010;\u001a\u00020)H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\u00020\r8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR&\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00058\u0000@BX\u0081\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001e\u0010\"\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0005@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b#\u0010!R\u001e\u0010$\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0005@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b%\u0010!R\u0014\u0010&\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u001b\u00a8\u0006C"}, d2={"Lcom/android/tools/idea/streaming/core/FloatingToolbarContainer;", "Ljavax/swing/JPanel;", "horizontal", "", "inactiveAlpha", "", "collapsedStateSelector", "Lkotlin/Function1;", "Lcom/intellij/openapi/actionSystem/impl/ActionButton;", "activateOnHover", "<init>", "(ZDLkotlin/jvm/functions/Function1;Z)V", "orientation", "", "getOrientation$annotations", "()V", "actionToolbars", "", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "visibilityDisposable", "Lcom/intellij/openapi/Disposable;", "listeningToMouseEvents", "activationAnimator", "Lcom/intellij/util/ui/Animator;", "deactivationAnimator", "pendingDeactivation", "isActive", "()Z", "value", "activationFactor", "getActivationFactor$intellij_android_streaming", "()D", "setActivationFactor", "(D)V", "expansionFactor", "setExpansionFactor", "alpha", "setAlpha", "collapsible", "getCollapsible", "addToolbar", "", "place", "", "actionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "setTargetComponent", "component", "Ljavax/swing/JComponent;", "triggerActivation", "triggerDeactivation", "delayMillis", "slow", "toggleActiveState", "setUpMouseListener", "disposable", "controlActivation", "event", "Ljava/awt/event/MouseEvent;", "onVisibilityChanged", "Orientation", "ActivationAnimator", "DeactivationAnimator", "ToolbarPanel", "Layout", "CollapserAction", "Companion", "intellij.android.streaming"})
@SourceDebugExtension(value={"SMAP\nFloatingToolbarContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FloatingToolbarContainer.kt\ncom/android/tools/idea/streaming/core/FloatingToolbarContainer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,646:1\n1#2:647\n*E\n"})
public final class FloatingToolbarContainer
extends JPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double inactiveAlpha;
    @Nullable
    private final Function1<ActionButton, Boolean> collapsedStateSelector;
    private final boolean activateOnHover;
    private final int orientation;
    @NotNull
    private final List<ActionToolbar> actionToolbars;
    @Nullable
    private Disposable visibilityDisposable;
    private boolean listeningToMouseEvents;
    @Nullable
    private Animator activationAnimator;
    @Nullable
    private Animator deactivationAnimator;
    private boolean pendingDeactivation;
    @VisibleForTesting
    private double activationFactor;
    private double expansionFactor;
    private double alpha;
    private static final int ANIMATION_FRAMES_PER_SECOND = 60;
    private static final int ACTIVATION_ANIMATION_DURATION_MILLIS = 100;
    private static final int COLLAPSE_ANIMATION_DURATION_MILLIS = 100;
    private static final int COLLAPSE_ANIMATION_DURATION_SLOW_MILLIS = 400;
    private static final int COLLAPSE_DELAY_MILLIS = 2000;
    private static final double ACTIVE_ALPHA = 1.0;
    @NotNull
    private static final Dimension ZERO_DIMENSION = new Dimension();
    private static final int SPACER_SIZE = ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE.width / 3;

    public FloatingToolbarContainer(boolean horizontal, double inactiveAlpha, @Nullable Function1<? super ActionButton, Boolean> collapsedStateSelector, boolean activateOnHover) {
        this.inactiveAlpha = inactiveAlpha;
        this.collapsedStateSelector = collapsedStateSelector;
        this.activateOnHover = activateOnHover;
        this.orientation = horizontal ? 0 : 1;
        this.actionToolbars = new ArrayList();
        this.expansionFactor = this.getCollapsible() ? this.activationFactor : 1.0;
        this.alpha = this.inactiveAlpha;
        double d = this.inactiveAlpha;
        if (!(0.0 <= d ? d <= 1.0 : false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.setOpaque(false);
        this.setLayout((LayoutManager)((Object)new Layout()));
        this.addHierarchyListener(arg_0 -> FloatingToolbarContainer._init_$lambda$0(this, arg_0));
    }

    public /* synthetic */ FloatingToolbarContainer(boolean bl, double d, Function1 function1, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            d = 1.0;
        }
        if ((n & 4) != 0) {
            function1 = null;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        this(bl, d, (Function1<? super ActionButton, Boolean>)function1, bl2);
    }

    @Orientation
    private static /* synthetic */ void getOrientation$annotations() {
    }

    public final boolean isActive() {
        return (this.activationFactor > 0.0 || this.activationAnimator != null) && !this.pendingDeactivation && this.deactivationAnimator == null;
    }

    public final double getActivationFactor$intellij_android_streaming() {
        return this.activationFactor;
    }

    private final void setActivationFactor(double value2) {
        if (!(this.activationFactor == value2)) {
            this.activationFactor = value2;
            if (this.getCollapsible()) {
                this.setExpansionFactor(this.activationFactor);
            }
            this.setAlpha(RangesKt.coerceIn((double)(this.inactiveAlpha + (1.0 - this.inactiveAlpha) * value2), (double)this.inactiveAlpha, (double)1.0));
        }
    }

    private final void setExpansionFactor(double value2) {
        if (!(this.expansionFactor == value2)) {
            this.expansionFactor = value2;
            this.revalidate();
        }
    }

    private final void setAlpha(double value2) {
        if (!(this.alpha == value2)) {
            this.alpha = value2;
            Component[] componentArray = this.getComponents();
            Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
            for (Component child : componentArray) {
                if (!(child instanceof ToolbarPanel)) continue;
                ((ToolbarPanel)((Object)child)).setAlpha((float)this.alpha);
            }
            this.repaint();
        }
    }

    private final boolean getCollapsible() {
        return this.collapsedStateSelector != null;
    }

    public final void addToolbar(@NonNls @NotNull String place, @NotNull ActionGroup actionGroup2) {
        ActionToolbar actionToolbar;
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)actionGroup2, (String)"actionGroup");
        ActionToolbar $this$addToolbar_u24lambda_u240 = actionToolbar = ActionManager.getInstance().createActionToolbar(place, actionGroup2, this.orientation == 0);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$addToolbar_u24lambda_u240);
        FloatingToolbarContainer.Companion.configureToolbar($this$addToolbar_u24lambda_u240);
        ActionToolbar actionToolbar2 = actionToolbar;
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar2, (String)"apply(...)");
        ActionToolbar actionToolbar3 = actionToolbar2;
        this.actionToolbars.add(actionToolbar3);
        ToolbarPanel toolbarPanel = new ToolbarPanel(actionToolbar3, this.collapsedStateSelector);
        toolbarPanel.setAlpha((float)this.alpha);
        this.add((Component)((Object)toolbarPanel));
    }

    public final void setTargetComponent(@NotNull JComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        for (ActionToolbar toolbar : this.actionToolbars) {
            toolbar.setTargetComponent(component);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void triggerActivation() {
        this.pendingDeactivation = false;
        Animator animator = this.deactivationAnimator;
        if (animator != null) {
            animator.dispose();
        }
        if (this.activationAnimator == null && this.activationFactor < 1.0) {
            void $this$triggerActivation_u24lambda_u240;
            ActivationAnimator activationAnimator;
            ActivationAnimator activationAnimator2 = activationAnimator = new ActivationAnimator(AwtUtilsKt.scaled((int)100, (double)(1.0 - this.activationFactor)));
            FloatingToolbarContainer floatingToolbarContainer = this;
            boolean bl = false;
            $this$triggerActivation_u24lambda_u240.resume();
            floatingToolbarContainer.activationAnimator = activationAnimator;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void triggerDeactivation(int delayMillis, boolean slow) {
        if (this.activationAnimator == null) {
            if (this.activationFactor > 0.0 && this.deactivationAnimator == null) {
                void $this$triggerDeactivation_u24lambda_u240;
                DeactivationAnimator deactivationAnimator;
                int duration = slow ? 400 : 100;
                DeactivationAnimator deactivationAnimator2 = deactivationAnimator = new DeactivationAnimator(delayMillis, duration);
                FloatingToolbarContainer floatingToolbarContainer = this;
                boolean bl = false;
                $this$triggerDeactivation_u24lambda_u240.resume();
                floatingToolbarContainer.deactivationAnimator = deactivationAnimator;
            }
        } else {
            this.pendingDeactivation = true;
        }
    }

    public static /* synthetic */ void triggerDeactivation$default(FloatingToolbarContainer floatingToolbarContainer, int n, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        if ((n2 & 2) != 0) {
            bl = false;
        }
        floatingToolbarContainer.triggerDeactivation(n, bl);
    }

    public final void toggleActiveState() {
        if (this.isActive()) {
            FloatingToolbarContainer.triggerDeactivation$default(this, 0, false, 3, null);
        } else {
            this.triggerActivation();
        }
    }

    private final void setUpMouseListener(Disposable disposable) {
        if (this.listeningToMouseEvents) {
            return;
        }
        MouseAdapter mouseListener2 = new MouseAdapter(this){
            final /* synthetic */ FloatingToolbarContainer this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseEntered(MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                FloatingToolbarContainer.access$controlActivation(this.this$0, event);
            }

            public void mouseExited(MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                FloatingToolbarContainer.access$controlActivation(this.this$0, event);
            }

            public void mouseMoved(MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                FloatingToolbarContainer.access$controlActivation(this.this$0, event);
            }
        };
        IdeGlassPane ideGlassPane = IdeGlassPaneUtil.find((Component)this);
        Intrinsics.checkNotNull((Object)ideGlassPane, (String)"null cannot be cast to non-null type com.intellij.openapi.wm.impl.IdeGlassPaneEx");
        IdeGlassPaneEx glass = (IdeGlassPaneEx)ideGlassPane;
        glass.addMousePreprocessor((MouseListener)mouseListener2, disposable);
        glass.addMouseMotionPreprocessor((MouseMotionListener)mouseListener2, disposable);
        this.listeningToMouseEvents = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void controlActivation(MouseEvent event) {
        Point point = event.getLocationOnScreen();
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getLocationOnScreen(...)");
        Point point2 = this.getLocationOnScreen();
        Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"getLocationOnScreen(...)");
        Point mouseLocation = FloatingToolbarContainer.Companion.minus(point, point2);
        if (mouseLocation.x >= 0 && mouseLocation.y >= 0 && mouseLocation.x < this.getWidth() && mouseLocation.y < this.getHeight() && this.getComponentCount() != 0) {
            int n = FloatingToolbarContainer.Companion.get(mouseLocation, this.orientation);
            Point point3 = this.getComponent(0).getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)point3, (String)"getLocation(...)");
            if (n >= FloatingToolbarContainer.Companion.get(point3, this.orientation)) {
                this.triggerActivation();
                return;
            }
        }
        this.triggerDeactivation(2000, true);
    }

    private final void onVisibilityChanged() {
        if (this.isShowing()) {
            Disposable disposable = this.visibilityDisposable;
            if (disposable == null) {
                Disposable disposable2;
                Disposable it = disposable2 = Disposer.newDisposable((String)"FloatingToolbarContainer");
                boolean bl = false;
                this.visibilityDisposable = it;
                Disposable disposable3 = disposable2;
                disposable = disposable3;
                Intrinsics.checkNotNullExpressionValue((Object)disposable3, (String)"also(...)");
            }
            Disposable disposable4 = disposable;
            if (this.activateOnHover && (this.getCollapsible() || this.inactiveAlpha < 1.0)) {
                this.setUpMouseListener(disposable4);
            }
        } else {
            Animator animator = this.activationAnimator;
            if (animator != null) {
                animator.dispose();
            }
            Animator animator2 = this.deactivationAnimator;
            if (animator2 != null) {
                animator2.dispose();
            }
            Disposable disposable = this.visibilityDisposable;
            if (disposable != null) {
                Disposable it = disposable;
                boolean bl = false;
                Disposer.dispose((Disposable)it);
            }
            this.visibilityDisposable = null;
            this.listeningToMouseEvents = false;
        }
    }

    private static final void _init_$lambda$0(FloatingToolbarContainer this$0, HierarchyEvent event) {
        if (((int)event.getChangeFlags() & 6) != 0) {
            this$0.onVisibilityChanged();
        }
    }

    public static final /* synthetic */ void access$controlActivation(FloatingToolbarContainer $this, MouseEvent event) {
        $this.controlActivation(event);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003H\u0016J\b\u0010\r\u001a\u00020\tH\u0014J\b\u0010\u000e\u001a\u00020\tH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/streaming/core/FloatingToolbarContainer$ActivationAnimator;", "Lcom/intellij/util/ui/Animator;", "durationMillis", "", "<init>", "(Lcom/android/tools/idea/streaming/core/FloatingToolbarContainer;I)V", "initialActivationFactor", "", "paintNow", "", "frame", "totalFrames", "cycle", "paintCycleEnd", "dispose", "intellij.android.streaming"})
    private final class ActivationAnimator
    extends Animator {
        private final double initialActivationFactor;

        public ActivationAnimator(int durationMillis) {
            super("ActivationAnimator", Companion.numFrames(durationMillis), durationMillis, false, false, null, 48, null);
            this.initialActivationFactor = FloatingToolbarContainer.this.getActivationFactor$intellij_android_streaming();
        }

        public void paintNow(int frame, int totalFrames, int cycle) {
            FloatingToolbarContainer.this.setActivationFactor(RangesKt.coerceIn((double)(this.initialActivationFactor + (double)frame / (double)totalFrames), (double)0.0, (double)1.0));
        }

        protected void paintCycleEnd() {
            FloatingToolbarContainer.this.setActivationFactor(1.0);
            this.dispose();
        }

        public void dispose() {
            super.dispose();
            FloatingToolbarContainer.this.activationAnimator = null;
            if (FloatingToolbarContainer.this.pendingDeactivation) {
                FloatingToolbarContainer.this.pendingDeactivation = false;
                FloatingToolbarContainer.this.triggerDeactivation(2000, true);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/streaming/core/FloatingToolbarContainer$CollapserAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/openapi/actionSystem/ex/CustomComponentAction;", "<init>", "()V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "intellij.android.streaming"})
    public static final class CollapserAction
    extends DumbAwareAction
    implements CustomComponentAction {
        public CollapserAction() {
            super(AllIcons.Actions.ArrowExpand);
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Companion.triggerDeactivation(event);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        @NotNull
        public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
            Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            return (JComponent)new ActionButton((AnAction)this, presentation, place, (Dimension)new JBDimension(0, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE.height, true));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007J0\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\u0014\u0010\u0014\u001a\u00020\u0015*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\f\u0010\u0019\u001a\u00020\u0015*\u00020\u0016H\u0002J\f\u0010\u001a\u001a\u00020\t*\u00020\u001bH\u0002J\u001e\u0010\u001c\u001a\u00020\t*\u00020\u00152\b\b\u0001\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u0015H\u0002J\u001e\u0010\u001f\u001a\u00020\t*\u00020\u00152\b\b\u0001\u0010\u001d\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u000fH\u0002J\u001f\u0010!\u001a\u00020\t*\u00020\u00152\b\b\u0001\u0010\u001d\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u000fH\u0082\u0002J\u0017\u0010\"\u001a\u00020\u000f*\u00020\u00152\b\b\u0001\u0010\u001d\u001a\u00020\u000fH\u0082\u0002J\u0015\u0010#\u001a\u00020\u0015*\u00020\u00152\u0006\u0010$\u001a\u00020%H\u0082\u0002J\u0015\u0010&\u001a\u00020\u0015*\u00020\u00152\u0006\u0010$\u001a\u00020%H\u0082\u0002J\u0017\u0010\"\u001a\u00020\u000f*\u00020'2\b\b\u0001\u0010\u001d\u001a\u00020\u000fH\u0082\u0002J\u0015\u0010#\u001a\u00020'*\u00020'2\u0006\u0010(\u001a\u00020'H\u0082\u0002J\u001c\u0010)\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010*\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020\u000fH\u0002J\u0010\u0010,\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020\u000fH\u0002R\u000e\u0010.\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000204X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/android/tools/idea/streaming/core/FloatingToolbarContainer$Companion;", "", "<init>", "()V", "fromActionEvent", "Lcom/android/tools/idea/streaming/core/FloatingToolbarContainer;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "triggerActivation", "", "triggerDeactivation", "toggleActiveState", "createRoundRectangle", "Ljava/awt/geom/RoundRectangle2D;", "x", "", "y", "w", "h", "cornerRadius", "preferredSize", "Ljava/awt/Dimension;", "Ljava/awt/Component;", "collapsed", "", "collapsedSize", "configureToolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "combine", "orientation", "other", "increment", "value", "set", "get", "minus", "insets", "Ljava/awt/Insets;", "plus", "Ljava/awt/Point;", "point", "scaled", "numerator", "denominator", "numFrames", "durationMillis", "ANIMATION_FRAMES_PER_SECOND", "ACTIVATION_ANIMATION_DURATION_MILLIS", "COLLAPSE_ANIMATION_DURATION_MILLIS", "COLLAPSE_ANIMATION_DURATION_SLOW_MILLIS", "COLLAPSE_DELAY_MILLIS", "ACTIVE_ALPHA", "", "ZERO_DIMENSION", "SPACER_SIZE", "intellij.android.streaming"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final FloatingToolbarContainer fromActionEvent(@NotNull AnActionEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Serializable serializable = event.getInputEvent();
            if (serializable == null || (serializable = serializable.getComponent()) == null) {
                return null;
            }
            Serializable component = serializable;
            return (FloatingToolbarContainer)ComponentUtil.getParentOfType(FloatingToolbarContainer.class, (Component)component);
        }

        public final void triggerActivation(@NotNull AnActionEvent event) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                FloatingToolbarContainer floatingToolbarContainer = this.fromActionEvent(event);
                if (floatingToolbarContainer == null) break block0;
                floatingToolbarContainer.triggerActivation();
            }
        }

        public final void triggerDeactivation(@NotNull AnActionEvent event) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                FloatingToolbarContainer floatingToolbarContainer = this.fromActionEvent(event);
                if (floatingToolbarContainer == null) break block0;
                FloatingToolbarContainer.triggerDeactivation$default(floatingToolbarContainer, 0, false, 3, null);
            }
        }

        public final void toggleActiveState(@NotNull AnActionEvent event) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                FloatingToolbarContainer floatingToolbarContainer = this.fromActionEvent(event);
                if (floatingToolbarContainer == null) break block0;
                floatingToolbarContainer.toggleActiveState();
            }
        }

        private final RoundRectangle2D createRoundRectangle(int x, int y, int w, int h, int cornerRadius) {
            return new RoundRectangle2D.Double(x, y, w, h, cornerRadius, cornerRadius);
        }

        private final Dimension preferredSize(Component $this$preferredSize, boolean collapsed) {
            Dimension dimension2;
            if (collapsed) {
                dimension2 = this.collapsedSize($this$preferredSize);
            } else {
                Dimension dimension3 = $this$preferredSize.getPreferredSize();
                dimension2 = dimension3;
                Intrinsics.checkNotNullExpressionValue((Object)dimension3, (String)"getPreferredSize(...)");
            }
            return dimension2;
        }

        private final Dimension collapsedSize(Component $this$collapsedSize) {
            Object object = $this$collapsedSize instanceof ToolbarPanel ? (ToolbarPanel)((Object)$this$collapsedSize) : null;
            if (object == null || (object = object.getCollapsedSize()) == null) {
                object = ZERO_DIMENSION;
            }
            return object;
        }

        private final void configureToolbar(ActionToolbar $this$configureToolbar) {
            JComponent jComponent;
            $this$configureToolbar.setLayoutStrategy(ToolbarLayoutStrategy.NOWRAP_STRATEGY);
            $this$configureToolbar.setMinimumButtonSize(ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
            ActionToolbarImpl actionToolbarImpl = $this$configureToolbar instanceof ActionToolbarImpl ? (ActionToolbarImpl)$this$configureToolbar : null;
            if (actionToolbarImpl != null) {
                actionToolbarImpl.setActionButtonBorder(1, 1);
            }
            JComponent $this$configureToolbar_u24lambda_u240 = jComponent = $this$configureToolbar.getComponent();
            boolean bl = false;
            $this$configureToolbar_u24lambda_u240.setBorder(JBUI.Borders.empty((int)2));
            $this$configureToolbar_u24lambda_u240.setOpaque(false);
            $this$configureToolbar_u24lambda_u240.putClientProperty("ActionToolbarImpl.importantToolbar", true);
            ActionToolbarUtilKt.makeNavigable((ActionToolbar)$this$configureToolbar);
        }

        private final void combine(Dimension $this$combine, @Orientation int orientation, Dimension other) {
            if (orientation == 0) {
                $this$combine.width += other.width;
                $this$combine.height = Math.max($this$combine.height, other.height);
            } else {
                $this$combine.width = Math.max($this$combine.width, other.width);
                $this$combine.height += other.height;
            }
        }

        private final void increment(Dimension $this$increment, @Orientation int orientation, int value2) {
            if (orientation == 0) {
                $this$increment.width += value2;
            } else {
                $this$increment.height += value2;
            }
        }

        private final void set(Dimension $this$set, @Orientation int orientation, int value2) {
            Intrinsics.checkNotNullParameter((Object)$this$set, (String)"<this>");
            if (orientation == 0) {
                $this$set.width = value2;
            } else {
                $this$set.height = value2;
            }
        }

        private final int get(Dimension $this$get, @Orientation int orientation) {
            Intrinsics.checkNotNullParameter((Object)$this$get, (String)"<this>");
            return orientation == 0 ? $this$get.width : $this$get.height;
        }

        private final Dimension minus(Dimension $this$minus, Insets insets) {
            Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"<this>");
            return new Dimension($this$minus.width - insets.left - insets.right, $this$minus.height - insets.top - insets.bottom);
        }

        private final Dimension plus(Dimension $this$plus, Insets insets) {
            Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
            return new Dimension($this$plus.width + insets.left + insets.right, $this$plus.height + insets.top + insets.bottom);
        }

        private final int get(Point $this$get, @Orientation int orientation) {
            Intrinsics.checkNotNullParameter((Object)$this$get, (String)"<this>");
            return orientation == 0 ? $this$get.x : $this$get.y;
        }

        private final Point minus(Point $this$minus, Point point) {
            Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"<this>");
            return new Point($this$minus.x - point.x, $this$minus.y - point.y);
        }

        private final int scaled(int $this$scaled, int numerator, int denominator) {
            return (int)(((long)$this$scaled * (long)numerator + (long)(denominator / 2)) / (long)denominator);
        }

        private final int numFrames(int durationMillis) {
            return Math.max(this.scaled(durationMillis, 60, 1000), 1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\b\u0010\u000f\u001a\u00020\u000bH\u0014J\b\u0010\u0010\u001a\u00020\u000bH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/streaming/core/FloatingToolbarContainer$DeactivationAnimator;", "Lcom/intellij/util/ui/Animator;", "delayMillis", "", "durationMillis", "<init>", "(Lcom/android/tools/idea/streaming/core/FloatingToolbarContainer;II)V", "initialActivationFactor", "", "delayFrames", "paintNow", "", "frame", "totalFrames", "cycle", "paintCycleEnd", "dispose", "intellij.android.streaming"})
    private final class DeactivationAnimator
    extends Animator {
        private final double initialActivationFactor;
        private final int delayFrames;

        public DeactivationAnimator(int delayMillis, int durationMillis) {
            super("CollapseAnimator", Companion.numFrames(delayMillis + durationMillis), delayMillis + durationMillis, false, false, null, 48, null);
            this.initialActivationFactor = FloatingToolbarContainer.this.getActivationFactor$intellij_android_streaming();
            this.delayFrames = Companion.numFrames(delayMillis);
        }

        public void paintNow(int frame, int totalFrames, int cycle) {
            if (frame <= this.delayFrames) {
                return;
            }
            FloatingToolbarContainer.this.setActivationFactor(RangesKt.coerceIn((double)(this.initialActivationFactor - (double)(frame - this.delayFrames) / (double)(totalFrames - this.delayFrames)), (double)0.0, (double)1.0));
        }

        protected void paintCycleEnd() {
            FloatingToolbarContainer.this.setActivationFactor(0.0);
            this.dispose();
        }

        public void dispose() {
            super.dispose();
            FloatingToolbarContainer.this.deactivationAnimator = null;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/streaming/core/FloatingToolbarContainer$Layout;", "Lcom/intellij/util/ui/AbstractLayoutManager;", "<init>", "(Lcom/android/tools/idea/streaming/core/FloatingToolbarContainer;)V", "preferredLayoutSize", "Ljava/awt/Dimension;", "container", "Ljava/awt/Container;", "layoutContainer", "", "computeSize", "collapsed", "", "intellij.android.streaming"})
    private final class Layout
    extends AbstractLayoutManager {
        @NotNull
        public Dimension preferredLayoutSize(@NotNull Container container) {
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            if (!Intrinsics.areEqual((Object)container, (Object)FloatingToolbarContainer.this)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return this.computeSize(false);
        }

        public void layoutContainer(@NotNull Container container) {
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            if (!Intrinsics.areEqual((Object)container, (Object)FloatingToolbarContainer.this)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            Dimension expandedSize = this.computeSize(false);
            Dimension collapsedSize = this.computeSize(true);
            Insets insets = FloatingToolbarContainer.this.getInsets();
            Rectangle rect = new Rectangle(insets.left, insets.top, FloatingToolbarContainer.this.getWidth() - insets.left - insets.right, FloatingToolbarContainer.this.getHeight() - insets.top - insets.bottom);
            int expansion2 = AwtUtilsKt.scaled((int)(Companion.get(expandedSize, FloatingToolbarContainer.this.orientation) - Companion.get(collapsedSize, FloatingToolbarContainer.this.orientation)), (double)FloatingToolbarContainer.this.expansionFactor);
            Dimension offset = new Dimension();
            int n = FloatingToolbarContainer.this.orientation;
            Dimension dimension2 = rect.getSize();
            Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"getSize(...)");
            Companion.set(offset, n, Companion.get(dimension2, FloatingToolbarContainer.this.orientation) - Companion.get(collapsedSize, FloatingToolbarContainer.this.orientation) - expansion2);
            boolean pendingSpacer = false;
            Component[] componentArray = container.getComponents();
            Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
            for (Component child : componentArray) {
                if (pendingSpacer) {
                    int spacerLength = Math.min(expansion2, SPACER_SIZE);
                    expansion2 -= spacerLength;
                    Companion.increment(offset, FloatingToolbarContainer.this.orientation, spacerLength);
                }
                Dimension childSize = child.getPreferredSize();
                Intrinsics.checkNotNull((Object)child);
                int minChildLength = Companion.get(Companion.preferredSize(child, true), FloatingToolbarContainer.this.orientation);
                Intrinsics.checkNotNull((Object)childSize);
                int childExpansion = Math.min(expansion2, Companion.get(childSize, FloatingToolbarContainer.this.orientation) - minChildLength);
                Companion.set(childSize, FloatingToolbarContainer.this.orientation, minChildLength + childExpansion);
                child.setBounds(offset.width, offset.height, childSize.width, childSize.height);
                expansion2 -= childExpansion;
                Companion.increment(offset, FloatingToolbarContainer.this.orientation, Companion.get(childSize, FloatingToolbarContainer.this.orientation));
                if (Companion.get(childSize, FloatingToolbarContainer.this.orientation) == 0) continue;
                pendingSpacer = true;
            }
        }

        private final Dimension computeSize(boolean collapsed) {
            Dimension size = new Dimension();
            boolean pendingSpacer = false;
            Component[] componentArray = FloatingToolbarContainer.this.getComponents();
            Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
            for (Component child : componentArray) {
                Intrinsics.checkNotNull((Object)child);
                Dimension childSize = Companion.preferredSize(child, collapsed);
                if (Companion.get(childSize, FloatingToolbarContainer.this.orientation) == 0) continue;
                if (pendingSpacer) {
                    Companion.increment(size, FloatingToolbarContainer.this.orientation, SPACER_SIZE);
                }
                Companion.combine(size, FloatingToolbarContainer.this.orientation, childSize);
                pendingSpacer = true;
            }
            return size;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0082\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Lcom/android/tools/idea/streaming/core/FloatingToolbarContainer$Orientation;", "", "intellij.android.streaming"})
    private static @interface Orientation {
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001:\u000289B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010'\u001a\u00020\u0007H\u0014J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0014J\u0010\u0010,\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0014J\u0010\u0010-\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0014J\u0018\u0010.\u001a\u00020)2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0002J\u0018\u00103\u001a\u00020)2\u0006\u0010/\u001a\u0002002\u0006\u00104\u001a\u000202H\u0002J\b\u00105\u001a\u000202H\u0002J\b\u00106\u001a\u00020$H\u0016J\b\u00107\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR1\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00138F@FX\u0086\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a*\u0004\b\u0015\u0010\u0016R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010#\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u0006:"}, d2={"Lcom/android/tools/idea/streaming/core/FloatingToolbarContainer$ToolbarPanel;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "toolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "collapsedStateSelector", "Lkotlin/Function1;", "Lcom/intellij/openapi/actionSystem/impl/ActionButton;", "", "<init>", "(Lcom/intellij/openapi/actionSystem/ActionToolbar;Lkotlin/jvm/functions/Function1;)V", "bufferingPainter", "Lcom/android/tools/idea/streaming/core/VolatileImageBufferingPainter;", "crossDimension", "", "getCrossDimension", "()I", "cornerRadius", "getCornerRadius", "<set-?>", "", "alpha", "getAlpha$delegate", "(Lcom/android/tools/idea/streaming/core/FloatingToolbarContainer$ToolbarPanel;)Ljava/lang/Object;", "getAlpha", "()F", "setAlpha", "(F)V", "alpha$receiver", "Lcom/android/tools/idea/streaming/core/VolatileImageBufferingPainter;", "actionButtons", "", "hierarchyListener", "Ljava/awt/event/HierarchyListener;", "buttonSelectionListener", "Ljava/beans/PropertyChangeListener;", "collapsedSize", "Ljava/awt/Dimension;", "getCollapsedSize", "()Ljava/awt/Dimension;", "isPaintingOrigin", "paintComponent", "", "g", "Ljava/awt/Graphics;", "paintBorder", "paintChildren", "paintWithTransparentCorners", "g2", "Ljava/awt/Graphics2D;", "outsideShape", "Ljava/awt/Shape;", "clearArea", "area", "createOutsideShape", "getMaximumSize", "isVisibleWhenCollapsed", "Layout", "Extent", "intellij.android.streaming"})
    @SourceDebugExtension(value={"SMAP\nFloatingToolbarContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FloatingToolbarContainer.kt\ncom/android/tools/idea/streaming/core/FloatingToolbarContainer$ToolbarPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,646:1\n1#2:647\n*E\n"})
    private static final class ToolbarPanel
    extends BorderLayoutPanel {
        @NotNull
        private final ActionToolbar toolbar;
        @Nullable
        private final Function1<ActionButton, Boolean> collapsedStateSelector;
        @NotNull
        private VolatileImageBufferingPainter bufferingPainter;
        @NotNull
        private final VolatileImageBufferingPainter alpha$receiver;
        @NotNull
        private final List<ActionButton> actionButtons;
        @NotNull
        private final HierarchyListener hierarchyListener;
        @NotNull
        private final PropertyChangeListener buttonSelectionListener;

        public ToolbarPanel(@NotNull ActionToolbar toolbar, @Nullable Function1<? super ActionButton, Boolean> collapsedStateSelector) {
            Intrinsics.checkNotNullParameter((Object)toolbar, (String)"toolbar");
            this.toolbar = toolbar;
            this.collapsedStateSelector = collapsedStateSelector;
            this.alpha$receiver = this.bufferingPainter = new VolatileImageBufferingPainter(3);
            this.actionButtons = new ArrayList();
            this.hierarchyListener = arg_0 -> ToolbarPanel.hierarchyListener$lambda$0(this, arg_0);
            this.buttonSelectionListener = arg_0 -> ToolbarPanel.buttonSelectionListener$lambda$0(this, arg_0);
            this.setOpaque(false);
            this.setBackground(JBUI.CurrentTheme.Popup.toolbarPanelColor());
            this.setLayout((LayoutManager)((Object)new Layout()));
            this.toolbar.getComponent().addHierarchyListener(this.hierarchyListener);
            this.add(this.toolbar.getComponent());
        }

        private final int getCrossDimension() {
            return this.toolbar.getOrientation() == 0 ? this.getHeight() : this.getWidth();
        }

        private final int getCornerRadius() {
            return this.getCrossDimension() / 2;
        }

        public final float getAlpha() {
            return this.alpha$receiver.getAlpha();
        }

        public final void setAlpha(float f) {
            this.alpha$receiver.setAlpha(f);
        }

        private static Object getAlpha$delegate(ToolbarPanel toolbarPanel) {
            return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)toolbarPanel.alpha$receiver, VolatileImageBufferingPainter.class, "alpha", "getAlpha()F", 0)));
        }

        @NotNull
        public final Dimension getCollapsedSize() {
            if (this.isVisibleWhenCollapsed()) {
                Dimension maxSize = this.getMaximumSize();
                int s = Math.min(maxSize.width, maxSize.height);
                return new Dimension(s, s);
            }
            return ZERO_DIMENSION;
        }

        protected boolean isPaintingOrigin() {
            return true;
        }

        protected void paintComponent(@NotNull Graphics g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        }

        protected void paintBorder(@NotNull Graphics g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        }

        protected void paintChildren(@NotNull Graphics g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Shape outsideShape = this.createOutsideShape();
            Dimension dimension2 = this.getSize();
            Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"getSize(...)");
            this.bufferingPainter.paintBuffered(g, dimension2, (Function1<? super Graphics2D, Unit>)((Function1)arg_0 -> ToolbarPanel.paintChildren$lambda$0(this, outsideShape, arg_0)));
        }

        private final void paintWithTransparentCorners(Graphics2D g2, Shape outsideShape) {
            GraphicsUtil.setupAAPainting((Graphics)g2);
            if (this.getBackground() != null) {
                g2.setColor(this.getBackground());
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            super.paintChildren((Graphics)g2);
            this.clearArea(g2, outsideShape);
            g2.setColor(JBUI.CurrentTheme.Toolbar.SEPARATOR_COLOR);
            g2.draw(Companion.createRoundRectangle(0, 0, this.getWidth() - 1, this.getHeight() - 1, this.getCornerRadius()));
        }

        private final void clearArea(Graphics2D g2, Shape area) {
            GraphicsConfig config = GraphicsUtil.disableAAPainting((Graphics)g2);
            Composite composite = g2.getComposite();
            g2.setComposite(AlphaComposite.Clear);
            g2.fill(area);
            g2.setComposite(composite);
            config.restore();
        }

        private final Shape createOutsideShape() {
            Path2D.Double double_;
            Path2D.Double $this$createOutsideShape_u24lambda_u240 = double_ = new Path2D.Double(0);
            boolean bl = false;
            $this$createOutsideShape_u24lambda_u240.append(Companion.createRoundRectangle(0, 0, this.getWidth() - 1, this.getHeight() - 1, this.getCornerRadius()), false);
            $this$createOutsideShape_u24lambda_u240.append(new Rectangle(0, 0, this.getWidth(), this.getHeight()), false);
            return double_;
        }

        @NotNull
        public Dimension getMaximumSize() {
            Dimension dimension2 = this.toolbar.getComponent().getPreferredSize();
            Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"getPreferredSize(...)");
            Insets insets = this.getInsets();
            Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"getInsets(...)");
            return Companion.plus(dimension2, insets);
        }

        private final boolean isVisibleWhenCollapsed() {
            Object object;
            block2: {
                Function1<ActionButton, Boolean> function1 = this.collapsedStateSelector;
                if (function1 == null) {
                    return false;
                }
                Function1<ActionButton, Boolean> selector = function1;
                Component[] componentArray = this.toolbar.getComponent().getComponents();
                Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
                for (Object object2 : (Object[])componentArray) {
                    Component it = (Component)object2;
                    boolean bl = false;
                    if (!(it instanceof ActionButton && ((ActionButton)it).isVisible() && (Boolean)selector.invoke((Object)it) != false)) continue;
                    object = object2;
                    break block2;
                }
                object = null;
            }
            return object != null;
        }

        private static final void hierarchyListener$lambda$0(ToolbarPanel this$0, HierarchyEvent it) {
            for (ActionButton button : this$0.actionButtons) {
                button.getPresentation().removePropertyChangeListener(this$0.buttonSelectionListener);
            }
            this$0.actionButtons.clear();
            Component[] componentArray = this$0.toolbar.getComponent().getComponents();
            Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
            for (Component child : componentArray) {
                if (!(child instanceof ActionButton)) continue;
                this$0.actionButtons.add((ActionButton)child);
                ((ActionButton)child).getPresentation().addPropertyChangeListener(this$0.buttonSelectionListener);
            }
        }

        private static final void buttonSelectionListener$lambda$0(ToolbarPanel this$0, PropertyChangeEvent event) {
            if (Intrinsics.areEqual((Object)event.getPropertyName(), (Object)Toggleable.SELECTED_KEY.toString())) {
                this$0.revalidate();
            }
        }

        private static final Unit paintChildren$lambda$0(ToolbarPanel this$0, Shape $outsideShape, Graphics2D it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            this$0.paintWithTransparentCorners(it, $outsideShape);
            return Unit.INSTANCE;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/streaming/core/FloatingToolbarContainer$ToolbarPanel$Extent;", "", "offset", "", "size", "<init>", "(II)V", "getOffset", "()I", "getSize", "intellij.android.streaming"})
        public static final class Extent {
            private final int offset;
            private final int size;

            public Extent(int offset, int size) {
                this.offset = offset;
                this.size = size;
            }

            public final int getOffset() {
                return this.offset;
            }

            public final int getSize() {
                return this.size;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0002J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/streaming/core/FloatingToolbarContainer$ToolbarPanel$Layout;", "Lcom/intellij/util/ui/AbstractLayoutManager;", "<init>", "(Lcom/android/tools/idea/streaming/core/FloatingToolbarContainer$ToolbarPanel;)V", "orientation", "", "getOrientation", "()I", "preferredLayoutSize", "Ljava/awt/Dimension;", "parent", "Ljava/awt/Container;", "layoutContainer", "", "calculateToolbarOffset", "availableSize", "preferredToolbarSize", "locateAnchorButton", "Lcom/android/tools/idea/streaming/core/FloatingToolbarContainer$ToolbarPanel$Extent;", "intellij.android.streaming"})
        private final class Layout
        extends AbstractLayoutManager {
            private final int getOrientation() {
                return ToolbarPanel.this.toolbar.getOrientation();
            }

            @NotNull
            public Dimension preferredLayoutSize(@NotNull Container parent) {
                Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
                Dimension dimension2 = ToolbarPanel.this.toolbar.getComponent().getPreferredSize();
                Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"getPreferredSize(...)");
                Insets insets = ToolbarPanel.this.getInsets();
                Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"getInsets(...)");
                return Companion.plus(dimension2, insets);
            }

            public void layoutContainer(@NotNull Container parent) {
                Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
                Insets insets = ToolbarPanel.this.getInsets();
                Dimension toolbarSize = ToolbarPanel.this.toolbar.getComponent().getPreferredSize();
                Dimension dimension2 = ToolbarPanel.this.getSize();
                Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"getSize(...)");
                Intrinsics.checkNotNull((Object)insets);
                Dimension dimension3 = Companion.minus(dimension2, insets);
                Intrinsics.checkNotNull((Object)toolbarSize);
                Dimension offset = this.calculateToolbarOffset(dimension3, toolbarSize);
                ToolbarPanel.this.toolbar.getComponent().setBounds(insets.left + offset.width, insets.top + offset.height, toolbarSize.width, toolbarSize.height);
            }

            private final Dimension calculateToolbarOffset(Dimension availableSize, Dimension preferredToolbarSize) {
                Insets insets = ToolbarPanel.this.toolbar.getComponent().getInsets();
                Intrinsics.checkNotNull((Object)insets);
                int available = Companion.get(Companion.minus(availableSize, insets), this.getOrientation());
                int preferred = Companion.get(Companion.minus(preferredToolbarSize, insets), this.getOrientation());
                if (preferred <= available) {
                    return ZERO_DIMENSION;
                }
                Extent extent = this.locateAnchorButton();
                if (extent == null) {
                    return ZERO_DIMENSION;
                }
                Extent anchorExtent = extent;
                if (preferred <= anchorExtent.getSize()) {
                    return ZERO_DIMENSION;
                }
                int d = Companion.scaled(anchorExtent.getOffset(), preferred - available, preferred - anchorExtent.getSize());
                return this.getOrientation() == 0 ? new Dimension(-d, 0) : new Dimension(0, -d);
            }

            private final Extent locateAnchorButton() {
                int offset = 0;
                Extent firstEnabled = null;
                Extent firstVisible = null;
                Component[] componentArray = ToolbarPanel.this.toolbar.getComponent().getComponents();
                Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
                for (Component child : componentArray) {
                    Dimension dimension2 = child.getPreferredSize();
                    Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"getPreferredSize(...)");
                    int childSize = Companion.get(dimension2, this.getOrientation());
                    if (child instanceof ActionButton && ((ActionButton)child).isVisible()) {
                        Function1 function1 = ToolbarPanel.this.collapsedStateSelector;
                        boolean bl = function1 != null ? ((Boolean)function1.invoke((Object)child)).booleanValue() : false;
                        if (bl) {
                            return new Extent(offset, childSize);
                        }
                        if (firstEnabled == null && ((ActionButton)child).isEnabled()) {
                            firstEnabled = new Extent(offset, childSize);
                        }
                        if (firstVisible == null) {
                            firstVisible = new Extent(offset, childSize);
                        }
                    }
                    offset += childSize;
                }
                Extent extent = firstEnabled;
                if (extent == null) {
                    extent = firstVisible;
                }
                return extent;
            }
        }
    }
}

