/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.core;

import com.android.tools.idea.streaming.core.DirectionalFlowLayout;
import com.intellij.util.ui.AbstractLayoutManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J$\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00110\u0015H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/streaming/core/DirectionalFlowLayout;", "Lcom/intellij/util/ui/AbstractLayoutManager;", "direction", "Lcom/android/tools/idea/streaming/core/DirectionalFlowLayout$Direction;", "gap", "", "<init>", "(Lcom/android/tools/idea/streaming/core/DirectionalFlowLayout$Direction;I)V", "getDirection", "()Lcom/android/tools/idea/streaming/core/DirectionalFlowLayout$Direction;", "getGap", "()I", "layoutContainer", "", "container", "Ljava/awt/Container;", "minimumLayoutSize", "Ljava/awt/Dimension;", "preferredLayoutSize", "combinedSize", "sizeProperty", "Lkotlin/Function1;", "Ljava/awt/Component;", "Direction", "intellij.android.streaming"})
public final class DirectionalFlowLayout
extends AbstractLayoutManager {
    @NotNull
    private final Direction direction;
    private final int gap;

    public DirectionalFlowLayout(@NotNull Direction direction, int gap) {
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        this.direction = direction;
        this.gap = gap;
    }

    public /* synthetic */ DirectionalFlowLayout(Direction direction, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            direction = Direction.LEFT_TO_RIGHT;
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        this(direction, n);
    }

    @NotNull
    public final Direction getDirection() {
        return this.direction;
    }

    public final int getGap() {
        return this.gap;
    }

    public void layoutContainer(@NotNull Container container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Insets insets = container.getInsets();
        switch (WhenMappings.$EnumSwitchMapping$0[this.direction.ordinal()]) {
            case 1: {
                Point offset = new Point(insets.left, insets.top);
                Component[] componentArray = container.getComponents();
                Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
                for (Component child : componentArray) {
                    child.setBounds(offset.x, offset.y, child.getPreferredSize().width, container.getHeight() - insets.top - insets.bottom);
                    offset.x += child.getPreferredSize().width + this.gap;
                }
                break;
            }
            case 2: {
                Point offset = new Point(container.getWidth() - insets.right, insets.top);
                Component[] componentArray = container.getComponents();
                Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
                for (Component child : componentArray) {
                    offset.x -= child.getPreferredSize().width;
                    child.setBounds(offset.x, offset.y, child.getPreferredSize().width, container.getHeight() - insets.top - insets.bottom);
                    offset.x -= this.gap;
                }
                break;
            }
            case 3: {
                Point offset = new Point(insets.left, insets.top);
                Component[] componentArray = container.getComponents();
                Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
                for (Component child : componentArray) {
                    child.setBounds(offset.x, offset.y, container.getWidth() - insets.left - insets.right, child.getPreferredSize().height);
                    offset.y += child.getPreferredSize().height + this.gap;
                }
                break;
            }
            case 4: {
                Point offset = new Point(insets.left, container.getHeight() - insets.bottom);
                Component[] componentArray = container.getComponents();
                Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
                for (Component child : componentArray) {
                    offset.y -= child.getPreferredSize().height;
                    child.setBounds(offset.x, offset.y, container.getWidth() - insets.left - insets.right, child.getPreferredSize().height);
                    offset.y -= this.gap;
                }
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @NotNull
    public Dimension minimumLayoutSize(@NotNull Container container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        return this.combinedSize(container, (Function1<? super Component, ? extends Dimension>)((Function1)minimumLayoutSize.1.INSTANCE));
    }

    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        return this.combinedSize(container, (Function1<? super Component, ? extends Dimension>)((Function1)preferredLayoutSize.1.INSTANCE));
    }

    private final Dimension combinedSize(Container container, Function1<? super Component, ? extends Dimension> sizeProperty) {
        Dimension result2 = new Dimension();
        Insets insets = container.getInsets();
        switch (WhenMappings.$EnumSwitchMapping$0[this.direction.ordinal()]) {
            case 1: 
            case 2: {
                Component[] componentArray = container.getComponents();
                Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
                for (Component child : componentArray) {
                    Intrinsics.checkNotNull((Object)child);
                    Dimension childSize = (Dimension)sizeProperty.invoke((Object)child);
                    result2.width += childSize.width + this.gap;
                    result2.height = RangesKt.coerceAtLeast((int)result2.height, (int)childSize.height);
                }
                if (result2.width > 0) {
                    result2.width -= this.gap;
                }
                result2.width += insets.left + insets.right;
                break;
            }
            case 3: 
            case 4: {
                Component[] componentArray = container.getComponents();
                Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
                for (Component child : componentArray) {
                    Intrinsics.checkNotNull((Object)child);
                    Dimension childSize = (Dimension)sizeProperty.invoke((Object)child);
                    result2.width = RangesKt.coerceAtLeast((int)result2.width, (int)childSize.width);
                    result2.height += childSize.height + this.gap;
                }
                if (result2.height > 0) {
                    result2.height -= this.gap;
                }
                result2.height += insets.top + insets.bottom;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return result2;
    }

    public DirectionalFlowLayout() {
        this(null, 0, 3, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/streaming/core/DirectionalFlowLayout$Direction;", "", "<init>", "(Ljava/lang/String;I)V", "LEFT_TO_RIGHT", "RIGHT_TO_LEFT", "TOP_TO_BOTTOM", "BOTTOM_TO_TOP", "intellij.android.streaming"})
    public static final class Direction
    extends Enum<Direction> {
        public static final /* enum */ Direction LEFT_TO_RIGHT = new Direction();
        public static final /* enum */ Direction RIGHT_TO_LEFT = new Direction();
        public static final /* enum */ Direction TOP_TO_BOTTOM = new Direction();
        public static final /* enum */ Direction BOTTOM_TO_TOP = new Direction();
        private static final /* synthetic */ Direction[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Direction[] values() {
            return (Direction[])$VALUES.clone();
        }

        public static Direction valueOf(String value2) {
            return Enum.valueOf(Direction.class, value2);
        }

        @NotNull
        public static EnumEntries<Direction> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = directionArray = new Direction[]{Direction.LEFT_TO_RIGHT, Direction.RIGHT_TO_LEFT, Direction.TOP_TO_BOTTOM, Direction.BOTTOM_TO_TOP};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.LEFT_TO_RIGHT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.RIGHT_TO_LEFT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.TOP_TO_BOTTOM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.BOTTOM_TO_TOP.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

