/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.core;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.streaming.core.StreamingToolWindowManagerKt;
import com.android.tools.idea.streaming.device.DeviceClient;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\b\u0001\u0018\u00002\u00020\u0001:\u0001#B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J=\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122!\u0010\u0013\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\u00070\u0014H\u0007J\u001a\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0007J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u0006H\u0007J\u001c\u0010\u001b\u001a\u00020\u00182\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00180\u0014H\u0007J\b\u0010\u001d\u001a\u00020\u001aH\u0007J\u000e\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u000bJ\u000e\u0010 \u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u000bJ\b\u0010!\u001a\u00020\u0018H\u0016J\b\u0010\"\u001a\u00020\u0018H\u0007R,\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\b8\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010\t\u001a.\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b \f*\u0015\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\u000e\u00a2\u0006\u0002\b\r0\n\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/android/tools/idea/streaming/core/DeviceClientRegistry;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "clientsBySerialNumber", "Ljava/util/LinkedHashMap;", "", "Lcom/android/tools/idea/streaming/device/DeviceClient;", "Lkotlin/collections/LinkedHashMap;", "listeners", "", "Lcom/android/tools/idea/streaming/core/DeviceClientRegistry$Listener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "getOrCreateDeviceClient", "serialNumber", "requester", "", "clientCreator", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "removeDeviceClient", "", "containsClientFor", "", "forEachClient", "consumer", "isEmpty", "addListener", "listener", "removeListener", "dispose", "clear", "Listener", "intellij.android.streaming"})
public final class DeviceClientRegistry
implements Disposable {
    @NotNull
    private final LinkedHashMap<String, DeviceClient> clientsBySerialNumber = new LinkedHashMap();
    @NotNull
    private final List<Listener> listeners;

    public DeviceClientRegistry() {
        List list2 = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"createLockFreeCopyOnWriteList(...)");
        this.listeners = list2;
    }

    @UiThread
    @NotNull
    public final DeviceClient getOrCreateDeviceClient(@NotNull String serialNumber, @Nullable Object requester, @NotNull Function1<? super String, DeviceClient> clientCreator) {
        Intrinsics.checkNotNullParameter((Object)serialNumber, (String)"serialNumber");
        Intrinsics.checkNotNullParameter(clientCreator, (String)"clientCreator");
        DeviceClient deviceClient = this.clientsBySerialNumber.computeIfAbsent(serialNumber, arg_0 -> DeviceClientRegistry.getOrCreateDeviceClient$lambda$1(arg_0 -> DeviceClientRegistry.getOrCreateDeviceClient$lambda$0(clientCreator, this, requester, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)deviceClient, (String)"computeIfAbsent(...)");
        return deviceClient;
    }

    @UiThread
    public final void removeDeviceClient(@NotNull String serialNumber, @Nullable Object requester) {
        block3: {
            DeviceClient deviceClient;
            Intrinsics.checkNotNullParameter((Object)serialNumber, (String)"serialNumber");
            DeviceClient deviceClient2 = (DeviceClient)this.clientsBySerialNumber.remove(serialNumber);
            if (deviceClient2 == null) break block3;
            DeviceClient client = deviceClient = deviceClient2;
            boolean bl = false;
            for (Listener listener2 : this.listeners) {
                try {
                    listener2.deviceClientRemoved(client, requester);
                }
                catch (Exception e) {
                    StreamingToolWindowManagerKt.access$getLogger$p().error((Throwable)e);
                }
            }
            Disposer.dispose((Disposable)client);
        }
    }

    @UiThread
    public final boolean containsClientFor(@NotNull String serialNumber) {
        Intrinsics.checkNotNullParameter((Object)serialNumber, (String)"serialNumber");
        return this.clientsBySerialNumber.containsKey(serialNumber);
    }

    @UiThread
    public final void forEachClient(@NotNull Function1<? super DeviceClient, Unit> consumer2) {
        Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
        Iterator<DeviceClient> iterator2 = this.clientsBySerialNumber.values().iterator();
        while (iterator2.hasNext()) {
            DeviceClient client;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            consumer2.invoke((Object)client);
        }
    }

    @UiThread
    public final boolean isEmpty() {
        return this.clientsBySerialNumber.isEmpty();
    }

    public final void addListener(@NotNull Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    public final void removeListener(@NotNull Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.remove(listener2);
    }

    public void dispose() {
    }

    @UiThread
    @TestOnly
    public final void clear() {
        Set<String> set2 = this.clientsBySerialNumber.keySet();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"<get-keys>(...)");
        for (String serialNumber : CollectionsKt.toList((Iterable)set2)) {
            this.removeDeviceClient(serialNumber, null);
        }
    }

    private static final DeviceClient getOrCreateDeviceClient$lambda$0(Function1 $clientCreator, DeviceClientRegistry this$0, Object $requester, String serial) {
        Intrinsics.checkNotNullParameter((Object)serial, (String)"serial");
        Object object = $clientCreator.invoke((Object)serial);
        DeviceClient client = (DeviceClient)object;
        boolean bl = false;
        Disposer.register((Disposable)this$0, (Disposable)client);
        for (Listener listener2 : this$0.listeners) {
            try {
                Intrinsics.checkNotNull((Object)client);
                listener2.deviceClientAdded(client, $requester);
            }
            catch (Exception e) {
                StreamingToolWindowManagerKt.access$getLogger$p().error((Throwable)e);
            }
        }
        return (DeviceClient)object;
    }

    private static final DeviceClient getOrCreateDeviceClient$lambda$1(Function1 $tmp0, Object p0) {
        return (DeviceClient)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001H'J\u001a\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001H'\u00a8\u0006\b\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/streaming/core/DeviceClientRegistry$Listener;", "", "deviceClientAdded", "", "client", "Lcom/android/tools/idea/streaming/device/DeviceClient;", "requester", "deviceClientRemoved", "intellij.android.streaming"})
    public static interface Listener {
        @UiThread
        public void deviceClientAdded(@NotNull DeviceClient var1, @Nullable Object var2);

        @UiThread
        public void deviceClientRemoved(@NotNull DeviceClient var1, @Nullable Object var2);
    }
}

