/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.benchmark;

import com.android.tools.adtui.util.AwtUtilsKt;
import com.android.tools.idea.concurrency.CoroutineUtilsKt;
import com.android.tools.idea.streaming.benchmark.Benchmarker;
import com.android.tools.idea.streaming.benchmark.DeviceAdapter;
import com.android.tools.idea.streaming.benchmark.DeviceAdapterKt;
import com.android.tools.idea.streaming.benchmark.StreamingBenchmarkTarget;
import com.android.tools.idea.streaming.benchmark.StreamingBenchmarkerAppInstaller;
import com.android.tools.idea.streaming.core.AbstractDisplayView;
import com.android.tools.idea.streaming.core.StreamingUtilsKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.IntRange;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlin.time.TimeMark;
import kotlin.time.TimeSource;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelIterator;
import kotlinx.coroutines.channels.ChannelKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001jBs\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\t\u0012\b\b\u0002\u0010\f\u001a\u00020\t\u0012\b\b\u0002\u0010\r\u001a\u00020\t\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017J/\u0010=\u001a\u00020$2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020(2\u0006\u0010A\u001a\u00020\t2\u0006\u0010B\u001a\u00020CH\u0016\u00a2\u0006\u0004\bD\u0010EJ\u0016\u0010F\u001a\u00020$2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00020+H\u0016J\u000e\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00020/H\u0016J\b\u0010I\u001a\u00020\tH\u0016J\u0010\u0010J\u001a\u00020$2\u0006\u0010K\u001a\u00020\u0002H\u0016J\b\u0010L\u001a\u00020$H\u0016J\b\u0010M\u001a\u00020$H\u0016J\b\u0010N\u001a\u00020$H\u0016J\b\u0010O\u001a\u00020$H\u0016J\b\u0010P\u001a\u00020$H\u0002J\u0014\u0010Q\u001a\u00020$*\u00020R2\u0006\u0010S\u001a\u00020\tH\u0002J\u0014\u0010T\u001a\u00020$*\u00020R2\u0006\u0010U\u001a\u00020VH\u0002J$\u0010W\u001a\u00020$*\u00020R2\u0006\u0010S\u001a\u00020\t2\u0006\u0010U\u001a\u00020V2\u0006\u0010X\u001a\u00020\tH\u0002J\u0014\u0010Y\u001a\u00020$*\u00020R2\u0006\u0010Z\u001a\u00020\tH\u0002J\u0010\u0010[\u001a\u00020$2\u0006\u0010B\u001a\u00020CH\u0002J\u001a\u0010\\\u001a\u0010\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020(\u0018\u00010]*\u00020CH\u0002J\f\u0010^\u001a\u00020\u0002*\u00020CH\u0002J,\u0010_\u001a\u00020\t*\u00020C2\u0006\u0010`\u001a\u00020\t2\u0006\u0010a\u001a\u00020b2\u0006\u0010c\u001a\u00020\t2\u0006\u0010d\u001a\u00020\tH\u0002J\f\u0010e\u001a\u00020f*\u00020gH\u0002J\f\u0010h\u001a\u00020\t*\u00020CH\u0002J\u000e\u0010i\u001a\u0004\u0018\u00010\u0002*\u00020\u0002H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0018\u001a\u00020\u00198BX\u0082\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\u001d*\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001e\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0#0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020(X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00020+X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082.\u00a2\u0006\u0002\n\u0000R!\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00020/8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b2\u00103\u001a\u0004\b0\u00101R\u001b\u00104\u001a\u00020\u00028BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b7\u00103\u001a\u0004\b5\u00106R\u001b\u00108\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b;\u00103\u001a\u0004\b9\u0010:R\u0010\u0010<\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006k"}, d2={"Lcom/android/tools/idea/streaming/benchmark/DeviceAdapter;", "Lcom/android/tools/idea/streaming/benchmark/Benchmarker$Adapter;", "Ljava/awt/Point;", "Lcom/android/tools/idea/streaming/core/AbstractDisplayView$FrameListener;", "project", "Lcom/intellij/openapi/project/Project;", "target", "Lcom/android/tools/idea/streaming/benchmark/StreamingBenchmarkTarget;", "bitsPerChannel", "", "latencyBits", "maxTouches", "step", "spikiness", "readyIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "timeSource", "Lkotlin/time/TimeSource;", "installer", "Lcom/android/tools/idea/streaming/benchmark/StreamingBenchmarkerAppInstaller;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/streaming/benchmark/StreamingBenchmarkTarget;IIIIILcom/intellij/openapi/progress/ProgressIndicator;Lkotlin/time/TimeSource;Lcom/android/tools/idea/streaming/benchmark/StreamingBenchmarkerAppInstaller;Lkotlinx/coroutines/CoroutineScope;)V", "deviceDisplaySize", "Ljava/awt/Dimension;", "getDeviceDisplaySize$delegate", "(Lcom/android/tools/idea/streaming/benchmark/DeviceAdapter;)Ljava/lang/Object;", "getDeviceDisplaySize", "()Ljava/awt/Dimension;", "maxBits", "numRegionsPerCoordinate", "numLatencyRegions", "keyEventDispatchChannel", "Lkotlinx/coroutines/channels/Channel;", "Lkotlin/Function0;", "", "appState", "Lcom/android/tools/idea/streaming/benchmark/DeviceAdapter$AppState;", "touchableArea", "Ljava/awt/Rectangle;", "touchableImageArea", "adapterCallbacks", "Lcom/android/tools/idea/streaming/benchmark/Benchmarker$Adapter$Callbacks;", "startedGettingReady", "Lkotlin/time/TimeMark;", "pointsToTouch", "", "getPointsToTouch", "()Ljava/util/Iterator;", "pointsToTouch$delegate", "Lkotlin/Lazy;", "startPoint", "getStartPoint", "()Ljava/awt/Point;", "startPoint$delegate", "numPointsToTouch", "getNumPointsToTouch", "()I", "numPointsToTouch$delegate", "lastPressed", "frameRendered", "frameNumber", "Lkotlin/UInt;", "displayRectangle", "displayOrientationQuadrants", "displayImage", "Ljava/awt/image/BufferedImage;", "frameRendered-SGjrQA4", "(ILjava/awt/Rectangle;ILjava/awt/image/BufferedImage;)V", "setCallbacks", "callbacks", "inputs", "numInputs", "dispatch", "input", "ready", "prepareForInputs", "finalizeInputs", "cleanUp", "keyConfigIntoApp", "press", "Lcom/android/tools/idea/streaming/core/AbstractDisplayView;", "keyCode", "type", "keyChar", "", "keyInput", "id", "typeNumber", "n", "processFrame", "findTouchableAreas", "Lkotlin/Pair;", "decodeToPoint", "readIntegerEncodedAt", "sampleX", "yRange", "Lkotlin/ranges/IntRange;", "numRegions", "totalBits", "decodeToBinaryString", "", "Ljava/awt/Color;", "decodeLatency", "toDisplayViewCoordinates", "AppState", "intellij.android.streaming"})
@SourceDebugExtension(value={"SMAP\nDeviceAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceAdapter.kt\ncom/android/tools/idea/streaming/benchmark/DeviceAdapter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,528:1\n1#2:529\n1179#3,2:530\n1563#4:532\n1634#4,3:533\n1563#4:536\n1634#4,3:537\n1869#4,2:540\n*S KotlinDebug\n*F\n+ 1 DeviceAdapter.kt\ncom/android/tools/idea/streaming/benchmark/DeviceAdapter\n*L\n398#1:530,2\n417#1:532\n417#1:533,3\n419#1:536\n419#1:537,3\n421#1:540,2\n*E\n"})
public final class DeviceAdapter
implements Benchmarker.Adapter<Point>,
AbstractDisplayView.FrameListener {
    @NotNull
    private final Project project;
    @NotNull
    private final StreamingBenchmarkTarget target;
    private final int bitsPerChannel;
    private final int latencyBits;
    private final int maxTouches;
    private final int step;
    private final int spikiness;
    @Nullable
    private final ProgressIndicator readyIndicator;
    @NotNull
    private final TimeSource timeSource;
    @NotNull
    private final StreamingBenchmarkerAppInstaller installer;
    @NotNull
    private final CoroutineScope coroutineScope;
    private final int maxBits;
    private final int numRegionsPerCoordinate;
    private final int numLatencyRegions;
    @NotNull
    private final Channel<Function0<Unit>> keyEventDispatchChannel;
    @NotNull
    private AppState appState;
    private volatile Rectangle touchableArea;
    private volatile Rectangle touchableImageArea;
    private volatile Benchmarker.Adapter.Callbacks<Point> adapterCallbacks;
    private volatile TimeMark startedGettingReady;
    @NotNull
    private final Lazy pointsToTouch$delegate;
    @NotNull
    private final Lazy startPoint$delegate;
    @NotNull
    private final Lazy numPointsToTouch$delegate;
    @Nullable
    private Point lastPressed;

    public DeviceAdapter(@NotNull Project project, @NotNull StreamingBenchmarkTarget target2, int bitsPerChannel, int latencyBits, int maxTouches, int step2, int spikiness, @Nullable ProgressIndicator readyIndicator2, @NotNull TimeSource timeSource, @NotNull StreamingBenchmarkerAppInstaller installer, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Intrinsics.checkNotNullParameter((Object)timeSource, (String)"timeSource");
        Intrinsics.checkNotNullParameter((Object)installer, (String)"installer");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.target = target2;
        this.bitsPerChannel = bitsPerChannel;
        this.latencyBits = latencyBits;
        this.maxTouches = maxTouches;
        this.step = step2;
        this.spikiness = spikiness;
        this.readyIndicator = readyIndicator2;
        this.timeSource = timeSource;
        this.installer = installer;
        this.coroutineScope = coroutineScope;
        this.target.getView();
        this.maxBits = MathKt.roundToInt((double)Math.ceil(MathKt.log2((double)Math.max(this.getDeviceDisplaySize().width, this.getDeviceDisplaySize().height))));
        this.numRegionsPerCoordinate = this.bitsPerChannel == 0 ? this.maxBits : (this.maxBits - 1) / (this.bitsPerChannel * 3) + 1;
        this.numLatencyRegions = this.bitsPerChannel == 0 ? this.latencyBits : (this.latencyBits - 1) / (this.bitsPerChannel * 3) + 1;
        this.keyEventDispatchChannel = ChannelKt.Channel$default((int)Integer.MAX_VALUE, null, null, (int)6, null);
        this.appState = AppState.INITIALIZING;
        this.pointsToTouch$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, () -> DeviceAdapter.pointsToTouch_delegate$lambda$0(this));
        this.startPoint$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, () -> DeviceAdapter.startPoint_delegate$lambda$0(this));
        this.numPointsToTouch$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, () -> DeviceAdapter.numPointsToTouch_delegate$lambda$0(this));
        if (!(this.maxTouches > 0)) {
            boolean $i$a$-require-DeviceAdapter$52 = false;
            String $i$a$-require-DeviceAdapter$52 = "Must specify a positive value for maxTouches";
            throw new IllegalArgumentException($i$a$-require-DeviceAdapter$52.toString());
        }
        if (!(this.step > 0)) {
            boolean $i$a$-require-DeviceAdapter$62 = false;
            String $i$a$-require-DeviceAdapter$62 = "Must specify a positive value for step";
            throw new IllegalArgumentException($i$a$-require-DeviceAdapter$62.toString());
        }
        if (!(this.spikiness >= 0)) {
            boolean $i$a$-require-DeviceAdapter$72 = false;
            String $i$a$-require-DeviceAdapter$72 = "Must specify a non-negative value for spikiness";
            throw new IllegalArgumentException($i$a$-require-DeviceAdapter$72.toString());
        }
        int n = this.bitsPerChannel;
        if (!(0 <= n ? n < 9 : false)) {
            boolean bl = false;
            String string = "Cannot extract " + this.bitsPerChannel + " bits from a channel. Must be in [0,8]";
            throw new IllegalArgumentException(string.toString());
        }
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            int label;
            final /* synthetic */ DeviceAdapter this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var2_3 = DeviceAdapter.access$getKeyEventDispatchChannel$p(this.this$0).iterator();
lbl6:
                        // 2 sources

                        while (true) {
                            this.L$0 = var2_3;
                            this.label = 1;
                            v0 = var2_3.hasNext((Continuation)this);
                            if (v0 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl17
                            break;
                        }
                    }
                    case 1: {
                        var2_3 = (ChannelIterator)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl17:
                        // 2 sources

                        if (!((Boolean)v0).booleanValue()) break;
                        keyEventDispatch = (Function0)var2_3.next();
                        v1 = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
                        v2 = ModalityState.any();
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"any(...)");
                        this.L$0 = var2_3;
                        this.label = 2;
                        v3 = BuildersKt.withContext((CoroutineContext)v1.plus(ModalityKt.asContextElement((ModalityState)v2)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Function0<Unit>)keyEventDispatch, null){
                            int label;
                            final /* synthetic */ Function0<Unit> $keyEventDispatch;
                            {
                                this.$keyEventDispatch = $keyEventDispatch;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.$keyEventDispatch.invoke();
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v3 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl32
                    }
                    case 2: {
                        var2_3 = (ChannelIterator)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl32:
                        // 2 sources

                        this.L$0 = var2_3;
                        this.label = 3;
                        v4 = DelayKt.delay-VtjQ1oo((long)DeviceAdapterKt.access$getKEY_EVENT_DELAY$p(), (Continuation)((Continuation)this));
                        if (v4 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl42
                    }
                    case 3: {
                        var2_3 = (ChannelIterator)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
lbl42:
                        // 2 sources

                        ** continue;
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public /* synthetic */ DeviceAdapter(Project project, StreamingBenchmarkTarget streamingBenchmarkTarget, int n, int n2, int n3, int n4, int n5, ProgressIndicator progressIndicator, TimeSource timeSource, StreamingBenchmarkerAppInstaller streamingBenchmarkerAppInstaller, CoroutineScope coroutineScope, int n6, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n6 & 4) != 0) {
            n = 0;
        }
        if ((n6 & 8) != 0) {
            n2 = 6;
        }
        if ((n6 & 0x10) != 0) {
            n3 = 10000;
        }
        if ((n6 & 0x20) != 0) {
            n4 = 1;
        }
        if ((n6 & 0x40) != 0) {
            n5 = 1;
        }
        if ((n6 & 0x80) != 0) {
            progressIndicator = null;
        }
        if ((n6 & 0x100) != 0) {
            timeSource = (TimeSource)TimeSource.Monotonic.INSTANCE;
        }
        if ((n6 & 0x200) != 0) {
            streamingBenchmarkerAppInstaller = StreamingBenchmarkerAppInstaller.Companion.invoke$default(StreamingBenchmarkerAppInstaller.Companion, project, streamingBenchmarkTarget.getSerialNumber(), null, 4, null);
        }
        if ((n6 & 0x400) != 0) {
            coroutineScope = CoroutineUtilsKt.createCoroutineScope$default((Disposable)streamingBenchmarkTarget.getView(), null, null, (int)3, null);
        }
        this(project, streamingBenchmarkTarget, n, n2, n3, n4, n5, progressIndicator, timeSource, streamingBenchmarkerAppInstaller, coroutineScope);
    }

    private final Dimension getDeviceDisplaySize() {
        return this.target.getView().getDeviceDisplaySize$intellij_android_streaming();
    }

    private static Object getDeviceDisplaySize$delegate(DeviceAdapter deviceAdapter) {
        return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl((Object)deviceAdapter.target.getView(), AbstractDisplayView.class, "deviceDisplaySize", "getDeviceDisplaySize$intellij_android_streaming()Ljava/awt/Dimension;", 0)));
    }

    private final Iterator<Point> getPointsToTouch() {
        Lazy lazy = this.pointsToTouch$delegate;
        return (Iterator)lazy.getValue();
    }

    private final Point getStartPoint() {
        Lazy lazy = this.startPoint$delegate;
        return (Point)lazy.getValue();
    }

    private final int getNumPointsToTouch() {
        Lazy lazy = this.numPointsToTouch$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    @Override
    public synchronized void frameRendered-SGjrQA4(int n, @NotNull Rectangle displayRectangle, int displayOrientationQuadrants, @NotNull BufferedImage displayImage) {
        Intrinsics.checkNotNullParameter((Object)displayRectangle, (String)"displayRectangle");
        Intrinsics.checkNotNullParameter((Object)displayImage, (String)"displayImage");
        switch (WhenMappings.$EnumSwitchMapping$0[this.appState.ordinal()]) {
            case 1: {
                TimeMark timeMark = this.startedGettingReady;
                if (timeMark == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"startedGettingReady");
                    timeMark = null;
                }
                if (Duration.compareTo-LRDsOJo((long)timeMark.elapsedNow-UwyO8pc(), (long)DeviceAdapterKt.access$getMAX_BECOME_READY_DURATION$p()) > 0) {
                    Benchmarker.Adapter.Callbacks<Point> callbacks2 = this.adapterCallbacks;
                    if (callbacks2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"adapterCallbacks");
                        callbacks2 = null;
                    }
                    callbacks2.onFailedToBecomeReady("Failed to detect initialized app within " + Duration.toString-impl((long)DeviceAdapterKt.access$getMAX_BECOME_READY_DURATION$p()));
                    return;
                }
                if (!DeviceAdapterKt.access$isInitializationFrame(displayImage)) break;
                this.keyConfigIntoApp();
                this.appState = AppState.KEYING_IN_CONFIG;
                break;
            }
            case 2: {
                if (!this.keyEventDispatchChannel.isEmpty()) break;
                this.appState = AppState.DISPLAYING_TOUCHABLE_AREA;
                break;
            }
            case 3: {
                Benchmarker.Adapter.Callbacks<Point> callbacks3;
                if (DeviceAdapterKt.access$isInitializationFrame(displayImage)) {
                    return;
                }
                TimeMark timeMark = this.startedGettingReady;
                if (timeMark == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"startedGettingReady");
                    timeMark = null;
                }
                if (Duration.compareTo-LRDsOJo((long)timeMark.elapsedNow-UwyO8pc(), (long)DeviceAdapterKt.access$getMAX_BECOME_READY_DURATION$p()) > 0) {
                    Benchmarker.Adapter.Callbacks<Point> callbacks4 = this.adapterCallbacks;
                    if (callbacks4 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"adapterCallbacks");
                        callbacks4 = null;
                    }
                    callbacks4.onFailedToBecomeReady("Failed to find touchable area within " + Duration.toString-impl((long)DeviceAdapterKt.access$getMAX_BECOME_READY_DURATION$p()));
                    return;
                }
                Pair<Rectangle, Rectangle> pair = this.findTouchableAreas(displayImage);
                if (pair == null) break;
                Pair<Rectangle, Rectangle> it = pair;
                boolean bl = false;
                this.touchableImageArea = (Rectangle)it.getFirst();
                this.touchableArea = (Rectangle)it.getSecond();
                this.appState = AppState.READY;
                ProgressIndicator progressIndicator = this.readyIndicator;
                if (progressIndicator != null) {
                    ProgressIndicator progressIndicator2;
                    ProgressIndicator $this$frameRendered_SGjrQA4_u24lambda_u240_u240 = progressIndicator2 = progressIndicator;
                    boolean bl2 = false;
                    $this$frameRendered_SGjrQA4_u24lambda_u240_u240.setIndeterminate(false);
                    $this$frameRendered_SGjrQA4_u24lambda_u240_u240.setFraction(1.0);
                }
                if ((callbacks3 = this.adapterCallbacks) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"adapterCallbacks");
                    callbacks3 = null;
                }
                callbacks3.onReady();
                break;
            }
            case 4: {
                this.processFrame(displayImage);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Override
    public void setCallbacks(@NotNull Benchmarker.Adapter.Callbacks<Point> callbacks2) {
        Intrinsics.checkNotNullParameter(callbacks2, (String)"callbacks");
        this.adapterCallbacks = callbacks2;
    }

    @Override
    @NotNull
    public Iterator<Point> inputs() {
        return this.getPointsToTouch();
    }

    @Override
    public int numInputs() {
        return this.getNumPointsToTouch();
    }

    @Override
    public void dispatch(@NotNull Point input2) {
        Intrinsics.checkNotNullParameter((Object)input2, (String)"input");
        this.lastPressed = input2;
        DeviceAdapterKt.dispatchMouseEvent$default(this.target.getView(), input2, 0, 2, null);
    }

    @Override
    public void ready() {
        ProgressIndicator progressIndicator = this.readyIndicator;
        if (progressIndicator != null) {
            progressIndicator.setIndeterminate(true);
        }
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DeviceAdapter this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = DeviceAdapter.access$getInstaller$p(this.this$0).installBenchmarkingApp(DeviceAdapter.access$getReadyIndicator$p(this.this$0), (Continuation<? super Boolean>)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if (!((Boolean)v0).booleanValue()) {
                            v1 = DeviceAdapter.access$getAdapterCallbacks$p(this.this$0);
                            if (v1 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"adapterCallbacks");
                                v1 = null;
                            }
                            v1.onFailedToBecomeReady("Could not install benchmarking app.");
                            return Unit.INSTANCE;
                        }
                        this.label = 2;
                        v2 = DeviceAdapter.access$getInstaller$p(this.this$0).launchBenchmarkingApp(DeviceAdapter.access$getReadyIndicator$p(this.this$0), (Continuation<? super Boolean>)((Continuation)this));
                        if (v2 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl28
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl28:
                        // 2 sources

                        if (!((Boolean)v2).booleanValue()) {
                            v3 = DeviceAdapter.access$getAdapterCallbacks$p(this.this$0);
                            if (v3 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"adapterCallbacks");
                                v3 = null;
                            }
                            v3.onFailedToBecomeReady("Could not launch benchmarking app.");
                            return Unit.INSTANCE;
                        }
                        DeviceAdapter.access$setStartedGettingReady$p(this.this$0, DeviceAdapter.access$getTimeSource$p(this.this$0).markNow());
                        DeviceAdapter.access$getTarget$p(this.this$0).getView().addFrameListener$intellij_android_streaming(this.this$0);
                        DeviceAdapter.access$getTarget$p(this.this$0).getView().repaint();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    public void prepareForInputs() {
        Point startPoint;
        this.lastPressed = startPoint = this.getPointsToTouch().next();
        DeviceAdapterKt.access$dispatchMouseEvent(this.target.getView(), startPoint, 501);
    }

    @Override
    public void finalizeInputs() {
        block0: {
            Point point = this.lastPressed;
            if (point == null) break block0;
            Point it = point;
            boolean bl = false;
            DeviceAdapterKt.access$dispatchMouseEvent(this.target.getView(), it, 502);
        }
    }

    @Override
    public void cleanUp() {
        this.target.getView().removeFrameListener$intellij_android_streaming(this);
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DeviceAdapter this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = DeviceAdapter.access$getInstaller$p(this.this$0).uninstallBenchmarkingApp((Continuation<? super Boolean>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final synchronized void keyConfigIntoApp() {
        AbstractDisplayView $this$keyConfigIntoApp_u24lambda_u240 = this.target.getView();
        boolean bl = false;
        this.press($this$keyConfigIntoApp_u24lambda_u240, 38);
        this.typeNumber($this$keyConfigIntoApp_u24lambda_u240, this.maxBits);
        this.type($this$keyConfigIntoApp_u24lambda_u240, ',');
        this.typeNumber($this$keyConfigIntoApp_u24lambda_u240, this.latencyBits);
        this.type($this$keyConfigIntoApp_u24lambda_u240, ',');
        this.typeNumber($this$keyConfigIntoApp_u24lambda_u240, this.bitsPerChannel);
        this.press($this$keyConfigIntoApp_u24lambda_u240, 10);
    }

    private final void press(AbstractDisplayView $this$press, int keyCode) {
        this.keyInput($this$press, keyCode, '\uffff', 401);
        this.keyInput($this$press, keyCode, '\uffff', 402);
    }

    private final void type(AbstractDisplayView $this$type, char keyChar) {
        this.keyInput($this$type, 0, keyChar, 400);
    }

    private final void keyInput(AbstractDisplayView $this$keyInput, int keyCode, char keyChar, int id2) {
        KeyEvent event = new KeyEvent((Component)((Object)$this$keyInput), id2, System.currentTimeMillis(), 0, keyCode, keyChar);
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, event, $this$keyInput, null){
            int label;
            final /* synthetic */ DeviceAdapter this$0;
            final /* synthetic */ KeyEvent $event;
            final /* synthetic */ AbstractDisplayView $this_keyInput;
            {
                this.this$0 = $receiver;
                this.$event = $event;
                this.$this_keyInput = $receiver2;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Function0 keyEventDispatch = () -> keyInput.1.invokeSuspend$lambda$0(this.$event, this.$this_keyInput);
                        this.label = 1;
                        Object object3 = DeviceAdapter.access$getKeyEventDispatchChannel$p(this.this$0).send((Object)keyEventDispatch, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(KeyEvent $event, AbstractDisplayView $this_keyInput) {
                DeviceAdapterKt.access$getLOG$p().info("Dispatching event: " + $event);
                $this_keyInput.dispatchEvent($event);
                return Unit.INSTANCE;
            }
        }), (int)1, null);
    }

    private final void typeNumber(AbstractDisplayView $this$typeNumber, int n) {
        CharSequence $this$forEach$iv = String.valueOf(n);
        boolean $i$f$forEach = false;
        for (int i = 0; i < $this$forEach$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$forEach$iv.charAt(i);
            boolean bl = false;
            this.type($this$typeNumber, it);
        }
    }

    private final synchronized void processFrame(BufferedImage displayImage) {
        TimeMark frameArrived = this.timeSource.markNow();
        Point point = this.toDisplayViewCoordinates(this.decodeToPoint(displayImage));
        if (point == null) {
            return;
        }
        Point point2 = point;
        long frameLatency = DurationKt.toDuration((int)this.decodeLatency(displayImage), (DurationUnit)DurationUnit.MILLISECONDS);
        Benchmarker.Adapter.Callbacks<Point> callbacks2 = this.adapterCallbacks;
        if (callbacks2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapterCallbacks");
            callbacks2 = null;
        }
        callbacks2.inputReturned(point2, frameArrived.minus-LRDsOJo(frameLatency));
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<Rectangle, Rectangle> findTouchableAreas(BufferedImage $this$findTouchableAreas) {
        void $this$forEach$iv;
        Point it;
        Collection collection2;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Rectangle rectangle = DeviceAdapterKt.access$findTouchableArea($this$findTouchableAreas);
        if (rectangle == null) {
            return null;
        }
        Rectangle imageRectangle = rectangle;
        Rectangle displayViewRectangle = new Rectangle(0, 0, -1, -1);
        Object object = new Point[]{imageRectangle.getLocation(), new Point(StreamingUtilsKt.getRight(imageRectangle), StreamingUtilsKt.getBottom(imageRectangle))};
        object = CollectionsKt.listOf((Object[])object);
        boolean $i$f$map = false;
        Iterator iterator2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Point point = (Point)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection2.add(StreamingUtilsKt.scaledUnbiased(it, new Dimension($this$findTouchableAreas.getWidth(), $this$findTouchableAreas.getHeight()), this.target.getView().getDeviceDisplaySize$intellij_android_streaming()));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Point)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            Point point = this.toDisplayViewCoordinates(it);
            if (point == null) {
                return null;
            }
            collection2.add(point);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Point p0 = (Point)element$iv;
            boolean bl = false;
            displayViewRectangle.add(p0);
        }
        DeviceAdapterKt.access$getLOG$p().info("Found touchable area in image: " + imageRectangle + ". Converted to AbstractDisplayView coordinates: " + displayViewRectangle);
        return TuplesKt.to((Object)imageRectangle, (Object)displayViewRectangle);
    }

    private final Point decodeToPoint(BufferedImage $this$decodeToPoint) {
        Rectangle rectangle = this.touchableImageArea;
        if (rectangle == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"touchableImageArea");
            rectangle = null;
        }
        IntRange yRange = DeviceAdapterKt.access$integerEncodingYRange(rectangle);
        Rectangle rectangle2 = this.touchableImageArea;
        if (rectangle2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"touchableImageArea");
            rectangle2 = null;
        }
        int x = this.readIntegerEncodedAt($this$decodeToPoint, DeviceAdapterKt.access$integer1EncodingX(rectangle2), yRange, this.numRegionsPerCoordinate, this.maxBits);
        Rectangle rectangle3 = this.touchableImageArea;
        if (rectangle3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"touchableImageArea");
            rectangle3 = null;
        }
        int y = this.readIntegerEncodedAt($this$decodeToPoint, DeviceAdapterKt.access$integer2EncodingX(rectangle3), yRange, this.numRegionsPerCoordinate, this.maxBits);
        return new Point(x, y);
    }

    private final int readIntegerEncodedAt(BufferedImage $this$readIntegerEncodedAt, int sampleX, IntRange yRange, int numRegions, int totalBits) {
        return Integer.parseInt(StringsKt.take((String)CollectionsKt.joinToString$default((Iterable)DeviceAdapterKt.access$sampleValues(yRange, numRegions), (CharSequence)"", null, null, (int)0, null, arg_0 -> DeviceAdapter.readIntegerEncodedAt$lambda$0(this, $this$readIntegerEncodedAt, sampleX, arg_0), (int)30, null), (int)totalBits), CharsKt.checkRadix((int)2));
    }

    private final String decodeToBinaryString(Color $this$decodeToBinaryString) {
        return switch (this.bitsPerChannel) {
            case 0 -> {
                if ($this$decodeToBinaryString.getRed() + $this$decodeToBinaryString.getGreen() + $this$decodeToBinaryString.getBlue() > 382) {
                    yield "1";
                }
                yield "0";
            }
            case 1 -> CollectionsKt.joinToString$default((Iterable)DeviceAdapterKt.access$channels($this$decodeToBinaryString), (CharSequence)"", null, null, (int)0, null, DeviceAdapter::decodeToBinaryString$lambda$0, (int)30, null);
            default -> CollectionsKt.joinToString$default((Iterable)DeviceAdapterKt.access$channels($this$decodeToBinaryString), (CharSequence)"", null, null, (int)0, null, arg_0 -> DeviceAdapter.decodeToBinaryString$lambda$1(this, arg_0), (int)30, null);
        };
    }

    private final int decodeLatency(BufferedImage $this$decodeLatency) {
        Rectangle rectangle = this.touchableImageArea;
        if (rectangle == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"touchableImageArea");
            rectangle = null;
        }
        IntRange latencyYRange = DeviceAdapterKt.access$latencyEncodingYRange(rectangle);
        Rectangle rectangle2 = this.touchableImageArea;
        if (rectangle2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"touchableImageArea");
            rectangle2 = null;
        }
        return this.readIntegerEncodedAt($this$decodeLatency, DeviceAdapterKt.access$latencyEncodingX(rectangle2), latencyYRange, this.numLatencyRegions, this.latencyBits);
    }

    private final Point toDisplayViewCoordinates(Point $this$toDisplayViewCoordinates) {
        Rectangle rectangle = this.target.getView().getDisplayRectangle();
        if (rectangle == null) {
            return null;
        }
        Rectangle displayRectangle = rectangle;
        Dimension dimension2 = displayRectangle.getSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"getSize(...)");
        Dimension imageSize = AwtUtilsKt.rotatedByQuadrants((Dimension)dimension2, (int)this.target.getView().getDisplayOrientationQuadrants());
        Point p2 = StreamingUtilsKt.scaledUnbiased($this$toDisplayViewCoordinates, this.getDeviceDisplaySize(), imageSize);
        double inverseScreenScale = 1.0 / this.target.getView().getScreenScalingFactor();
        Point viewCoordinates = new Point();
        switch (this.target.getView().getDisplayOrientationQuadrants()) {
            case 0: {
                viewCoordinates.x = AwtUtilsKt.scaled((int)(p2.x + displayRectangle.x), (double)inverseScreenScale);
                viewCoordinates.y = AwtUtilsKt.scaled((int)(p2.y + displayRectangle.y), (double)inverseScreenScale);
                break;
            }
            case 3: {
                viewCoordinates.x = AwtUtilsKt.scaled((int)(StreamingUtilsKt.getBottom(displayRectangle) - p2.y), (double)inverseScreenScale);
                viewCoordinates.y = AwtUtilsKt.scaled((int)(p2.x + displayRectangle.x), (double)inverseScreenScale);
                break;
            }
            case 2: {
                viewCoordinates.x = AwtUtilsKt.scaled((int)(StreamingUtilsKt.getRight(displayRectangle) - p2.x), (double)inverseScreenScale);
                viewCoordinates.y = AwtUtilsKt.scaled((int)(StreamingUtilsKt.getBottom(displayRectangle) - p2.y), (double)inverseScreenScale);
                break;
            }
            default: {
                viewCoordinates.x = AwtUtilsKt.scaled((int)(p2.y + displayRectangle.y), (double)inverseScreenScale);
                viewCoordinates.y = AwtUtilsKt.scaled((int)(StreamingUtilsKt.getRight(displayRectangle) - p2.x), (double)inverseScreenScale);
            }
        }
        return viewCoordinates;
    }

    private static final Iterator pointsToTouch_delegate$lambda$0(DeviceAdapter this$0) {
        Rectangle rectangle = this$0.touchableArea;
        if (rectangle == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"touchableArea");
            rectangle = null;
        }
        return DeviceAdapterKt.access$scribble(rectangle, this$0.maxTouches + 1, this$0.step, this$0.spikiness).iterator();
    }

    private static final Point startPoint_delegate$lambda$0(DeviceAdapter this$0) {
        return this$0.getPointsToTouch().next();
    }

    private static final int numPointsToTouch_delegate$lambda$0(DeviceAdapter this$0) {
        Rectangle rectangle = this$0.touchableArea;
        if (rectangle == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"touchableArea");
            rectangle = null;
        }
        int n = rectangle.width;
        Rectangle rectangle2 = this$0.touchableArea;
        if (rectangle2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"touchableArea");
            rectangle2 = null;
        }
        int n2 = n * rectangle2.height;
        int n3 = this$0.maxTouches;
        return Math.min(n2, n3);
    }

    private static final CharSequence readIntegerEncodedAt$lambda$0(DeviceAdapter this$0, BufferedImage $this_readIntegerEncodedAt, int $sampleX, int it) {
        return this$0.decodeToBinaryString(DeviceAdapterKt.access$extract($this_readIntegerEncodedAt, $sampleX, it));
    }

    private static final CharSequence decodeToBinaryString$lambda$0(int it) {
        return it > 127 ? (CharSequence)"1" : (CharSequence)"0";
    }

    private static final CharSequence decodeToBinaryString$lambda$1(DeviceAdapter this$0, int channel) {
        String string = Integer.toString(MathKt.roundToInt((double)((double)channel * (double)((1 << this$0.bitsPerChannel) - 1) / (double)255)), CharsKt.checkRadix((int)2));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return StringsKt.padStart((String)string, (int)this$0.bitsPerChannel, (char)'0');
    }

    public static final /* synthetic */ StreamingBenchmarkerAppInstaller access$getInstaller$p(DeviceAdapter $this) {
        return $this.installer;
    }

    public static final /* synthetic */ ProgressIndicator access$getReadyIndicator$p(DeviceAdapter $this) {
        return $this.readyIndicator;
    }

    public static final /* synthetic */ Benchmarker.Adapter.Callbacks access$getAdapterCallbacks$p(DeviceAdapter $this) {
        return $this.adapterCallbacks;
    }

    public static final /* synthetic */ void access$setStartedGettingReady$p(DeviceAdapter $this, TimeMark timeMark) {
        $this.startedGettingReady = timeMark;
    }

    public static final /* synthetic */ TimeSource access$getTimeSource$p(DeviceAdapter $this) {
        return $this.timeSource;
    }

    public static final /* synthetic */ StreamingBenchmarkTarget access$getTarget$p(DeviceAdapter $this) {
        return $this.target;
    }

    public static final /* synthetic */ Channel access$getKeyEventDispatchChannel$p(DeviceAdapter $this) {
        return $this.keyEventDispatchChannel;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/streaming/benchmark/DeviceAdapter$AppState;", "", "<init>", "(Ljava/lang/String;I)V", "INITIALIZING", "KEYING_IN_CONFIG", "DISPLAYING_TOUCHABLE_AREA", "READY", "intellij.android.streaming"})
    private static final class AppState
    extends Enum<AppState> {
        public static final /* enum */ AppState INITIALIZING = new AppState();
        public static final /* enum */ AppState KEYING_IN_CONFIG = new AppState();
        public static final /* enum */ AppState DISPLAYING_TOUCHABLE_AREA = new AppState();
        public static final /* enum */ AppState READY = new AppState();
        private static final /* synthetic */ AppState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static AppState[] values() {
            return (AppState[])$VALUES.clone();
        }

        public static AppState valueOf(String value2) {
            return Enum.valueOf(AppState.class, value2);
        }

        @NotNull
        public static EnumEntries<AppState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = appStateArray = new AppState[]{AppState.INITIALIZING, AppState.KEYING_IN_CONFIG, AppState.DISPLAYING_TOUCHABLE_AREA, AppState.READY};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AppState.values().length];
            try {
                nArray[AppState.INITIALIZING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AppState.KEYING_IN_CONFIG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AppState.DISPLAYING_TOUCHABLE_AREA.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AppState.READY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

