/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.actions;

import com.android.tools.idea.streaming.core.DeviceId;
import com.intellij.openapi.components.Service;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0001\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\nR!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0010\u001a\u00020\u0006*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/streaming/actions/HardwareInputStateStorage;", "", "<init>", "()V", "enabledDevices", "Lcom/intellij/util/containers/ConcurrentList;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "isHardwareInputEnabled", "", "deviceId", "Lcom/android/tools/idea/streaming/core/DeviceId;", "setHardwareInputEnabled", "", "enabled", "storageKey", "getStorageKey", "(Lcom/android/tools/idea/streaming/core/DeviceId;)Ljava/lang/String;", "intellij.android.streaming"})
public final class HardwareInputStateStorage {
    @NotNull
    private final ConcurrentList<String> enabledDevices;

    public HardwareInputStateStorage() {
        ConcurrentList concurrentList = ContainerUtil.createConcurrentList();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentList, (String)"createConcurrentList(...)");
        this.enabledDevices = concurrentList;
    }

    public final boolean isHardwareInputEnabled(@NotNull DeviceId deviceId) {
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        return this.enabledDevices.contains((Object)this.getStorageKey(deviceId));
    }

    public final void setHardwareInputEnabled(@NotNull DeviceId deviceId, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        boolean bl = enabled ? this.enabledDevices.addIfAbsent((Object)this.getStorageKey(deviceId)) : this.enabledDevices.remove((Object)this.getStorageKey(deviceId));
    }

    private final String getStorageKey(DeviceId $this$storageKey) {
        String string;
        DeviceId deviceId = $this$storageKey;
        if (deviceId instanceof DeviceId.EmulatorDeviceId) {
            string = ((DeviceId.EmulatorDeviceId)$this$storageKey).getEmulatorId().getAvdId();
        } else if (deviceId instanceof DeviceId.PhysicalDeviceId) {
            string = $this$storageKey.getSerialNumber();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }
}

