/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.startup;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.startup.ProjectMetricsService;
import com.android.tools.idea.stats.ToolWindowTrackerService;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.StudioProjectChange;
import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseListener;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.util.ApplicationKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/startup/ProjectMetricsInitializer;", "Lcom/intellij/openapi/project/ProjectCloseListener;", "<init>", "()V", "projectClosed", "", "project", "Lcom/intellij/openapi/project/Project;", "MyStartupActivity", "intellij.android.core"})
public final class ProjectMetricsInitializer
implements ProjectCloseListener {
    public void projectClosed(@NotNull Project project) {
        block0: {
            Future<?> future2;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            int projectsOpen = ProjectManager.getInstance().getOpenProjects().length;
            AndroidStudioEvent.Builder builder = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.STUDIO_PROJECT_CLOSED).setStudioProjectChange(StudioProjectChange.newBuilder().setProjectsOpen(projectsOpen));
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setStudioProjectChange(...)");
            UsageTracker.log((AndroidStudioEvent.Builder)builder);
            Future<?> future3 = future2 = ((ProjectMetricsService)ApplicationKt.getApplication().getService(ProjectMetricsService.class)).getPersistStatisticsSessionsMap().remove(project);
            if (future3 == null) break block0;
            future3.cancel(true);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/startup/ProjectMetricsInitializer$MyStartupActivity;", "Lcom/intellij/openapi/startup/ProjectActivity;", "<init>", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.android.core"})
    public static final class MyStartupActivity
    implements ProjectActivity {
        @Nullable
        public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
            ToolWindowTrackerService service = ToolWindowTrackerService.Companion.getInstance(project);
            MessageBusConnection messageBusConnection = project.getMessageBus().connect((Disposable)project);
            Topic topic = ToolWindowManagerListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            messageBusConnection.subscribe(topic, (Object)service);
            int projectsOpen = ProjectManager.getInstance().getOpenProjects().length - 1;
            AndroidStudioEvent.Builder builder = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.STUDIO_PROJECT_OPENED).setStudioProjectChange(StudioProjectChange.newBuilder().setProjectsOpen(projectsOpen));
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setStudioProjectChange(...)");
            UsageTracker.log((AndroidStudioEvent.Builder)builder);
            ScheduledFuture<?> scheduledFuture = JobScheduler.getScheduler().schedule(() -> MyStartupActivity.execute$lambda$0(project), 10L, TimeUnit.MINUTES);
            ((ProjectMetricsService)ApplicationKt.getApplication().getService(ProjectMetricsService.class)).getPersistStatisticsSessionsMap().put(project, scheduledFuture);
            return Unit.INSTANCE;
        }

        private static final void execute$lambda$0(Project $project) {
            DumbService.Companion.getInstance($project).runWhenSmart(() -> MyStartupActivity.execute$lambda$0$0($project));
        }

        private static final void execute$lambda$0$0(Project $project) {
            ScheduledFuture<?> future2 = JobScheduler.getScheduler().scheduleWithFixedDelay(() -> MyStartupActivity.execute$lambda$0$0$0($project), 0L, 60L, TimeUnit.MINUTES);
            ((ProjectMetricsService)ApplicationKt.getApplication().getService(ProjectMetricsService.class)).getPersistStatisticsSessionsMap().put($project, future2);
        }

        private static final void execute$lambda$0$0$0(Project $project) {
            Set<String> knownProjectIds = ProjectSystemUtil.getProjectSystem($project).getKnownApplicationIds($project);
            AndroidStudioEvent.Builder builder = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.PROJECT_IDS).addAllRawProjectIds((Iterable)knownProjectIds);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"addAllRawProjectIds(...)");
            UsageTracker.log((AndroidStudioEvent.Builder)builder);
        }
    }
}

