/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.startup;

import com.android.tools.analytics.AnalyticsPublisher;
import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.analytics.UsageTracker;
import com.android.utils.ILogger;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.OptInToMetrics;
import com.google.wireless.android.sdk.stats.OptOutOfMetrics;
import com.intellij.concurrency.JobScheduler;
import com.intellij.ide.ConsentOptionsProvider;
import com.intellij.ide.gdpr.DataSharingSettingsChangeListener;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class AndroidStudioAnalyticsImpl {
    private ILogger androidLogger;

    @NotNull
    public static AndroidStudioAnalyticsImpl getInstance() {
        return (AndroidStudioAnalyticsImpl)ApplicationManager.getApplication().getService(AndroidStudioAnalyticsImpl.class);
    }

    @NotNull
    private ConsentOptionsProvider getConsentOptionsProvider() {
        return Objects.requireNonNull((ConsentOptionsProvider)ApplicationManager.getApplication().getService(ConsentOptionsProvider.class));
    }

    private void updateAndroidStudioMetrics(boolean allowed) {
        boolean updated = false;
        ScheduledExecutorService scheduler = JobScheduler.getScheduler();
        AnalyticsSettings.initialize((ILogger)this.getAndroidLogger(), (ScheduledExecutorService)scheduler);
        try {
            if (allowed == AnalyticsSettings.getOptedIn()) {
                updated = false;
            } else {
                if (!allowed) {
                    UsageTracker.log((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.OPTOUT_METRICS).setOptOutOfMetrics(OptOutOfMetrics.newBuilder()));
                }
                AnalyticsSettings.setOptedIn((boolean)allowed);
                AnalyticsSettings.saveSettings();
                updated = true;
            }
        }
        catch (IOException e) {
            this.getAndroidLogger().error((Throwable)e, "Unable to update analytics settings", new Object[0]);
        }
        if (updated) {
            this.initializeAndroidStudioUsageTrackerAndPublisher();
            if (allowed) {
                UsageTracker.log((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.OPTIN_METRICS).setOptInToMetrics(OptInToMetrics.newBuilder()));
            }
        }
    }

    public void initializeAndroidStudioUsageTrackerAndPublisher() {
        ILogger logger = this.getAndroidLogger();
        ScheduledExecutorService scheduler = JobScheduler.getScheduler();
        AnalyticsSettings.initialize((ILogger)logger, (ScheduledExecutorService)(ApplicationManager.getApplication().isUnitTestMode() ? null : scheduler));
        try {
            boolean ijOptedIn = this.getConsentOptionsProvider().isSendingUsageStatsAllowed();
            if (AnalyticsSettings.getOptedIn() != ijOptedIn) {
                AnalyticsSettings.setOptedIn((boolean)ijOptedIn);
                AnalyticsSettings.saveSettings();
            }
            UsageTracker.initialize((ScheduledExecutorService)scheduler);
        }
        catch (Exception e) {
            logger.warning("Unable to initialize analytics tracker: " + e.getMessage(), new Object[0]);
            return;
        }
        UsageTracker.setMaxJournalTime((long)10L, (TimeUnit)TimeUnit.MINUTES);
        UsageTracker.setMaxJournalSize((int)1000);
        ApplicationInfo application = ApplicationInfo.getInstance();
        AnalyticsPublisher.updatePublisher((ILogger)logger, (ScheduledExecutorService)scheduler, (String)application.getStrictVersion());
    }

    private ILogger getAndroidLogger() {
        if (this.androidLogger == null) {
            final Logger intelliJLogger = Logger.getInstance((String)"#com.intellij.internal.statistic.persistence.UsageStatisticsPersistenceComponent");
            this.androidLogger = new ILogger(){

                public void error(@Nullable Throwable t, @Nullable String msgFormat, Object ... args) {
                    intelliJLogger.error(String.format(msgFormat, args), t);
                }

                public void warning(String msgFormat, Object ... args) {
                    intelliJLogger.warn(String.format(msgFormat, args));
                }

                public void info(String msgFormat, Object ... args) {
                    intelliJLogger.info(String.format(msgFormat, args));
                }

                public void verbose(String msgFormat, Object ... args) {
                    this.info(msgFormat, args);
                }
            };
        }
        return this.androidLogger;
    }

    public static class MyDataSharingSettingsChangeListener
    implements DataSharingSettingsChangeListener {
        public void consentWritten() {
        }

        public void consentsUpdated() {
            AndroidStudioAnalyticsImpl service = AndroidStudioAnalyticsImpl.getInstance();
            service.updateAndroidStudioMetrics(service.getConsentOptionsProvider().isSendingUsageStatsAllowed());
        }
    }
}

