/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite.ui.sqliteEvaluator;

import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.stdui.ActionData;
import com.android.tools.adtui.stdui.Chunk;
import com.android.tools.adtui.stdui.CommonButton;
import com.android.tools.adtui.stdui.EmptyStatePanel;
import com.android.tools.adtui.stdui.LabelData;
import com.android.tools.adtui.stdui.NewLineChunk;
import com.android.tools.adtui.stdui.TextChunk;
import com.android.tools.idea.lang.androidSql.AndroidSqlLanguage;
import com.android.tools.idea.sqlite.SchemaProvider;
import com.android.tools.idea.sqlite.localization.DatabaseInspectorBundle;
import com.android.tools.idea.sqlite.model.SqliteDatabaseId;
import com.android.tools.idea.sqlite.model.SqliteSchema;
import com.android.tools.idea.sqlite.sqlLanguage.SqliteSchemaContext;
import com.android.tools.idea.sqlite.ui.UtilsKt;
import com.android.tools.idea.sqlite.ui.sqliteEvaluator.QueryHistoryView;
import com.android.tools.idea.sqlite.ui.sqliteEvaluator.SqliteEvaluatorView;
import com.android.tools.idea.sqlite.ui.tableView.TableView;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EditorTextFieldProvider;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0006\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020\u001bH\u0016J\u0010\u0010,\u001a\u00020\n2\u0006\u0010-\u001a\u00020'H\u0016J\b\u0010.\u001a\u00020\nH\u0002J\b\u0010/\u001a\u00020\nH\u0002J \u00100\u001a\u00020\n2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u001b022\b\u00103\u001a\u0004\u0018\u00010\u001bH\u0016J\u0010\u00104\u001a\u00020\n2\u0006\u00105\u001a\u00020!H\u0016J\u0010\u00106\u001a\u00020\n2\u0006\u00105\u001a\u00020!H\u0016J\u0010\u00107\u001a\u00020\n2\u0006\u00108\u001a\u000209H\u0016J\u001a\u0010:\u001a\u00020\n2\u0006\u0010;\u001a\u0002092\b\u0010<\u001a\u0004\u0018\u00010=H\u0016J\u0016\u0010>\u001a\u00020\n2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020902H\u0016J\u0010\u0010@\u001a\u00020\n2\u0006\u0010;\u001a\u000209H\u0016J\b\u0010A\u001a\u00020\nH\u0016J\u0010\u0010B\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001c\u001a\u00070\u001d\u00a2\u0006\u0002\b\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/android/tools/idea/sqlite/ui/sqliteEvaluator/SqliteEvaluatorViewImpl;", "Lcom/android/tools/idea/sqlite/ui/sqliteEvaluator/SqliteEvaluatorView;", "project", "Lcom/intellij/openapi/project/Project;", "tableView", "Lcom/android/tools/idea/sqlite/ui/tableView/TableView;", "schemaProvider", "Lcom/android/tools/idea/sqlite/SchemaProvider;", "dropPsiCaches", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/sqlite/ui/tableView/TableView;Lcom/android/tools/idea/sqlite/SchemaProvider;Lkotlin/jvm/functions/Function0;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getTableView", "()Lcom/android/tools/idea/sqlite/ui/tableView/TableView;", "splitterPanel", "Lcom/intellij/ui/OnePixelSplitter;", "bottomPanel", "Ljavax/swing/JPanel;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "databaseComboBox", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/android/tools/idea/sqlite/model/SqliteDatabaseId;", "editorTextField", "Lcom/intellij/ui/EditorTextField;", "Lorg/jetbrains/annotations/NotNull;", "listeners", "Ljava/util/ArrayList;", "Lcom/android/tools/idea/sqlite/ui/sqliteEvaluator/SqliteEvaluatorView$Listener;", "queryHistoryButton", "Lcom/android/tools/adtui/stdui/CommonButton;", "runButton", "Ljavax/swing/JButton;", "evaluateSqliteStatementEnabled", "", "queryHistoryView", "Lcom/android/tools/idea/sqlite/ui/sqliteEvaluator/QueryHistoryView;", "schemaChanged", "databaseId", "setRunSqliteStatementEnabled", "enabled", "evaluateSqliteExpression", "setSchemaFromSelectedItem", "setDatabases", "databaseIds", "", "selected", "addListener", "listener", "removeListener", "showSqliteStatement", "sqliteStatement", "", "reportError", "message", "t", "", "setQueryHistory", "queries", "showMessagePanel", "showTableView", "resetBottomPanelAndAddView", "app-inspection.inspectors.database"})
@SourceDebugExtension(value={"SMAP\nSqliteEvaluatorViewImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqliteEvaluatorViewImpl.kt\ncom/android/tools/idea/sqlite/ui/sqliteEvaluator/SqliteEvaluatorViewImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,317:1\n1869#2,2:318\n1869#2,2:320\n1869#2,2:326\n37#3:322\n36#3,3:323\n*S KotlinDebug\n*F\n+ 1 SqliteEvaluatorViewImpl.kt\ncom/android/tools/idea/sqlite/ui/sqliteEvaluator/SqliteEvaluatorViewImpl\n*L\n240#1:318,2\n294#1:320,2\n140#1:326,2\n299#1:322\n299#1:323,3\n*E\n"})
public final class SqliteEvaluatorViewImpl
implements SqliteEvaluatorView {
    @NotNull
    private final Project project;
    @NotNull
    private final TableView tableView;
    @NotNull
    private final SchemaProvider schemaProvider;
    @NotNull
    private final Function0<Unit> dropPsiCaches;
    @NotNull
    private final OnePixelSplitter splitterPanel;
    @NotNull
    private final JPanel bottomPanel;
    @NotNull
    private final JComponent component;
    @NotNull
    private final ComboBox<SqliteDatabaseId> databaseComboBox;
    @NotNull
    private final EditorTextField editorTextField;
    @NotNull
    private final ArrayList<SqliteEvaluatorView.Listener> listeners;
    @NotNull
    private final CommonButton queryHistoryButton;
    @NotNull
    private final JButton runButton;
    private boolean evaluateSqliteStatementEnabled;
    @NotNull
    private final QueryHistoryView queryHistoryView;

    public SqliteEvaluatorViewImpl(@NotNull Project project, @NotNull TableView tableView, @NotNull SchemaProvider schemaProvider, @NotNull Function0<Unit> dropPsiCaches) {
        JButton jButton;
        CommonButton commonButton;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)tableView, (String)"tableView");
        Intrinsics.checkNotNullParameter((Object)schemaProvider, (String)"schemaProvider");
        Intrinsics.checkNotNullParameter(dropPsiCaches, (String)"dropPsiCaches");
        this.project = project;
        this.tableView = tableView;
        this.schemaProvider = schemaProvider;
        this.dropPsiCaches = dropPsiCaches;
        this.splitterPanel = new OnePixelSplitter(true);
        this.bottomPanel = new JPanel(new BorderLayout());
        this.component = (JComponent)this.splitterPanel;
        this.databaseComboBox = new ComboBox();
        EditorTextField editorTextField = EditorTextFieldProvider.getInstance().getEditorField((Language)AndroidSqlLanguage.INSTANCE, this.getProject(), (Iterable)CollectionsKt.listOf(SqliteEvaluatorViewImpl::editorTextField$lambda$0));
        Intrinsics.checkNotNullExpressionValue((Object)editorTextField, (String)"getEditorField(...)");
        this.editorTextField = editorTextField;
        this.listeners = new ArrayList();
        this.queryHistoryButton = new CommonButton(AllIcons.Vcs.History);
        this.runButton = new JButton("Run");
        this.queryHistoryView = new QueryHistoryView(this.editorTextField);
        JPanel topPanel = new JPanel(new BorderLayout());
        JPanel controlsPanel = new JPanel(new BorderLayout());
        controlsPanel.setLayout(new BoxLayout(controlsPanel, 2));
        topPanel.add((Component)this.editorTextField, "Center");
        topPanel.add((Component)controlsPanel, "South");
        CommonButton $this$_init__u24lambda_u241 = commonButton = this.splitterPanel;
        boolean bl = false;
        $this$_init__u24lambda_u241.setFocusTraversalPolicy((FocusTraversalPolicy)new LayoutFocusTraversalPolicy());
        $this$_init__u24lambda_u241.setFocusCycleRoot(false);
        $this$_init__u24lambda_u241.setProportion(0.3f);
        $this$_init__u24lambda_u241.setFirstComponent((JComponent)topPanel);
        $this$_init__u24lambda_u241.setSecondComponent((JComponent)this.bottomPanel);
        topPanel.setBorder(JBUI.Borders.empty((int)6));
        controlsPanel.setBorder((Border)JBUI.Borders.emptyTop((int)6));
        this.bottomPanel.setBorder(IdeBorderFactory.createBorder((int)2));
        topPanel.setBackground((Color)StudioColorsKt.getPrimaryContentBackground());
        controlsPanel.setBackground((Color)StudioColorsKt.getPrimaryContentBackground());
        controlsPanel.add((Component)this.databaseComboBox);
        controlsPanel.add(Box.createRigidArea((Dimension)JBDimension.size((Dimension)new Dimension(5, 0))));
        controlsPanel.add((Component)this.queryHistoryButton);
        controlsPanel.add(Box.createHorizontalGlue());
        controlsPanel.add(this.runButton);
        CommonButton $this$_init__u24lambda_u242 = commonButton = this.databaseComboBox;
        boolean bl2 = false;
        $this$_init__u24lambda_u242.addActionListener(arg_0 -> SqliteEvaluatorViewImpl.lambda$2$0(this, arg_0));
        $this$_init__u24lambda_u242.setMinimumAndPreferredWidth(JBUI.scale((int)300));
        $this$_init__u24lambda_u242.setMaximumSize((Dimension)JBUI.size((int)300, (int)this.databaseComboBox.getPreferredSize().height));
        $this$_init__u24lambda_u242.setRenderer((ListCellRenderer)new ColoredListCellRenderer<SqliteDatabaseId>(){

            protected void customizeCellRenderer(JList<? extends SqliteDatabaseId> list2, SqliteDatabaseId sqliteDatabase, int index, boolean selected, boolean hasFocus) {
                Intrinsics.checkNotNullParameter(list2, (String)"list");
                if (sqliteDatabase != null) {
                    Icon icon;
                    SqliteDatabaseId sqliteDatabaseId = sqliteDatabase;
                    if (sqliteDatabaseId instanceof SqliteDatabaseId.LiveSqliteDatabaseId) {
                        icon = StudioIcons.DatabaseInspector.DATABASE;
                    } else if (sqliteDatabaseId instanceof SqliteDatabaseId.FileSqliteDatabaseId) {
                        icon = StudioIcons.DatabaseInspector.DATABASE_OFFLINE;
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    this.setIcon(icon);
                    v1 = this.append(sqliteDatabase.getName());
                } else {
                    this.setIcon(null);
                    v1 = this.append(DatabaseInspectorBundle.INSTANCE.message("no.databases.available", new String[0]));
                }
            }
        });
        CommonButton $this$_init__u24lambda_u243 = commonButton = this.queryHistoryButton;
        boolean bl3 = false;
        Icon icon = AllIcons.Vcs.History;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"History");
        $this$_init__u24lambda_u243.setDisabledIcon(IconLoader.getDisabledIcon((Icon)icon));
        $this$_init__u24lambda_u243.setToolTipText("Show query history");
        $this$_init__u24lambda_u243.addActionListener(arg_0 -> SqliteEvaluatorViewImpl.lambda$3$0(this, topPanel, controlsPanel, arg_0));
        Keymap keymap = KeymapManager.getInstance().getActiveKeymap();
        Intrinsics.checkNotNullExpressionValue((Object)keymap, (String)"getActiveKeymap(...)");
        Keymap active = keymap;
        Shortcut[] shortcutArray = active.getShortcuts("Console.Execute.Multiline");
        Intrinsics.checkNotNullExpressionValue((Object)shortcutArray, (String)"getShortcuts(...)");
        Shortcut[] shortcutsMultiline = shortcutArray;
        KeyStroke keyStroke = KeymapUtil.getKeyStroke((ShortcutSet)((ShortcutSet)new CustomShortcutSet(Arrays.copyOf(shortcutsMultiline, shortcutsMultiline.length))));
        if (keyStroke == null) {
            keyStroke = KeyStroke.getKeyStroke(10, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx());
        }
        KeyStroke keyStrokeMultiline = keyStroke;
        String string = KeymapUtil.getFirstKeyboardShortcutText((ShortcutSet)((ShortcutSet)new CustomShortcutSet(keyStrokeMultiline)));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFirstKeyboardShortcutText(...)");
        String shortcutText = string;
        JButton $this$_init__u24lambda_u244 = jButton = this.runButton;
        boolean bl4 = false;
        $this$_init__u24lambda_u244.setToolTipText("Run SQLite expression (" + shortcutText + ")");
        $this$_init__u24lambda_u244.setEnabled(false);
        $this$_init__u24lambda_u244.addActionListener(arg_0 -> SqliteEvaluatorViewImpl.lambda$4$0(this, arg_0));
        $this$_init__u24lambda_u244.setName("run-button");
        $this$_init__u24lambda_u244.setBackground((Color)StudioColorsKt.getPrimaryContentBackground());
        JButton $this$_init__u24lambda_u245 = jButton = this.editorTextField;
        boolean bl5 = false;
        $this$_init__u24lambda_u245.setBackground((Color)StudioColorsKt.getPrimaryContentBackground());
        $this$_init__u24lambda_u245.setName("editor");
        $this$_init__u24lambda_u245.setPlaceholder("Enter query...");
        DumbAwareAction.create(arg_0 -> SqliteEvaluatorViewImpl.lambda$5$1(arg_0 -> SqliteEvaluatorViewImpl.lambda$5$0(this, arg_0), arg_0)).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(keyStrokeMultiline), (JComponent)this.editorTextField);
        $this$_init__u24lambda_u245.getDocument().addDocumentListener(new DocumentListener(this){
            final /* synthetic */ SqliteEvaluatorViewImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public void documentChanged(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Iterable $this$forEach$iv = SqliteEvaluatorViewImpl.access$getListeners$p(this.this$0);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    SqliteEvaluatorView.Listener it = (SqliteEvaluatorView.Listener)element$iv;
                    boolean bl = false;
                    String string = event.getDocument().getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    it.sqliteStatementTextChangedInvoked(string);
                }
            }
        });
    }

    public /* synthetic */ SqliteEvaluatorViewImpl(Project project, TableView tableView, SchemaProvider schemaProvider, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            function0 = () -> SqliteEvaluatorViewImpl._init_$lambda$0(project);
        }
        this(project, tableView, schemaProvider, (Function0<Unit>)function0);
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public TableView getTableView() {
        return this.tableView;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public void schemaChanged(@NotNull SqliteDatabaseId databaseId) {
        Intrinsics.checkNotNullParameter((Object)databaseId, (String)"databaseId");
        Object object = this.databaseComboBox.getSelectedItem();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.android.tools.idea.sqlite.model.SqliteDatabaseId");
        if (Intrinsics.areEqual((Object)((SqliteDatabaseId)object), (Object)databaseId)) {
            this.setSchemaFromSelectedItem();
        }
    }

    @Override
    public void setRunSqliteStatementEnabled(boolean enabled) {
        this.evaluateSqliteStatementEnabled = enabled;
        this.runButton.setEnabled(enabled);
    }

    private final void evaluateSqliteExpression() {
        if (!this.evaluateSqliteStatementEnabled) {
            return;
        }
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SqliteEvaluatorView.Listener it = (SqliteEvaluatorView.Listener)element$iv;
            boolean bl = false;
            it.evaluateCurrentStatement();
        }
    }

    private final void setSchemaFromSelectedItem() {
        if (this.databaseComboBox.getSelectedIndex() < 0) {
            return;
        }
        Object object = this.databaseComboBox.getSelectedItem();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.android.tools.idea.sqlite.model.SqliteDatabaseId");
        SqliteDatabaseId database = (SqliteDatabaseId)object;
        SqliteSchema schema = this.schemaProvider.getSchema(database);
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
        FileDocumentManager fileDocumentManager2 = fileDocumentManager;
        VirtualFile virtualFile = fileDocumentManager2.getFile(this.editorTextField.getDocument());
        if (virtualFile != null) {
            virtualFile.putUserData(SqliteSchemaContext.Companion.getSQLITE_SCHEMA_KEY(), (Object)schema);
        }
        this.dropPsiCaches.invoke();
    }

    @Override
    public void setDatabases(@NotNull List<? extends SqliteDatabaseId> databaseIds, @Nullable SqliteDatabaseId selected) {
        Intrinsics.checkNotNullParameter(databaseIds, (String)"databaseIds");
        this.databaseComboBox.removeAllItems();
        this.databaseComboBox.setEnabled(!((Collection)databaseIds).isEmpty());
        for (SqliteDatabaseId sqliteDatabaseId : databaseIds) {
            this.databaseComboBox.addItem((Object)sqliteDatabaseId);
        }
        if (!Intrinsics.areEqual((Object)this.databaseComboBox.getSelectedItem(), (Object)selected)) {
            this.databaseComboBox.setSelectedItem((Object)selected);
        }
    }

    @Override
    public void addListener(@NotNull SqliteEvaluatorView.Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    @Override
    public void removeListener(@NotNull SqliteEvaluatorView.Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.remove(listener2);
    }

    @Override
    public void showSqliteStatement(@NotNull String sqliteStatement) {
        Intrinsics.checkNotNullParameter((Object)sqliteStatement, (String)"sqliteStatement");
        this.editorTextField.setText(sqliteStatement);
    }

    @Override
    public void reportError(@NotNull String message, @Nullable Throwable t) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        UtilsKt.notifyError(message, t);
    }

    @Override
    public void setQueryHistory(@NotNull List<String> queries) {
        Intrinsics.checkNotNullParameter(queries, (String)"queries");
        this.queryHistoryView.setQueryHistory(queries);
    }

    @Override
    public void showMessagePanel(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        List chunks = new ArrayList();
        String[] stringArray = new String[]{"\n"};
        Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)message, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            chunks.add(new TextChunk(it));
            chunks.add(NewLineChunk.INSTANCE);
        }
        Collection $this$toTypedArray$iv = CollectionsKt.dropLast((List)chunks, (int)1);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Chunk[] chunkArray = thisCollection$iv.toArray(new Chunk[0]);
        EmptyStatePanel enterOfflineModePanel = new EmptyStatePanel(new LabelData(Arrays.copyOf(chunkArray, chunkArray.length)), null, new ActionData[0], null, null, 26, null);
        enterOfflineModePanel.setName("message-panel");
        this.resetBottomPanelAndAddView((JComponent)enterOfflineModePanel);
    }

    @Override
    public void showTableView() {
        this.resetBottomPanelAndAddView(this.getTableView().getComponent());
    }

    private final void resetBottomPanelAndAddView(JComponent component) {
        this.bottomPanel.removeAll();
        this.bottomPanel.setLayout(new BorderLayout());
        this.bottomPanel.add((Component)component, "Center");
        this.bottomPanel.revalidate();
        this.bottomPanel.repaint();
    }

    private static final Unit _init_$lambda$0(Project $project) {
        ApplicationManager.getApplication().invokeLaterOnWriteThread(() -> SqliteEvaluatorViewImpl._init_$lambda$0$0($project));
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$0$0(Project $project) {
        PsiManager.getInstance((Project)$project).dropPsiCaches();
    }

    private static final void editorTextField$lambda$0(EditorEx editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        editor.setBorder((Border)JBUI.Borders.empty());
    }

    private static final void lambda$2$0(SqliteEvaluatorViewImpl this$0, ActionEvent it) {
        this$0.setSchemaFromSelectedItem();
        Object object = this$0.databaseComboBox.getSelectedItem();
        SqliteDatabaseId sqliteDatabaseId = object instanceof SqliteDatabaseId ? (SqliteDatabaseId)object : null;
        if (sqliteDatabaseId == null) {
            return;
        }
        SqliteDatabaseId sqliteDatabaseId2 = sqliteDatabaseId;
        Iterable $this$forEach$iv = this$0.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SqliteEvaluatorView.Listener it2 = (SqliteEvaluatorView.Listener)element$iv;
            boolean bl = false;
            it2.onDatabaseSelected(sqliteDatabaseId2);
        }
    }

    private static final void lambda$3$0(SqliteEvaluatorViewImpl this$0, JPanel $topPanel, JPanel $controlsPanel, ActionEvent it) {
        this$0.queryHistoryView.show(this$0.getComponent(), this$0.queryHistoryButton.getX() + this$0.queryHistoryButton.getWidth() / 2, $topPanel.getHeight() - $topPanel.getBorder().getBorderInsets((Component)((Component)$controlsPanel)).bottom);
    }

    private static final void lambda$4$0(SqliteEvaluatorViewImpl this$0, ActionEvent it) {
        this$0.evaluateSqliteExpression();
    }

    private static final Unit lambda$5$0(SqliteEvaluatorViewImpl this$0, AnActionEvent it) {
        this$0.evaluateSqliteExpression();
        return Unit.INSTANCE;
    }

    private static final void lambda$5$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ ArrayList access$getListeners$p(SqliteEvaluatorViewImpl $this) {
        return $this.listeners;
    }
}

